---
title: 📣 Community Call - October 10, 2019
subtitle: Ignite Conference updates, a refreshed website, and two new ways to take advantage of templating
date: 2019-10-10
featured_image: https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/10/Screenshot-of-https-adaptivecards-io-1024x944.png
github_username: matthidinger
twitter: matthidinger
---

Welcome to our Adaptive Cards community call series for 2019, the 2nd Thursday of each month. We are excited to provide you with a monthly opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.

Agenda for this month's call, hosted by Matt Hidinger, included:

### Microsoft Ignite Conference

The Microsoft Ignite Conference takes place Nov 4-8 in Orlando, FL. If you'll be there be sure to join us for an Adaptive Cards breakout session: [Powering the next generation of contextual user experiences in your apps and Microsoft 365](https://myignite.techcommunity.microsoft.com/sessions/81641?source=sessions).

### Technology Adoption Preview (TAP) Program

We're looking to gauge interest in a Microsoft Developer TAP program for Adaptive Cards. TAP programs offer early access and close partnerships with engineering teams to validate designs and provide early feedback on development and explorations.

Email [AdaptiveCardsTAP@microsoft.com](mailto:AdaptiveCardsTAP@microsoft.com) if you'd be interested in joining the program.

![Help us build what you need Have a look at the Adaptive Card Feature Portal to keep an eye on what features the team is considering, and vote/submit the features you need. It takes less than a minute to vote and only requires an email address.](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/10/Information-on-the-Technology-Adoption-Preview-TAP-Program-1024x472.png)

### Help us build what *you* need

Have a look at the [Adaptive Card Feature Portal](https://aka.ms/ACFeatures) to keep an eye on what features the team is considering, and vote/submit the features you need.

It takes less than a minute to vote and only requires an email address.

![Screenshot of Product board](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/10/Screenshot-of-product-board-feature-list-e1571173437175.png)

### Refreshing the Adaptive Cards website

We recently refreshed the Adaptive Cards website. The update includes a standalone blog, some overdue polish and bug fixes, and makes it easier for newcomers to learn what Adaptive Cards offers.

Interested in how it's built? The website is open-source and built by utilizing other files in the GitHub repository, like the JSON Schema, Samples payloads, etc. Take a look at [PR #3261](https://github.com/microsoft/AdaptiveCards/pull/3261) for all the code changes.

![screenshot of AdaptiveCards.io](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/10/Screenshot-of-https-adaptivecards-io-1024x944.png)

### New ways to take advantage of Adaptive Cards Templating

The bulk of this call was spent reviewing the time-saving benefits of [Adaptive Cards Templating](https://docs.microsoft.com/en-us/adaptive-cards/templating/), and introduced two new tools that help build reusable card templates faster than ever.

The first tool is a preview of the [AdaptiveCards.Templating](https://www.nuget.org/packages/AdaptiveCards.Templating) .NET SDK now available on NuGet. The [templating SDKs](https://docs.microsoft.com/en-us/adaptive-cards/templating/sdk) (also available for JavaScript) make it easy to populate an Adaptive Card template with real data at runtime.

The second way we're helping developers get started with templating is by updating all the Adaptive Card Samples with reusable template payloads. This is a major improvement over the existing Samples, which don't make it very straight forward to populate them with your own data. We are also updating the Card Designer with full templating support. Stay tuned in the coming weeks for these updates and more to roll out to [https://adaptivecards.io](https://adaptivecards.io/)

And as always for the curious, the website code for these updates can be found in [PR #3505](https://adaptivecardsci.z5.web.core.windows.net/pr/3505)

Watch the call here.

<iframe width="560" height="315" title="Community Call October 2019 video" src="https://www.youtube.com/embed/GY8__dqPMiU" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="allowfullscreen"></iframe>

Next month's call will be held on **Thursday, November 14, 2019 at 9:00am PST.** We look forward to talking to you then! Download a recurring calendar invite here at <https://aka.ms/adaptivecardscommunitycall>.

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)