---
title: 📣 Community Call - February 14, 2019
subtitle: "Sneak preview: Data binding in Adaptive Cards"
date: 2019-02-14
featured_image: https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/02/Adaptive-cards-cards-stock-bot-image-1024x977.png
github_username: matthidinger
twitter: matthidinger
---

Welcome to our new Adaptive Cards community call series for 2019, the 2nd Thursday of each month. We are excited to provide you with a monthly opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.

You can download a recurring monthly calendar invite at https://aka.ms/adaptivecardscommunitycall

Agenda for this month's call included a **Sneak Preview: Data Binding in Adaptive Cards**

We're excited to announce an **early preview** of data binding in Adaptive Cards "2.0". This is very much "still baking" and subject to change, so your feedback is not only welcome, but is critical to ensure we deliver the features **you** need.

Data binding enables the separation of **data** from **content** in your Adaptive Card. The data can be provided in-line with the AdaptiveCard payload, or at runtime using new APIs.

In the video below we walk-through an end-to-end example by creating an Adaptive Cards Stock Bot, showcasing the creation of multiple Adaptive Card templates that are then bound to a real-time stock API.

![Screenshot of stock bot](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/02/Adaptive-cards-cards-stock-bot-image-1024x977.png)

### Designer Support and Documentation

We're also excited to announce a preview of the Adaptive Cards Designer that supports data binding.

Try it out now at **https://vnext.adaptivecards.io/designer**

For full documentation and to leave feedback on this preview please check the [GitHub announcement](https://github.com/Microsoft/AdaptiveCards/issues/2448). The link above also includes instructions for trying to the Stock bot yourself.

![Screenshot of Designer with Data Binding](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/02/Adaptive-cards-example-of-adding-stock-symbols-1024x832.png)

Watch the call here.

<iframe title="Video of the community call" src="https://www.youtube.com/embed/O7xA-OO69OY" height="315" width="560"></iframe>

Next month's call will be held on Thursday, March 14, 2019 at 9:00am PST. We look forward to talking to you then!

### Resources:

From February's call

-   [Data binding documentation](https://github.com/Microsoft/AdaptiveCards/issues/2448)
-   <https://vnext.adaptivecards.io/designer/>

Adaptive Cards community call

-   Recurring monthly community call calendar invite -- <https://aka.ms/adaptivecardscommunitycall>.
-   Previous monthly call recordings -- [Office Development YouTube Channel](https://na01.safelinks.protection.outlook.com/?url=https%3A%2F%2Fwww.youtube.com%2Fchannel%2FUCV_6HOhwxYLXAGd-JOqKPoQ&data=04%7C01%7Cv-chargr%40microsoft.com%7Cbaeead6e3a844690785d08d56d9e6864%7Cee3303d7fb734b0c8589bcd847f1c277%7C1%7C0%7C636535449508737676%7CUnknown%7CTWFpbGZsb3d8eyJWIjoiMC4wLjAwMDAiLCJQIjoiV2luMzIiLCJBTiI6Ik1haWwifQ%3D%3D%7C-2&sdata=emAMNFO82YoWjc2hnXShDlBPRR3jOPxAAfJLTKozgYk%3D&reserved=0)

Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)