---
title: 📣 Community Call - August 8, 2019
subtitle: Update on Adaptive Cards templating, vote on the features you need, and a live demo from Tim at Teamwork.com
date: 2019-08-08
featured_image: https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/08/Image-1024x813.png
github_username: matthidinger
twitter: matthidinger
---

Welcome to our Adaptive Cards community call series for 2019, the 2nd Thursday of each month. We are excited to provide you with a monthly opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.

Agenda for this month's call, hosted by Matt Hidinger, included:

### Adaptive Cards Templating

The team polished up and released in-depth documentation to better understand [how templating can help you](https://docs.microsoft.com/en-us/adaptive-cards/templating/#how-can-templating-help-you), and how all the pieces fit together. Take a look and let us know if you have any feedback!

1.  The **[Template Language](https://docs.microsoft.com/en-us/adaptive-cards/templating/language)** is the syntax used for authoring a template. The Designer even lets you preview your templates at design time by including "sample data".
2.  The [**Templating SDK's**](https://docs.microsoft.com/en-us/adaptive-cards/templating/sdk) will exist on all supported Adaptive Card platforms. These SDKs allow you to populate a template with real data, on the back-end or directly on the client.
3.  The [**Template Service**](https://docs.microsoft.com/en-us/adaptive-cards/templating/service) is a proof-of-concept service that allows anyone to find, contribute to, and share a set of well-known templates.

### Vote on the features you need!

The public [feature portal](https://portal.productboard.com/adaptivecards/) is the place to go to weigh in on what you need from Adaptive Cards. Vote on existing features, add comments, or submit new ideas --- privately or publicly. Steer the direction that Adaptive Cards heads.

![screenshot of product board feature list](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2019/08/Image-1024x813.png)

### Special guest, Tim Cadenbach, from Teamwork

This month, we had a special guest showcase a **fantastic demo** of Templating in the real world. Tim showed an integrated card dashboard, where templates can be previewed using built-in or custom host configs. Not only that, but when the templates are saved to the backend, they are instantly available to any client that takes advantage of them. In his demo, Tim showed the Teamwork extension for Visual Studio Code, where the card template updated instantly, without ever having to restart the extension or VS code. Take a look at the call recording to see it in action.

Watch the call here.

<iframe title="Video of the community call" width="560" height="315" src="https://www.youtube.com/embed/oymSj_Vw6SM" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="allowfullscreen"></iframe>

Next month's call will be held on **Thursday, September 12, 2019 at 9:00am PST.** We look forward to talking to you then! Download a recurring calendar invite here at <https://aka.ms/adaptivecardscommunitycall>.

Check out the previous month's call recording on our [Office Development YouTube Channel](https://na01.safelinks.protection.outlook.com/?url=https%3A%2F%2Fwww.youtube.com%2Fchannel%2FUCV_6HOhwxYLXAGd-JOqKPoQ&data=04%7C01%7Cv-chargr%40microsoft.com%7Cbaeead6e3a844690785d08d56d9e6864%7Cee3303d7fb734b0c8589bcd847f1c277%7C1%7C0%7C636535449508737676%7CUnknown%7CTWFpbGZsb3d8eyJWIjoiMC4wLjAwMDAiLCJQIjoiV2luMzIiLCJBTiI6Ik1haWwifQ%3D%3D%7C-2&sdata=emAMNFO82YoWjc2hnXShDlBPRR3jOPxAAfJLTKozgYk%3D&reserved=0)

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)