# About the AdaptiveCards website

The https://adaptivecards.io site is entirely static-generated HTML using NodeJS and Hexo. It uses other files in the repo to help build out the site, like the JSON-schema file, and sample card payloads. [Hexo](https://hexo.io/) is the static-site-generator used to build the site.

* **[Schema Explorer](https://adaptivecards.io/explorer)** is built by generating markdown and then generating HTML based on the [JSON-Schama file](../../../schemas/adaptive-card.json). The **Example** cards are found by naming convention: 
  * The default example is: `../../../samples/v1.*/Elements/<ElementName>.json` (e.g., `v1.0/Elements/TextBlock.json`)
  * Property examples are: `../../../samples/v1.*/Elements/<ElementName>.<PropertyName>.json` (e.g., `v1.0/Elements/TextBlock.Color.json`)
* **[Samples](https://adaptivecards.io/samples)** is built by scanning for JSON files matching this filter: `../../../samples/v1.*/Scenarios/*.json`. Any JSON files added here will automatically get added to the Samples page of the site.
* **[Designer](https://adaptivecards.io/designer)** is built from the `../adaptivecards-designer` project 
* **[Blog](https://adaptivecards.io/blog)** is built from the `./pages/_posts` directory (see [BLOGGING.md](./BLOGGING.md))
* **[Documentation](https://docs.microsoft.com/en-us/adaptive-cards/)** contains the rest of our free-form docs and is hosted on a separate site (docs.microsoft.com), which builds out of the [MicrosoftDocs/AdaptiveCards](https://github.com/MicrosoftDocs/AdaptiveCards) repo. The Card Schema and Host Config schema pages can be generated by the tool in this site


## Source files for generating the site

* `pages` - any markdown blog posts or pages, these get rendered as HTML on generate
* `themes/adaptivecards` - the source code for generating the site. It uses nodejs
    * `source` - any raw content added to the genated output (CSS, JS, images, etc)
    * `scripts` - these scripts run on the dev box and control the generated output.
        * `generator-*.js` - control how each page is generated. For example: `generator-samples.js` builds the samples.html page
    * `layout` - the HTML templates for the pages and partials
* `_config.yml` - config for the site, like the top-level menu, etc
* `schema-explorer-toc.yml` - generates the "Table of Contents" left-nav for the Schema Explorer pages
* `schema-hostconfig-toc.yml` - generates the "Table of Contents" left-nav for the Host Config pages (Not working yet)
* `public` - output location from `hexo generate` - this is the wwwroot of the site

## Authoring Blog Posts

See [BLOGGING.md](./BLOGGING.md)

## The Microsoft Universal Header/Footer

Microsoft properties have a standard header/footer that is provided by the UHF API. Any updates to the header or footer should also be updated in the UHF. See the Team OneNote for this process (search UFH).

* [Get UHF HTML + CSS + Script here](https://uhf.microsoft.com/en-US/shell/xml/UHFPortal?headerId=MSDocsHeader-AdaptiveCards&footerid=UHFPortalFooter)
    * `head.ejs` CSS and mandatory JS references
    * `header.ejs` has a manual copy-paste of the HTML
    * `footer.ejs` non-essential JS includes that can be placed at the bottom of the page to decrease page load times.

## Install and Build

### Prerequisites
Ensure that you've bootstrapped the repo following instructions [here](https://github.com/microsoft/AdaptiveCards/tree/main/source/nodejs#build). Note that since we use lerna to manage our node project, the instructions below reference lerna commands rather than raw npm commands for consistency.

### Build & Generate

```console
1. cd adaptivecards-site
2. npx lerna run release

```

### Run

```console
1. npm start
2. Open up the browser to point to: localhost:[portnumber] printed after the command above returns under "Hexo is running at".
```
