using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace Microsoft.MarkedNet
{
    /// <summary>
    /// Converter for Emoji - defines maps from symbol to Char and symbol to markup.
    /// </summary>
    public static class EmojiConverter
    {
        private static Dictionary<string, string> markup2Emoji = new Dictionary<string, string>();
        private static Dictionary<string, string> emoji2Markup = new Dictionary<string, string>();

        static EmojiConverter()
        {
            Add("copyright sign", ":copyright:", 0x00A9);
            Add("registered sign", ":registered:", 0x00AE);
            Add("double exclamation mark", ":bangbang:", 0x203C);
            Add("exclamation question mark", ":interrobang:", 0x2049);
            Add("trade mark sign", ":tm:", 0x2122);
            Add("information source", ":information_source:", 0x2139);
            Add("left right arrow", ":left_right_arrow:", 0x2194);
            Add("up down arrow", ":arrow_up_down:", 0x2195);
            Add("north west arrow", ":arrow_upper_left:", 0x2196);
            Add("north east arrow", ":arrow_upper_right:", 0x2197);
            Add("south east arrow", ":arrow_lower_right:", 0x2198);
            Add("south west arrow", ":arrow_lower_left:", 0x2199);
            Add("leftwards arrow with hook", ":leftwards_arrow_with_hook:", 0x21A9);
            Add("rightwards arrow with hook", ":arrow_right_hook:", 0x21AA);
            Add("watch", ":watch:", 0x231A);
            Add("hourglass", ":hourglass: ", 0x231B);
            Add("keyboard", ":keyboard: ", 0x2328);
            Add("black right-pointing double triangle", ":fast_forward: ", 0x23E9);
            Add("black left-pointing double triangle", ":rewind: ", 0x23EA);
            Add("black up-pointing double triangle", ":arrow_double_up: ", 0x23EB);
            Add("black down-pointing double triangle", ":arrow_double_down: ", 0x23EC);
            Add("black right-pointing double triangle with vertical bar", ":black_right_pointing_double_triangle_with_vertical_bar: ", 0x23ED);
            Add("black left-pointing double triangle with vertical bar", ":black_left_pointing_double_triangle_with_vertical_bar: ", 0x23EE);
            Add("black right-pointing triangle with double vertical bar", ":black_right_pointing_triangle_with_double_vertical_bar: ", 0x23EF);
            Add("alarm clock", ":alarm_clock: ", 0x23F0);
            Add("stopwatch", ":stopwatch: ", 0x23F1);
            Add("timer clock", ":timer_clock: ", 0x23F2);
            Add("hourglass with flowing sand", ":hourglass_flowing_sand: ", 0x23F3);
            Add("double vertical bar", ":double_vertical_bar: ", 0x23F8);
            Add("black square for stop", ":black_square_for_stop:", 0x23F9);
            Add("black circle for record", ":black_circle_for_record:", 0x23FA);
            Add("circled latin capital letter m", ":m:", 0x24C2);
            Add("black small square", ":black_small_square:", 0x25AA);
            Add("white small square", ":white_small_square:", 0x25AB);
            Add("black right-pointing triangle", ":arrow_forward:", 0x25B6);
            Add("black left-pointing triangle", ":arrow_backward:", 0x25C0);
            Add("white medium square", ":white_medium_square:", 0x25FB);
            Add("black medium square", ":black_medium_square:", 0x25FC);
            Add("white medium small square", ":white_medium_small_square:", 0x25FD);
            Add("black medium small square", ":black_medium_small_square:", 0x25FE);
            Add("black sun with rays", ":sunny:", 0x2600);
            Add("cloud", ":cloud:", 0x2601);
            Add("umbrella", ":umbrella:", 0x2602);
            Add("snowman", ":showman:", 0x2603);
            Add("comet", ":comet:", 0x2604);
            Add("black telephone", ":phone:", 0x260E);
            Add("ballot box with check", ":ballot_box_with_check:", 0x2611);
            // Add("umbrella with rain drops", ":umbrella:", 0x2614);
            Add("hot beverage", ":coffee:", 0x2615);
            Add("shamrock", ":shamrock:", 0x2618);
            Add("white up pointing index", ":point_up:", 0x261D);
            Add("skull and crossbones", ":skull_and_crossbones:", 0x2620);
            Add("radioactive sign", ":radioactive_sign:", 0x2622);
            Add("biohazard sign", ":biohazard_sign:", 0x2623);
            Add("orthodox cross", ":orthodox_cross:", 0x2626);
            Add("star and crescent", ":star_and_crescent:", 0x262A);
            Add("peace symbol", ":peace_symbol:", 0x262E);
            Add("yin yang", ":yin_yang:", 0x262F);
            Add("wheel of dharma", ":wheel_of_dharma:", 0x2638);
            Add("white frowning face", ":white_frowning_face:", 0x2639);
            Add("white smiling face", ":relaxed:", 0x263A);
            Add("aries", ":aries:", 0x2648);
            Add("taurus", ":taurus:", 0x2649);
            Add("gemini", ":gemini:", 0x264A);
            Add("cancer", ":cancer:", 0x264B);
            Add("leo", ":leo:", 0x264C);
            Add("virgo", ":virgo:", 0x264D);
            Add("libra", ":libra:", 0x264E);
            Add("scorpius", ":scorpius:", 0x264F);
            Add("sagittarius", ":sagittarius:", 0x2650);
            Add("capricorn", ":capricorn:", 0x2651);
            Add("aquarius", ":aquarius:", 0x2652);
            Add("pisces", ":pisces:", 0x2653);
            Add("black spade suit", ":spades:", 0x2660);
            Add("black club suit", ":clubs:", 0x2663);
            Add("black heart suit", ":hearts:", 0x2665);
            Add("black diamond suit", ":diamonds:", 0x2666);
            Add("hot springs", ":hotsprings:", 0x2668);
            Add("black universal recycling symbol", ":recycle:", 0x267B);
            Add("wheelchair symbol", ":wheelchair:", 0x267F);
            Add("hammer and pick", ":hammer_and_pick:", 0x2692);
            Add("anchor", ":anchor:", 0x2693);
            Add("crossed swords", ":crossed_swords:", 0x2694);
            Add("scales", ":scales:", 0x2696);
            Add("alembic", ":alembic:", 0x2697);
            Add("gear", ":gear:", 0x2699);
            Add("atom symbol", ":atom_symbol:", 0x269B);
            Add("fleur-de-lis", ":fleur_de_lis:", 0x269C);
            Add("warning sign", ":warning:", 0x26A0);
            Add("high voltage sign", ":zap:", 0x26A1);
            Add("medium white circle", ":white_circle:", 0x26AA);
            Add("medium black circle", ":black_circle:", 0x26AB);
            Add("coffin", ":coffin:", 0x26B0);
            Add("funeral urn", ":funeral_urn:", 0x26B1);
            Add("soccer ball", ":soccer:", 0x26BD);
            Add("baseball", ":baseball:", 0x26BE);
            Add("snowman without snow", ":snowman:", 0x26C4);
            Add("sun behind cloud", ":partly_sunny:", 0x26C5);
            Add("thunder cloud and rain", ":thunder_cloud_and_rain:", 0x26C8);
            Add("ophiuchus", ":ophiuchus:", 0x26CE);
            Add("pick", ":pick:", 0x26CF);
            Add("helmet with white cross", ":helmet_with_white_cross:", 0x26D1);
            Add("chains", ":chains:", 0x26D3);
            Add("no entry", ":no_entry:", 0x26D4);
            Add("shinto shrine", ":shinto_shrine:", 0x26E9);
            Add("church", ":church:", 0x26EA);
            Add("mountain", ":mountain:", 0x26F0);
            Add("umbrella on ground", ":umbrella_on_ground:", 0x26F1);
            Add("fountain", ":fountain:", 0x26F2);
            Add("flag in hole", ":golf:", 0x26F3);
            Add("ferry", ":ferry:", 0x26F4);
            Add("sailboat", ":boat:", 0x26F5);
            Add("skier", ":skier:", 0x26F7);
            Add("ice skate", ":ice_skate:", 0x26F8);
            Add("person with ball", ":person_with_ball:", 0x26F9);
            Add("tent", ":tent:", 0x26FA);
            Add("fuel pump", ":fuelpump:", 0x26FD);
            Add("black scissors", ":scissors:", 0x2702);
            Add("white heavy check mark", ":white_check_mark:", 0x2705);
            Add("airplane", ":airplane:", 0x2708);
            Add("envelope", ":email:", 0x2709);
            Add("raised fist", ":fist:", 0x270A);
            Add("raised hand", ":hand:", 0x270B);
            Add("victory hand", ":v:", 0x270C);
            Add("writing hand", ":writing_hand:", 0x270D);
            Add("pencil", ":pencil2:", 0x270F);
            Add("black nib", ":black_nib:", 0x2712);
            Add("heavy check mark", ":heavy_check_mark:", 0x2714);
            Add("heavy multiplication x", ":heavy_multiplication_x:", 0x2716);
            Add("latin cross", ":latin_cross:", 0x271D);
            Add("star of david", ":star_of_david:", 0x2721);
            Add("sparkles", ":sparkles:", 0x2728);
            Add("eight spoked asterisk", ":eight_spoked_asterisk:", 0x2733);
            Add("eight pointed black star", ":eight_pointed_black_star:", 0x2734);
            Add("snowflake", ":snowflake:", 0x2744);
            Add("sparkle", ":sparkle:", 0x2747);
            Add("cross mark", ":x:", 0x274C);
            Add("negative squared cross mark", ":negative_squared_cross_mark:", 0x274E);
            Add("black question mark ornament", ":question:", 0x2753);
            Add("white question mark ornament", ":grey_question:", 0x2754);
            Add("white exclamation mark ornament", ":grey_exclamation:", 0x2755);
            Add("heavy exclamation mark symbol", ":exclamation:", 0x2757);
            Add("heavy heart exclamation mark ornament", ":heavy_heart_exclamation_mark_ornament:", 0x2763);
            Add("heavy black heart", ":heart:", 0x2764);
            Add("heavy plus sign", ":heavy_plus_sign:", 0x2795);
            Add("heavy minus sign", ":heavy_minus_sign:", 0x2796);
            Add("heavy division sign", ":heavy_division_sign:", 0x2797);
            Add("black rightwards arrow", ":arrow_right:", 0x27A1);
            Add("curly loop", ":curly_loop:", 0x27B0);
            Add("double curly loop", ":loop:", 0x27BF);
            Add("arrow pointing rightwards then curving upwards", ":arrow_heading_up:", 0x2934);
            Add("arrow pointing rightwards then curving downwards", ":arrow_heading_down:", 0x2935);
            Add("leftwards black arrow", ":arrow_left:", 0x2B05);
            Add("upwards black arrow", ":arrow_up:", 0x2B06);
            Add("downwards black arrow", ":arrow_down:", 0x2B07);
            Add("black large square", ":black_large_square:", 0x2B1B);
            Add("white large square", ":white_large_square:", 0x2B1C);
            Add("white medium star", ":star:", 0x2B50);
            Add("heavy large circle", ":o:", 0x2B55);
            Add("wavy dash", ":wavy_dash:", 0x3030);
            Add("part alternation mark", ":part_alternation_mark:", 0x303D);
            Add("circled ideograph congratulation", ":congratulations:", 0x3297);
            Add("circled ideograph secret", ":secret:", 0x3299);
            Add("mahjong tile red dragon", ":mahjong:", 0x1F004);
            Add("playing card black joker", ":black_joker:", 0x1F0CF);
            Add("negative squared latin capital letter a", ":a:", 0x1F170);
            Add("negative squared latin capital letter b", ":b:", 0x1F171);
            Add("negative squared latin capital letter o", ":o2:", 0x1F17E);
            Add("negative squared latin capital letter p", ":parking:", 0x1F17F);
            Add("negative squared ab", ":ab:", 0x1F18E);
            Add("squared cl", ":cl:", 0x1F191);
            Add("squared cool", ":cool:", 0x1F192);
            Add("squared free", ":free:", 0x1F193);
            Add("squared id", ":id:", 0x1F194);
            Add("squared new", ":new:", 0x1F195);
            Add("squared ng", ":ng:", 0x1F196);
            Add("squared ok", ":ok:", 0x1F197);
            Add("squared sos", ":sos:", 0x1F198);
            Add("squared up with exclamation mark", ":up:", 0x1F199);
            Add("squared vs", ":vs:", 0x1F19A);
            Add("squared katakana koko", ":koko:", 0x1F201);
            Add("squared katakana sa", ":sa:", 0x1F202);
            Add("squared cjk unified ideograph-7121", ":u7121:", 0x1F21A);
            Add("squared cjk unified ideograph-6307", ":u6307:", 0x1F22F);
            Add("squared cjk unified ideograph-7981", ":u7981:", 0x1F232);
            Add("squared cjk unified ideograph-7a7a", ":u7a7a:", 0x1F233);
            Add("squared cjk unified ideograph-5408", ":u5408:", 0x1F234);
            Add("squared cjk unified ideograph-6e80", ":u6e80:", 0x1F235);
            Add("squared cjk unified ideograph-6709", ":u6709:", 0x1F236);
            Add("squared cjk unified ideograph-6708", ":u6708:", 0x1F237);
            Add("squared cjk unified ideograph-7533", ":u7533:", 0x1F238);
            Add("squared cjk unified ideograph-5272", ":u5272:", 0x1F239);
            Add("squared cjk unified ideograph-55b6", ":u55b6:", 0x1F23A);
            Add("circled ideograph advantage", ":ideograph_advantage:", 0x1F250);
            Add("circled ideograph accept", ":accept:", 0x1F251);
            Add("cyclone", ":cyclone:", 0x1F300);
            Add("foggy", ":foggy:", 0x1F301);
            Add("closed umbrella", ":closed_umbrella:", 0x1F302);
            Add("night with stars", ":night_with_stars:", 0x1F303);
            Add("sunrise over mountains", ":sunrise_over_mountains:", 0x1F304);
            Add("sunrise", ":sunrise:", 0x1F305);
            Add("cityscape at dusk", ":city_sunset:", 0x1F306);
            Add("sunset over buildings", ":city_sunrise:", 0x1F307);
            Add("rainbow", ":rainbow:", 0x1F308);
            Add("bridge at night", ":bridge_at_night:", 0x1F309);
            Add("water wave", ":ocean:", 0x1F30A);
            Add("volcano", ":volcano:", 0x1F30B);
            Add("milky way", ":milky_way:", 0x1F30C);
            Add("earth globe europe-africa", ":earth_africa:", 0x1F30D);
            Add("earth globe americas", ":earth_americas:", 0x1F30E);
            Add("earth globe asia-australia", ":earth_asia:", 0x1F30F);
            Add("globe with meridians", ":globe_with_meridians:", 0x1F310);
            Add("new moon symbol", ":new_moon:", 0x1F311);
            Add("waxing crescent moon symbol", ":waxing_crescent_moon:", 0x1F312);
            Add("first quarter moon symbol", ":first_quarter_moon:", 0x1F313);
            Add("waxing gibbous moon symbol", ":moon:", 0x1F314);
            Add("full moon symbol", ":full_moon:", 0x1F315);
            Add("waning gibbous moon symbol", ":waning_gibbous_moon:", 0x1F316);
            Add("last quarter moon symbol", ":last_quarter_moon:", 0x1F317);
            Add("waning crescent moon symbol", ":waning_crescent_moon:", 0x1F318);
            Add("crescent moon", ":crescent_moon:", 0x1F319);
            Add("new moon with face", ":new_moon_with_face:", 0x1F31A);
            Add("first quarter moon with face", ":first_quarter_moon_with_face:", 0x1F31B);
            Add("last quarter moon with face", ":last_quarter_moon_with_face:", 0x1F31C);
            Add("full moon with face", ":full_moon_with_face:", 0x1F31D);
            Add("sun with face", ":sun_with_face:", 0x1F31E);
            Add("glowing star", ":star2:", 0x1F31F);
            Add("shooting star", ":stars:", 0x1F320);
            Add("thermometer", ":thermometer:", 0x1F321);
            Add("white sun with small cloud", ":mostly_sunny:", 0x1F324);
            Add("white sun behind cloud", ":barely_sunny:", 0x1F325);
            Add("white sun behind cloud with rain", ":partly_sunny_rain:", 0x1F326);
            Add("cloud with rain", ":rain_cloud:", 0x1F327);
            Add("cloud with snow", ":snow_cloud:", 0x1F328);
            Add("cloud with lightning", ":lightning:", 0x1F329);
            Add("cloud with tornado", ":tornado:", 0x1F32A);
            Add("fog", ":fog:", 0x1F32B);
            Add("wind blowing face", ":wind_blowing_face:", 0x1F32C);
            Add("hot dog", ":hotdog:", 0x1F32D);
            Add("taco", ":taco:", 0x1F32E);
            Add("burrito", ":burrito:", 0x1F32F);
            Add("chestnut", ":chestnut:", 0x1F330);
            Add("seedling", ":seedling:", 0x1F331);
            Add("evergreen tree", ":evergreen_tree:", 0x1F332);
            Add("deciduous tree", ":deciduous_tree:", 0x1F333);
            Add("palm tree", ":palm_tree:", 0x1F334);
            Add("cactus", ":cactus:", 0x1F335);
            Add("hot pepper", ":hot_pepper:", 0x1F336);
            Add("tulip", ":tulip:", 0x1F337);
            Add("cherry blossom", ":cherry_blossom:", 0x1F338);
            Add("rose", ":rose:", 0x1F339);
            Add("hibiscus", ":hibiscus:", 0x1F33A);
            Add("sunflower", ":sunflower:", 0x1F33B);
            Add("blossom", ":blossom:", 0x1F33C);
            Add("ear of maize", ":corn:", 0x1F33D);
            Add("ear of rice", ":ear_of_rice:", 0x1F33E);
            Add("herb", ":herb:", 0x1F33F);
            Add("four leaf clover", ":four_leaf_clover:", 0x1F340);
            Add("maple leaf", ":maple_leaf:", 0x1F341);
            Add("fallen leaf", ":fallen_leaf:", 0x1F342);
            Add("leaf fluttering in wind", ":leaves:", 0x1F343);
            Add("mushroom", ":mushroom:", 0x1F344);
            Add("tomato", ":tomato:", 0x1F345);
            Add("aubergine", ":eggplant:", 0x1F346);
            Add("grapes", ":grapes:", 0x1F347);
            Add("melon", ":melon:", 0x1F348);
            Add("watermelon", ":watermelon:", 0x1F349);
            Add("tangerine", ":tangerine:", 0x1F34A);
            Add("lemon", ":lemon:", 0x1F34B);
            Add("banana", ":banana:", 0x1F34C);
            Add("pineapple", ":pineapple:", 0x1F34D);
            Add("red apple", ":apple:", 0x1F34E);
            Add("green apple", ":green_apple:", 0x1F34F);
            Add("pear", ":pear:", 0x1F350);
            Add("peach", ":peach:", 0x1F351);
            Add("cherries", ":cherries:", 0x1F352);
            Add("strawberry", ":strawberry:", 0x1F353);
            Add("hamburger", ":hamburger:", 0x1F354);
            Add("slice of pizza", ":pizza:", 0x1F355);
            Add("meat on bone", ":meat_on_bone:", 0x1F356);
            Add("poultry leg", ":poultry_leg:", 0x1F357);
            Add("rice cracker", ":rice_cracker:", 0x1F358);
            Add("rice ball", ":rice_ball:", 0x1F359);
            Add("cooked rice", ":rice:", 0x1F35A);
            Add("curry and rice", ":curry:", 0x1F35B);
            Add("steaming bowl", ":ramen:", 0x1F35C);
            Add("spaghetti", ":spaghetti:", 0x1F35D);
            Add("bread", ":bread:", 0x1F35E);
            Add("french fries", ":fries:", 0x1F35F);
            Add("roasted sweet potato", ":sweet_potato:", 0x1F360);
            Add("dango", ":dango:", 0x1F361);
            Add("oden", ":oden:", 0x1F362);
            Add("sushi", ":sushi:", 0x1F363);
            Add("fried shrimp", ":fried_shrimp:", 0x1F364);
            Add("fish cake with swirl design", ":fish_cake:", 0x1F365);
            Add("soft ice cream", ":icecream:", 0x1F366);
            Add("shaved ice", ":shaved_ice:", 0x1F367);
            Add("ice cream", ":ice_cream:", 0x1F368);
            Add("doughnut", ":doughnut:", 0x1F369);
            Add("cookie", ":cookie:", 0x1F36A);
            Add("chocolate bar", ":chocolate_bar:", 0x1F36B);
            Add("candy", ":candy:", 0x1F36C);
            Add("lollipop", ":lollipop:", 0x1F36D);
            Add("custard", ":custard:", 0x1F36E);
            Add("honey pot", ":honey_pot:", 0x1F36F);
            Add("shortcake", ":cake:", 0x1F370);
            Add("bento box", ":bento:", 0x1F371);
            Add("pot of food", ":stew:", 0x1F372);
            Add("cooking", ":egg:", 0x1F373);
            Add("fork and knife", ":fork_and_knife:", 0x1F374);
            Add("teacup without handle", ":tea:", 0x1F375);
            Add("sake bottle and cup", ":sake:", 0x1F376);
            Add("wine glass", ":wine_glass:", 0x1F377);
            Add("cocktail glass", ":cocktail:", 0x1F378);
            Add("tropical drink", ":tropical_drink:", 0x1F379);
            Add("beer mug", ":beer:", 0x1F37A);
            Add("clinking beer mugs", ":beers:", 0x1F37B);
            Add("baby bottle", ":baby_bottle:", 0x1F37C);
            Add("fork and knife with plate", ":knife_fork_plate:", 0x1F37D);
            Add("bottle with popping cork", ":champagne:", 0x1F37E);
            Add("popcorn", ":popcorn:", 0x1F37F);
            Add("ribbon", ":ribbon:", 0x1F380);
            Add("wrapped present", ":gift:", 0x1F381);
            Add("birthday cake", ":birthday:", 0x1F382);
            Add("jack-o-lantern", ":jack_o_lantern:", 0x1F383);
            Add("christmas tree", ":christmas_tree:", 0x1F384);
            Add("father christmas", ":santa:", 0x1F385);
            Add("fireworks", ":fireworks:", 0x1F386);
            Add("firework sparkler", ":sparkler:", 0x1F387);
            Add("balloon", ":balloon:", 0x1F388);
            Add("party popper", ":tada:", 0x1F389);
            Add("confetti ball", ":confetti_ball:", 0x1F38A);
            Add("tanabata tree", ":tanabata_tree:", 0x1F38B);
            Add("crossed flags", ":crossed_flags:", 0x1F38C);
            Add("pine decoration", ":bamboo:", 0x1F38D);
            Add("japanese dolls", ":dolls:", 0x1F38E);
            Add("carp streamer", ":flags:", 0x1F38F);
            Add("wind chime", ":wind_chime:", 0x1F390);
            Add("moon viewing ceremony", ":rice_scene:", 0x1F391);
            Add("school satchel", ":school_satchel:", 0x1F392);
            Add("graduation cap", ":mortar_board:", 0x1F393);
            Add("military medal", ":medal:", 0x1F396);
            Add("reminder ribbon", ":reminder_ribbon:", 0x1F397);
            Add("studio microphone", ":studio_microphone:", 0x1F399);
            Add("level slider", ":level_slider:", 0x1F39A);
            Add("control knobs", ":control_knobs:", 0x1F39B);
            Add("film frames", ":film_frames:", 0x1F39E);
            Add("admission tickets", ":admission_tickets:", 0x1F39F);
            Add("carousel horse", ":carousel_horse:", 0x1F3A0);
            Add("ferris wheel", ":ferris_wheel:", 0x1F3A1);
            Add("roller coaster", ":roller_coaster:", 0x1F3A2);
            Add("fishing pole and fish", ":fishing_pole_and_fish:", 0x1F3A3);
            Add("microphone", ":microphone:", 0x1F3A4);
            Add("movie camera", ":movie_camera:", 0x1F3A5);
            Add("cinema", ":cinema:", 0x1F3A6);
            Add("headphone", ":headphones:", 0x1F3A7);
            Add("artist palette", ":art:", 0x1F3A8);
            Add("top hat", ":tophat:", 0x1F3A9);
            Add("circus tent", ":circus_tent:", 0x1F3AA);
            Add("ticket", ":ticket:", 0x1F3AB);
            Add("clapper board", ":clapper:", 0x1F3AC);
            Add("performing arts", ":performing_arts:", 0x1F3AD);
            Add("video game", ":video_game:", 0x1F3AE);
            Add("direct hit", ":dart:", 0x1F3AF);
            Add("slot machine", ":slot_machine:", 0x1F3B0);
            Add("billiards", ":8ball:", 0x1F3B1);
            Add("game die", ":game_die:", 0x1F3B2);
            Add("bowling", ":bowling:", 0x1F3B3);
            Add("flower playing cards", ":flower_playing_cards:", 0x1F3B4);
            Add("musical note", ":musical_note:", 0x1F3B5);
            Add("multiple musical notes", ":notes:", 0x1F3B6);
            Add("saxophone", ":saxophone:", 0x1F3B7);
            Add("guitar", ":guitar:", 0x1F3B8);
            Add("musical keyboard", ":musical_keyboard:", 0x1F3B9);
            Add("trumpet", ":trumpet:", 0x1F3BA);
            Add("violin", ":violin:", 0x1F3BB);
            Add("musical score", ":musical_score:", 0x1F3BC);
            Add("running shirt with sash", ":running_shirt_with_sash:", 0x1F3BD);
            Add("tennis racquet and ball", ":tennis:", 0x1F3BE);
            Add("ski and ski boot", ":ski:", 0x1F3BF);
            Add("basketball and hoop", ":basketball:", 0x1F3C0);
            Add("chequered flag", ":checkered_flag:", 0x1F3C1);
            Add("snowboarder", ":snowboarder:", 0x1F3C2);
            Add("runner", ":runner:", 0x1F3C3);
            Add("surfer", ":surfer:", 0x1F3C4);
            Add("sports medal", ":sports_medal:", 0x1F3C5);
            Add("trophy", ":trophy:", 0x1F3C6);
            Add("horse racing", ":horse_racing:", 0x1F3C7);
            Add("american football", ":football:", 0x1F3C8);
            Add("rugby football", ":rugby_football:", 0x1F3C9);
            Add("swimmer", ":swimmer:", 0x1F3CA);
            Add("weight lifter", ":weight_lifter:", 0x1F3CB);
            Add("golfer", ":golfer:", 0x1F3CC);
            Add("racing motorcycle", ":racing_motorcycle:", 0x1F3CD);
            Add("racing car", ":racing_car:", 0x1F3CE);
            Add("cricket bat and ball", ":cricket_bat_and_ball:", 0x1F3CF);
            Add("volleyball", ":volleyball:", 0x1F3D0);
            Add("field hockey stick and ball", ":field_hockey_stick_and_ball:", 0x1F3D1);
            Add("ice hockey stick and puck", ":ice_hockey_stick_and_puck:", 0x1F3D2);
            Add("table tennis paddle and ball", ":table_tennis_paddle_and_ball:", 0x1F3D3);
            Add("snow capped mountain", ":snow_capped_mountain:", 0x1F3D4);
            Add("camping", ":camping:", 0x1F3D5);
            Add("beach with umbrella", ":beach_with_umbrella:", 0x1F3D6);
            Add("building construction", ":building_construction:", 0x1F3D7);
            Add("house buildings", ":house_buildings:", 0x1F3D8);
            Add("cityscape", ":cityscape:", 0x1F3D9);
            Add("derelict house building", ":derelict_house_building:", 0x1F3DA);
            Add("classical building", ":classical_building:", 0x1F3DB);
            Add("desert", ":desert:", 0x1F3DC);
            Add("desert island", ":desert_island:", 0x1F3DD);
            Add("national park", ":national_park:", 0x1F3DE);
            Add("stadium", ":stadium:", 0x1F3DF);
            Add("house building", ":house:", 0x1F3E0);
            Add("house with garden", ":house_with_garden:", 0x1F3E1);
            Add("office building", ":office:", 0x1F3E2);
            Add("japanese post office", ":post_office:", 0x1F3E3);
            Add("european post office", ":european_post_office:", 0x1F3E4);
            Add("hospital", ":hospital:", 0x1F3E5);
            Add("bank", ":bank:", 0x1F3E6);
            Add("automated teller machine", ":atm:", 0x1F3E7);
            Add("hotel", ":hotel:", 0x1F3E8);
            Add("love hotel", ":love_hotel:", 0x1F3E9);
            Add("convenience store", ":convenience_store:", 0x1F3EA);
            Add("school", ":school:", 0x1F3EB);
            Add("department store", ":department_store:", 0x1F3EC);
            Add("factory", ":factory:", 0x1F3ED);
            Add("izakaya lantern", ":izakaya_lantern:", 0x1F3EE);
            Add("japanese castle", ":japanese_castle:", 0x1F3EF);
            Add("european castle", ":european_castle:", 0x1F3F0);
            Add("waving white flag", ":waving_white_flag:", 0x1F3F3);
            Add("waving black flag", ":waving_black_flag:", 0x1F3F4);
            Add("rosette", ":rosette:", 0x1F3F5);
            Add("label", ":label:", 0x1F3F7);
            Add("badminton racquet and shuttlecock", ":badminton_racquet_and_shuttlecock:", 0x1F3F8);
            Add("bow and arrow", ":bow_and_arrow:", 0x1F3F9);
            Add("amphora", ":amphora:", 0x1F3FA);
            Add("emoji modifier fitzpatrick type-1-2", ":skin-tone-2:", 0x1F3FB);
            Add("emoji modifier fitzpatrick type-3", ":skin-tone-3:", 0x1F3FC);
            Add("emoji modifier fitzpatrick type-4", ":skin-tone-4:", 0x1F3FD);
            Add("emoji modifier fitzpatrick type-5", ":skin-tone-5:", 0x1F3FE);
            Add("emoji modifier fitzpatrick type-6", ":skin-tone-6:", 0x1F3FF);
            Add("rat", ":rat:", 0x1F400);
            Add("mouse", ":mouse2:", 0x1F401);
            Add("ox", ":ox:", 0x1F402);
            Add("water buffalo", ":water_buffalo:", 0x1F403);
            Add("cow", ":cow2:", 0x1F404);
            Add("tiger", ":tiger2:", 0x1F405);
            Add("leopard", ":leopard:", 0x1F406);
            Add("rabbit", ":rabbit2:", 0x1F407);
            Add("cat", ":cat2:", 0x1F408);
            Add("dragon", ":dragon:", 0x1F409);
            Add("crocodile", ":crocodile:", 0x1F40A);
            Add("whale", ":whale2:", 0x1F40B);
            Add("snail", ":snail:", 0x1F40C);
            Add("snake", ":snake:", 0x1F40D);
            Add("horse", ":racehorse:", 0x1F40E);
            Add("ram", ":ram:", 0x1F40F);
            Add("goat", ":goat:", 0x1F410);
            Add("sheep", ":sheep:", 0x1F411);
            Add("monkey", ":monkey:", 0x1F412);
            Add("rooster", ":rooster:", 0x1F413);
            Add("chicken", ":chicken:", 0x1F414);
            Add("dog", ":dog2:", 0x1F415);
            Add("pig", ":pig2:", 0x1F416);
            Add("boar", ":boar:", 0x1F417);
            Add("elephant", ":elephant:", 0x1F418);
            Add("octopus", ":octopus:", 0x1F419);
            Add("spiral shell", ":shell:", 0x1F41A);
            Add("bug", ":bug:", 0x1F41B);
            Add("ant", ":ant:", 0x1F41C);
            Add("honeybee", ":bee:", 0x1F41D);
            Add("lady beetle", ":beetle:", 0x1F41E);
            Add("fish", ":fish:", 0x1F41F);
            Add("tropical fish", ":tropical_fish:", 0x1F420);
            Add("blowfish", ":blowfish:", 0x1F421);
            Add("turtle", ":turtle:", 0x1F422);
            Add("hatching chick", ":hatching_chick:", 0x1F423);
            Add("baby chick", ":baby_chick:", 0x1F424);
            Add("front-facing baby chick", ":hatched_chick:", 0x1F425);
            Add("bird", ":bird:", 0x1F426);
            Add("penguin", ":penguin:", 0x1F427);
            Add("koala", ":koala:", 0x1F428);
            Add("poodle", ":poodle:", 0x1F429);
            Add("dromedary camel", ":dromedary_camel:", 0x1F42A);
            Add("bactrian camel", ":camel:", 0x1F42B);
            Add("dolphin", ":dolphin:", 0x1F42C);
            Add("mouse face", ":mouse:", 0x1F42D);
            Add("cow face", ":cow:", 0x1F42E);
            Add("tiger face", ":tiger:", 0x1F42F);
            Add("rabbit face", ":rabbit:", 0x1F430);
            Add("cat face", ":cat:", 0x1F431);
            Add("dragon face", ":dragon_face:", 0x1F432);
            Add("spouting whale", ":whale:", 0x1F433);
            Add("horse face", ":horse:", 0x1F434);
            Add("monkey face", ":monkey_face:", 0x1F435);
            Add("dog face", ":dog:", 0x1F436);
            Add("pig face", ":pig:", 0x1F437);
            Add("frog face", ":frog:", 0x1F438);
            Add("hamster face", ":hamster:", 0x1F439);
            Add("wolf face", ":wolf:", 0x1F43A);
            Add("bear face", ":bear:", 0x1F43B);
            Add("panda face", ":panda_face:", 0x1F43C);
            Add("pig nose", ":pig_nose:", 0x1F43D);
            Add("paw prints", ":feet:", 0x1F43E);
            Add("chipmunk", ":chipmunk:", 0x1F43F);
            Add("eyes", ":eyes:", 0x1F440);
            Add("eye", ":eye:", 0x1F441);
            Add("ear", ":ear:", 0x1F442);
            Add("nose", ":nose:", 0x1F443);
            Add("mouth", ":lips:", 0x1F444);
            Add("tongue", ":tongue:", 0x1F445);
            Add("white up pointing backhand index", ":point_up_2:", 0x1F446);
            Add("white down pointing backhand index", ":point_down:", 0x1F447);
            Add("white left pointing backhand index", ":point_left:", 0x1F448);
            Add("white right pointing backhand index", ":point_right:", 0x1F449);
            Add("fisted hand sign", ":facepunch:", 0x1F44A);
            Add("waving hand sign", ":wave:", 0x1F44B);
            Add("ok hand sign", ":ok_hand:", 0x1F44C);
            Add("thumbs up sign", ":+1:", 0x1F44D);
            Add("thumbs down sign", ":-1:", 0x1F44E);
            Add("clapping hands sign", ":clap:", 0x1F44F);
            Add("open hands sign", ":open_hands:", 0x1F450);
            Add("crown", ":crown:", 0x1F451);
            Add("womans hat", ":womans_hat:", 0x1F452);
            Add("eyeglasses", ":eyeglasses:", 0x1F453);
            Add("necktie", ":necktie:", 0x1F454);
            Add("t-shirt", ":shirt:", 0x1F455);
            Add("jeans", ":jeans:", 0x1F456);
            Add("dress", ":dress:", 0x1F457);
            Add("kimono", ":kimono:", 0x1F458);
            Add("bikini", ":bikini:", 0x1F459);
            Add("womans clothes", ":womans_clothes:", 0x1F45A);
            Add("purse", ":purse:", 0x1F45B);
            Add("handbag", ":handbag:", 0x1F45C);
            Add("pouch", ":pouch:", 0x1F45D);
            Add("mans shoe", ":mans_shoe:", 0x1F45E);
            Add("athletic shoe", ":athletic_shoe:", 0x1F45F);
            Add("high-heeled shoe", ":high_heel:", 0x1F460);
            Add("womans sandal", ":sandal:", 0x1F461);
            Add("womans boots", ":boot:", 0x1F462);
            Add("footprints", ":footprints:", 0x1F463);
            Add("bust in silhouette", ":bust_in_silhouette:", 0x1F464);
            Add("busts in silhouette", ":busts_in_silhouette:", 0x1F465);
            Add("boy", ":boy:", 0x1F466);
            Add("girl", ":girl:", 0x1F467);
            Add("man", ":man:", 0x1F468);
            Add("woman", ":woman:", 0x1F469);
            Add("family", ":family:", 0x1F46A);
            Add("man and woman holding hands", ":couple:", 0x1F46B);
            Add("two men holding hands", ":two_men_holding_hands:", 0x1F46C);
            Add("two women holding hands", ":two_women_holding_hands:", 0x1F46D);
            Add("police officer", ":cop:", 0x1F46E);
            Add("woman with bunny ears", ":dancers:", 0x1F46F);
            Add("bride with veil", ":bride_with_veil:", 0x1F470);
            Add("person with blond hair", ":person_with_blond_hair:", 0x1F471);
            Add("man with gua pi mao", ":man_with_gua_pi_mao:", 0x1F472);
            Add("man with turban", ":man_with_turban:", 0x1F473);
            Add("older man", ":older_man:", 0x1F474);
            Add("older woman", ":older_woman:", 0x1F475);
            Add("baby", ":baby:", 0x1F476);
            Add("construction worker", ":construction_worker:", 0x1F477);
            Add("princess", ":princess:", 0x1F478);
            Add("japanese ogre", ":japanese_ogre:", 0x1F479);
            Add("japanese goblin", ":japanese_goblin:", 0x1F47A);
            Add("ghost", ":ghost:", 0x1F47B);
            Add("baby angel", ":angel:", 0x1F47C);
            Add("extraterrestrial alien", ":alien:", 0x1F47D);
            Add("alien monster", ":space_invader:", 0x1F47E);
            Add("imp", ":imp:", 0x1F47F);
            Add("skull", ":skull:", 0x1F480);
            Add("information desk person", ":information_desk_person:", 0x1F481);
            Add("guardsman", ":guardsman:", 0x1F482);
            Add("dancer", ":dancer:", 0x1F483);
            Add("lipstick", ":lipstick:", 0x1F484);
            Add("nail polish", ":nail_care:", 0x1F485);
            Add("face massage", ":massage:", 0x1F486);
            Add("haircut", ":haircut:", 0x1F487);
            Add("barber pole", ":barber:", 0x1F488);
            Add("syringe", ":syringe:", 0x1F489);
            Add("pill", ":pill:", 0x1F48A);
            Add("kiss mark", ":kiss:", 0x1F48B);
            Add("love letter", ":love_letter:", 0x1F48C);
            Add("ring", ":ring:", 0x1F48D);
            Add("gem stone", ":gem:", 0x1F48E);
            Add("kiss", ":couplekiss:", 0x1F48F);
            Add("bouquet", ":bouquet:", 0x1F490);
            Add("couple with heart", ":couple_with_heart:", 0x1F491);
            Add("wedding", ":wedding:", 0x1F492);
            Add("beating heart", ":heartbeat:", 0x1F493);
            Add("broken heart", ":broken_heart:", 0x1F494);
            Add("two hearts", ":two_hearts:", 0x1F495);
            Add("sparkling heart", ":sparkling_heart:", 0x1F496);
            Add("growing heart", ":heartpulse:", 0x1F497);
            Add("heart with arrow", ":cupid:", 0x1F498);
            Add("blue heart", ":blue_heart:", 0x1F499);
            Add("green heart", ":green_heart:", 0x1F49A);
            Add("yellow heart", ":yellow_heart:", 0x1F49B);
            Add("purple heart", ":purple_heart:", 0x1F49C);
            Add("heart with ribbon", ":gift_heart:", 0x1F49D);
            Add("revolving hearts", ":revolving_hearts:", 0x1F49E);
            Add("heart decoration", ":heart_decoration:", 0x1F49F);
            Add("diamond shape with a dot inside", ":diamond_shape_with_a_dot_inside:", 0x1F4A0);
            Add("electric light bulb", ":bulb:", 0x1F4A1);
            Add("anger symbol", ":anger:", 0x1F4A2);
            Add("bomb", ":bomb:", 0x1F4A3);
            Add("sleeping symbol", ":zzz:", 0x1F4A4);
            Add("collision symbol", ":boom:", 0x1F4A5);
            Add("splashing sweat symbol", ":sweat_drops:", 0x1F4A6);
            Add("droplet", ":droplet:", 0x1F4A7);
            Add("dash symbol", ":dash:", 0x1F4A8);
            Add("pile of poo", ":hankey:", 0x1F4A9);
            Add("flexed biceps", ":muscle:", 0x1F4AA);
            Add("dizzy symbol", ":dizzy:", 0x1F4AB);
            Add("speech balloon", ":speech_balloon:", 0x1F4AC);
            Add("thought balloon", ":thought_balloon:", 0x1F4AD);
            Add("white flower", ":white_flower:", 0x1F4AE);
            Add("hundred points symbol", ":100:", 0x1F4AF);
            Add("money bag", ":moneybag:", 0x1F4B0);
            Add("currency exchange", ":currency_exchange:", 0x1F4B1);
            Add("heavy dollar sign", ":heavy_dollar_sign:", 0x1F4B2);
            Add("credit card", ":credit_card:", 0x1F4B3);
            Add("banknote with yen sign", ":yen:", 0x1F4B4);
            Add("banknote with dollar sign", ":dollar:", 0x1F4B5);
            Add("banknote with euro sign", ":euro:", 0x1F4B6);
            Add("banknote with pound sign", ":pound:", 0x1F4B7);
            Add("money with wings", ":money_with_wings:", 0x1F4B8);
            Add("chart with upwards trend and yen sign", ":chart:", 0x1F4B9);
            Add("seat", ":seat:", 0x1F4BA);
            Add("personal computer", ":computer:", 0x1F4BB);
            Add("briefcase", ":briefcase:", 0x1F4BC);
            Add("minidisc", ":minidisc:", 0x1F4BD);
            Add("floppy disk", ":floppy_disk:", 0x1F4BE);
            Add("optical disc", ":cd:", 0x1F4BF);
            Add("dvd", ":dvd:", 0x1F4C0);
            Add("file folder", ":file_folder:", 0x1F4C1);
            Add("open file folder", ":open_file_folder:", 0x1F4C2);
            Add("page with curl", ":page_with_curl:", 0x1F4C3);
            Add("page facing up", ":page_facing_up:", 0x1F4C4);
            Add("calendar", ":date:", 0x1F4C5);
            Add("tear-off calendar", ":calendar:", 0x1F4C6);
            Add("card index", ":card_index:", 0x1F4C7);
            Add("chart with upwards trend", ":chart_with_upwards_trend:", 0x1F4C8);
            Add("chart with downwards trend", ":chart_with_downwards_trend:", 0x1F4C9);
            Add("bar chart", ":bar_chart:", 0x1F4CA);
            Add("clipboard", ":clipboard:", 0x1F4CB);
            Add("pushpin", ":pushpin:", 0x1F4CC);
            Add("round pushpin", ":round_pushpin:", 0x1F4CD);
            Add("paperclip", ":paperclip:", 0x1F4CE);
            Add("straight ruler", ":straight_ruler:", 0x1F4CF);
            Add("triangular ruler", ":triangular_ruler:", 0x1F4D0);
            Add("bookmark tabs", ":bookmark_tabs:", 0x1F4D1);
            Add("ledger", ":ledger:", 0x1F4D2);
            Add("notebook", ":notebook:", 0x1F4D3);
            Add("notebook with decorative cover", ":notebook_with_decorative_cover:", 0x1F4D4);
            Add("closed book", ":closed_book:", 0x1F4D5);
            Add("open book", ":book:", 0x1F4D6);
            Add("green book", ":green_book:", 0x1F4D7);
            Add("blue book", ":blue_book:", 0x1F4D8);
            Add("orange book", ":orange_book:", 0x1F4D9);
            Add("books", ":books:", 0x1F4DA);
            Add("name badge", ":name_badge:", 0x1F4DB);
            Add("scroll", ":scroll:", 0x1F4DC);
            Add("memo", ":memo:", 0x1F4DD);
            Add("telephone receiver", ":telephone_receiver:", 0x1F4DE);
            Add("pager", ":pager:", 0x1F4DF);
            Add("fax machine", ":fax:", 0x1F4E0);
            // Add("satellite antenna", ":satellite:", 0x1F4E1);
            Add("public address loudspeaker", ":loudspeaker:", 0x1F4E2);
            Add("cheering megaphone", ":mega:", 0x1F4E3);
            Add("outbox tray", ":outbox_tray:", 0x1F4E4);
            Add("inbox tray", ":inbox_tray:", 0x1F4E5);
            Add("package", ":package:", 0x1F4E6);
            Add("e-mail symbol", ":e-mail:", 0x1F4E7);
            Add("incoming envelope", ":incoming_envelope:", 0x1F4E8);
            Add("envelope with downwards arrow above", ":envelope_with_arrow:", 0x1F4E9);
            Add("closed mailbox with lowered flag", ":mailbox_closed:", 0x1F4EA);
            Add("closed mailbox with raised flag", ":mailbox:", 0x1F4EB);
            Add("open mailbox with raised flag", ":mailbox_with_mail:", 0x1F4EC);
            Add("open mailbox with lowered flag", ":mailbox_with_no_mail:", 0x1F4ED);
            Add("postbox", ":postbox:", 0x1F4EE);
            Add("postal horn", ":postal_horn:", 0x1F4EF);
            Add("newspaper", ":newspaper:", 0x1F4F0);
            Add("mobile phone", ":iphone:", 0x1F4F1);
            Add("mobile phone with rightwards arrow at left", ":calling:", 0x1F4F2);
            Add("vibration mode", ":vibration_mode:", 0x1F4F3);
            Add("mobile phone off", ":mobile_phone_off:", 0x1F4F4);
            Add("no mobile phones", ":no_mobile_phones:", 0x1F4F5);
            Add("antenna with bars", ":signal_strength:", 0x1F4F6);
            Add("camera", ":camera:", 0x1F4F7);
            Add("camera with flash", ":camera_with_flash:", 0x1F4F8);
            Add("video camera", ":video_camera:", 0x1F4F9);
            Add("television", ":tv:", 0x1F4FA);
            Add("radio", ":radio:", 0x1F4FB);
            Add("videocassette", ":vhs:", 0x1F4FC);
            Add("film projector", ":film_projector:", 0x1F4FD);
            Add("prayer beads", ":prayer_beads:", 0x1F4FF);
            Add("twisted rightwards arrows", ":twisted_rightwards_arrows:", 0x1F500);
            Add("clockwise rightwards and leftwards open circle arrows", ":repeat:", 0x1F501);
            Add("clockwise rightwards and leftwards open circle arrows with circled one overlay", ":repeat_one:", 0x1F502);
            Add("clockwise downwards and upwards open circle arrows", ":arrows_clockwise:", 0x1F503);
            Add("anticlockwise downwards and upwards open circle arrows", ":arrows_counterclockwise:", 0x1F504);
            Add("low brightness symbol", ":low_brightness:", 0x1F505);
            Add("high brightness symbol", ":high_brightness:", 0x1F506);
            Add("speaker with cancellation stroke", ":mute:", 0x1F507);
            Add("speaker", ":speaker:", 0x1F508);
            Add("speaker with one sound wave", ":sound:", 0x1F509);
            Add("speaker with three sound waves", ":loud_sound:", 0x1F50A);
            Add("battery", ":battery:", 0x1F50B);
            Add("electric plug", ":electric_plug:", 0x1F50C);
            Add("left-pointing magnifying glass", ":mag:", 0x1F50D);
            Add("right-pointing magnifying glass", ":mag_right:", 0x1F50E);
            Add("lock with ink pen", ":lock_with_ink_pen:", 0x1F50F);
            Add("closed lock with key", ":closed_lock_with_key:", 0x1F510);
            Add("key", ":key:", 0x1F511);
            Add("lock", ":lock:", 0x1F512);
            Add("open lock", ":unlock:", 0x1F513);
            Add("bell", ":bell:", 0x1F514);
            Add("bell with cancellation stroke", ":no_bell:", 0x1F515);
            Add("bookmark", ":bookmark:", 0x1F516);
            Add("link symbol", ":link:", 0x1F517);
            Add("radio button", ":radio_button:", 0x1F518);
            Add("back with leftwards arrow above", ":back:", 0x1F519);
            Add("end with leftwards arrow above", ":end:", 0x1F51A);
            Add("on with exclamation mark with left right arrow above", ":on:", 0x1F51B);
            Add("soon with rightwards arrow above", ":soon:", 0x1F51C);
            Add("top with upwards arrow above", ":top:", 0x1F51D);
            Add("no one under eighteen symbol", ":underage:", 0x1F51E);
            Add("keycap ten", ":keycap_ten:", 0x1F51F);
            Add("input symbol for latin capital letters", ":capital_abcd:", 0x1F520);
            Add("input symbol for latin small letters", ":abcd:", 0x1F521);
            Add("input symbol for numbers", ":1234:", 0x1F522);
            Add("input symbol for symbols", ":symbols:", 0x1F523);
            Add("input symbol for latin letters", ":abc:", 0x1F524);
            Add("fire", ":fire:", 0x1F525);
            Add("electric torch", ":flashlight:", 0x1F526);
            Add("wrench", ":wrench:", 0x1F527);
            Add("hammer", ":hammer:", 0x1F528);
            Add("nut and bolt", ":nut_and_bolt:", 0x1F529);
            Add("hocho", ":hocho:", 0x1F52A);
            Add("pistol", ":gun:", 0x1F52B);
            Add("microscope", ":microscope:", 0x1F52C);
            Add("telescope", ":telescope:", 0x1F52D);
            Add("crystal ball", ":crystal_ball:", 0x1F52E);
            Add("six pointed star with middle dot", ":six_pointed_star:", 0x1F52F);
            Add("japanese symbol for beginner", ":beginner:", 0x1F530);
            Add("trident emblem", ":trident:", 0x1F531);
            Add("black square button", ":black_square_button:", 0x1F532);
            Add("white square button", ":white_square_button:", 0x1F533);
            Add("large red circle", ":red_circle:", 0x1F534);
            Add("large blue circle", ":large_blue_circle:", 0x1F535);
            Add("large orange diamond", ":large_orange_diamond:", 0x1F536);
            Add("large blue diamond", ":large_blue_diamond:", 0x1F537);
            Add("small orange diamond", ":small_orange_diamond:", 0x1F538);
            Add("small blue diamond", ":small_blue_diamond:", 0x1F539);
            Add("up-pointing red triangle", ":small_red_triangle:", 0x1F53A);
            Add("down-pointing red triangle", ":small_red_triangle_down:", 0x1F53B);
            Add("up-pointing small red triangle", ":arrow_up_small:", 0x1F53C);
            Add("down-pointing small red triangle", ":arrow_down_small:", 0x1F53D);
            Add("om symbol", ":om_symbol:", 0x1F549);
            Add("dove of peace", ":dove_of_peace:", 0x1F54A);
            Add("kaaba", ":kaaba:", 0x1F54B);
            Add("mosque", ":mosque:", 0x1F54C);
            Add("synagogue", ":synagogue:", 0x1F54D);
            Add("menorah with nine branches", ":menorah_with_nine_branches:", 0x1F54E);
            Add("clock face one oclock", ":clock1:", 0x1F550);
            Add("clock face two oclock", ":clock2:", 0x1F551);
            Add("clock face three oclock", ":clock3:", 0x1F552);
            Add("clock face four oclock", ":clock4:", 0x1F553);
            Add("clock face five oclock", ":clock5:", 0x1F554);
            Add("clock face six oclock", ":clock6:", 0x1F555);
            Add("clock face seven oclock", ":clock7:", 0x1F556);
            Add("clock face eight oclock", ":clock8:", 0x1F557);
            Add("clock face nine oclock", ":clock9:", 0x1F558);
            Add("clock face ten oclock", ":clock10:", 0x1F559);
            Add("clock face eleven oclock", ":clock11:", 0x1F55A);
            Add("clock face twelve oclock", ":clock12:", 0x1F55B);
            Add("clock face one-thirty", ":clock130:", 0x1F55C);
            Add("clock face two-thirty", ":clock230:", 0x1F55D);
            Add("clock face three-thirty", ":clock330:", 0x1F55E);
            Add("clock face four-thirty", ":clock430:", 0x1F55F);
            Add("clock face five-thirty", ":clock530:", 0x1F560);
            Add("clock face six-thirty", ":clock630:", 0x1F561);
            Add("clock face seven-thirty", ":clock730:", 0x1F562);
            Add("clock face eight-thirty", ":clock830:", 0x1F563);
            Add("clock face nine-thirty", ":clock930:", 0x1F564);
            Add("clock face ten-thirty", ":clock1030:", 0x1F565);
            Add("clock face eleven-thirty", ":clock1130:", 0x1F566);
            Add("clock face twelve-thirty", ":clock1230:", 0x1F567);
            Add("candle", ":candle:", 0x1F56F);
            Add("mantelpiece clock", ":mantelpiece_clock:", 0x1F570);
            Add("hole", ":hole:", 0x1F573);
            Add("man in business suit levitating", ":man_in_business_suit_levitating:", 0x1F574);
            Add("sleuth or spy", ":sleuth_or_spy:", 0x1F575);
            Add("dark sunglasses", ":dark_sunglasses:", 0x1F576);
            Add("spider", ":spider:", 0x1F577);
            Add("spider web", ":spider_web:", 0x1F578);
            Add("joystick", ":joystick:", 0x1F579);
            Add("linked paperclips", ":linked_paperclips:", 0x1F587);
            Add("lower left ballpoint pen", ":lower_left_ballpoint_pen:", 0x1F58A);
            Add("lower left fountain pen", ":lower_left_fountain_pen:", 0x1F58B);
            Add("lower left paintbrush", ":lower_left_paintbrush:", 0x1F58C);
            Add("lower left crayon", ":lower_left_crayon:", 0x1F58D);
            Add("raised hand with fingers splayed", ":raised_hand_with_fingers_splayed:", 0x1F590);
            Add("reversed hand with middle finger extended", ":middle_finger:", 0x1F595);
            Add("raised hand with part between middle and ring fingers", ":spock-hand:", 0x1F596);
            Add("desktop computer", ":desktop_computer:", 0x1F5A5);
            Add("printer", ":printer:", 0x1F5A8);
            Add("three button mouse", ":three_button_mouse:", 0x1F5B1);
            Add("trackball", ":trackball:", 0x1F5B2);
            Add("frame with picture", ":frame_with_picture:", 0x1F5BC);
            Add("card index dividers", ":card_index_dividers:", 0x1F5C2);
            Add("card file box", ":card_file_box:", 0x1F5C3);
            Add("file cabinet", ":file_cabinet:", 0x1F5C4);
            Add("wastebasket", ":wastebasket:", 0x1F5D1);
            Add("spiral note pad", ":spiral_note_pad:", 0x1F5D2);
            Add("spiral calendar pad", ":spiral_calendar_pad:", 0x1F5D3);
            Add("compression", ":compression:", 0x1F5DC);
            Add("old key", ":old_key:", 0x1F5DD);
            Add("rolled-up newspaper", ":rolled_up_newspaper:", 0x1F5DE);
            Add("dagger knife", ":dagger_knife:", 0x1F5E1);
            Add("speaking head in silhouette", ":speaking_head_in_silhouette:", 0x1F5E3);
            Add("left speech bubble", ":left_speech_bubble:", 0x1F5E8);
            Add("right anger bubble", ":right_anger_bubble:", 0x1F5EF);
            Add("ballot box with ballot", ":ballot_box_with_ballot:", 0x1F5F3);
            Add("world map", ":world_map:", 0x1F5FA);
            Add("mount fuji", ":mount_fuji:", 0x1F5FB);
            Add("tokyo tower", ":tokyo_tower:", 0x1F5FC);
            Add("statue of liberty", ":statue_of_liberty:", 0x1F5FD);
            Add("silhouette of japan", ":japan:", 0x1F5FE);
            Add("moyai", ":moyai:", 0x1F5FF);
            Add("grinning face", ":grinning:", 0x1F600);
            Add("grinning face with smiling eyes", ":grin:", 0x1F601);
            Add("face with tears of joy", ":joy:", 0x1F602);
            Add("smiling face with open mouth", ":smiley:", 0x1F603);
            Add("smiling face with open mouth and smiling eyes", ":smile:", 0x1F604);
            Add("smiling face with open mouth and cold sweat", ":sweat_smile:", 0x1F605);
            Add("smiling face with open mouth and tightly-closed eyes", ":laughing:", 0x1F606);
            Add("smiling face with halo", ":innocent:", 0x1F607);
            Add("smiling face with horns", ":smiling_imp:", 0x1F608);
            Add("winking face", ":wink:", 0x1F609);
            Add("smiling face with smiling eyes", ":blush:", 0x1F60A);
            Add("face savouring delicious food", ":yum:", 0x1F60B);
            Add("relieved face", ":relieved:", 0x1F60C);
            Add("smiling face with heart-shaped eyes", ":heart_eyes:", 0x1F60D);
            Add("smiling face with sunglasses", ":sunglasses:", 0x1F60E);
            Add("smirking face", ":smirk:", 0x1F60F);
            Add("neutral face", ":neutral_face:", 0x1F610);
            Add("expressionless face", ":expressionless:", 0x1F611);
            Add("unamused face", ":unamused:", 0x1F612);
            Add("face with cold sweat", ":sweat:", 0x1F613);
            Add("pensive face", ":pensive:", 0x1F614);
            Add("confused face", ":confused:", 0x1F615);
            Add("confounded face", ":confounded:", 0x1F616);
            Add("kissing face", ":kissing:", 0x1F617);
            Add("face throwing a kiss", ":kissing_heart:", 0x1F618);
            Add("kissing face with smiling eyes", ":kissing_smiling_eyes:", 0x1F619);
            Add("kissing face with closed eyes", ":kissing_closed_eyes:", 0x1F61A);
            Add("face with stuck-out tongue", ":stuck_out_tongue:", 0x1F61B);
            Add("face with stuck-out tongue and winking eye", ":stuck_out_tongue_winking_eye:", 0x1F61C);
            Add("face with stuck-out tongue and tightly-closed eyes", ":stuck_out_tongue_closed_eyes:", 0x1F61D);
            Add("disappointed face", ":disappointed:", 0x1F61E);
            Add("worried face", ":worried:", 0x1F61F);
            Add("angry face", ":angry:", 0x1F620);
            Add("pouting face", ":rage:", 0x1F621);
            Add("crying face", ":cry:", 0x1F622);
            Add("persevering face", ":persevere:", 0x1F623);
            Add("face with look of triumph", ":triumph:", 0x1F624);
            Add("disappointed but relieved face", ":disappointed_relieved:", 0x1F625);
            Add("frowning face with open mouth", ":frowning:", 0x1F626);
            Add("anguished face", ":anguished:", 0x1F627);
            Add("fearful face", ":fearful:", 0x1F628);
            Add("weary face", ":weary:", 0x1F629);
            Add("sleepy face", ":sleepy:", 0x1F62A);
            Add("tired face", ":tired_face:", 0x1F62B);
            Add("grimacing face", ":grimacing:", 0x1F62C);
            Add("loudly crying face", ":sob:", 0x1F62D);
            Add("face with open mouth", ":open_mouth:", 0x1F62E);
            Add("hushed face", ":hushed:", 0x1F62F);
            Add("face with open mouth and cold sweat", ":cold_sweat:", 0x1F630);
            Add("face screaming in fear", ":scream:", 0x1F631);
            Add("astonished face", ":astonished:", 0x1F632);
            Add("flushed face", ":flushed:", 0x1F633);
            Add("sleeping face", ":sleeping:", 0x1F634);
            Add("dizzy face", ":dizzy_face:", 0x1F635);
            Add("face without mouth", ":no_mouth:", 0x1F636);
            Add("face with medical mask", ":mask:", 0x1F637);
            Add("grinning cat face with smiling eyes", ":smile_cat:", 0x1F638);
            Add("cat face with tears of joy", ":joy_cat:", 0x1F639);
            Add("smiling cat face with open mouth", ":smiley_cat:", 0x1F63A);
            Add("smiling cat face with heart-shaped eyes", ":heart_eyes_cat:", 0x1F63B);
            Add("cat face with wry smile", ":smirk_cat:", 0x1F63C);
            Add("kissing cat face with closed eyes", ":kissing_cat:", 0x1F63D);
            Add("pouting cat face", ":pouting_cat:", 0x1F63E);
            Add("crying cat face", ":crying_cat_face:", 0x1F63F);
            Add("weary cat face", ":scream_cat:", 0x1F640);
            Add("slightly frowning face", ":slightly_frowning_face:", 0x1F641);
            Add("slightly smiling face", ":slightly_smiling_face:", 0x1F642);
            Add("upside-down face", ":upside_down_face:", 0x1F643);
            Add("face with rolling eyes", ":face_with_rolling_eyes:", 0x1F644);
            Add("face with no good gesture", ":no_good:", 0x1F645);
            Add("face with ok gesture", ":ok_woman:", 0x1F646);
            Add("person bowing deeply", ":bow:", 0x1F647);
            Add("see-no-evil monkey", ":see_no_evil:", 0x1F648);
            Add("hear-no-evil monkey", ":hear_no_evil:", 0x1F649);
            Add("speak-no-evil monkey", ":speak_no_evil:", 0x1F64A);
            Add("happy person raising one hand", ":raising_hand:", 0x1F64B);
            Add("person raising both hands in celebration", ":raised_hands:", 0x1F64C);
            Add("person frowning", ":person_frowning:", 0x1F64D);
            Add("person with pouting face", ":person_with_pouting_face:", 0x1F64E);
            Add("person with folded hands", ":pray:", 0x1F64F);
            Add("rocket", ":rocket:", 0x1F680);
            Add("helicopter", ":helicopter:", 0x1F681);
            Add("steam locomotive", ":steam_locomotive:", 0x1F682);
            Add("railway car", ":railway_car:", 0x1F683);
            Add("high-speed train", ":bullettrain_side:", 0x1F684);
            Add("high-speed train with bullet nose", ":bullettrain_front:", 0x1F685);
            Add("train", ":train2:", 0x1F686);
            Add("metro", ":metro:", 0x1F687);
            Add("light rail", ":light_rail:", 0x1F688);
            Add("station", ":station:", 0x1F689);
            Add("tram", ":tram:", 0x1F68A);
            Add("tram car", ":train:", 0x1F68B);
            Add("bus", ":bus:", 0x1F68C);
            Add("oncoming bus", ":oncoming_bus:", 0x1F68D);
            Add("trolleybus", ":trolleybus:", 0x1F68E);
            Add("bus stop", ":busstop:", 0x1F68F);
            Add("minibus", ":minibus:", 0x1F690);
            Add("ambulance", ":ambulance:", 0x1F691);
            Add("fire engine", ":fire_engine:", 0x1F692);
            Add("police car", ":police_car:", 0x1F693);
            Add("oncoming police car", ":oncoming_police_car:", 0x1F694);
            Add("taxi", ":taxi:", 0x1F695);
            Add("oncoming taxi", ":oncoming_taxi:", 0x1F696);
            Add("automobile", ":car:", 0x1F697);
            Add("oncoming automobile", ":oncoming_automobile:", 0x1F698);
            Add("recreational vehicle", ":blue_car:", 0x1F699);
            Add("delivery truck", ":truck:", 0x1F69A);
            Add("articulated lorry", ":articulated_lorry:", 0x1F69B);
            Add("tractor", ":tractor:", 0x1F69C);
            Add("monorail", ":monorail:", 0x1F69D);
            Add("mountain railway", ":mountain_railway:", 0x1F69E);
            Add("suspension railway", ":suspension_railway:", 0x1F69F);
            Add("mountain cableway", ":mountain_cableway:", 0x1F6A0);
            Add("aerial tramway", ":aerial_tramway:", 0x1F6A1);
            Add("ship", ":ship:", 0x1F6A2);
            Add("rowboat", ":rowboat:", 0x1F6A3);
            Add("speedboat", ":speedboat:", 0x1F6A4);
            Add("horizontal traffic light", ":traffic_light:", 0x1F6A5);
            Add("vertical traffic light", ":vertical_traffic_light:", 0x1F6A6);
            Add("construction sign", ":construction:", 0x1F6A7);
            Add("police cars revolving light", ":rotating_light:", 0x1F6A8);
            Add("triangular flag on post", ":triangular_flag_on_post:", 0x1F6A9);
            Add("door", ":door:", 0x1F6AA);
            Add("no entry sign", ":no_entry_sign:", 0x1F6AB);
            Add("smoking symbol", ":smoking:", 0x1F6AC);
            Add("no smoking symbol", ":no_smoking:", 0x1F6AD);
            Add("put litter in its place symbol", ":put_litter_in_its_place:", 0x1F6AE);
            Add("do not litter symbol", ":do_not_litter:", 0x1F6AF);
            Add("potable water symbol", ":potable_water:", 0x1F6B0);
            Add("non-potable water symbol", ":non-potable_water:", 0x1F6B1);
            Add("bicycle", ":bike:", 0x1F6B2);
            Add("no bicycles", ":no_bicycles:", 0x1F6B3);
            Add("bicyclist", ":bicyclist:", 0x1F6B4);
            Add("mountain bicyclist", ":mountain_bicyclist:", 0x1F6B5);
            Add("pedestrian", ":walking:", 0x1F6B6);
            Add("no pedestrians", ":no_pedestrians:", 0x1F6B7);
            Add("children crossing", ":children_crossing:", 0x1F6B8);
            Add("mens symbol", ":mens:", 0x1F6B9);
            Add("womens symbol", ":womens:", 0x1F6BA);
            Add("restroom", ":restroom:", 0x1F6BB);
            Add("baby symbol", ":baby_symbol:", 0x1F6BC);
            Add("toilet", ":toilet:", 0x1F6BD);
            Add("water closet", ":wc:", 0x1F6BE);
            Add("shower", ":shower:", 0x1F6BF);
            Add("bath", ":bath:", 0x1F6C0);
            Add("bathtub", ":bathtub:", 0x1F6C1);
            Add("passport control", ":passport_control:", 0x1F6C2);
            Add("customs", ":customs:", 0x1F6C3);
            Add("baggage claim", ":baggage_claim:", 0x1F6C4);
            Add("left luggage", ":left_luggage:", 0x1F6C5);
            Add("couch and lamp", ":couch_and_lamp:", 0x1F6CB);
            Add("sleeping accommodation", ":sleeping_accommodation:", 0x1F6CC);
            Add("shopping bags", ":shopping_bags:", 0x1F6CD);
            Add("bellhop bell", ":bellhop_bell:", 0x1F6CE);
            Add("bed", ":bed:", 0x1F6CF);
            Add("place of worship", ":place_of_worship:", 0x1F6D0);
            Add("hammer and wrench", ":hammer_and_wrench:", 0x1F6E0);
            Add("shield", ":shield:", 0x1F6E1);
            Add("oil drum", ":oil_drum:", 0x1F6E2);
            Add("motorway", ":motorway:", 0x1F6E3);
            Add("railway track", ":railway_track:", 0x1F6E4);
            Add("motor boat", ":motor_boat:", 0x1F6E5);
            Add("small airplane", ":small_airplane:", 0x1F6E9);
            Add("airplane departure", ":airplane_departure:", 0x1F6EB);
            Add("airplane arriving", ":airplane_arriving:", 0x1F6EC);
            Add("satellite", ":satellite:", 0x1F6F0);
            Add("passenger ship", ":passenger_ship:", 0x1F6F3);
            Add("zipper-mouth face", ":zipper_mouth_face:", 0x1F910);
            Add("money-mouth face", ":money_mouth_face:", 0x1F911);
            Add("face with thermometer", ":face_with_thermometer:", 0x1F912);
            Add("nerd face", ":nerd_face:", 0x1F913);
            Add("thinking face", ":thinking_face:", 0x1F914);
            Add("face with head-bandage", ":face_with_head_bandage:", 0x1F915);
            Add("robot face", ":robot_face:", 0x1F916);
            Add("hugging face", ":hugging_face:", 0x1F917);
            Add("sign of the horns", ":the_horns:", 0x1F918);
            Add("crab", ":crab:", 0x1F980);
            Add("lion face", ":lion_face:", 0x1F981);
            Add("scorpion", ":scorpion:", 0x1F982);
            Add("turkey", ":turkey:", 0x1F983);
            Add("unicorn face", ":unicorn_face:", 0x1F984);
            Add("cheese wedge", ":cheese_wedge:", 0x1F9C0);
            Add("hash key", ":hash:", 0x0023, 0x20E3);
            Add("", ":keycap_star:", 0x002A, 0x20E3);
            Add("keycap 0", ":zero:", 0x0030, 0x20E3);
            Add("keycap 1", ":one:", 0x0031, 0x20E3);
            Add("keycap 2", ":two:", 0x0032, 0x20E3);
            Add("keycap 3", ":three:", 0x0033, 0x20E3);
            Add("keycap 4", ":four:", 0x0034, 0x20E3);
            Add("keycap 5", ":five:", 0x0035, 0x20E3);
            Add("keycap 6", ":six:", 0x0036, 0x20E3);
            Add("keycap 7", ":seven:", 0x0037, 0x20E3);
            Add("keycap 8", ":eight:", 0x0038, 0x20E3);
            Add("keycap 9", ":nine:", 0x0039, 0x20E3);
            Add("regional indicator symbol letters ac", ":flag-ac:", 0x1F1E6, 0x1F1E8);
            Add("regional indicator symbol letters ad", ":flag-ad:", 0x1F1E6, 0x1F1E9);
            Add("regional indicator symbol letters ae", ":flag-ae:", 0x1F1E6, 0x1F1EA);
            Add("regional indicator symbol letters af", ":flag-af:", 0x1F1E6, 0x1F1EB);
            Add("regional indicator symbol letters ag", ":flag-ag:", 0x1F1E6, 0x1F1EC);
            Add("regional indicator symbol letters ai", ":flag-ai:", 0x1F1E6, 0x1F1EE);
            Add("regional indicator symbol letters al", ":flag-al:", 0x1F1E6, 0x1F1F1);
            Add("regional indicator symbol letters am", ":flag-am:", 0x1F1E6, 0x1F1F2);
            Add("regional indicator symbol letters ao", ":flag-ao:", 0x1F1E6, 0x1F1F4);
            Add("regional indicator symbol letters aq", ":flag-aq:", 0x1F1E6, 0x1F1F6);
            Add("regional indicator symbol letters ar", ":flag-ar:", 0x1F1E6, 0x1F1F7);
            Add("regional indicator symbol letters as", ":flag -as:", 0x1F1E6, 0x1F1F8);
            Add("regional indicator symbol letters at", ":flag-at:", 0x1F1E6, 0x1F1F9);
            Add("regional indicator symbol letters au", ":flag-au:", 0x1F1E6, 0x1F1FA);
            Add("regional indicator symbol letters aw", ":flag-aw:", 0x1F1E6, 0x1F1FC);
            Add("regional indicator symbol letters ax", ":flag-ax:", 0x1F1E6, 0x1F1FD);
            Add("regional indicator symbol letters az", ":flag-az:", 0x1F1E6, 0x1F1FF);
            Add("regional indicator symbol letters ba", ":flag-ba:", 0x1F1E7, 0x1F1E6);
            Add("regional indicator symbol letters bb", ":flag-bb:", 0x1F1E7, 0x1F1E7);
            Add("regional indicator symbol letters bd", ":flag-bd:", 0x1F1E7, 0x1F1E9);
            Add("regional indicator symbol letters be", ":flag-be:", 0x1F1E7, 0x1F1EA);
            Add("regional indicator symbol letters bf", ":flag-bf:", 0x1F1E7, 0x1F1EB);
            Add("regional indicator symbol letters bg", ":flag-bg:", 0x1F1E7, 0x1F1EC);
            Add("regional indicator symbol letters bh", ":flag-bh:", 0x1F1E7, 0x1F1ED);
            Add("regional indicator symbol letters bi", ":flag-bi:", 0x1F1E7, 0x1F1EE);
            Add("regional indicator symbol letters bj", ":flag-bj:", 0x1F1E7, 0x1F1EF);
            Add("regional indicator symbol letters bl", ":flag-bl:", 0x1F1E7, 0x1F1F1);
            Add("regional indicator symbol letters bm", ":flag-bm:", 0x1F1E7, 0x1F1F2);
            Add("regional indicator symbol letters bn", ":flag-bn:", 0x1F1E7, 0x1F1F3);
            Add("regional indicator symbol letters bo", ":flag-bo:", 0x1F1E7, 0x1F1F4);
            Add("regional indicator symbol letters bq", ":flag-bq:", 0x1F1E7, 0x1F1F6);
            Add("regional indicator symbol letters br", ":flag-br:", 0x1F1E7, 0x1F1F7);
            Add("regional indicator symbol letters bs", ":flag-bs:", 0x1F1E7, 0x1F1F8);
            Add("regional indicator symbol letters bt", ":flag-bt:", 0x1F1E7, 0x1F1F9);
            Add("regional indicator symbol letters bv", ":flag-bv:", 0x1F1E7, 0x1F1FB);
            Add("regional indicator symbol letters bw", ":flag-bw:", 0x1F1E7, 0x1F1FC);
            Add("regional indicator symbol letters by", ":flag-by:", 0x1F1E7, 0x1F1FE);
            Add("regional indicator symbol letters bz", ":flag-bz:", 0x1F1E7, 0x1F1FF);
            Add("regional indicator symbol letters ca", ":flag-ca:", 0x1F1E8, 0x1F1E6);
            Add("regional indicator symbol letters cc", ":flag-cc:", 0x1F1E8, 0x1F1E8);
            Add("regional indicator symbol letters cd", ":flag-cd:", 0x1F1E8, 0x1F1E9);
            Add("regional indicator symbol letters cf", ":flag-cf:", 0x1F1E8, 0x1F1EB);
            Add("regional indicator symbol letters cg", ":flag-cg:", 0x1F1E8, 0x1F1EC);
            Add("regional indicator symbol letters ch", ":flag-ch:", 0x1F1E8, 0x1F1ED);
            Add("regional indicator symbol letters ci", ":flag-ci:", 0x1F1E8, 0x1F1EE);
            Add("regional indicator symbol letters ck", ":flag-ck:", 0x1F1E8, 0x1F1F0);
            Add("regional indicator symbol letters cl", ":flag-cl:", 0x1F1E8, 0x1F1F1);
            Add("regional indicator symbol letters cm", ":flag-cm:", 0x1F1E8, 0x1F1F2);
            Add("regional indicator symbol letters cn", ":flag-cn:", 0x1F1E8, 0x1F1F3);
            Add("regional indicator symbol letters co", ":flag-co:", 0x1F1E8, 0x1F1F4);
            Add("regional indicator symbol letters cp", ":flag-cp:", 0x1F1E8, 0x1F1F5);
            Add("regional indicator symbol letters cr", ":flag-cr:", 0x1F1E8, 0x1F1F7);
            Add("regional indicator symbol letters cu", ":flag-cu:", 0x1F1E8, 0x1F1FA);
            Add("regional indicator symbol letters cv", ":flag-cv:", 0x1F1E8, 0x1F1FB);
            Add("regional indicator symbol letters cw", ":flag-cw:", 0x1F1E8, 0x1F1FC);
            Add("regional indicator symbol letters cx", ":flag-cx:", 0x1F1E8, 0x1F1FD);
            Add("regional indicator symbol letters cy", ":flag-cy:", 0x1F1E8, 0x1F1FE);
            Add("regional indicator symbol letters cz", ":flag-cz:", 0x1F1E8, 0x1F1FF);
            Add("regional indicator symbol letters de", ":flag-de:", 0x1F1E9, 0x1F1EA);
            Add("regional indicator symbol letters dg", ":flag-dg:", 0x1F1E9, 0x1F1EC);
            Add("regional indicator symbol letters dj", ":flag-dj:", 0x1F1E9, 0x1F1EF);
            Add("regional indicator symbol letters dk", ":flag-dk:", 0x1F1E9, 0x1F1F0);
            Add("regional indicator symbol letters dm", ":flag-dm:", 0x1F1E9, 0x1F1F2);
            Add("regional indicator symbol letters do ", ":flag -do:", 0x1F1E9, 0x1F1F4);
            Add("regional indicator symbol letters dz", ":flag-dz:", 0x1F1E9, 0x1F1FF);
            Add("regional indicator symbol letters ea", ":flag-ea:", 0x1F1EA, 0x1F1E6);
            Add("regional indicator symbol letters ec", ":flag-ec:", 0x1F1EA, 0x1F1E8);
            Add("regional indicator symbol letters ee", ":flag-ee:", 0x1F1EA, 0x1F1EA);
            Add("regional indicator symbol letters eg", ":flag-eg:", 0x1F1EA, 0x1F1EC);
            Add("regional indicator symbol letters eh", ":flag-eh:", 0x1F1EA, 0x1F1ED);
            Add("regional indicator symbol letters er", ":flag-er:", 0x1F1EA, 0x1F1F7);
            Add("regional indicator symbol letters es", ":flag-es:", 0x1F1EA, 0x1F1F8);
            Add("regional indicator symbol letters et", ":flag-et:", 0x1F1EA, 0x1F1F9);
            Add("regional indicator symbol letters eu", ":flag-eu:", 0x1F1EA, 0x1F1FA);
            Add("regional indicator symbol letters fi", ":flag-fi:", 0x1F1EB, 0x1F1EE);
            Add("regional indicator symbol letters fj", ":flag-fj:", 0x1F1EB, 0x1F1EF);
            Add("regional indicator symbol letters fk", ":flag-fk:", 0x1F1EB, 0x1F1F0);
            Add("regional indicator symbol letters fm", ":flag-fm:", 0x1F1EB, 0x1F1F2);
            Add("regional indicator symbol letters fo", ":flag-fo:", 0x1F1EB, 0x1F1F4);
            Add("regional indicator symbol letters fr", ":flag-fr:", 0x1F1EB, 0x1F1F7);
            Add("regional indicator symbol letters ga", ":flag-ga:", 0x1F1EC, 0x1F1E6);
            Add("regional indicator symbol letters gb", ":flag-gb:", 0x1F1EC, 0x1F1E7);
            Add("regional indicator symbol letters gd", ":flag-gd:", 0x1F1EC, 0x1F1E9);
            Add("regional indicator symbol letters ge", ":flag-ge:", 0x1F1EC, 0x1F1EA);
            Add("regional indicator symbol letters gf", ":flag-gf:", 0x1F1EC, 0x1F1EB);
            Add("regional indicator symbol letters gg", ":flag-gg:", 0x1F1EC, 0x1F1EC);
            Add("regional indicator symbol letters gh", ":flag-gh:", 0x1F1EC, 0x1F1ED);
            Add("regional indicator symbol letters gi", ":flag-gi:", 0x1F1EC, 0x1F1EE);
            Add("regional indicator symbol letters gl", ":flag-gl:", 0x1F1EC, 0x1F1F1);
            Add("regional indicator symbol letters gm", ":flag-gm:", 0x1F1EC, 0x1F1F2);
            Add("regional indicator symbol letters gn", ":flag-gn:", 0x1F1EC, 0x1F1F3);
            Add("regional indicator symbol letters gp", ":flag-gp:", 0x1F1EC, 0x1F1F5);
            Add("regional indicator symbol letters gq", ":flag-gq:", 0x1F1EC, 0x1F1F6);
            Add("regional indicator symbol letters gr", ":flag-gr:", 0x1F1EC, 0x1F1F7);
            Add("regional indicator symbol letters gs", ":flag-gs:", 0x1F1EC, 0x1F1F8);
            Add("regional indicator symbol letters gt", ":flag-gt:", 0x1F1EC, 0x1F1F9);
            Add("regional indicator symbol letters gu", ":flag-gu:", 0x1F1EC, 0x1F1FA);
            Add("regional indicator symbol letters gw", ":flag-gw:", 0x1F1EC, 0x1F1FC);
            Add("regional indicator symbol letters gy", ":flag-gy:", 0x1F1EC, 0x1F1FE);
            Add("regional indicator symbol letters hk", ":flag-hk:", 0x1F1ED, 0x1F1F0);
            Add("regional indicator symbol letters hm", ":flag-hm:", 0x1F1ED, 0x1F1F2);
            Add("regional indicator symbol letters hn", ":flag-hn:", 0x1F1ED, 0x1F1F3);
            Add("regional indicator symbol letters hr", ":flag-hr:", 0x1F1ED, 0x1F1F7);
            Add("regional indicator symbol letters ht", ":flag-ht:", 0x1F1ED, 0x1F1F9);
            Add("regional indicator symbol letters hu", ":flag-hu:", 0x1F1ED, 0x1F1FA);
            Add("regional indicator symbol letters ic", ":flag-ic:", 0x1F1EE, 0x1F1E8);
            Add("regional indicator symbol letters id", ":flag-id:", 0x1F1EE, 0x1F1E9);
            Add("regional indicator symbol letters ie", ":flag-ie:", 0x1F1EE, 0x1F1EA);
            Add("regional indicator symbol letters il", ":flag-il:", 0x1F1EE, 0x1F1F1);
            Add("regional indicator symbol letters im", ":flag-im:", 0x1F1EE, 0x1F1F2);
            Add("regional indicator symbol letters in", ":flag -in:", 0x1F1EE, 0x1F1F3);
            Add("regional indicator symbol letters io", ":flag-io:", 0x1F1EE, 0x1F1F4);
            Add("regional indicator symbol letters iq", ":flag-iq:", 0x1F1EE, 0x1F1F6);
            Add("regional indicator symbol letters ir", ":flag-ir:", 0x1F1EE, 0x1F1F7);
            Add("regional indicator symbol letters is", ":flag -is:", 0x1F1EE, 0x1F1F8);
            Add("regional indicator symbol letters it", ":flag-it:", 0x1F1EE, 0x1F1F9);
            Add("regional indicator symbol letters je", ":flag-je:", 0x1F1EF, 0x1F1EA);
            Add("regional indicator symbol letters jm", ":flag-jm:", 0x1F1EF, 0x1F1F2);
            Add("regional indicator symbol letters jo", ":flag-jo:", 0x1F1EF, 0x1F1F4);
            Add("regional indicator symbol letters jp", ":flag-jp:", 0x1F1EF, 0x1F1F5);
            Add("regional indicator symbol letters ke", ":flag-ke:", 0x1F1F0, 0x1F1EA);
            Add("regional indicator symbol letters kg", ":flag-kg:", 0x1F1F0, 0x1F1EC);
            Add("regional indicator symbol letters kh", ":flag-kh:", 0x1F1F0, 0x1F1ED);
            Add("regional indicator symbol letters ki", ":flag-ki:", 0x1F1F0, 0x1F1EE);
            Add("regional indicator symbol letters km", ":flag-km:", 0x1F1F0, 0x1F1F2);
            Add("regional indicator symbol letters kn", ":flag-kn:", 0x1F1F0, 0x1F1F3);
            Add("regional indicator symbol letters kp", ":flag-kp:", 0x1F1F0, 0x1F1F5);
            Add("regional indicator symbol letters kr", ":flag-kr:", 0x1F1F0, 0x1F1F7);
            Add("regional indicator symbol letters kw", ":flag-kw:", 0x1F1F0, 0x1F1FC);
            Add("regional indicator symbol letters ky", ":flag-ky:", 0x1F1F0, 0x1F1FE);
            Add("regional indicator symbol letters kz", ":flag-kz:", 0x1F1F0, 0x1F1FF);
            Add("regional indicator symbol letters la", ":flag-la:", 0x1F1F1, 0x1F1E6);
            Add("regional indicator symbol letters lb", ":flag-lb:", 0x1F1F1, 0x1F1E7);
            Add("regional indicator symbol letters lc", ":flag-lc:", 0x1F1F1, 0x1F1E8);
            Add("regional indicator symbol letters li", ":flag-li:", 0x1F1F1, 0x1F1EE);
            Add("regional indicator symbol letters lk", ":flag-lk:", 0x1F1F1, 0x1F1F0);
            Add("regional indicator symbol letters lr", ":flag-lr:", 0x1F1F1, 0x1F1F7);
            Add("regional indicator symbol letters ls", ":flag-ls:", 0x1F1F1, 0x1F1F8);
            Add("regional indicator symbol letters lt", ":flag-lt:", 0x1F1F1, 0x1F1F9);
            Add("regional indicator symbol letters lu", ":flag-lu:", 0x1F1F1, 0x1F1FA);
            Add("regional indicator symbol letters lv", ":flag-lv:", 0x1F1F1, 0x1F1FB);
            Add("regional indicator symbol letters ly", ":flag-ly:", 0x1F1F1, 0x1F1FE);
            Add("regional indicator symbol letters ma", ":flag-ma:", 0x1F1F2, 0x1F1E6);
            Add("regional indicator symbol letters mc", ":flag-mc:", 0x1F1F2, 0x1F1E8);
            Add("regional indicator symbol letters md", ":flag-md:", 0x1F1F2, 0x1F1E9);
            Add("regional indicator symbol letters me", ":flag-me:", 0x1F1F2, 0x1F1EA);
            Add("regional indicator symbol letters mf", ":flag-mf:", 0x1F1F2, 0x1F1EB);
            Add("regional indicator symbol letters mg", ":flag-mg:", 0x1F1F2, 0x1F1EC);
            Add("regional indicator symbol letters mh", ":flag-mh:", 0x1F1F2, 0x1F1ED);
            Add("regional indicator symbol letters mk", ":flag-mk:", 0x1F1F2, 0x1F1F0);
            Add("regional indicator symbol letters ml", ":flag-ml:", 0x1F1F2, 0x1F1F1);
            Add("regional indicator symbol letters mm", ":flag-mm:", 0x1F1F2, 0x1F1F2);
            Add("regional indicator symbol letters mn", ":flag-mn:", 0x1F1F2, 0x1F1F3);
            Add("regional indicator symbol letters mo", ":flag-mo:", 0x1F1F2, 0x1F1F4);
            Add("regional indicator symbol letters mp", ":flag-mp:", 0x1F1F2, 0x1F1F5);
            Add("regional indicator symbol letters mq", ":flag-mq:", 0x1F1F2, 0x1F1F6);
            Add("regional indicator symbol letters mr", ":flag-mr:", 0x1F1F2, 0x1F1F7);
            Add("regional indicator symbol letters ms", ":flag-ms:", 0x1F1F2, 0x1F1F8);
            Add("regional indicator symbol letters mt", ":flag-mt:", 0x1F1F2, 0x1F1F9);
            Add("regional indicator symbol letters mu", ":flag-mu:", 0x1F1F2, 0x1F1FA);
            Add("regional indicator symbol letters mv", ":flag-mv:", 0x1F1F2, 0x1F1FB);
            Add("regional indicator symbol letters mw", ":flag-mw:", 0x1F1F2, 0x1F1FC);
            Add("regional indicator symbol letters mx", ":flag-mx:", 0x1F1F2, 0x1F1FD);
            Add("regional indicator symbol letters my", ":flag-my:", 0x1F1F2, 0x1F1FE);
            Add("regional indicator symbol letters mz", ":flag-mz:", 0x1F1F2, 0x1F1FF);
            Add("regional indicator symbol letters na", ":flag-na:", 0x1F1F3, 0x1F1E6);
            Add("regional indicator symbol letters nc", ":flag-nc:", 0x1F1F3, 0x1F1E8);
            Add("regional indicator symbol letters ne", ":flag-ne:", 0x1F1F3, 0x1F1EA);
            Add("regional indicator symbol letters nf", ":flag-nf:", 0x1F1F3, 0x1F1EB);
            Add("regional indicator symbol letters ng", ":flag-ng:", 0x1F1F3, 0x1F1EC);
            Add("regional indicator symbol letters ni", ":flag-ni:", 0x1F1F3, 0x1F1EE);
            Add("regional indicator symbol letters nl", ":flag-nl:", 0x1F1F3, 0x1F1F1);
            Add("regional indicator symbol letters no", ":flag-no:", 0x1F1F3, 0x1F1F4);
            Add("regional indicator symbol letters np", ":flag-np:", 0x1F1F3, 0x1F1F5);
            Add("regional indicator symbol letters nr", ":flag-nr:", 0x1F1F3, 0x1F1F7);
            Add("regional indicator symbol letters nu", ":flag-nu:", 0x1F1F3, 0x1F1FA);
            Add("regional indicator symbol letters nz", ":flag-nz:", 0x1F1F3, 0x1F1FF);
            Add("regional indicator symbol letters om", ":flag-om:", 0x1F1F4, 0x1F1F2);
            Add("regional indicator symbol letters pa", ":flag-pa:", 0x1F1F5, 0x1F1E6);
            Add("regional indicator symbol letters pe", ":flag-pe:", 0x1F1F5, 0x1F1EA);
            Add("regional indicator symbol letters pf", ":flag-pf:", 0x1F1F5, 0x1F1EB);
            Add("regional indicator symbol letters pg", ":flag-pg:", 0x1F1F5, 0x1F1EC);
            Add("regional indicator symbol letters ph", ":flag-ph:", 0x1F1F5, 0x1F1ED);
            Add("regional indicator symbol letters pk", ":flag-pk:", 0x1F1F5, 0x1F1F0);
            Add("regional indicator symbol letters pl", ":flag-pl:", 0x1F1F5, 0x1F1F1);
            Add("regional indicator symbol letters pm", ":flag-pm:", 0x1F1F5, 0x1F1F2);
            Add("regional indicator symbol letters pn", ":flag-pn:", 0x1F1F5, 0x1F1F3);
            Add("regional indicator symbol letters pr", ":flag-pr:", 0x1F1F5, 0x1F1F7);
            Add("regional indicator symbol letters ps", ":flag-ps:", 0x1F1F5, 0x1F1F8);
            Add("regional indicator symbol letters pt", ":flag-pt:", 0x1F1F5, 0x1F1F9);
            Add("regional indicator symbol letters pw", ":flag-pw:", 0x1F1F5, 0x1F1FC);
            Add("regional indicator symbol letters py", ":flag-py:", 0x1F1F5, 0x1F1FE);
            Add("regional indicator symbol letters qa", ":flag-qa:", 0x1F1F6, 0x1F1E6);
            Add("regional indicator symbol letters re", ":flag-re:", 0x1F1F7, 0x1F1EA);
            Add("regional indicator symbol letters ro", ":flag-ro:", 0x1F1F7, 0x1F1F4);
            Add("regional indicator symbol letters rs", ":flag-rs:", 0x1F1F7, 0x1F1F8);
            Add("regional indicator symbol letters ru", ":flag-ru:", 0x1F1F7, 0x1F1FA);
            Add("regional indicator symbol letters rw", ":flag-rw:", 0x1F1F7, 0x1F1FC);
            Add("regional indicator symbol letters sa", ":flag-sa:", 0x1F1F8, 0x1F1E6);
            Add("regional indicator symbol letters sb", ":flag-sb:", 0x1F1F8, 0x1F1E7);
            Add("regional indicator symbol letters sc", ":flag-sc:", 0x1F1F8, 0x1F1E8);
            Add("regional indicator symbol letters sd", ":flag-sd:", 0x1F1F8, 0x1F1E9);
            Add("regional indicator symbol letters se", ":flag-se:", 0x1F1F8, 0x1F1EA);
            Add("regional indicator symbol letters sg", ":flag-sg:", 0x1F1F8, 0x1F1EC);
            Add("regional indicator symbol letters sh", ":flag-sh:", 0x1F1F8, 0x1F1ED);
            Add("regional indicator symbol letters si", ":flag-si:", 0x1F1F8, 0x1F1EE);
            Add("regional indicator symbol letters sj", ":flag-sj:", 0x1F1F8, 0x1F1EF);
            Add("regional indicator symbol letters sk", ":flag-sk:", 0x1F1F8, 0x1F1F0);
            Add("regional indicator symbol letters sl", ":flag-sl:", 0x1F1F8, 0x1F1F1);
            Add("regional indicator symbol letters sm", ":flag-sm:", 0x1F1F8, 0x1F1F2);
            Add("regional indicator symbol letters sn", ":flag-sn:", 0x1F1F8, 0x1F1F3);
            Add("regional indicator symbol letters so", ":flag-so:", 0x1F1F8, 0x1F1F4);
            Add("regional indicator symbol letters sr", ":flag-sr:", 0x1F1F8, 0x1F1F7);
            Add("regional indicator symbol letters ss", ":flag-ss:", 0x1F1F8, 0x1F1F8);
            Add("regional indicator symbol letters st", ":flag-st:", 0x1F1F8, 0x1F1F9);
            Add("regional indicator symbol letters sv", ":flag-sv:", 0x1F1F8, 0x1F1FB);
            Add("regional indicator symbol letters sx", ":flag-sx:", 0x1F1F8, 0x1F1FD);
            Add("regional indicator symbol letters sy", ":flag-sy:", 0x1F1F8, 0x1F1FE);
            Add("regional indicator symbol letters sz", ":flag-sz:", 0x1F1F8, 0x1F1FF);
            Add("regional indicator symbol letters ta", ":flag-ta:", 0x1F1F9, 0x1F1E6);
            Add("regional indicator symbol letters tc", ":flag-tc:", 0x1F1F9, 0x1F1E8);
            Add("regional indicator symbol letters td", ":flag-td:", 0x1F1F9, 0x1F1E9);
            Add("regional indicator symbol letters tf", ":flag-tf:", 0x1F1F9, 0x1F1EB);
            Add("regional indicator symbol letters tg", ":flag-tg:", 0x1F1F9, 0x1F1EC);
            Add("regional indicator symbol letters th", ":flag-th:", 0x1F1F9, 0x1F1ED);
            Add("regional indicator symbol letters tj", ":flag-tj:", 0x1F1F9, 0x1F1EF);
            Add("regional indicator symbol letters tk", ":flag-tk:", 0x1F1F9, 0x1F1F0);
            Add("regional indicator symbol letters tl", ":flag-tl:", 0x1F1F9, 0x1F1F1);
            Add("regional indicator symbol letters tm", ":flag-tm:", 0x1F1F9, 0x1F1F2);
            Add("regional indicator symbol letters tn", ":flag-tn:", 0x1F1F9, 0x1F1F3);
            Add("regional indicator symbol letters to", ":flag-to:", 0x1F1F9, 0x1F1F4);
            Add("regional indicator symbol letters tr", ":flag-tr:", 0x1F1F9, 0x1F1F7);
            Add("regional indicator symbol letters tt", ":flag-tt:", 0x1F1F9, 0x1F1F9);
            Add("regional indicator symbol letters tv", ":flag-tv:", 0x1F1F9, 0x1F1FB);
            Add("regional indicator symbol letters tw", ":flag-tw:", 0x1F1F9, 0x1F1FC);
            Add("regional indicator symbol letters tz", ":flag-tz:", 0x1F1F9, 0x1F1FF);
            Add("regional indicator symbol letters ua", ":flag-ua:", 0x1F1FA, 0x1F1E6);
            Add("regional indicator symbol letters ug", ":flag-ug:", 0x1F1FA, 0x1F1EC);
            Add("regional indicator symbol letters um", ":flag-um:", 0x1F1FA, 0x1F1F2);
            Add("regional indicator symbol letters us", ":flag-us:", 0x1F1FA, 0x1F1F8);
            Add("regional indicator symbol letters uy", ":flag-uy:", 0x1F1FA, 0x1F1FE);
            Add("regional indicator symbol letters uz", ":flag-uz:", 0x1F1FA, 0x1F1FF);
            Add("regional indicator symbol letters va", ":flag-va:", 0x1F1FB, 0x1F1E6);
            Add("regional indicator symbol letters vc", ":flag-vc:", 0x1F1FB, 0x1F1E8);
            Add("regional indicator symbol letters ve", ":flag-ve:", 0x1F1FB, 0x1F1EA);
            Add("regional indicator symbol letters vg", ":flag-vg:", 0x1F1FB, 0x1F1EC);
            Add("regional indicator symbol letters vi", ":flag-vi:", 0x1F1FB, 0x1F1EE);
            Add("regional indicator symbol letters vn", ":flag-vn:", 0x1F1FB, 0x1F1F3);
            Add("regional indicator symbol letters vu", ":flag-vu:", 0x1F1FB, 0x1F1FA);
            Add("regional indicator symbol letters wf", ":flag-wf:", 0x1F1FC, 0x1F1EB);
            Add("regional indicator symbol letters ws", ":flag-ws:", 0x1F1FC, 0x1F1F8);
            Add("regional indicator symbol letters xk", ":flag-xk:", 0x1F1FD, 0x1F1F0);
            Add("regional indicator symbol letters ye", ":flag-ye:", 0x1F1FE, 0x1F1EA);
            Add("regional indicator symbol letters yt", ":flag-yt:", 0x1F1FE, 0x1F1F9);
            Add("regional indicator symbol letters za", ":flag-za:", 0x1F1FF, 0x1F1E6);
            Add("regional indicator symbol letters zm", ":flag-zm:", 0x1F1FF, 0x1F1F2);
            Add("regional indicator symbol letters zw", ":flag-zw:", 0x1F1FF, 0x1F1FC);
        }

        /// <summary>
        /// Add a new definition
        /// </summary>
        /// <param name="name"></param>
        /// <param name="markup"></param>
        /// <param name="code1"></param>
        /// <param name="code2"></param>
        /// <param name="code3"></param>
        public static void Add(string name, string markup, int code1, int? code2 = null, int? code3 = null)
        {
            string emoji = Char.ConvertFromUtf32(code1);
            if (code2.HasValue)
                emoji += code2.Value;
            if (code3.HasValue)
                emoji += code3.Value;

            try
            {
                markup2Emoji.Add(markup, emoji);
            }
            catch (ArgumentException)
            {
#if NET452
                Trace.TraceError($"Failed to add {markup} because: {err.Message}");
#endif
            }
            try
            {
                emoji2Markup.Add(emoji, markup);
            }
            catch (ArgumentException)
            {
#if NET452
                Trace.TraceError($"Failed to add {emoji} because: {err.Message}");
#endif
            }

        }

        /// <summary>
        /// Table of markup to emojii chars
        /// </summary>
        public static Dictionary<string, string> Markup2Emoji { get { return markup2Emoji; } }

        /// <summary>
        /// Table of emoji to markup 
        /// </summary>
        public static Dictionary<string, string> Emoji2Markup { get { return emoji2Markup; } }

        private static Regex MarkupRegex = new Regex(@"(:[^:\s]+:)", RegexOptions.Compiled);

        /// <summary>
        /// Convert markup to emoji chars
        /// </summary>
        /// <param name="markup"></param>
        /// <returns></returns>
        public static string ConvertMarkupToEmoji(string markup)
        {
            StringBuilder sb = new StringBuilder(markup);
            var matches = MarkupRegex.Matches(markup);
            for (int i = 0; i < matches.Count; i++)
            {
                var match = matches[i];
                string emoji;
                if (Markup2Emoji.TryGetValue(match.Value, out emoji))
                {
                    sb.Replace(match.Value, emoji);
                }
            }
            return sb.ToString();
        }

        /// <summary>
        /// Converts emojichars to markup
        /// </summary>
        /// <param name="emojiText"></param>
        /// <returns></returns>
        public static string ConvertEmojiToMarkup(string emojiText)
        {
            StringBuilder sb = new StringBuilder(emojiText);
            foreach (var emoji in emoji2Markup.Keys)
            {
                if (emojiText.Contains(emoji))
                    sb.Replace(emoji, emoji2Markup[emoji]);
            }
            return sb.ToString();
        }
    }
}
