// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
namespace AdaptiveCards
{
    /// <summary>
    ///     Controls the horizontal size (width) of Column.
    /// </summary>
    public class AdaptiveColumnWidth
    {
        /// <summary>
        ///     The width of the Column is optimally chosen depending on the space available in the element's container
        /// </summary>
        public const string Auto = "auto";

        /// <summary>
        ///     The width of the Column adjusts to match that of its container
        /// </summary>
        public const string Stretch = "stretch";
    }
}
