/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION) || defined(DEBUG_DIRECTOR_THREAD_NAME)
#include <iostream>
#endif

#include <exception>

#if defined(SWIG_JAVA_USE_THREAD_NAME)

#if !defined(SWIG_JAVA_GET_THREAD_NAME)
namespace Swig {
  SWIGINTERN int GetThreadName(char *name, size_t len);
}

#if defined(__linux__)

#include <sys/prctl.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
#if defined(PR_GET_NAME)
  return prctl(PR_GET_NAME, (unsigned long)name, 0, 0, 0);
#else
  (void)name;
  return 1;
#endif
}

#elif defined(__unix__) || defined(__APPLE__)

#include <pthread.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  return pthread_getname_np(pthread_self(), name, len);
}

#else

SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
  (void)name;
  return 1;
}
#endif

#endif

#endif

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
        /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
        JavaVMAttachArgs args;
        args.version = JNI_VERSION_1_2;
        args.group = NULL;
        args.name = NULL;
#if defined(SWIG_JAVA_USE_THREAD_NAME)
        char thread_name[64];  // MAX_TASK_COMM_LEN=16 is hard-coded in the Linux kernel and MacOS has MAXTHREADNAMESIZE=64.
        if (Swig::GetThreadName(thread_name, sizeof(thread_name)) == 0) {
          args.name = thread_name;
#if defined(DEBUG_DIRECTOR_THREAD_NAME)
          std::cout << "JNIEnvWrapper: thread name: " << thread_name << std::endl;
        } else {
          std::cout << "JNIEnvWrapper: Couldn't set Java thread name" << std::endl;
#endif
        }
#endif
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, &args);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, &args);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
        cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
        jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    // Return a C string of the exception message in the jthrowable passed in the constructor
    // If no message is available, null_string is return instead
    const char *message(const char *null_string = "Could not get exception message in JavaExceptionMessage") const {
      return message_.c_str(null_string);
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
        jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
        jclass throwclz = jenv->GetObjectClass(throwable);
        if (throwclz) {
          // All Throwable classes have a getMessage() method, so call it to extract the exception message
          jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
          if (getMessageMethodID)
            jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
        }
        if (jmsg == NULL && jenv->ExceptionCheck())
          jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : jenv_(jenv), throwable_(throwable), classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (jenv && throwable) {
        jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
        jclass throwclz = jenv->GetObjectClass(throwable);
        if (throwclz) {
          jclass clzclz = jenv->GetObjectClass(throwclz);
          if (clzclz) {
            jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
            if (getNameMethodID) {
              jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
            }
          }
        }
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message(0));
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : jenv_(0), throwable_(0), classname_(0), msg_(msg ? copystr(msg) : 0) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_ ? msg_ : "Unspecified DirectorException message";
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void throwException(JNIEnv *jenv) const {
      if (jenv) {
        if (jenv == jenv_ && throwable_) {
          // Throw original exception if not already pending
          jthrowable throwable = jenv->ExceptionOccurred();
          if (throwable && jenv->IsSameObject(throwable, throwable_) == JNI_FALSE) {
            jenv->ExceptionClear();
            throwable = 0;
          }
          if (!throwable)
            jenv->Throw(throwable_);
        } else {
          // Try and reconstruct original exception, but original stacktrace is not reconstructed
          jenv->ExceptionClear();

          jmethodID ctorMethodID = 0;
          jclass throwableclass = 0;
          if (classname_) {
            throwableclass = jenv->FindClass(classname_);
            if (throwableclass)
              ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
          }

          if (ctorMethodID) {
            jenv->ThrowNew(throwableclass, what());
          } else {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
          }
        }
      }
    }

    // Deprecated - use throwException
    void raiseJavaException(JNIEnv *jenv) const {
      throwException(jenv);
    }

    // Create and throw the DirectorException
    static void raise(JNIEnv *jenv, jthrowable throwable) {
      throw DirectorException(jenv, throwable);
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
        size_t msglen = strlen(srcmsg) + 1;
        target = new char[msglen];
        strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    JNIEnv *jenv_;
    jthrowable throwable_;
    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  // Note side effect of clearing any pending exceptions
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
        jclass classclz = jenv->GetObjectClass(clz);
        jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
        if (isInstanceMethodID) {
          matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
        }
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_AdaptiveCardObjectModelJNI = NULL;
    jmethodID director_method_ids[27];
  }
}

#include <string>


#include <typeinfo>
#include <stdexcept>


#include <vector>
#include <stdexcept>


#include "pch.h"
#include <memory>
#include <time.h>
#include "../../../shared/cpp/ObjectModel/EnumMagic.h"
#include "../../../shared/cpp/ObjectModel/Enums.h"
#include "../../../shared/cpp/ObjectModel/AdaptiveBase64Util.h"
#include "../../../shared/cpp/ObjectModel/RemoteResourceInformation.h"
#include "../../../shared/cpp/ObjectModel/InternalId.h"
#include "../../../shared/cpp/ObjectModel/BaseElement.h"
#include "../../../shared/cpp/ObjectModel/BaseCardElement.h"
#include "../../../shared/cpp/ObjectModel/BaseActionElement.h"
#include "../../../shared/cpp/ObjectModel/BaseInputElement.h"
#include "../../../shared/cpp/ObjectModel/CollectionCoreElement.h"
#include "../../../shared/cpp/ObjectModel/StyledCollectionElement.h"
#include "../../../shared/cpp/ObjectModel/AdaptiveCardParseWarning.h"
#include "../../../shared/cpp/ObjectModel/ActionParserRegistration.h"
#include "../../../shared/cpp/ObjectModel/ElementParserRegistration.h"
#include "../../../shared/cpp/ObjectModel/FeatureRegistration.h"
#include "../../../shared/cpp/ObjectModel/BackgroundImage.h"
#include "../../../shared/cpp/ObjectModel/Container.h"
#include "../../../shared/cpp/ObjectModel/Image.h"
#include "../../../shared/cpp/ObjectModel/ImageSet.h"
#include "../../../shared/cpp/ObjectModel/InternalId.h"
#include "../../../shared/cpp/ObjectModel/Column.h"
#include "../../../shared/cpp/ObjectModel/ColumnSet.h"
#include "../../../shared/cpp/ObjectModel/ChoicesData.h"
#include "../../../shared/cpp/ObjectModel/ChoiceInput.h"
#include "../../../shared/cpp/ObjectModel/ChoiceSetInput.h"
#include "../../../shared/cpp/ObjectModel/DateInput.h"
#include "../../../shared/cpp/ObjectModel/NumberInput.h"
#include "../../../shared/cpp/ObjectModel/TextInput.h"
#include "../../../shared/cpp/ObjectModel/TimeInput.h"
#include "../../../shared/cpp/ObjectModel/ToggleInput.h"
#include "../../../shared/cpp/ObjectModel/OpenUrlAction.h"
#include "../../../shared/cpp/ObjectModel/SemanticVersion.h"
#include "../../../shared/cpp/ObjectModel/ShowCardAction.h"
#include "../../../shared/cpp/ObjectModel/SubmitAction.h"
#include "../../../shared/cpp/ObjectModel/ParseContext.h"
#include "../../../shared/cpp/ObjectModel/ParseResult.h"
#include "../../../shared/cpp/ObjectModel/SharedAdaptiveCard.h"
#include "../../../shared/cpp/ObjectModel/AdaptiveCardParseException.h"
#include "../../../shared/cpp/ObjectModel/HostConfig.h"
#include "../../../shared/cpp/ObjectModel/MarkDownParser.h"
#include "../../../shared/cpp/ObjectModel/DateTimePreparsedToken.h"
#include "../../../shared/cpp/ObjectModel/DateTimePreparser.h"
#include "../../../shared/cpp/ObjectModel/Fact.h"
#include "../../../shared/cpp/ObjectModel/FactSet.h"
#include "../../../shared/cpp/ObjectModel/Table.h"
#include "../../../shared/cpp/ObjectModel/TableCell.h"
#include "../../../shared/cpp/ObjectModel/TableColumnDefinition.h"
#include "../../../shared/cpp/ObjectModel/TableRow.h"
#include "../../../shared/cpp/ObjectModel/TextBlock.h"
#include "../../../shared/cpp/ObjectModel/ActionSet.h"
#include "../../../shared/cpp/ObjectModel/CaptionSource.h"
#include "../../../shared/cpp/ObjectModel/ContentSource.h"
#include "../../../shared/cpp/ObjectModel/MediaSource.h"
#include "../../../shared/cpp/ObjectModel/Media.h"
#include "../../../shared/cpp/ObjectModel/ToggleVisibilityAction.h"
#include "../../../shared/cpp/ObjectModel/ToggleVisibilityTarget.h"
#include "../../../shared/cpp/ObjectModel/UnknownElement.h"
#include "../../../shared/cpp/ObjectModel/UnknownAction.h"
#include "../../../shared/cpp/ObjectModel/TextElementProperties.h"
#include "../../../shared/cpp/ObjectModel/Inline.h"
#include "../../../shared/cpp/ObjectModel/RichTextBlock.h"
#include "../../../shared/cpp/ObjectModel/TextRun.h"
#include "../../../shared/cpp/ObjectModel/RichTextElementProperties.h"
#include "../../../shared/cpp/ObjectModel/ExecuteAction.h"
#include "../../../shared/cpp/ObjectModel/Refresh.h"
#include "../../../shared/cpp/ObjectModel/Authentication.h"
#include "../../../shared/cpp/ObjectModel/TokenExchangeResource.h"
#include "../../../shared/cpp/ObjectModel/AuthCardButton.h"

SWIGINTERN std::string Json_Value_getString(Json::Value *self){
            Json::StreamWriterBuilder builder;
            builder["commentStyle"] = "None";
            builder["indentation"] = "";
            std::unique_ptr<Json::StreamWriter> writer(builder.newStreamWriter());

            std::ostringstream outStream;
            writer->write(*self, &outStream);
            outStream << std::endl;
            return outStream.str();
        }

/* Check for overflow converting to Java int (always signed 32-bit) from (unsigned variable-bit) size_t */
SWIGINTERN jint SWIG_JavaIntFromSize_t(size_t size) {
  static const jint JINT_MAX = 0x7FFFFFFF;
  return (size > (size_t)JINT_MAX) ? -1 : (jint)size;
}


SWIGINTERN jint SWIG_VectorSize(size_t size) {
  jint sz = SWIG_JavaIntFromSize_t(size);
  if (sz == -1)
    throw std::out_of_range("vector size is too large to fit into a Java int");
  return sz;
}

SWIGINTERN std::vector< AdaptiveCards::RemoteResourceInformation > *new_std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg___SWIG_2(jint count,AdaptiveCards::RemoteResourceInformation const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< AdaptiveCards::RemoteResourceInformation >(static_cast<std::vector< AdaptiveCards::RemoteResourceInformation >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doSize(std::vector< AdaptiveCards::RemoteResourceInformation > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doAdd__SWIG_0(std::vector< AdaptiveCards::RemoteResourceInformation > *self,std::vector< AdaptiveCards::RemoteResourceInformation >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doAdd__SWIG_1(std::vector< AdaptiveCards::RemoteResourceInformation > *self,jint index,std::vector< AdaptiveCards::RemoteResourceInformation >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< AdaptiveCards::RemoteResourceInformation >::value_type std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doRemove(std::vector< AdaptiveCards::RemoteResourceInformation > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          AdaptiveCards::RemoteResourceInformation const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< AdaptiveCards::RemoteResourceInformation >::value_type const &std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doGet(std::vector< AdaptiveCards::RemoteResourceInformation > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }

struct SWIG_null_deleter {
  void operator() (void const *) const {
  }
};
#define SWIG_NO_NULL_DELETER_0 , SWIG_null_deleter()
#define SWIG_NO_NULL_DELETER_1
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_NEW
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_OWN

SWIGINTERN std::vector< AdaptiveCards::RemoteResourceInformation >::value_type std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doSet(std::vector< AdaptiveCards::RemoteResourceInformation > *self,jint index,std::vector< AdaptiveCards::RemoteResourceInformation >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          AdaptiveCards::RemoteResourceInformation const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doRemoveRange(std::vector< AdaptiveCards::RemoteResourceInformation > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *self,std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::BaseCardElement > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *self,std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::BaseCardElement > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::BaseCardElement > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Image > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::Image > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::Image > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::Image > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::Image > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::Image > > *self,std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::Image > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::Image > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::Image > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::Image > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::Image > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::Image > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::Image > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Fact > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::Fact > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::Fact > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::Fact > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::Fact > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::Fact > > *self,std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::Fact > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::Fact > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::Fact > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::Fact > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::Fact > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::Fact > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::Fact > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Column > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::Column > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::Column > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::Column > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::Column > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::Column > > *self,std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::Column > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::Column > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::Column > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::Column > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::Column > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::Column > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::Column > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::ChoiceInput > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *self,std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::ChoiceInput > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::ChoiceInput > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::CaptionSource > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *self,std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::CaptionSource > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::CaptionSource > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::MediaSource > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *self,std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::MediaSource > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::MediaSource > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::BaseActionElement > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *self,std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::BaseActionElement > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::BaseActionElement > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *self,std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::TableCell > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::TableCell > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *self,std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::TableCell > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::TableCell > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::TableRow > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::TableRow > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *self,std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::TableRow > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::TableRow > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::TableColumnDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *self,std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::TableColumnDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::TableColumnDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *self,std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string > *new_std_vector_Sl_std_string_Sg___SWIG_2(jint count,std::string const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::string >(static_cast<std::vector< std::string >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_string_Sg__doSize(std::vector< std::string > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_0(std::vector< std::string > *self,std::vector< std::string >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_1(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doRemove(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::string const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type const &std_vector_Sl_std_string_Sg__doGet(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doSet(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::string const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doRemoveRange(std::vector< std::string > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< char > *new_std_vector_Sl_char_Sg___SWIG_2(jint count,char const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< char >(static_cast<std::vector< char >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_char_Sg__doSize(std::vector< char > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_char_Sg__doAdd__SWIG_0(std::vector< char > *self,std::vector< char >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_char_Sg__doAdd__SWIG_1(std::vector< char > *self,jint index,std::vector< char >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< char >::value_type std_vector_Sl_char_Sg__doRemove(std::vector< char > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          char const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< char >::value_type const &std_vector_Sl_char_Sg__doGet(std::vector< char > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< char >::value_type std_vector_Sl_char_Sg__doSet(std::vector< char > *self,jint index,std::vector< char >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          char const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_char_Sg__doRemoveRange(std::vector< char > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Inline > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::Inline > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::Inline > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::Inline > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::Inline > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::Inline > > *self,std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::Inline > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::Inline > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::Inline > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::Inline > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::Inline > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::Inline > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::Inline > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg___SWIG_2(jint count,std::shared_ptr< AdaptiveCards::AuthCardButton > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >(static_cast<std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doSize(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doAdd__SWIG_0(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *self,std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doAdd__SWIG_1(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doRemove(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::shared_ptr< AdaptiveCards::AuthCardButton > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type const &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doGet(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doSet(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *self,jint index,std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::shared_ptr< AdaptiveCards::AuthCardButton > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doRemoveRange(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN jobject AdaptiveCards_BaseCardElement_swigOriginalObject(AdaptiveCards::BaseCardElement *self,JNIEnv *jenv){
        Swig::Director *dir = dynamic_cast<Swig::Director*>(self);
        if (dir) {
            return dir->swig_get_self(jenv);
        }
        return NULL;
    }
SWIGINTERN AdaptiveCards::BaseCardElement *AdaptiveCards_BaseCardElement_dynamic_cast(AdaptiveCards::BaseElement *baseElement){
        return dynamic_cast<AdaptiveCards::BaseCardElement *>(baseElement);
    }
SWIGINTERN jobject AdaptiveCards_BaseActionElement_swigOriginalObject(AdaptiveCards::BaseActionElement *self,JNIEnv *jenv){
        Swig::Director *dir = dynamic_cast<Swig::Director*>(self);
        if (dir) {
            return dir->swig_get_self(jenv);
        }
        return NULL;
    }
SWIGINTERN AdaptiveCards::BaseActionElement *AdaptiveCards_BaseActionElement_dynamic_cast(AdaptiveCards::BaseElement *baseElement){
        return dynamic_cast<AdaptiveCards::BaseActionElement *>(baseElement);
    }
SWIGINTERN AdaptiveCards::BaseInputElement *AdaptiveCards_BaseInputElement_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::BaseInputElement *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::Container *AdaptiveCards_Container_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::Container *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::Image *AdaptiveCards_Image_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::Image *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::ImageSet *AdaptiveCards_ImageSet_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::ImageSet *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::Column *AdaptiveCards_Column_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::Column *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::ColumnSet *AdaptiveCards_ColumnSet_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::ColumnSet *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::ChoiceInput *AdaptiveCards_ChoiceInput_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::ChoiceInput *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::ChoiceSetInput *AdaptiveCards_ChoiceSetInput_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::ChoiceSetInput *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::DateInput *AdaptiveCards_DateInput_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::DateInput *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::NumberInput *AdaptiveCards_NumberInput_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::NumberInput *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::TextInput *AdaptiveCards_TextInput_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::TextInput *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::TimeInput *AdaptiveCards_TimeInput_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::TimeInput *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::ToggleInput *AdaptiveCards_ToggleInput_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::ToggleInput *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::ExecuteAction *AdaptiveCards_ExecuteAction_dynamic_cast(AdaptiveCards::BaseActionElement *baseActionElement){
        return dynamic_cast<AdaptiveCards::ExecuteAction *>(baseActionElement);
    }
SWIGINTERN AdaptiveCards::OpenUrlAction *AdaptiveCards_OpenUrlAction_dynamic_cast(AdaptiveCards::BaseActionElement *baseActionElement){
        return dynamic_cast<AdaptiveCards::OpenUrlAction *>(baseActionElement);
    }
SWIGINTERN AdaptiveCards::ShowCardAction *AdaptiveCards_ShowCardAction_dynamic_cast(AdaptiveCards::BaseActionElement *baseActionElement){
        return dynamic_cast<AdaptiveCards::ShowCardAction *>(baseActionElement);
    }
SWIGINTERN AdaptiveCards::SubmitAction *AdaptiveCards_SubmitAction_dynamic_cast(AdaptiveCards::BaseActionElement *baseActionElement){
        return dynamic_cast<AdaptiveCards::SubmitAction *>(baseActionElement);
    }
SWIGINTERN AdaptiveCards::FactSet *AdaptiveCards_FactSet_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::FactSet *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::Table *AdaptiveCards_Table_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::Table *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::TextBlock *AdaptiveCards_TextBlock_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::TextBlock *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::Media *AdaptiveCards_Media_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::Media *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::ToggleVisibilityAction *AdaptiveCards_ToggleVisibilityAction_dynamic_cast(AdaptiveCards::BaseActionElement *baseActionElement){
        return dynamic_cast<AdaptiveCards::ToggleVisibilityAction *>(baseActionElement);
    }
SWIGINTERN AdaptiveCards::ActionSet *AdaptiveCards_ActionSet_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::ActionSet *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::RichTextBlock *AdaptiveCards_RichTextBlock_dynamic_cast(AdaptiveCards::BaseCardElement *baseCardElement){
        return dynamic_cast<AdaptiveCards::RichTextBlock *>(baseCardElement);
    }
SWIGINTERN AdaptiveCards::TextRun *AdaptiveCards_TextRun_dynamic_cast(AdaptiveCards::Inline *inlineVar){
        return dynamic_cast<AdaptiveCards::TextRun *>(inlineVar);
    }


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "objectmodel_wrap.h"

SwigDirector_ActionElementParser::SwigDirector_ActionElementParser(JNIEnv *jenv) : AdaptiveCards::ActionElementParser(), Swig::Director(jenv) {
}

SwigDirector_ActionElementParser::~SwigDirector_ActionElementParser() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::shared_ptr< AdaptiveCards::BaseActionElement > SwigDirector_ActionElementParser::Deserialize(AdaptiveCards::ParseContext &context, Json::Value const &value) {
  std::shared_ptr< AdaptiveCards::BaseActionElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcontext = 0 ;
  jlong jvalue = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method AdaptiveCards::ActionElementParser::Deserialize.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcontext = 0;
    *((std::shared_ptr<  AdaptiveCards::ParseContext > **)&jcontext) = new std::shared_ptr<  AdaptiveCards::ParseContext > (&context SWIG_NO_NULL_DELETER_0); 
    *(Json::Value **)&jvalue = (Json::Value *) &value; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[0], swigjobj, jcontext, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    std::shared_ptr< AdaptiveCards::BaseActionElement > * tmp = NULL;
    *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&tmp = *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult;
    if (!tmp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::shared_ptr< AdaptiveCards::BaseActionElement >");
      return NULL;
    }
    c_result = *tmp;
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::ActionElementParser::Deserialize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::shared_ptr< AdaptiveCards::BaseActionElement > SwigDirector_ActionElementParser::DeserializeFromString(AdaptiveCards::ParseContext &context, std::string const &value) {
  std::shared_ptr< AdaptiveCards::BaseActionElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcontext = 0 ;
  jstring jvalue = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method AdaptiveCards::ActionElementParser::DeserializeFromString.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcontext = 0;
    *((std::shared_ptr<  AdaptiveCards::ParseContext > **)&jcontext) = new std::shared_ptr<  AdaptiveCards::ParseContext > (&context SWIG_NO_NULL_DELETER_0); 
    jvalue = jenv->NewStringUTF((&value)->c_str());
    Swig::LocalRefGuard value_refguard(jenv, jvalue); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[1], swigjobj, jcontext, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    std::shared_ptr< AdaptiveCards::BaseActionElement > * tmp = NULL;
    *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&tmp = *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult;
    if (!tmp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::shared_ptr< AdaptiveCards::BaseActionElement >");
      return NULL;
    }
    c_result = *tmp;
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::ActionElementParser::DeserializeFromString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ActionElementParser::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "Deserialize", "(Lio/adaptivecards/objectmodel/ParseContext;Lio/adaptivecards/objectmodel/JsonValue;)Lio/adaptivecards/objectmodel/BaseActionElement;", NULL 
    },
    {
      "DeserializeFromString", "(Lio/adaptivecards/objectmodel/ParseContext;Ljava/lang/String;)Lio/adaptivecards/objectmodel/BaseActionElement;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("io/adaptivecards/objectmodel/ActionElementParser");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = derived;
    }
  }
}


SwigDirector_BaseCardElementParser::SwigDirector_BaseCardElementParser(JNIEnv *jenv) : AdaptiveCards::BaseCardElementParser(), Swig::Director(jenv) {
}

SwigDirector_BaseCardElementParser::~SwigDirector_BaseCardElementParser() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::shared_ptr< AdaptiveCards::BaseCardElement > SwigDirector_BaseCardElementParser::Deserialize(AdaptiveCards::ParseContext &context, Json::Value const &value) {
  std::shared_ptr< AdaptiveCards::BaseCardElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcontext = 0 ;
  jlong jvalue = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method AdaptiveCards::BaseCardElementParser::Deserialize.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcontext = 0;
    *((std::shared_ptr<  AdaptiveCards::ParseContext > **)&jcontext) = new std::shared_ptr<  AdaptiveCards::ParseContext > (&context SWIG_NO_NULL_DELETER_0); 
    *(Json::Value **)&jvalue = (Json::Value *) &value; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[2], swigjobj, jcontext, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    std::shared_ptr< AdaptiveCards::BaseCardElement > * tmp = NULL;
    *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&tmp = *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult;
    if (!tmp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::shared_ptr< AdaptiveCards::BaseCardElement >");
      return NULL;
    }
    c_result = *tmp;
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElementParser::Deserialize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::shared_ptr< AdaptiveCards::BaseCardElement > SwigDirector_BaseCardElementParser::DeserializeFromString(AdaptiveCards::ParseContext &context, std::string const &value) {
  std::shared_ptr< AdaptiveCards::BaseCardElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcontext = 0 ;
  jstring jvalue = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method AdaptiveCards::BaseCardElementParser::DeserializeFromString.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcontext = 0;
    *((std::shared_ptr<  AdaptiveCards::ParseContext > **)&jcontext) = new std::shared_ptr<  AdaptiveCards::ParseContext > (&context SWIG_NO_NULL_DELETER_0); 
    jvalue = jenv->NewStringUTF((&value)->c_str());
    Swig::LocalRefGuard value_refguard(jenv, jvalue); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[3], swigjobj, jcontext, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    std::shared_ptr< AdaptiveCards::BaseCardElement > * tmp = NULL;
    *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&tmp = *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult;
    if (!tmp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::shared_ptr< AdaptiveCards::BaseCardElement >");
      return NULL;
    }
    c_result = *tmp;
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElementParser::DeserializeFromString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseCardElementParser::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "Deserialize", "(Lio/adaptivecards/objectmodel/ParseContext;Lio/adaptivecards/objectmodel/JsonValue;)Lio/adaptivecards/objectmodel/BaseCardElement;", NULL 
    },
    {
      "DeserializeFromString", "(Lio/adaptivecards/objectmodel/ParseContext;Ljava/lang/String;)Lio/adaptivecards/objectmodel/BaseCardElement;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("io/adaptivecards/objectmodel/BaseCardElementParser");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = derived;
    }
  }
}


SwigDirector_BaseElement::SwigDirector_BaseElement(JNIEnv *jenv) : AdaptiveCards::BaseElement(), Swig::Director(jenv) {
}

SwigDirector_BaseElement::SwigDirector_BaseElement(JNIEnv *jenv, AdaptiveCards::BaseElement const &arg0) : AdaptiveCards::BaseElement(arg0), Swig::Director(jenv) {
}

SwigDirector_BaseElement::SwigDirector_BaseElement(JNIEnv *jenv, AdaptiveCards::BaseElement &&arg0) : AdaptiveCards::BaseElement(arg0), Swig::Director(jenv) {
}

SwigDirector_BaseElement::~SwigDirector_BaseElement() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_BaseElement::SetId(std::string &&value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  
  if (!swig_override[0]) {
    AdaptiveCards::BaseElement::SetId(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::string **)&jvalue = (std::string *) &value; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[4], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseElement::SetId ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseElement::SetId(std::string const &value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jvalue = 0 ;
  
  if (!swig_override[1]) {
    AdaptiveCards::BaseElement::SetId(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jvalue = jenv->NewStringUTF((&value)->c_str());
    Swig::LocalRefGuard value_refguard(jenv, jvalue); 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[5], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseElement::SetId ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_BaseElement::Serialize() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return AdaptiveCards::BaseElement::Serialize();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[6], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseElement::Serialize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Json::Value SwigDirector_BaseElement::SerializeToJsonValue() const {
  Json::Value c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  Json::Value *argp ;
  
  if (!swig_override[3]) {
    return AdaptiveCards::BaseElement::SerializeToJsonValue();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[7], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Json::Value **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Json::Value");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseElement::SerializeToJsonValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseElement::GetResourceInformation(std::vector< AdaptiveCards::RemoteResourceInformation > &resourceUris) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jresourceUris = 0 ;
  
  if (!swig_override[4]) {
    AdaptiveCards::BaseElement::GetResourceInformation(resourceUris);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jresourceUris = (std::vector< AdaptiveCards::RemoteResourceInformation > *) &resourceUris; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[8], swigjobj, jresourceUris);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseElement::GetResourceInformation ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseElement::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "SetId", "(Lio/adaptivecards/objectmodel/SWIGTYPE_p_std__string;)V", NULL 
    },
    {
      "SetId", "(Ljava/lang/String;)V", NULL 
    },
    {
      "Serialize", "()Ljava/lang/String;", NULL 
    },
    {
      "SerializeToJsonValue", "()Lio/adaptivecards/objectmodel/JsonValue;", NULL 
    },
    {
      "GetResourceInformation", "(Lio/adaptivecards/objectmodel/RemoteResourceInformationVector;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("io/adaptivecards/objectmodel/BaseElement");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 5; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = derived;
    }
  }
}


SwigDirector_BaseCardElement::SwigDirector_BaseCardElement(JNIEnv *jenv, AdaptiveCards::CardElementType type, AdaptiveCards::Spacing spacing, bool separator, AdaptiveCards::HeightType height) : AdaptiveCards::BaseCardElement(type, spacing, separator, height), Swig::Director(jenv) {
}

SwigDirector_BaseCardElement::SwigDirector_BaseCardElement(JNIEnv *jenv, AdaptiveCards::CardElementType type) : AdaptiveCards::BaseCardElement(type), Swig::Director(jenv) {
}

SwigDirector_BaseCardElement::SwigDirector_BaseCardElement(JNIEnv *jenv) : AdaptiveCards::BaseCardElement(), Swig::Director(jenv) {
}

SwigDirector_BaseCardElement::SwigDirector_BaseCardElement(JNIEnv *jenv, AdaptiveCards::BaseCardElement const &arg0) : AdaptiveCards::BaseCardElement(arg0), Swig::Director(jenv) {
}

SwigDirector_BaseCardElement::SwigDirector_BaseCardElement(JNIEnv *jenv, AdaptiveCards::BaseCardElement &&arg0) : AdaptiveCards::BaseCardElement(arg0), Swig::Director(jenv) {
}

SwigDirector_BaseCardElement::~SwigDirector_BaseCardElement() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_BaseCardElement::SetId(std::string &&value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  
  if (!swig_override[0]) {
    AdaptiveCards::BaseElement::SetId(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::string **)&jvalue = (std::string *) &value; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[9], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::SetId ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseCardElement::SetId(std::string const &value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jvalue = 0 ;
  
  if (!swig_override[1]) {
    AdaptiveCards::BaseElement::SetId(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jvalue = jenv->NewStringUTF((&value)->c_str());
    Swig::LocalRefGuard value_refguard(jenv, jvalue); 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[10], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::SetId ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_BaseCardElement::Serialize() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return AdaptiveCards::BaseElement::Serialize();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[11], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::Serialize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Json::Value SwigDirector_BaseCardElement::SerializeToJsonValue() const {
  Json::Value c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  Json::Value *argp ;
  
  if (!swig_override[3]) {
    return AdaptiveCards::BaseCardElement::SerializeToJsonValue();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[12], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Json::Value **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Json::Value");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::SerializeToJsonValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseCardElement::GetResourceInformation(std::vector< AdaptiveCards::RemoteResourceInformation > &resourceUris) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jresourceUris = 0 ;
  
  if (!swig_override[4]) {
    AdaptiveCards::BaseElement::GetResourceInformation(resourceUris);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jresourceUris = (std::vector< AdaptiveCards::RemoteResourceInformation > *) &resourceUris; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[13], swigjobj, jresourceUris);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::GetResourceInformation ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_BaseCardElement::GetSeparator() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    return AdaptiveCards::BaseCardElement::GetSeparator();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[14], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::GetSeparator ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseCardElement::SetSeparator(bool value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jboolean jvalue  ;
  
  if (!swig_override[6]) {
    AdaptiveCards::BaseCardElement::SetSeparator(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jvalue = (jboolean) value;
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[15], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::SetSeparator ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

AdaptiveCards::Spacing SwigDirector_BaseCardElement::GetSpacing() const {
  AdaptiveCards::Spacing c_result = SwigValueInit< AdaptiveCards::Spacing >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    return AdaptiveCards::BaseCardElement::GetSpacing();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[16], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (AdaptiveCards::Spacing)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::GetSpacing ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseCardElement::SetSpacing(AdaptiveCards::Spacing value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jvalue  ;
  
  if (!swig_override[8]) {
    AdaptiveCards::BaseCardElement::SetSpacing(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jvalue = (jint) value;
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[17], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseCardElement::SetSpacing ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseCardElement::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "SetId", "(Lio/adaptivecards/objectmodel/SWIGTYPE_p_std__string;)V", NULL 
    },
    {
      "SetId", "(Ljava/lang/String;)V", NULL 
    },
    {
      "Serialize", "()Ljava/lang/String;", NULL 
    },
    {
      "SerializeToJsonValue", "()Lio/adaptivecards/objectmodel/JsonValue;", NULL 
    },
    {
      "GetResourceInformation", "(Lio/adaptivecards/objectmodel/RemoteResourceInformationVector;)V", NULL 
    },
    {
      "GetSeparator", "()Z", NULL 
    },
    {
      "SetSeparator", "(Z)V", NULL 
    },
    {
      "GetSpacing", "()Lio/adaptivecards/objectmodel/Spacing;", NULL 
    },
    {
      "SetSpacing", "(Lio/adaptivecards/objectmodel/Spacing;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("io/adaptivecards/objectmodel/BaseCardElement");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 9; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_BaseActionElement::SwigDirector_BaseActionElement(JNIEnv *jenv, AdaptiveCards::ActionType type) : AdaptiveCards::BaseActionElement(type), Swig::Director(jenv) {
}

SwigDirector_BaseActionElement::SwigDirector_BaseActionElement(JNIEnv *jenv) : AdaptiveCards::BaseActionElement(), Swig::Director(jenv) {
}

SwigDirector_BaseActionElement::SwigDirector_BaseActionElement(JNIEnv *jenv, AdaptiveCards::BaseActionElement const &arg0) : AdaptiveCards::BaseActionElement(arg0), Swig::Director(jenv) {
}

SwigDirector_BaseActionElement::SwigDirector_BaseActionElement(JNIEnv *jenv, AdaptiveCards::BaseActionElement &&arg0) : AdaptiveCards::BaseActionElement(arg0), Swig::Director(jenv) {
}

SwigDirector_BaseActionElement::~SwigDirector_BaseActionElement() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_BaseActionElement::SetId(std::string &&value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  
  if (!swig_override[0]) {
    AdaptiveCards::BaseElement::SetId(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::string **)&jvalue = (std::string *) &value; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[18], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::SetId ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseActionElement::SetId(std::string const &value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jvalue = 0 ;
  
  if (!swig_override[1]) {
    AdaptiveCards::BaseElement::SetId(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jvalue = jenv->NewStringUTF((&value)->c_str());
    Swig::LocalRefGuard value_refguard(jenv, jvalue); 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[19], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::SetId ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_BaseActionElement::Serialize() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return AdaptiveCards::BaseElement::Serialize();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[20], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::Serialize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Json::Value SwigDirector_BaseActionElement::SerializeToJsonValue() const {
  Json::Value c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  Json::Value *argp ;
  
  if (!swig_override[3]) {
    return AdaptiveCards::BaseActionElement::SerializeToJsonValue();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[21], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Json::Value **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Json::Value");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::SerializeToJsonValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseActionElement::GetResourceInformation(std::vector< AdaptiveCards::RemoteResourceInformation > &resourceUris) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jresourceUris = 0 ;
  
  if (!swig_override[4]) {
    AdaptiveCards::BaseActionElement::GetResourceInformation(resourceUris);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jresourceUris = (std::vector< AdaptiveCards::RemoteResourceInformation > *) &resourceUris; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[22], swigjobj, jresourceUris);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::GetResourceInformation ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseActionElement::SetTitle(std::string &&value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  
  if (!swig_override[5]) {
    AdaptiveCards::BaseActionElement::SetTitle(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::string **)&jvalue = (std::string *) &value; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[23], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::SetTitle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseActionElement::SetTitle(std::string const &value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jvalue = 0 ;
  
  if (!swig_override[6]) {
    AdaptiveCards::BaseActionElement::SetTitle(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jvalue = jenv->NewStringUTF((&value)->c_str());
    Swig::LocalRefGuard value_refguard(jenv, jvalue); 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[24], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::SetTitle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseActionElement::SetTooltip(std::string &&value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  
  if (!swig_override[7]) {
    AdaptiveCards::BaseActionElement::SetTooltip(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::string **)&jvalue = (std::string *) &value; 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[25], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::SetTooltip ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseActionElement::SetTooltip(std::string const &value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jvalue = 0 ;
  
  if (!swig_override[8]) {
    AdaptiveCards::BaseActionElement::SetTooltip(value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jvalue = jenv->NewStringUTF((&value)->c_str());
    Swig::LocalRefGuard value_refguard(jenv, jvalue); 
    jenv->CallStaticVoidMethod(Swig::jclass_AdaptiveCardObjectModelJNI, Swig::director_method_ids[26], swigjobj, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in AdaptiveCards::BaseActionElement::SetTooltip ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseActionElement::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "SetId", "(Lio/adaptivecards/objectmodel/SWIGTYPE_p_std__string;)V", NULL 
    },
    {
      "SetId", "(Ljava/lang/String;)V", NULL 
    },
    {
      "Serialize", "()Ljava/lang/String;", NULL 
    },
    {
      "SerializeToJsonValue", "()Lio/adaptivecards/objectmodel/JsonValue;", NULL 
    },
    {
      "GetResourceInformation", "(Lio/adaptivecards/objectmodel/RemoteResourceInformationVector;)V", NULL 
    },
    {
      "SetTitle", "(Lio/adaptivecards/objectmodel/SWIGTYPE_p_std__string;)V", NULL 
    },
    {
      "SetTitle", "(Ljava/lang/String;)V", NULL 
    },
    {
      "SetTooltip", "(Lio/adaptivecards/objectmodel/SWIGTYPE_p_std__string;)V", NULL 
    },
    {
      "SetTooltip", "(Ljava/lang/String;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("io/adaptivecards/objectmodel/BaseActionElement");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 9; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Sec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_sec = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Sec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_sec);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Min_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_min = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Min_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_min);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Hour_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_hour = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Hour_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_hour);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1MDay_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_mday = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1MDay_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_mday);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Mon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_mon = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Mon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_mon);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Year_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_year = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1Year_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_year);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1WDay_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_wday = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1WDay_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_wday);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1YDay_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_yday = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1YDay_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_yday);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1IsDst_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  tm *arg1 = (tm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tm_isdst = arg2;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CTime_1IsDst_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  tm *arg1 = (tm *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tm **)&jarg1; 
  result = (int) ((arg1)->tm_isdst);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CTime(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  tm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (tm *)new tm();
  *(tm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CTime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  tm *arg1 = (tm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(tm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalBool_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< bool > *)new std::optional< bool >();
  *(std::optional< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalBool_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jlong jresult = 0 ;
  bool arg1 ;
  std::optional< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (std::optional< bool > *)new std::optional< bool >(arg1);
  *(std::optional< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalBool_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< bool > *arg1 = (std::optional< bool > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< bool > **)&jarg1; 
  result = (bool)((std::optional< bool > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalBool_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< bool > *arg1 = (std::optional< bool > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< bool > **)&jarg1; 
  result = (bool)(arg1)->value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalBool(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< bool > *arg1 = (std::optional< bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< bool > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalDouble_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< double > *)new std::optional< double >();
  *(std::optional< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalDouble_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  std::optional< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  result = (std::optional< double > *)new std::optional< double >(arg1);
  *(std::optional< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalDouble_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< double > *arg1 = (std::optional< double > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< double > **)&jarg1; 
  result = (bool)((std::optional< double > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalDouble_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::optional< double > *arg1 = (std::optional< double > *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< double > **)&jarg1; 
  result = (double)(arg1)->value();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalDouble(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< double > *arg1 = (std::optional< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< double > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalLong_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< unsigned int > *)new std::optional< unsigned int >();
  *(std::optional< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalLong_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  std::optional< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (std::optional< unsigned int > *)new std::optional< unsigned int >(arg1);
  *(std::optional< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalLong_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< unsigned int > *arg1 = (std::optional< unsigned int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< unsigned int > **)&jarg1; 
  result = (bool)((std::optional< unsigned int > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalLong_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::optional< unsigned int > *arg1 = (std::optional< unsigned int > *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< unsigned int > **)&jarg1; 
  result = (unsigned int)(arg1)->value();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalLong(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< unsigned int > *arg1 = (std::optional< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< unsigned int > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalFontType_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< AdaptiveCards::FontType > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< AdaptiveCards::FontType > *)new std::optional< AdaptiveCards::FontType >();
  *(std::optional< AdaptiveCards::FontType > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalFontType_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::FontType arg1 ;
  std::optional< AdaptiveCards::FontType > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::FontType)jarg1; 
  result = (std::optional< AdaptiveCards::FontType > *)new std::optional< AdaptiveCards::FontType >(arg1);
  *(std::optional< AdaptiveCards::FontType > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalFontType_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< AdaptiveCards::FontType > *arg1 = (std::optional< AdaptiveCards::FontType > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::FontType > **)&jarg1; 
  result = (bool)((std::optional< AdaptiveCards::FontType > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalFontType_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::optional< AdaptiveCards::FontType > *arg1 = (std::optional< AdaptiveCards::FontType > *) 0 ;
  AdaptiveCards::FontType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::FontType > **)&jarg1; 
  result = (AdaptiveCards::FontType)(arg1)->value();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalFontType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< AdaptiveCards::FontType > *arg1 = (std::optional< AdaptiveCards::FontType > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< AdaptiveCards::FontType > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalTextWeight_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< AdaptiveCards::TextWeight > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< AdaptiveCards::TextWeight > *)new std::optional< AdaptiveCards::TextWeight >();
  *(std::optional< AdaptiveCards::TextWeight > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalTextWeight_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::TextWeight arg1 ;
  std::optional< AdaptiveCards::TextWeight > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::TextWeight)jarg1; 
  result = (std::optional< AdaptiveCards::TextWeight > *)new std::optional< AdaptiveCards::TextWeight >(arg1);
  *(std::optional< AdaptiveCards::TextWeight > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalTextWeight_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< AdaptiveCards::TextWeight > *arg1 = (std::optional< AdaptiveCards::TextWeight > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::TextWeight > **)&jarg1; 
  result = (bool)((std::optional< AdaptiveCards::TextWeight > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalTextWeight_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::optional< AdaptiveCards::TextWeight > *arg1 = (std::optional< AdaptiveCards::TextWeight > *) 0 ;
  AdaptiveCards::TextWeight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::TextWeight > **)&jarg1; 
  result = (AdaptiveCards::TextWeight)(arg1)->value();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalTextWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< AdaptiveCards::TextWeight > *arg1 = (std::optional< AdaptiveCards::TextWeight > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< AdaptiveCards::TextWeight > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalTextSize_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< AdaptiveCards::TextSize > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< AdaptiveCards::TextSize > *)new std::optional< AdaptiveCards::TextSize >();
  *(std::optional< AdaptiveCards::TextSize > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalTextSize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::TextSize arg1 ;
  std::optional< AdaptiveCards::TextSize > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::TextSize)jarg1; 
  result = (std::optional< AdaptiveCards::TextSize > *)new std::optional< AdaptiveCards::TextSize >(arg1);
  *(std::optional< AdaptiveCards::TextSize > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalTextSize_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< AdaptiveCards::TextSize > *arg1 = (std::optional< AdaptiveCards::TextSize > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::TextSize > **)&jarg1; 
  result = (bool)((std::optional< AdaptiveCards::TextSize > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalTextSize_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::optional< AdaptiveCards::TextSize > *arg1 = (std::optional< AdaptiveCards::TextSize > *) 0 ;
  AdaptiveCards::TextSize result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::TextSize > **)&jarg1; 
  result = (AdaptiveCards::TextSize)(arg1)->value();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalTextSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< AdaptiveCards::TextSize > *arg1 = (std::optional< AdaptiveCards::TextSize > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< AdaptiveCards::TextSize > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalForegroundColor_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< AdaptiveCards::ForegroundColor > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< AdaptiveCards::ForegroundColor > *)new std::optional< AdaptiveCards::ForegroundColor >();
  *(std::optional< AdaptiveCards::ForegroundColor > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalForegroundColor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::ForegroundColor arg1 ;
  std::optional< AdaptiveCards::ForegroundColor > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ForegroundColor)jarg1; 
  result = (std::optional< AdaptiveCards::ForegroundColor > *)new std::optional< AdaptiveCards::ForegroundColor >(arg1);
  *(std::optional< AdaptiveCards::ForegroundColor > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalForegroundColor_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< AdaptiveCards::ForegroundColor > *arg1 = (std::optional< AdaptiveCards::ForegroundColor > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::ForegroundColor > **)&jarg1; 
  result = (bool)((std::optional< AdaptiveCards::ForegroundColor > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalForegroundColor_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::optional< AdaptiveCards::ForegroundColor > *arg1 = (std::optional< AdaptiveCards::ForegroundColor > *) 0 ;
  AdaptiveCards::ForegroundColor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::ForegroundColor > **)&jarg1; 
  result = (AdaptiveCards::ForegroundColor)(arg1)->value();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalForegroundColor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< AdaptiveCards::ForegroundColor > *arg1 = (std::optional< AdaptiveCards::ForegroundColor > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< AdaptiveCards::ForegroundColor > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalTextStyle_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< AdaptiveCards::TextStyle > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< AdaptiveCards::TextStyle > *)new std::optional< AdaptiveCards::TextStyle >();
  *(std::optional< AdaptiveCards::TextStyle > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalTextStyle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::TextStyle arg1 ;
  std::optional< AdaptiveCards::TextStyle > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::TextStyle)jarg1; 
  result = (std::optional< AdaptiveCards::TextStyle > *)new std::optional< AdaptiveCards::TextStyle >(arg1);
  *(std::optional< AdaptiveCards::TextStyle > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalTextStyle_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< AdaptiveCards::TextStyle > *arg1 = (std::optional< AdaptiveCards::TextStyle > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::TextStyle > **)&jarg1; 
  result = (bool)((std::optional< AdaptiveCards::TextStyle > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalTextStyle_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::optional< AdaptiveCards::TextStyle > *arg1 = (std::optional< AdaptiveCards::TextStyle > *) 0 ;
  AdaptiveCards::TextStyle result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::TextStyle > **)&jarg1; 
  result = (AdaptiveCards::TextStyle)(arg1)->value();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalTextStyle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< AdaptiveCards::TextStyle > *arg1 = (std::optional< AdaptiveCards::TextStyle > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< AdaptiveCards::TextStyle > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalHorizontalAlignment_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< AdaptiveCards::HorizontalAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< AdaptiveCards::HorizontalAlignment > *)new std::optional< AdaptiveCards::HorizontalAlignment >();
  *(std::optional< AdaptiveCards::HorizontalAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalHorizontalAlignment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::HorizontalAlignment arg1 ;
  std::optional< AdaptiveCards::HorizontalAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::HorizontalAlignment)jarg1; 
  result = (std::optional< AdaptiveCards::HorizontalAlignment > *)new std::optional< AdaptiveCards::HorizontalAlignment >(arg1);
  *(std::optional< AdaptiveCards::HorizontalAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalHorizontalAlignment_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< AdaptiveCards::HorizontalAlignment > *arg1 = (std::optional< AdaptiveCards::HorizontalAlignment > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::HorizontalAlignment > **)&jarg1; 
  result = (bool)((std::optional< AdaptiveCards::HorizontalAlignment > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalHorizontalAlignment_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::optional< AdaptiveCards::HorizontalAlignment > *arg1 = (std::optional< AdaptiveCards::HorizontalAlignment > *) 0 ;
  AdaptiveCards::HorizontalAlignment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::HorizontalAlignment > **)&jarg1; 
  result = (AdaptiveCards::HorizontalAlignment)(arg1)->value();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalHorizontalAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< AdaptiveCards::HorizontalAlignment > *arg1 = (std::optional< AdaptiveCards::HorizontalAlignment > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< AdaptiveCards::HorizontalAlignment > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalVerticalContentAlignment_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::optional< AdaptiveCards::VerticalContentAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::optional< AdaptiveCards::VerticalContentAlignment > *)new std::optional< AdaptiveCards::VerticalContentAlignment >();
  *(std::optional< AdaptiveCards::VerticalContentAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StdOptionalVerticalContentAlignment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::VerticalContentAlignment arg1 ;
  std::optional< AdaptiveCards::VerticalContentAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::VerticalContentAlignment)jarg1; 
  result = (std::optional< AdaptiveCards::VerticalContentAlignment > *)new std::optional< AdaptiveCards::VerticalContentAlignment >(arg1);
  *(std::optional< AdaptiveCards::VerticalContentAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalVerticalContentAlignment_1has_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::optional< AdaptiveCards::VerticalContentAlignment > *arg1 = (std::optional< AdaptiveCards::VerticalContentAlignment > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::VerticalContentAlignment > **)&jarg1; 
  result = (bool)((std::optional< AdaptiveCards::VerticalContentAlignment > const *)arg1)->has_value();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StdOptionalVerticalContentAlignment_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::optional< AdaptiveCards::VerticalContentAlignment > *arg1 = (std::optional< AdaptiveCards::VerticalContentAlignment > *) 0 ;
  AdaptiveCards::VerticalContentAlignment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::optional< AdaptiveCards::VerticalContentAlignment > **)&jarg1; 
  result = (AdaptiveCards::VerticalContentAlignment)(arg1)->value();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StdOptionalVerticalContentAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::optional< AdaptiveCards::VerticalContentAlignment > *arg1 = (std::optional< AdaptiveCards::VerticalContentAlignment > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::optional< AdaptiveCards::VerticalContentAlignment > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_JsonValue_1getString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Json::Value *arg1 = (Json::Value *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Json::Value **)&jarg1; 
  result = Json_Value_getString(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1JsonValue(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Json::Value *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Json::Value *)new Json::Value();
  *(Json::Value **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1JsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Json::Value *arg1 = (Json::Value *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Json::Value **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1RemoteResourceInformationVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< AdaptiveCards::RemoteResourceInformation > *)new std::vector< AdaptiveCards::RemoteResourceInformation >();
  *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1RemoteResourceInformationVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > const & reference is null");
    return 0;
  } 
  result = (std::vector< AdaptiveCards::RemoteResourceInformation > *)new std::vector< AdaptiveCards::RemoteResourceInformation >((std::vector< AdaptiveCards::RemoteResourceInformation > const &)*arg1);
  *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  result = ((std::vector< AdaptiveCards::RemoteResourceInformation > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  arg2 = (std::vector< AdaptiveCards::RemoteResourceInformation >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  result = (bool)((std::vector< AdaptiveCards::RemoteResourceInformation > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1RemoteResourceInformationVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  AdaptiveCards::RemoteResourceInformation *arg2 = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  
  arg2 = (AdaptiveCards::RemoteResourceInformation *)((*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg2) ? (*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::RemoteResourceInformation const & reference is null");
    return 0;
  } 
  try {
    result = (std::vector< AdaptiveCards::RemoteResourceInformation > *)new_std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg___SWIG_2(arg1,(AdaptiveCards::RemoteResourceInformation const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  try {
    result = std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doSize((std::vector< AdaptiveCards::RemoteResourceInformation > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  
  arg2 = (std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *)((*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg2) ? (*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation >::value_type const & reference is null");
    return ;
  } 
  std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doAdd__SWIG_0(arg1,(AdaptiveCards::RemoteResourceInformation const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  jint arg2 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  arg2 = jarg2; 
  
  arg3 = (std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *)((*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg3) ? (*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg3)->get() : 0);
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation >::value_type const & reference is null");
    return ;
  } 
  try {
    std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doAdd__SWIG_1(arg1,arg2,(AdaptiveCards::RemoteResourceInformation const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  jint arg2 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jresult = new std::shared_ptr<  AdaptiveCards::RemoteResourceInformation >(new std::vector< AdaptiveCards::RemoteResourceInformation >::value_type((std::vector< AdaptiveCards::RemoteResourceInformation >::value_type &)result)); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  jint arg2 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *) &std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jresult = new std::shared_ptr< const AdaptiveCards::RemoteResourceInformation >(result SWIG_NO_NULL_DELETER_0); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  jint arg2 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *arg3 = 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  arg2 = jarg2; 
  
  arg3 = (std::vector< AdaptiveCards::RemoteResourceInformation >::value_type *)((*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg3) ? (*(std::shared_ptr< const AdaptiveCards::RemoteResourceInformation > **)&jarg3)->get() : 0);
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation >::value_type const & reference is null");
    return 0;
  } 
  try {
    result = std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doSet(arg1,arg2,(AdaptiveCards::RemoteResourceInformation const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jresult = new std::shared_ptr<  AdaptiveCards::RemoteResourceInformation >(new std::vector< AdaptiveCards::RemoteResourceInformation >::value_type((std::vector< AdaptiveCards::RemoteResourceInformation >::value_type &)result)); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformationVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_AdaptiveCards_RemoteResourceInformation_Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1RemoteResourceInformationVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg1 = (std::vector< AdaptiveCards::RemoteResourceInformation > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCardParseWarningVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *)new std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCardParseWarningVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *)new std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >((std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCardParseWarningVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarningVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AdaptiveCardParseWarning_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1AdaptiveCardParseWarningVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElementVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *)new std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElementVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *)new std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >((std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElementVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::BaseCardElement > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::BaseCardElement > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::BaseCardElement > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::BaseCardElement > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseCardElement_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseCardElementVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *)new std::vector< std::shared_ptr< AdaptiveCards::Image > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::Image > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *)new std::vector< std::shared_ptr< AdaptiveCards::Image > >((std::vector< std::shared_ptr< AdaptiveCards::Image > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::Image > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::Image > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::Image > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::Image > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Image > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::Image > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::Image > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::Image > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::Image > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::Image > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::Image > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Image > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Image_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ImageVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1FactVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *)new std::vector< std::shared_ptr< AdaptiveCards::Fact > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1FactVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::Fact > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *)new std::vector< std::shared_ptr< AdaptiveCards::Fact > >((std::vector< std::shared_ptr< AdaptiveCards::Fact > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::Fact > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::Fact > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1FactVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::Fact > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Fact > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::Fact > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::Fact > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::Fact > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::Fact > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::Fact > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::Fact > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Fact > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FactVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Fact_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1FactVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::Fact > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Fact > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Fact > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *)new std::vector< std::shared_ptr< AdaptiveCards::Column > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::Column > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *)new std::vector< std::shared_ptr< AdaptiveCards::Column > >((std::vector< std::shared_ptr< AdaptiveCards::Column > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::Column > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::Column > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::Column > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::Column > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Column > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::Column > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::Column > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::Column > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::Column > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::Column > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::Column > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Column > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Column_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ColumnVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceInputVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *)new std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceInputVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *)new std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >((std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceInputVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::ChoiceInput > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::ChoiceInput > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::ChoiceInput > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::ChoiceInput > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::ChoiceInput > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInputVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ChoiceInput_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ChoiceInputVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CaptionSourceVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *)new std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CaptionSourceVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *)new std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >((std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CaptionSourceVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::CaptionSource > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::CaptionSource > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::CaptionSource > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::CaptionSource > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::CaptionSource > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::CaptionSource > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::CaptionSource > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CaptionSourceVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_CaptionSource_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CaptionSourceVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::CaptionSource > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1MediaSourceVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *)new std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1MediaSourceVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *)new std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >((std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1MediaSourceVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::MediaSource > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::MediaSource > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::MediaSource > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::MediaSource > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::MediaSource > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::MediaSource > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::MediaSource > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::MediaSource > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_MediaSourceVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_MediaSource_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1MediaSourceVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::MediaSource > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseActionElementVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *)new std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseActionElementVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *)new std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >((std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseActionElementVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::BaseActionElement > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::BaseActionElement > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::BaseActionElement > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::BaseActionElement > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElementVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_BaseActionElement_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseActionElementVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1DateTimePreparsedTokenVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *)new std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1DateTimePreparsedTokenVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *)new std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >((std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1DateTimePreparsedTokenVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateTimePreparsedTokenVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_DateTimePreparsedToken_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1DateTimePreparsedTokenVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::DateTimePreparsedToken > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableCellVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *)new std::vector< std::shared_ptr< AdaptiveCards::TableCell > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableCellVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::TableCell > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *)new std::vector< std::shared_ptr< AdaptiveCards::TableCell > >((std::vector< std::shared_ptr< AdaptiveCards::TableCell > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::TableCell > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::TableCell > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableCellVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::TableCell > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TableCell > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::TableCell > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::TableCell > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::TableCell > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::TableCell > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::TableCell > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::TableCell > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::TableCell > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableCellVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableCell_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TableCellVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableCell > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableCell > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableRowVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *)new std::vector< std::shared_ptr< AdaptiveCards::TableRow > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableRowVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::TableRow > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *)new std::vector< std::shared_ptr< AdaptiveCards::TableRow > >((std::vector< std::shared_ptr< AdaptiveCards::TableRow > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::TableRow > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::TableRow > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableRowVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::TableRow > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TableRow > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::TableRow > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::TableRow > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::TableRow > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::TableRow > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::TableRow > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::TableRow > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::TableRow > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableRowVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableRow_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TableRowVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableRow > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableRow > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableColumnDefinitionVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *)new std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableColumnDefinitionVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *)new std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >((std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TableColumnDefinitionVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::TableColumnDefinition > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TableColumnDefinition > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::TableColumnDefinition > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::TableColumnDefinition > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::TableColumnDefinition > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::TableColumnDefinition > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::TableColumnDefinition > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TableColumnDefinitionVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_TableColumnDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TableColumnDefinitionVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::TableColumnDefinition > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ToggleVisibilityTargetVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *)new std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ToggleVisibilityTargetVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *)new std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >((std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ToggleVisibilityTargetVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleVisibilityTargetVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_ToggleVisibilityTarget_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ToggleVisibilityTargetVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::ToggleVisibilityTarget > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StringVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::string > *)new std::vector< std::string >();
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StringVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::string > *)new std::vector< std::string >((std::vector< std::string > const &)*arg1);
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  result = ((std::vector< std::string > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  result = (bool)((std::vector< std::string > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1StringVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::string *arg2 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  try {
    result = (std::vector< std::string > *)new_std_vector_Sl_std_string_Sg___SWIG_2(arg1,(std::string const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  try {
    result = std_vector_Sl_std_string_Sg__doSize((std::vector< std::string > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::vector< std::string >::value_type arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  std_vector_Sl_std_string_Sg__doAdd__SWIG_0(arg1,(std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  try {
    std_vector_Sl_std_string_Sg__doAdd__SWIG_1(arg1,arg2,(std::string const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_string_Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  try {
    result = std_vector_Sl_std_string_Sg__doSet(arg1,arg2,(std::string const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StringVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_string_Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StringVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CharVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< char > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< char > *)new std::vector< char >();
  *(std::vector< char > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CharVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< char > *arg1 = 0 ;
  std::vector< char > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< char > const & reference is null");
    return 0;
  } 
  result = (std::vector< char > *)new std::vector< char >((std::vector< char > const &)*arg1);
  *(std::vector< char > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  std::vector< char >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  result = ((std::vector< char > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  std::vector< char >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  arg2 = (std::vector< char >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  result = (bool)((std::vector< char > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CharVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jchar jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  char *arg2 = 0 ;
  char temp2 ;
  std::vector< char > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (char)jarg2; 
  arg2 = &temp2; 
  try {
    result = (std::vector< char > *)new_std_vector_Sl_char_Sg___SWIG_2(arg1,(char const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< char > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  try {
    result = std_vector_Sl_char_Sg__doSize((std::vector< char > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  std::vector< char >::value_type *arg2 = 0 ;
  std::vector< char >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  temp2 = (std::vector< char >::value_type)jarg2; 
  arg2 = &temp2; 
  std_vector_Sl_char_Sg__doAdd__SWIG_0(arg1,(char const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jchar jarg3) {
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  jint arg2 ;
  std::vector< char >::value_type *arg3 = 0 ;
  std::vector< char >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< char >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_char_Sg__doAdd__SWIG_1(arg1,arg2,(char const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jchar JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jchar jresult = 0 ;
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  jint arg2 ;
  std::vector< char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< char >::value_type)std_vector_Sl_char_Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jchar JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jchar jresult = 0 ;
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  jint arg2 ;
  std::vector< char >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< char >::value_type *) &std_vector_Sl_char_Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jchar)*result; 
  return jresult;
}


SWIGEXPORT jchar JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jchar jarg3) {
  jchar jresult = 0 ;
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  jint arg2 ;
  std::vector< char >::value_type *arg3 = 0 ;
  std::vector< char >::value_type temp3 ;
  std::vector< char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< char >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    result = (std::vector< char >::value_type)std_vector_Sl_char_Sg__doSet(arg1,arg2,(char const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CharVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_char_Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CharVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< char > *arg1 = (std::vector< char > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< char > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1InlineVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *)new std::vector< std::shared_ptr< AdaptiveCards::Inline > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1InlineVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::Inline > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *)new std::vector< std::shared_ptr< AdaptiveCards::Inline > >((std::vector< std::shared_ptr< AdaptiveCards::Inline > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::Inline > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::Inline > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1InlineVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::Inline > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Inline > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::Inline > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::Inline > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::Inline > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::Inline > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::Inline > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::Inline > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::Inline > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_Inline_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1InlineVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::Inline > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::Inline > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::Inline > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AuthCardButtonVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *)new std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >();
  *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AuthCardButtonVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const & reference is null");
    return 0;
  } 
  result = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *)new std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >((std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const &)*arg1);
  *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  result = ((std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  arg2 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::size_type)jarg2; 
  try {
    (arg1)->reserve(arg2);
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  result = (bool)((std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AuthCardButtonVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > tempnull2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::AuthCardButton > **)&jarg2 : &tempnull2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *)new_std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg___SWIG_2(arg1,(std::shared_ptr< AdaptiveCards::AuthCardButton > const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doSize((std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type **)&jarg2 : &tempnull2; 
  std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doAdd__SWIG_0(arg1,(std::shared_ptr< AdaptiveCards::AuthCardButton > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type **)&jarg3 : &tempnull3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::shared_ptr< AdaptiveCards::AuthCardButton > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doRemove(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type *) &std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doGet(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type **)&jresult = *result ? new std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  jint arg2 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type tempnull3 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type **)&jarg3 : &tempnull3; 
  try {
    result = std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doSet(arg1,arg2,(std::shared_ptr< AdaptiveCards::AuthCardButton > const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type **)&jresult = result ? new std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButtonVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_std_shared_ptr_Sl_AdaptiveCards_AuthCardButton_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1AuthCardButtonVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg1 = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_EnableSharedFromThisContainer_1shared_1from_1this(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::enable_shared_from_this< AdaptiveCards::Container > *arg1 = (std::enable_shared_from_this< AdaptiveCards::Container > *) 0 ;
  std::shared_ptr< AdaptiveCards::Container > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::enable_shared_from_this< AdaptiveCards::Container > **)&jarg1; 
  result = (arg1)->shared_from_this();
  *(std::shared_ptr< AdaptiveCards::Container > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::Container >(result) : 0; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_c_1sharedModelVersion_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)AdaptiveCards::c_sharedModelVersion;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CaseInsensitiveEqualTo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::CaseInsensitiveEqualTo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::CaseInsensitiveEqualTo *)new AdaptiveCards::CaseInsensitiveEqualTo();
  *(AdaptiveCards::CaseInsensitiveEqualTo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CaseInsensitiveEqualTo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::CaseInsensitiveEqualTo *arg1 = (AdaptiveCards::CaseInsensitiveEqualTo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::CaseInsensitiveEqualTo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CaseInsensitiveHash(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::CaseInsensitiveHash *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::CaseInsensitiveHash *)new AdaptiveCards::CaseInsensitiveHash();
  *(AdaptiveCards::CaseInsensitiveHash **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CaseInsensitiveHash(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::CaseInsensitiveHash *arg1 = (AdaptiveCards::CaseInsensitiveHash *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::CaseInsensitiveHash **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1EnumHash(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHash *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHash *)new AdaptiveCards::EnumHash();
  *(AdaptiveCards::EnumHash **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1EnumHash(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::EnumHash *arg1 = (AdaptiveCards::EnumHash *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::EnumHash **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getAdaptiveCardSchemaKeyEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::AdaptiveCardSchemaKey > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::AdaptiveCardSchemaKey > *) &AdaptiveCards::EnumHelpers::getAdaptiveCardSchemaKeyEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::AdaptiveCardSchemaKey > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardSchemaKeyToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::AdaptiveCardSchemaKey arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::AdaptiveCardSchemaKey)jarg1; 
  result = (std::string *) &AdaptiveCards::AdaptiveCardSchemaKeyToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardSchemaKeyFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::AdaptiveCardSchemaKey result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::AdaptiveCardSchemaKey)AdaptiveCards::AdaptiveCardSchemaKeyFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getCardElementTypeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::CardElementType > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::CardElementType > *) &AdaptiveCards::EnumHelpers::getCardElementTypeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::CardElementType > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CardElementTypeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::CardElementType arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::CardElementType)jarg1; 
  result = (std::string *) &AdaptiveCards::CardElementTypeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CardElementTypeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::CardElementType result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::CardElementType)AdaptiveCards::CardElementTypeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getInlineElementTypeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::InlineElementType > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::InlineElementType > *) &AdaptiveCards::EnumHelpers::getInlineElementTypeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::InlineElementType > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineElementTypeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::InlineElementType arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::InlineElementType)jarg1; 
  result = (std::string *) &AdaptiveCards::InlineElementTypeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InlineElementTypeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::InlineElementType result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::InlineElementType)AdaptiveCards::InlineElementTypeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getTextStyleEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextStyle > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextStyle > *) &AdaptiveCards::EnumHelpers::getTextStyleEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextStyle > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextStyleToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::TextStyle arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::TextStyle)jarg1; 
  result = (std::string *) &AdaptiveCards::TextStyleToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextStyleFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::TextStyle result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::TextStyle)AdaptiveCards::TextStyleFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getTextSizeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextSize > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextSize > *) &AdaptiveCards::EnumHelpers::getTextSizeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextSize > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextSizeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::TextSize arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::TextSize)jarg1; 
  result = (std::string *) &AdaptiveCards::TextSizeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextSizeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::TextSize result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::TextSize)AdaptiveCards::TextSizeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getTextWeightEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextWeight > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextWeight > *) &AdaptiveCards::EnumHelpers::getTextWeightEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextWeight > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextWeightToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::TextWeight arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::TextWeight)jarg1; 
  result = (std::string *) &AdaptiveCards::TextWeightToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextWeightFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::TextWeight result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::TextWeight)AdaptiveCards::TextWeightFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getFontTypeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::FontType > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::FontType > *) &AdaptiveCards::EnumHelpers::getFontTypeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::FontType > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FontTypeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::FontType arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::FontType)jarg1; 
  result = (std::string *) &AdaptiveCards::FontTypeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FontTypeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::FontType result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::FontType)AdaptiveCards::FontTypeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getForegroundColorEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ForegroundColor > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ForegroundColor > *) &AdaptiveCards::EnumHelpers::getForegroundColorEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ForegroundColor > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ForegroundColorToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ForegroundColor arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ForegroundColor)jarg1; 
  result = (std::string *) &AdaptiveCards::ForegroundColorToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ForegroundColorFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ForegroundColor result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ForegroundColor)AdaptiveCards::ForegroundColorFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getHorizontalAlignmentEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::HorizontalAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::HorizontalAlignment > *) &AdaptiveCards::EnumHelpers::getHorizontalAlignmentEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::HorizontalAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_HorizontalAlignmentToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::HorizontalAlignment arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::HorizontalAlignment)jarg1; 
  result = (std::string *) &AdaptiveCards::HorizontalAlignmentToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_HorizontalAlignmentFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::HorizontalAlignment result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::HorizontalAlignment)AdaptiveCards::HorizontalAlignmentFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getVerticalAlignmentEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::VerticalAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::VerticalAlignment > *) &AdaptiveCards::EnumHelpers::getVerticalAlignmentEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::VerticalAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_VerticalAlignmentToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::VerticalAlignment arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::VerticalAlignment)jarg1; 
  result = (std::string *) &AdaptiveCards::VerticalAlignmentToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_VerticalAlignmentFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::VerticalAlignment result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::VerticalAlignment)AdaptiveCards::VerticalAlignmentFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getImageFillModeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageFillMode > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageFillMode > *) &AdaptiveCards::EnumHelpers::getImageFillModeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageFillMode > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageFillModeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ImageFillMode arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ImageFillMode)jarg1; 
  result = (std::string *) &AdaptiveCards::ImageFillModeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageFillModeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ImageFillMode result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ImageFillMode)AdaptiveCards::ImageFillModeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getImageStyleEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageStyle > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageStyle > *) &AdaptiveCards::EnumHelpers::getImageStyleEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageStyle > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageStyleToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ImageStyle arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ImageStyle)jarg1; 
  result = (std::string *) &AdaptiveCards::ImageStyleToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageStyleFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ImageStyle result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ImageStyle)AdaptiveCards::ImageStyleFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getImageSizeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageSize > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageSize > *) &AdaptiveCards::EnumHelpers::getImageSizeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ImageSize > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSizeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ImageSize arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ImageSize)jarg1; 
  result = (std::string *) &AdaptiveCards::ImageSizeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSizeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ImageSize result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ImageSize)AdaptiveCards::ImageSizeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getTextInputStyleEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextInputStyle > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextInputStyle > *) &AdaptiveCards::EnumHelpers::getTextInputStyleEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::TextInputStyle > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInputStyleToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::TextInputStyle arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::TextInputStyle)jarg1; 
  result = (std::string *) &AdaptiveCards::TextInputStyleToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInputStyleFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::TextInputStyle result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::TextInputStyle)AdaptiveCards::TextInputStyleFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getActionTypeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionType > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionType > *) &AdaptiveCards::EnumHelpers::getActionTypeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionType > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionTypeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ActionType arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ActionType)jarg1; 
  result = (std::string *) &AdaptiveCards::ActionTypeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionTypeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ActionType result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ActionType)AdaptiveCards::ActionTypeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getActionAlignmentEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionAlignment > *) &AdaptiveCards::EnumHelpers::getActionAlignmentEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionAlignmentToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ActionAlignment arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ActionAlignment)jarg1; 
  result = (std::string *) &AdaptiveCards::ActionAlignmentToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionAlignmentFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ActionAlignment result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ActionAlignment)AdaptiveCards::ActionAlignmentFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getAssociatedInputsEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::AssociatedInputs > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::AssociatedInputs > *) &AdaptiveCards::EnumHelpers::getAssociatedInputsEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::AssociatedInputs > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AssociatedInputsToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::AssociatedInputs arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::AssociatedInputs)jarg1; 
  result = (std::string *) &AdaptiveCards::AssociatedInputsToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AssociatedInputsFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::AssociatedInputs result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::AssociatedInputs)AdaptiveCards::AssociatedInputsFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getChoiceSetStyleEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ChoiceSetStyle > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ChoiceSetStyle > *) &AdaptiveCards::EnumHelpers::getChoiceSetStyleEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ChoiceSetStyle > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetStyleToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoiceSetStyle arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ChoiceSetStyle)jarg1; 
  result = (std::string *) &AdaptiveCards::ChoiceSetStyleToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetStyleFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ChoiceSetStyle result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ChoiceSetStyle)AdaptiveCards::ChoiceSetStyleFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getSeparatorThicknessEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::SeparatorThickness > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::SeparatorThickness > *) &AdaptiveCards::EnumHelpers::getSeparatorThicknessEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::SeparatorThickness > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SeparatorThicknessToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::SeparatorThickness arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::SeparatorThickness)jarg1; 
  result = (std::string *) &AdaptiveCards::SeparatorThicknessToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SeparatorThicknessFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::SeparatorThickness result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::SeparatorThickness)AdaptiveCards::SeparatorThicknessFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getSpacingEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::Spacing > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::Spacing > *) &AdaptiveCards::EnumHelpers::getSpacingEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::Spacing > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SpacingToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::Spacing arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::Spacing)jarg1; 
  result = (std::string *) &AdaptiveCards::SpacingToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SpacingFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::Spacing result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::Spacing)AdaptiveCards::SpacingFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getActionsOrientationEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionsOrientation > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionsOrientation > *) &AdaptiveCards::EnumHelpers::getActionsOrientationEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionsOrientation > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionsOrientationToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ActionsOrientation arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ActionsOrientation)jarg1; 
  result = (std::string *) &AdaptiveCards::ActionsOrientationToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionsOrientationFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ActionsOrientation result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ActionsOrientation)AdaptiveCards::ActionsOrientationFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getActionModeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionMode > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionMode > *) &AdaptiveCards::EnumHelpers::getActionModeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ActionMode > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionModeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ActionMode arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ActionMode)jarg1; 
  result = (std::string *) &AdaptiveCards::ActionModeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionModeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ActionMode result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ActionMode)AdaptiveCards::ActionModeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getContainerStyleEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ContainerStyle > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ContainerStyle > *) &AdaptiveCards::EnumHelpers::getContainerStyleEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ContainerStyle > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ContainerStyleToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ContainerStyle arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ContainerStyle)jarg1; 
  result = (std::string *) &AdaptiveCards::ContainerStyleToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ContainerStyleFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ContainerStyle result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ContainerStyle)AdaptiveCards::ContainerStyleFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getModeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::Mode > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::Mode > *) &AdaptiveCards::EnumHelpers::getModeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::Mode > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ModeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::Mode arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::Mode)jarg1; 
  result = (std::string *) &AdaptiveCards::ModeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ModeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::Mode result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::Mode)AdaptiveCards::ModeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getErrorStatusCodeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ErrorStatusCode > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ErrorStatusCode > *) &AdaptiveCards::EnumHelpers::getErrorStatusCodeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::ErrorStatusCode > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ErrorStatusCodeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::ErrorStatusCode arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ErrorStatusCode)jarg1; 
  result = (std::string *) &AdaptiveCards::ErrorStatusCodeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ErrorStatusCodeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ErrorStatusCode result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::ErrorStatusCode)AdaptiveCards::ErrorStatusCodeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getIconPlacementEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::IconPlacement > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::IconPlacement > *) &AdaptiveCards::EnumHelpers::getIconPlacementEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::IconPlacement > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_IconPlacementToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::IconPlacement arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::IconPlacement)jarg1; 
  result = (std::string *) &AdaptiveCards::IconPlacementToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_IconPlacementFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::IconPlacement result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::IconPlacement)AdaptiveCards::IconPlacementFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getVerticalContentAlignmentEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::VerticalContentAlignment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::VerticalContentAlignment > *) &AdaptiveCards::EnumHelpers::getVerticalContentAlignmentEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::VerticalContentAlignment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_VerticalContentAlignmentToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::VerticalContentAlignment arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::VerticalContentAlignment)jarg1; 
  result = (std::string *) &AdaptiveCards::VerticalContentAlignmentToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_VerticalContentAlignmentFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::VerticalContentAlignment result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::VerticalContentAlignment)AdaptiveCards::VerticalContentAlignmentFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_getHeightTypeEnum(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::HeightType > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::HeightType > *) &AdaptiveCards::EnumHelpers::getHeightTypeEnum();
  *(AdaptiveCards::EnumHelpers::EnumMapping< AdaptiveCards::HeightType > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_HeightTypeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  AdaptiveCards::HeightType arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::HeightType)jarg1; 
  result = (std::string *) &AdaptiveCards::HeightTypeToString(arg1);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_HeightTypeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::HeightType result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::HeightType)AdaptiveCards::HeightTypeFromString((std::string const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveBase64Util_1Decode(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::vector< char > result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = AdaptiveCards::AdaptiveBase64Util::Decode((std::string const &)*arg1);
  *(std::vector< char > **)&jresult = new std::vector< char >((const std::vector< char > &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveBase64Util_1Encode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  std::vector< char > *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< char > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< char > const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::AdaptiveBase64Util::Encode((std::vector< char > const &)*arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveBase64Util_1ExtractDataFromUri(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = AdaptiveCards::AdaptiveBase64Util::ExtractDataFromUri((std::string const &)*arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveBase64Util(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::AdaptiveBase64Util *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::AdaptiveBase64Util *)new AdaptiveCards::AdaptiveBase64Util();
  *(AdaptiveCards::AdaptiveBase64Util **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1AdaptiveBase64Util(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::AdaptiveBase64Util *arg1 = (AdaptiveCards::AdaptiveBase64Util *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::AdaptiveBase64Util **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformation_1url_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::RemoteResourceInformation *arg1 = (AdaptiveCards::RemoteResourceInformation *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::RemoteResourceInformation > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jarg1;
  arg1 = (AdaptiveCards::RemoteResourceInformation *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->url = *arg2;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformation_1url_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::RemoteResourceInformation *arg1 = (AdaptiveCards::RemoteResourceInformation *) 0 ;
  std::shared_ptr< AdaptiveCards::RemoteResourceInformation > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jarg1;
  arg1 = (AdaptiveCards::RemoteResourceInformation *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) & ((arg1)->url);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformation_1mimeType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::RemoteResourceInformation *arg1 = (AdaptiveCards::RemoteResourceInformation *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::RemoteResourceInformation > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jarg1;
  arg1 = (AdaptiveCards::RemoteResourceInformation *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->mimeType = *arg2;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_RemoteResourceInformation_1mimeType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::RemoteResourceInformation *arg1 = (AdaptiveCards::RemoteResourceInformation *) 0 ;
  std::shared_ptr< AdaptiveCards::RemoteResourceInformation > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jarg1;
  arg1 = (AdaptiveCards::RemoteResourceInformation *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) & ((arg1)->mimeType);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1RemoteResourceInformation(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::RemoteResourceInformation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::RemoteResourceInformation *)new AdaptiveCards::RemoteResourceInformation();
  
  *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::RemoteResourceInformation >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1RemoteResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::RemoteResourceInformation *arg1 = (AdaptiveCards::RemoteResourceInformation *) 0 ;
  std::shared_ptr< AdaptiveCards::RemoteResourceInformation > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::RemoteResourceInformation > **)&jarg1;
  arg1 = (AdaptiveCards::RemoteResourceInformation *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCardParseWarning(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::WarningStatusCode arg1 ;
  std::string *arg2 = 0 ;
  AdaptiveCards::AdaptiveCardParseWarning *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::WarningStatusCode)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (AdaptiveCards::AdaptiveCardParseWarning *)new AdaptiveCards::AdaptiveCardParseWarning(arg1,(std::string const &)*arg2);
  
  *(std::shared_ptr<  AdaptiveCards::AdaptiveCardParseWarning > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AdaptiveCardParseWarning >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarning_1GetStatusCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::AdaptiveCardParseWarning *arg1 = (AdaptiveCards::AdaptiveCardParseWarning *) 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning const > *smartarg1 = 0 ;
  AdaptiveCards::WarningStatusCode result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::AdaptiveCardParseWarning > **)&jarg1;
  arg1 = (AdaptiveCards::AdaptiveCardParseWarning *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::WarningStatusCode)((AdaptiveCards::AdaptiveCardParseWarning const *)arg1)->GetStatusCode();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCardParseWarning_1GetReason(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::AdaptiveCardParseWarning *arg1 = (AdaptiveCards::AdaptiveCardParseWarning *) 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::AdaptiveCardParseWarning > **)&jarg1;
  arg1 = (AdaptiveCards::AdaptiveCardParseWarning *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::AdaptiveCardParseWarning const *)arg1)->GetReason();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1AdaptiveCardParseWarning(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::AdaptiveCardParseWarning *arg1 = (AdaptiveCards::AdaptiveCardParseWarning *) 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AdaptiveCardParseWarning > **)&jarg1;
  arg1 = (AdaptiveCards::AdaptiveCardParseWarning *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ActionElementParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ActionElementParser *arg1 = (AdaptiveCards::ActionElementParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionElementParser > **)&jarg1;
  arg1 = (AdaptiveCards::ActionElementParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionElementParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionElementParser *arg1 = (AdaptiveCards::ActionElementParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionElementParser > **)&jarg1;
  arg1 = (AdaptiveCards::ActionElementParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionElementParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionElementParser *arg1 = (AdaptiveCards::ActionElementParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionElementParser > **)&jarg1;
  arg1 = (AdaptiveCards::ActionElementParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ActionElementParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionElementParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ActionElementParser *)new SwigDirector_ActionElementParser(jenv);
  
  *(std::shared_ptr<  AdaptiveCards::ActionElementParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ActionElementParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionElementParser_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  std::shared_ptr< AdaptiveCards::ActionElementParser > *obj = *((std::shared_ptr< AdaptiveCards::ActionElementParser > **)&objarg);
  (void)jcls;
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_ActionElementParser *director = static_cast<SwigDirector_ActionElementParser *>(obj->operator->());
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionElementParser_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  std::shared_ptr< AdaptiveCards::ActionElementParser > *obj = *((std::shared_ptr< AdaptiveCards::ActionElementParser > **)&objarg);
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_ActionElementParser *director = dynamic_cast<SwigDirector_ActionElementParser *>(obj->operator->());
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ActionElementParserWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > arg1 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > *argp1 ;
  AdaptiveCards::ActionElementParserWrapper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::shared_ptr< AdaptiveCards::ActionElementParser > **)&jarg1;
  if (argp1) arg1 = *argp1; 
  result = (AdaptiveCards::ActionElementParserWrapper *)new AdaptiveCards::ActionElementParserWrapper(arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ActionElementParserWrapper > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ActionElementParserWrapper >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ActionElementParserWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ActionElementParserWrapper *arg1 = (AdaptiveCards::ActionElementParserWrapper *) 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParserWrapper > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::ActionElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionElementParserWrapper_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionElementParserWrapper *arg1 = (AdaptiveCards::ActionElementParserWrapper *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParserWrapper > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::ActionElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionElementParserWrapper_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionElementParserWrapper *arg1 = (AdaptiveCards::ActionElementParserWrapper *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParserWrapper > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::ActionElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionElementParserWrapper_1GetActualParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionElementParserWrapper *arg1 = (AdaptiveCards::ActionElementParserWrapper *) 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParserWrapper const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ActionElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::ActionElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ActionElementParserWrapper const *)arg1)->GetActualParser();
  *(std::shared_ptr< AdaptiveCards::ActionElementParser > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::ActionElementParser >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ActionParserRegistration(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionParserRegistration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ActionParserRegistration *)new AdaptiveCards::ActionParserRegistration();
  
  *(std::shared_ptr<  AdaptiveCards::ActionParserRegistration > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ActionParserRegistration >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionParserRegistration_1AddParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::ActionParserRegistration *arg1 = (AdaptiveCards::ActionParserRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > arg3 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ActionParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  argp3 = *(std::shared_ptr< AdaptiveCards::ActionElementParser > **)&jarg3;
  if (argp3) arg3 = *argp3; 
  (arg1)->AddParser((std::string const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionParserRegistration_1RemoveParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ActionParserRegistration *arg1 = (AdaptiveCards::ActionParserRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ActionParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->RemoveParser((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ActionParserRegistration_1GetParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionParserRegistration *arg1 = (AdaptiveCards::ActionParserRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionElementParser > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ActionParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ActionParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((AdaptiveCards::ActionParserRegistration const *)arg1)->GetParser((std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::ActionElementParser > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::ActionElementParser >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ActionParserRegistration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ActionParserRegistration *arg1 = (AdaptiveCards::ActionParserRegistration *) 0 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ActionParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ActionParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseCardElementParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::BaseCardElementParser *arg1 = (AdaptiveCards::BaseCardElementParser *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElementParser > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElementParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElementParser *arg1 = (AdaptiveCards::BaseCardElementParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElementParser > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElementParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElementParser *arg1 = (AdaptiveCards::BaseCardElementParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElementParser > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElementParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElementParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElementParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::BaseCardElementParser *)new SwigDirector_BaseCardElementParser(jenv);
  
  *(std::shared_ptr<  AdaptiveCards::BaseCardElementParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseCardElementParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementParser_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > *obj = *((std::shared_ptr< AdaptiveCards::BaseCardElementParser > **)&objarg);
  (void)jcls;
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseCardElementParser *director = static_cast<SwigDirector_BaseCardElementParser *>(obj->operator->());
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementParser_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > *obj = *((std::shared_ptr< AdaptiveCards::BaseCardElementParser > **)&objarg);
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseCardElementParser *director = dynamic_cast<SwigDirector_BaseCardElementParser *>(obj->operator->());
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElementParserWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > arg1 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > *argp1 ;
  AdaptiveCards::BaseCardElementParserWrapper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::shared_ptr< AdaptiveCards::BaseCardElementParser > **)&jarg1;
  if (argp1) arg1 = *argp1; 
  result = (AdaptiveCards::BaseCardElementParserWrapper *)new AdaptiveCards::BaseCardElementParserWrapper(arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BaseCardElementParserWrapper > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseCardElementParserWrapper >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseCardElementParserWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::BaseCardElementParserWrapper *arg1 = (AdaptiveCards::BaseCardElementParserWrapper *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParserWrapper > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementParserWrapper_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElementParserWrapper *arg1 = (AdaptiveCards::BaseCardElementParserWrapper *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParserWrapper > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementParserWrapper_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElementParserWrapper *arg1 = (AdaptiveCards::BaseCardElementParserWrapper *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParserWrapper > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElementParserWrapper_1GetActualParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElementParserWrapper *arg1 = (AdaptiveCards::BaseCardElementParserWrapper *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParserWrapper const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElementParserWrapper > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElementParserWrapper *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseCardElementParserWrapper const *)arg1)->GetActualParser();
  *(std::shared_ptr< AdaptiveCards::BaseCardElementParser > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElementParser >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ElementParserRegistration(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ElementParserRegistration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ElementParserRegistration *)new AdaptiveCards::ElementParserRegistration();
  
  *(std::shared_ptr<  AdaptiveCards::ElementParserRegistration > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ElementParserRegistration >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ElementParserRegistration_1AddParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::ElementParserRegistration *arg1 = (AdaptiveCards::ElementParserRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > arg3 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ElementParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ElementParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  argp3 = *(std::shared_ptr< AdaptiveCards::BaseCardElementParser > **)&jarg3;
  if (argp3) arg3 = *argp3; 
  (arg1)->AddParser((std::string const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ElementParserRegistration_1RemoveParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ElementParserRegistration *arg1 = (AdaptiveCards::ElementParserRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ElementParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ElementParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->RemoveParser((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ElementParserRegistration_1GetParser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ElementParserRegistration *arg1 = (AdaptiveCards::ElementParserRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElementParser > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ElementParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ElementParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((AdaptiveCards::ElementParserRegistration const *)arg1)->GetParser((std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::BaseCardElementParser > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElementParser >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ElementParserRegistration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ElementParserRegistration *arg1 = (AdaptiveCards::ElementParserRegistration *) 0 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ElementParserRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::ElementParserRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ParseContext_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ParseContext *)new AdaptiveCards::ParseContext();
  
  *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ParseContext >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ParseContext_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > arg1 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > arg2 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > *argp1 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > *argp2 ;
  AdaptiveCards::ParseContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(std::shared_ptr< AdaptiveCards::ElementParserRegistration > **)&jarg1;
  if (argp1) arg1 = *argp1; 
  argp2 = *(std::shared_ptr< AdaptiveCards::ActionParserRegistration > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  result = (AdaptiveCards::ParseContext *)new AdaptiveCards::ParseContext(arg1,arg2);
  
  *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ParseContext >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1elementParserRegistration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::ElementParserRegistration > **)&jarg2 : &tempnull2; 
  if (arg1) (arg1)->elementParserRegistration = *arg2;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1elementParserRegistration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ElementParserRegistration > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::shared_ptr< AdaptiveCards::ElementParserRegistration > *) & ((arg1)->elementParserRegistration);
  *(std::shared_ptr< AdaptiveCards::ElementParserRegistration > **)&jresult = *result ? new std::shared_ptr< AdaptiveCards::ElementParserRegistration >(*result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1actionParserRegistration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? *(std::shared_ptr< AdaptiveCards::ActionParserRegistration > **)&jarg2 : &tempnull2; 
  if (arg1) (arg1)->actionParserRegistration = *arg2;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1actionParserRegistration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ActionParserRegistration > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::shared_ptr< AdaptiveCards::ActionParserRegistration > *) & ((arg1)->actionParserRegistration);
  *(std::shared_ptr< AdaptiveCards::ActionParserRegistration > **)&jresult = *result ? new std::shared_ptr< AdaptiveCards::ActionParserRegistration >(*result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1warnings_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg2 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg2; 
  if (arg1) (arg1)->warnings = *arg2;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1warnings_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *)& ((arg1)->warnings);
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1PushElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::string *arg2 = 0 ;
  AdaptiveCards::InternalId *arg3 = 0 ;
  bool arg4 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(AdaptiveCards::InternalId **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::InternalId const & reference is null");
    return ;
  } 
  arg4 = jarg4 ? true : false; 
  (arg1)->PushElement((std::string const &)*arg2,(AdaptiveCards::InternalId const &)*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1PushElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::string *arg2 = 0 ;
  AdaptiveCards::InternalId *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(AdaptiveCards::InternalId **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::InternalId const & reference is null");
    return ;
  } 
  (arg1)->PushElement((std::string const &)*arg2,(AdaptiveCards::InternalId const &)*arg3);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1PopElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  (arg1)->PopElement();
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1GetCanFallbackToAncestor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::ParseContext const *)arg1)->GetCanFallbackToAncestor();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1SetCanFallbackToAncestor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetCanFallbackToAncestor(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1SetLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetLanguage((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1GetLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::ParseContext const *)arg1)->GetLanguage();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1GetParentalContainerStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext const > *smartarg1 = 0 ;
  AdaptiveCards::ContainerStyle result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ContainerStyle)((AdaptiveCards::ParseContext const *)arg1)->GetParentalContainerStyle();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1SetParentalContainerStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  AdaptiveCards::ContainerStyle arg2 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::ContainerStyle)jarg2; 
  (arg1)->SetParentalContainerStyle(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1PaddingParentInternalId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext const > *smartarg1 = 0 ;
  AdaptiveCards::InternalId result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ParseContext const *)arg1)->PaddingParentInternalId();
  *(AdaptiveCards::InternalId **)&jresult = new AdaptiveCards::InternalId((const AdaptiveCards::InternalId &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1SaveContextForStyledCollectionElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  AdaptiveCards::StyledCollectionElement *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::StyledCollectionElement *)((*(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg2) ? (*(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::StyledCollectionElement const & reference is null");
    return ;
  } 
  (arg1)->SaveContextForStyledCollectionElement((AdaptiveCards::StyledCollectionElement const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1RestoreContextForStyledCollectionElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  AdaptiveCards::StyledCollectionElement *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::StyledCollectionElement *)((*(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg2) ? (*(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::StyledCollectionElement const & reference is null");
    return ;
  } 
  (arg1)->RestoreContextForStyledCollectionElement((AdaptiveCards::StyledCollectionElement const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1GetBleedDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext const > *smartarg1 = 0 ;
  AdaptiveCards::ContainerBleedDirection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ContainerBleedDirection)((AdaptiveCards::ParseContext const *)arg1)->GetBleedDirection();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1PushBleedDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  AdaptiveCards::ContainerBleedDirection arg2 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::ContainerBleedDirection)jarg2; 
  (arg1)->PushBleedDirection(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseContext_1PopBleedDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  (arg1)->PopBleedDirection();
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ParseContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ParseContext *arg1 = (AdaptiveCards::ParseContext *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseContext > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1;
  arg1 = (AdaptiveCards::ParseContext *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1InternalId(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::InternalId *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::InternalId *)new AdaptiveCards::InternalId();
  *(AdaptiveCards::InternalId **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InternalId_1Next(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::InternalId result;
  
  (void)jenv;
  (void)jcls;
  result = AdaptiveCards::InternalId::Next();
  *(AdaptiveCards::InternalId **)&jresult = new AdaptiveCards::InternalId((const AdaptiveCards::InternalId &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InternalId_1Current(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::InternalId result;
  
  (void)jenv;
  (void)jcls;
  result = AdaptiveCards::InternalId::Current();
  *(AdaptiveCards::InternalId **)&jresult = new AdaptiveCards::InternalId((const AdaptiveCards::InternalId &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_InternalId_1Hash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::InternalId *arg1 = (AdaptiveCards::InternalId *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AdaptiveCards::InternalId **)&jarg1; 
  result = (unsigned int)((AdaptiveCards::InternalId const *)arg1)->Hash();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1InternalId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::InternalId *arg1 = (AdaptiveCards::InternalId *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::InternalId **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1InternalIdKeyHash(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::InternalIdKeyHash *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::InternalIdKeyHash *)new AdaptiveCards::InternalIdKeyHash();
  *(AdaptiveCards::InternalIdKeyHash **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1InternalIdKeyHash(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::InternalIdKeyHash *arg1 = (AdaptiveCards::InternalIdKeyHash *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::InternalIdKeyHash **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::BaseElement *)new SwigDirector_BaseElement(jenv);
  
  *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = 0 ;
  AdaptiveCards::BaseElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::BaseElement *)((*(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::BaseElement const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::BaseElement *)new SwigDirector_BaseElement(jenv,(AdaptiveCards::BaseElement const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetElementTypeString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::BaseElement const *)arg1)->GetElementTypeString();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetElementTypeString_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->SetElementTypeString((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetElementTypeString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetElementTypeString((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::BaseElement const *)arg1)->GetId();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetId_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->SetId((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetIdSwigExplicitBaseElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->AdaptiveCards::BaseElement::SetId((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetId_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetId((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetIdSwigExplicitBaseElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->AdaptiveCards::BaseElement::SetId((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetInternalId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  AdaptiveCards::InternalId result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseElement const *)arg1)->GetInternalId();
  *(AdaptiveCards::InternalId **)&jresult = new AdaptiveCards::InternalId((const AdaptiveCards::InternalId &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseElement const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SerializeSwigExplicitBaseElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseElement const *)arg1)->AdaptiveCards::BaseElement::Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseElement const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SerializeToJsonValueSwigExplicitBaseElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseElement const *)arg1)->AdaptiveCards::BaseElement::SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetAdditionalProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  Json::Value *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (Json::Value *) &((AdaptiveCards::BaseElement const *)arg1)->GetAdditionalProperties();
  *(Json::Value **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetAdditionalProperties_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value && reference is null");
    return ;
  } 
  (arg1)->SetAdditionalProperties((Json::Value &&)*arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetFallbackType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  AdaptiveCards::FallbackType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::FallbackType)((AdaptiveCards::BaseElement const *)arg1)->GetFallbackType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetFallbackContent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::shared_ptr< AdaptiveCards::BaseElement > *) &((AdaptiveCards::BaseElement const *)arg1)->GetFallbackContent();
  *(std::shared_ptr< AdaptiveCards::BaseElement > **)&jresult = *result ? new std::shared_ptr< AdaptiveCards::BaseElement >(*result) : 0; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1CanFallbackToAncestor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::BaseElement const *)arg1)->CanFallbackToAncestor();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetFallbackType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  AdaptiveCards::FallbackType arg2 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::FallbackType)jarg2; 
  (arg1)->SetFallbackType(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1SetFallbackContent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > arg2 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::BaseElement > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetFallbackContent(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1MeetsRequirements(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  AdaptiveCards::FeatureRegistration *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::FeatureRegistration *)((*(std::shared_ptr< const AdaptiveCards::FeatureRegistration > **)&jarg2) ? (*(std::shared_ptr< const AdaptiveCards::FeatureRegistration > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::FeatureRegistration const & reference is null");
    return 0;
  } 
  result = (bool)((AdaptiveCards::BaseElement const *)arg1)->MeetsRequirements((AdaptiveCards::FeatureRegistration const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetRequirements_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  std::unordered_map< std::string,AdaptiveCards::SemanticVersion > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::unordered_map< std::string,AdaptiveCards::SemanticVersion > *) &(arg1)->GetRequirements();
  *(std::unordered_map< std::string,AdaptiveCards::SemanticVersion > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1GetResourceInformationSwigExplicitBaseElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->AdaptiveCards::BaseElement::GetResourceInformation(*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  std::shared_ptr< AdaptiveCards::BaseElement > *obj = *((std::shared_ptr< AdaptiveCards::BaseElement > **)&objarg);
  (void)jcls;
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseElement *director = static_cast<SwigDirector_BaseElement *>(obj->operator->());
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseElement_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  std::shared_ptr< AdaptiveCards::BaseElement > *obj = *((std::shared_ptr< AdaptiveCards::BaseElement > **)&objarg);
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseElement *director = dynamic_cast<SwigDirector_BaseElement *>(obj->operator->());
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_HandleUnknownProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  Json::Value *arg1 = 0 ;
  std::unordered_set< std::string > *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Json::Value **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  arg2 = *(std::unordered_set< std::string > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::unordered_set< std::string > const & reference is null");
    return ;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value & reference is null");
    return ;
  } 
  HandleUnknownProperties((Json::Value const &)*arg1,(std::unordered_set< std::string > const &)*arg2,*arg3);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jboolean jarg3, jint jarg4) {
  jlong jresult = 0 ;
  AdaptiveCards::CardElementType arg1 ;
  AdaptiveCards::Spacing arg2 ;
  bool arg3 ;
  AdaptiveCards::HeightType arg4 ;
  AdaptiveCards::BaseCardElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::CardElementType)jarg1; 
  arg2 = (AdaptiveCards::Spacing)jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = (AdaptiveCards::HeightType)jarg4; 
  result = (AdaptiveCards::BaseCardElement *)new SwigDirector_BaseCardElement(jenv,arg1,arg2,arg3,arg4);
  
  *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseCardElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::CardElementType arg1 ;
  AdaptiveCards::BaseCardElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::CardElementType)jarg1; 
  result = (AdaptiveCards::BaseCardElement *)new SwigDirector_BaseCardElement(jenv,arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseCardElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElement_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::BaseCardElement *)new SwigDirector_BaseCardElement(jenv);
  
  *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseCardElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseCardElement_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = 0 ;
  AdaptiveCards::BaseCardElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::BaseCardElement *)((*(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::BaseCardElement const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::BaseCardElement *)new SwigDirector_BaseCardElement(jenv,(AdaptiveCards::BaseCardElement const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseCardElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseCardElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseCardElement const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SerializeToJsonValueSwigExplicitBaseCardElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseCardElement const *)arg1)->AdaptiveCards::BaseCardElement::SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1GetSeparator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::BaseCardElement const *)arg1)->GetSeparator();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1GetSeparatorSwigExplicitBaseCardElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::BaseCardElement const *)arg1)->AdaptiveCards::BaseCardElement::GetSeparator();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SetSeparator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetSeparator(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SetSeparatorSwigExplicitBaseCardElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->AdaptiveCards::BaseCardElement::SetSeparator(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1GetHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  AdaptiveCards::HeightType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::HeightType)((AdaptiveCards::BaseCardElement const *)arg1)->GetHeight();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SetHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  AdaptiveCards::HeightType arg2 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::HeightType)jarg2; 
  (arg1)->SetHeight(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1GetSpacing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  AdaptiveCards::Spacing result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::Spacing)((AdaptiveCards::BaseCardElement const *)arg1)->GetSpacing();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1GetSpacingSwigExplicitBaseCardElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  AdaptiveCards::Spacing result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::Spacing)((AdaptiveCards::BaseCardElement const *)arg1)->AdaptiveCards::BaseCardElement::GetSpacing();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SetSpacing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  AdaptiveCards::Spacing arg2 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::Spacing)jarg2; 
  (arg1)->SetSpacing(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SetSpacingSwigExplicitBaseCardElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  AdaptiveCards::Spacing arg2 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::Spacing)jarg2; 
  (arg1)->AdaptiveCards::BaseCardElement::SetSpacing(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1GetIsVisible(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::BaseCardElement const *)arg1)->GetIsVisible();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1SetIsVisible(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetIsVisible(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1GetElementType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement const > *smartarg1 = 0 ;
  AdaptiveCards::CardElementType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::CardElementType)((AdaptiveCards::BaseCardElement const *)arg1)->GetElementType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1DeserializeBasePropertiesFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::BaseCardElement::DeserializeBasePropertiesFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1DeserializeBaseProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::BaseCardElement::DeserializeBaseProperties(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1ParseJsonObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return ;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  arg3 = jarg3 ? *(std::shared_ptr< AdaptiveCards::BaseElement > **)&jarg3 : &tempnull3; 
  AdaptiveCards::BaseCardElement::ParseJsonObject(*arg1,(Json::Value const &)*arg2,*arg3);
}


SWIGEXPORT jobject JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1swigOriginalObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  jobject result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = AdaptiveCards_BaseCardElement_swigOriginalObject(arg1,arg2);
  jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  AdaptiveCards::BaseCardElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::BaseCardElement *)AdaptiveCards_BaseCardElement_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseCardElement >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  std::shared_ptr< AdaptiveCards::BaseCardElement > *obj = *((std::shared_ptr< AdaptiveCards::BaseCardElement > **)&objarg);
  (void)jcls;
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseCardElement *director = static_cast<SwigDirector_BaseCardElement *>(obj->operator->());
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseCardElement_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  std::shared_ptr< AdaptiveCards::BaseCardElement > *obj = *((std::shared_ptr< AdaptiveCards::BaseCardElement > **)&objarg);
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseCardElement *director = dynamic_cast<SwigDirector_BaseCardElement *>(obj->operator->());
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseActionElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::ActionType arg1 ;
  AdaptiveCards::BaseActionElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::ActionType)jarg1; 
  result = (AdaptiveCards::BaseActionElement *)new SwigDirector_BaseActionElement(jenv,arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseActionElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseActionElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::BaseActionElement *)new SwigDirector_BaseActionElement(jenv);
  
  *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseActionElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseActionElement_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = 0 ;
  AdaptiveCards::BaseActionElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::BaseActionElement *)((*(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::BaseActionElement const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::BaseActionElement *)new SwigDirector_BaseActionElement(jenv,(AdaptiveCards::BaseActionElement const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseActionElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseActionElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetTitle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::BaseActionElement const *)arg1)->GetTitle();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTitle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->SetTitle((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTitleSwigExplicitBaseActionElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->AdaptiveCards::BaseActionElement::SetTitle((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTitle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetTitle((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTitleSwigExplicitBaseActionElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->AdaptiveCards::BaseActionElement::SetTitle((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetIconUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::BaseActionElement const *)arg1)->GetIconUrl();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetIconUrl_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->SetIconUrl((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetIconUrl_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetIconUrl((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::BaseActionElement const *)arg1)->GetStyle();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetStyle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->SetStyle((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetStyle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetStyle((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetTooltip(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::string *) &((AdaptiveCards::BaseActionElement const *)arg1)->GetTooltip();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTooltip_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->SetTooltip((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTooltipSwigExplicitBaseActionElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string && reference is null");
    return ;
  } 
  (arg1)->AdaptiveCards::BaseActionElement::SetTooltip((std::string &&)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTooltip_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetTooltip((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetTooltipSwigExplicitBaseActionElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->AdaptiveCards::BaseActionElement::SetTooltip((std::string const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetElementType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  AdaptiveCards::ActionType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ActionType)((AdaptiveCards::BaseActionElement const *)arg1)->GetElementType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  AdaptiveCards::Mode result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::Mode)((AdaptiveCards::BaseActionElement const *)arg1)->GetMode();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  AdaptiveCards::Mode arg2 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::Mode)jarg2; 
  (arg1)->SetMode(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetIsEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::BaseActionElement const *)arg1)->GetIsEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SetIsEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetIsEnabled(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1GetResourceInformationSwigExplicitBaseActionElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->AdaptiveCards::BaseActionElement::GetResourceInformation(*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseActionElement const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1SerializeToJsonValueSwigExplicitBaseActionElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseActionElement const *)arg1)->AdaptiveCards::BaseActionElement::SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1DeserializeBasePropertiesFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::BaseActionElement::DeserializeBasePropertiesFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1DeserializeBaseProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::BaseActionElement::DeserializeBaseProperties(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1ParseJsonObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return ;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  arg3 = jarg3 ? *(std::shared_ptr< AdaptiveCards::BaseElement > **)&jarg3 : &tempnull3; 
  AdaptiveCards::BaseActionElement::ParseJsonObject(*arg1,(Json::Value const &)*arg2,*arg3);
}


SWIGEXPORT jobject JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1swigOriginalObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  jobject result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = AdaptiveCards_BaseActionElement_swigOriginalObject(arg1,arg2);
  jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseElement *arg1 = (AdaptiveCards::BaseElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseElement > *smartarg1 = 0 ;
  AdaptiveCards::BaseActionElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::BaseActionElement *)AdaptiveCards_BaseActionElement_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseActionElement >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  std::shared_ptr< AdaptiveCards::BaseActionElement > *obj = *((std::shared_ptr< AdaptiveCards::BaseActionElement > **)&objarg);
  (void)jcls;
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseActionElement *director = static_cast<SwigDirector_BaseActionElement *>(obj->operator->());
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseActionElement_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  std::shared_ptr< AdaptiveCards::BaseActionElement > *obj = *((std::shared_ptr< AdaptiveCards::BaseActionElement > **)&objarg);
  // Keep a local instance of the smart pointer around while we are using the raw pointer
  // Avoids using smart pointer specific API.
  SwigDirector_BaseActionElement *director = dynamic_cast<SwigDirector_BaseActionElement *>(obj->operator->());
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseInputElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseInputElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::BaseInputElement *)new AdaptiveCards::BaseInputElement();
  
  *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseInputElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseInputElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::CardElementType arg1 ;
  AdaptiveCards::BaseInputElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::CardElementType)jarg1; 
  result = (AdaptiveCards::BaseInputElement *)new AdaptiveCards::BaseInputElement(arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseInputElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BaseInputElement_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jboolean jarg3, jint jarg4) {
  jlong jresult = 0 ;
  AdaptiveCards::CardElementType arg1 ;
  AdaptiveCards::Spacing arg2 ;
  bool arg3 ;
  AdaptiveCards::HeightType arg4 ;
  AdaptiveCards::BaseInputElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::CardElementType)jarg1; 
  arg2 = (AdaptiveCards::Spacing)jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = (AdaptiveCards::HeightType)jarg4; 
  result = (AdaptiveCards::BaseInputElement *)new AdaptiveCards::BaseInputElement(arg1,arg2,arg3,arg4);
  
  *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseInputElement >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1GetLabel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseInputElement const *)arg1)->GetLabel();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1SetLabel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetLabel(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1GetIsRequired(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::BaseInputElement const *)arg1)->GetIsRequired();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1SetIsRequired(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetIsRequired(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1GetErrorMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseInputElement const *)arg1)->GetErrorMessage();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1SetErrorMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetErrorMessage(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1DeserializeBasePropertiesFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::BaseInputElement::DeserializeBasePropertiesFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::BaseInputElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseInputElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1DeserializeBaseProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::BaseInputElement::DeserializeBaseProperties(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::BaseInputElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseInputElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BaseInputElement const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BaseInputElement_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::BaseInputElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::BaseInputElement *)AdaptiveCards_BaseInputElement_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BaseInputElement >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BaseInputElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::BaseInputElement *arg1 = (AdaptiveCards::BaseInputElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseInputElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseInputElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseInputElement *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BackgroundImage_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::BackgroundImage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::BackgroundImage *)new AdaptiveCards::BackgroundImage();
  
  *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BackgroundImage >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BackgroundImage_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::BackgroundImage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::BackgroundImage *)new AdaptiveCards::BackgroundImage((std::string const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BackgroundImage >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1BackgroundImage_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::ImageFillMode arg2 ;
  AdaptiveCards::HorizontalAlignment arg3 ;
  AdaptiveCards::VerticalAlignment arg4 ;
  AdaptiveCards::BackgroundImage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (AdaptiveCards::ImageFillMode)jarg2; 
  arg3 = (AdaptiveCards::HorizontalAlignment)jarg3; 
  arg4 = (AdaptiveCards::VerticalAlignment)jarg4; 
  result = (AdaptiveCards::BackgroundImage *)new AdaptiveCards::BackgroundImage((std::string const &)*arg1,arg2,arg3,arg4);
  
  *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::BackgroundImage >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1GetUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BackgroundImage const *)arg1)->GetUrl();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1SetUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetUrl((std::string const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1GetFillMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage const > *smartarg1 = 0 ;
  AdaptiveCards::ImageFillMode result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ImageFillMode)((AdaptiveCards::BackgroundImage const *)arg1)->GetFillMode();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1SetFillMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  AdaptiveCards::ImageFillMode *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *smartarg1 = 0 ;
  AdaptiveCards::ImageFillMode temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  temp2 = (AdaptiveCards::ImageFillMode)jarg2; 
  arg2 = &temp2; 
  (arg1)->SetFillMode((AdaptiveCards::ImageFillMode const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1GetHorizontalAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage const > *smartarg1 = 0 ;
  AdaptiveCards::HorizontalAlignment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::HorizontalAlignment)((AdaptiveCards::BackgroundImage const *)arg1)->GetHorizontalAlignment();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1SetHorizontalAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  AdaptiveCards::HorizontalAlignment *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *smartarg1 = 0 ;
  AdaptiveCards::HorizontalAlignment temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  temp2 = (AdaptiveCards::HorizontalAlignment)jarg2; 
  arg2 = &temp2; 
  (arg1)->SetHorizontalAlignment((AdaptiveCards::HorizontalAlignment const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1GetVerticalAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage const > *smartarg1 = 0 ;
  AdaptiveCards::VerticalAlignment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::VerticalAlignment)((AdaptiveCards::BackgroundImage const *)arg1)->GetVerticalAlignment();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1SetVerticalAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  AdaptiveCards::VerticalAlignment *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *smartarg1 = 0 ;
  AdaptiveCards::VerticalAlignment temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  temp2 = (AdaptiveCards::VerticalAlignment)jarg2; 
  arg2 = &temp2; 
  (arg1)->SetVerticalAlignment((AdaptiveCards::VerticalAlignment const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1ShouldSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::BackgroundImage const *)arg1)->ShouldSerialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BackgroundImage const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::BackgroundImage const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Json::Value *arg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Json::Value **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::BackgroundImage::Deserialize((Json::Value const &)*arg1);
  *(std::shared_ptr< AdaptiveCards::BackgroundImage > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BackgroundImage >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_BackgroundImage_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = AdaptiveCards::BackgroundImage::DeserializeFromString((std::string const &)*arg1);
  *(std::shared_ptr< AdaptiveCards::BackgroundImage > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BackgroundImage >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1BackgroundImage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::BackgroundImage *arg1 = (AdaptiveCards::BackgroundImage *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BackgroundImage > **)&jarg1;
  arg1 = (AdaptiveCards::BackgroundImage *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CollectionCoreElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::CollectionCoreElement *arg1 = (AdaptiveCards::CollectionCoreElement *) 0 ;
  std::shared_ptr< AdaptiveCards::CollectionCoreElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::CollectionCoreElement > **)&jarg1;
  arg1 = (AdaptiveCards::CollectionCoreElement *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_CollectionCoreElement_1DeserializeChildren(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::CollectionCoreElement *arg1 = (AdaptiveCards::CollectionCoreElement *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::CollectionCoreElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::CollectionCoreElement > **)&jarg1;
  arg1 = (AdaptiveCards::CollectionCoreElement *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return ;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  (arg1)->DeserializeChildren(*arg2,(Json::Value const &)*arg3);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1StyledCollectionElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  AdaptiveCards::ContainerStyle result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ContainerStyle)((AdaptiveCards::StyledCollectionElement const *)arg1)->GetStyle();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  AdaptiveCards::ContainerStyle arg2 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::ContainerStyle)jarg2; 
  (arg1)->SetStyle(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetVerticalContentAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  std::optional< AdaptiveCards::VerticalContentAlignment > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::StyledCollectionElement const *)arg1)->GetVerticalContentAlignment();
  *(std::optional< AdaptiveCards::VerticalContentAlignment > **)&jresult = new std::optional< AdaptiveCards::VerticalContentAlignment >((const std::optional< AdaptiveCards::VerticalContentAlignment > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetVerticalContentAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::optional< AdaptiveCards::VerticalContentAlignment > arg2 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  std::optional< AdaptiveCards::VerticalContentAlignment > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::optional< AdaptiveCards::VerticalContentAlignment > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::optional< AdaptiveCards::VerticalContentAlignment > const");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetVerticalContentAlignment(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetPadding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::StyledCollectionElement const *)arg1)->GetPadding();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetPadding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetPadding(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetBleed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::StyledCollectionElement const *)arg1)->GetBleed();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetBleed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetBleed(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetCanBleed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::StyledCollectionElement const *)arg1)->GetCanBleed();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetBleedDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  AdaptiveCards::ContainerBleedDirection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ContainerBleedDirection)((AdaptiveCards::StyledCollectionElement const *)arg1)->GetBleedDirection();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1ConfigForContainerStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr< const AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr< const AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext const & reference is null");
    return ;
  } 
  (arg1)->ConfigForContainerStyle((AdaptiveCards::ParseContext const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetParentalId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  AdaptiveCards::InternalId *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(AdaptiveCards::InternalId **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::InternalId const & reference is null");
    return ;
  } 
  (arg1)->SetParentalId((AdaptiveCards::InternalId const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetParentalId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  AdaptiveCards::InternalId result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::StyledCollectionElement const *)arg1)->GetParentalId();
  *(AdaptiveCards::InternalId **)&jresult = new AdaptiveCards::InternalId((const AdaptiveCards::InternalId &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetSelectAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::StyledCollectionElement const *)arg1)->GetSelectAction();
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetSelectAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > arg2 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetSelectAction(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetBackgroundImage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::StyledCollectionElement const *)arg1)->GetBackgroundImage();
  *(std::shared_ptr< AdaptiveCards::BackgroundImage > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BackgroundImage >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetBackgroundImage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > arg2 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::BackgroundImage > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetBackgroundImage(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1GetMinHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = (unsigned int)((AdaptiveCards::StyledCollectionElement const *)arg1)->GetMinHeight();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SetMinHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  unsigned int arg2 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (unsigned int)jarg2; 
  (arg1)->SetMinHeight(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_StyledCollectionElement_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::StyledCollectionElement *arg1 = (AdaptiveCards::StyledCollectionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::StyledCollectionElement const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::StyledCollectionElement > **)&jarg1;
  arg1 = (AdaptiveCards::StyledCollectionElement *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::StyledCollectionElement const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_c_1adaptiveCardsFeature_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)AdaptiveCards::c_adaptiveCardsFeature;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToLowercase(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = AdaptiveCards::ParseUtil::ToLowercase((std::string const &)*arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CaseInsensitiveKeyHash(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::CaseInsensitiveKeyHash *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::CaseInsensitiveKeyHash *)new AdaptiveCards::CaseInsensitiveKeyHash();
  *(AdaptiveCards::CaseInsensitiveKeyHash **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CaseInsensitiveKeyHash(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::CaseInsensitiveKeyHash *arg1 = (AdaptiveCards::CaseInsensitiveKeyHash *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::CaseInsensitiveKeyHash **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1CaseInsensitiveKeyEquals(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::CaseInsensitiveKeyEquals *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::CaseInsensitiveKeyEquals *)new AdaptiveCards::CaseInsensitiveKeyEquals();
  *(AdaptiveCards::CaseInsensitiveKeyEquals **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1CaseInsensitiveKeyEquals(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::CaseInsensitiveKeyEquals *arg1 = (AdaptiveCards::CaseInsensitiveKeyEquals *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::CaseInsensitiveKeyEquals **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1FeatureRegistration(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::FeatureRegistration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::FeatureRegistration *)new AdaptiveCards::FeatureRegistration();
  
  *(std::shared_ptr<  AdaptiveCards::FeatureRegistration > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::FeatureRegistration >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FeatureRegistration_1AddFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  AdaptiveCards::FeatureRegistration *arg1 = (AdaptiveCards::FeatureRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::FeatureRegistration > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::FeatureRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::FeatureRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  (arg1)->AddFeature((std::string const &)*arg2,(std::string const &)*arg3);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FeatureRegistration_1RemoveFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::FeatureRegistration *arg1 = (AdaptiveCards::FeatureRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::FeatureRegistration > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::FeatureRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::FeatureRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->RemoveFeature((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FeatureRegistration_1GetAdaptiveCardsVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::FeatureRegistration *arg1 = (AdaptiveCards::FeatureRegistration *) 0 ;
  std::shared_ptr< AdaptiveCards::FeatureRegistration const > *smartarg1 = 0 ;
  SwigValueWrapper< AdaptiveCards::SemanticVersion > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::FeatureRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::FeatureRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::FeatureRegistration const *)arg1)->GetAdaptiveCardsVersion();
  *(AdaptiveCards::SemanticVersion **)&jresult = new AdaptiveCards::SemanticVersion((const AdaptiveCards::SemanticVersion &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_FeatureRegistration_1GetFeatureVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  AdaptiveCards::FeatureRegistration *arg1 = (AdaptiveCards::FeatureRegistration *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::FeatureRegistration const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::FeatureRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::FeatureRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((AdaptiveCards::FeatureRegistration const *)arg1)->GetFeatureVersion((std::string const &)*arg2);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1FeatureRegistration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::FeatureRegistration *arg1 = (AdaptiveCards::FeatureRegistration *) 0 ;
  std::shared_ptr< AdaptiveCards::FeatureRegistration > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::FeatureRegistration > **)&jarg1;
  arg1 = (AdaptiveCards::FeatureRegistration *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1SemanticVersion(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  AdaptiveCards::SemanticVersion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (AdaptiveCards::SemanticVersion *)new AdaptiveCards::SemanticVersion((std::string const &)*arg1);
  *(AdaptiveCards::SemanticVersion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SemanticVersion_1GetMajor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SemanticVersion *arg1 = (AdaptiveCards::SemanticVersion *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AdaptiveCards::SemanticVersion **)&jarg1; 
  result = (unsigned int)((AdaptiveCards::SemanticVersion const *)arg1)->GetMajor();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SemanticVersion_1GetMinor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SemanticVersion *arg1 = (AdaptiveCards::SemanticVersion *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AdaptiveCards::SemanticVersion **)&jarg1; 
  result = (unsigned int)((AdaptiveCards::SemanticVersion const *)arg1)->GetMinor();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SemanticVersion_1GetBuild(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SemanticVersion *arg1 = (AdaptiveCards::SemanticVersion *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AdaptiveCards::SemanticVersion **)&jarg1; 
  result = (unsigned int)((AdaptiveCards::SemanticVersion const *)arg1)->GetBuild();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SemanticVersion_1GetRevision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SemanticVersion *arg1 = (AdaptiveCards::SemanticVersion *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AdaptiveCards::SemanticVersion **)&jarg1; 
  result = (unsigned int)((AdaptiveCards::SemanticVersion const *)arg1)->GetRevision();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1SemanticVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::SemanticVersion *arg1 = (AdaptiveCards::SemanticVersion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AdaptiveCards::SemanticVersion **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Container_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::Container *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::Container *)new AdaptiveCards::Container();
  
  *(std::shared_ptr<  AdaptiveCards::Container > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Container >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Container_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  AdaptiveCards::CardElementType arg1 ;
  AdaptiveCards::Container *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (AdaptiveCards::CardElementType)jarg1; 
  result = (AdaptiveCards::Container *)new AdaptiveCards::Container(arg1);
  
  *(std::shared_ptr<  AdaptiveCards::Container > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Container >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Container_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Container *arg1 = 0 ;
  AdaptiveCards::Container *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::Container *)((*(std::shared_ptr< const AdaptiveCards::Container > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::Container > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::Container const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::Container *)new AdaptiveCards::Container((AdaptiveCards::Container const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::Container > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Container >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1Container(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::Container *arg1 = (AdaptiveCards::Container *) 0 ;
  std::shared_ptr< AdaptiveCards::Container > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Container > **)&jarg1;
  arg1 = (AdaptiveCards::Container *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Container_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Container *arg1 = (AdaptiveCards::Container *) 0 ;
  std::shared_ptr< AdaptiveCards::Container const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Container > **)&jarg1;
  arg1 = (AdaptiveCards::Container *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Container const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Container_1DeserializeChildren(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::Container *arg1 = (AdaptiveCards::Container *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::Container > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Container > **)&jarg1;
  arg1 = (AdaptiveCards::Container *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return ;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  (arg1)->DeserializeChildren(*arg2,(Json::Value const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Container_1GetItems_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Container *arg1 = (AdaptiveCards::Container *) 0 ;
  std::shared_ptr< AdaptiveCards::Container > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Container > **)&jarg1;
  arg1 = (AdaptiveCards::Container *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) &(arg1)->GetItems();
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Container_1GetRtl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Container *arg1 = (AdaptiveCards::Container *) 0 ;
  std::shared_ptr< AdaptiveCards::Container const > *smartarg1 = 0 ;
  std::optional< bool > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Container > **)&jarg1;
  arg1 = (AdaptiveCards::Container *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Container const *)arg1)->GetRtl();
  *(std::optional< bool > **)&jresult = new std::optional< bool >((const std::optional< bool > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Container_1SetRtl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Container *arg1 = (AdaptiveCards::Container *) 0 ;
  std::optional< bool > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Container > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Container > **)&jarg1;
  arg1 = (AdaptiveCards::Container *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::optional< bool > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::optional< bool > const & reference is null");
    return ;
  } 
  (arg1)->SetRtl((std::optional< bool > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Container_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Container *arg1 = (AdaptiveCards::Container *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Container > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Container > **)&jarg1;
  arg1 = (AdaptiveCards::Container *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Container_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::Container *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::Container *)AdaptiveCards_Container_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::Container > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Container >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ContainerParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ContainerParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ContainerParser *)new AdaptiveCards::ContainerParser();
  
  *(std::shared_ptr<  AdaptiveCards::ContainerParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ContainerParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ContainerParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ContainerParser *arg1 = 0 ;
  AdaptiveCards::ContainerParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ContainerParser *)((*(std::shared_ptr< const AdaptiveCards::ContainerParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ContainerParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ContainerParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ContainerParser *)new AdaptiveCards::ContainerParser((AdaptiveCards::ContainerParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ContainerParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ContainerParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ContainerParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ContainerParser *arg1 = (AdaptiveCards::ContainerParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ContainerParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ContainerParser > **)&jarg1;
  arg1 = (AdaptiveCards::ContainerParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ContainerParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ContainerParser *arg1 = (AdaptiveCards::ContainerParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ContainerParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ContainerParser > **)&jarg1;
  arg1 = (AdaptiveCards::ContainerParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ContainerParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ContainerParser *arg1 = (AdaptiveCards::ContainerParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ContainerParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ContainerParser > **)&jarg1;
  arg1 = (AdaptiveCards::ContainerParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Image_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::Image *)new AdaptiveCards::Image();
  
  *(std::shared_ptr<  AdaptiveCards::Image > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Image >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Image_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Image *arg1 = 0 ;
  AdaptiveCards::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::Image *)((*(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::Image const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::Image *)new AdaptiveCards::Image((AdaptiveCards::Image const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::Image > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Image >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1Image(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Image const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Image const *)arg1)->GetUrl();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetUrl((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetBackgroundColor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Image const *)arg1)->GetBackgroundColor();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetBackgroundColor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetBackgroundColor((std::string const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetImageStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  AdaptiveCards::ImageStyle result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ImageStyle)((AdaptiveCards::Image const *)arg1)->GetImageStyle();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetImageStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  AdaptiveCards::ImageStyle arg2 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::ImageStyle)jarg2; 
  (arg1)->SetImageStyle(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetImageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  AdaptiveCards::ImageSize result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ImageSize)((AdaptiveCards::Image const *)arg1)->GetImageSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetImageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  AdaptiveCards::ImageSize arg2 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::ImageSize)jarg2; 
  (arg1)->SetImageSize(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetAltText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Image const *)arg1)->GetAltText();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetAltText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetAltText((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetHorizontalAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  std::optional< AdaptiveCards::HorizontalAlignment > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Image const *)arg1)->GetHorizontalAlignment();
  *(std::optional< AdaptiveCards::HorizontalAlignment > **)&jresult = new std::optional< AdaptiveCards::HorizontalAlignment >((const std::optional< AdaptiveCards::HorizontalAlignment > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetHorizontalAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::optional< AdaptiveCards::HorizontalAlignment > arg2 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  std::optional< AdaptiveCards::HorizontalAlignment > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::optional< AdaptiveCards::HorizontalAlignment > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::optional< AdaptiveCards::HorizontalAlignment > const");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetHorizontalAlignment(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetSelectAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Image const *)arg1)->GetSelectAction();
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetSelectAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > arg2 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetSelectAction(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetPixelWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = (unsigned int)((AdaptiveCards::Image const *)arg1)->GetPixelWidth();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetPixelWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  unsigned int arg2 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (unsigned int)jarg2; 
  (arg1)->SetPixelWidth(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetPixelHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::shared_ptr< AdaptiveCards::Image const > *smartarg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  result = (unsigned int)((AdaptiveCards::Image const *)arg1)->GetPixelHeight();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1SetPixelHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  unsigned int arg2 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (unsigned int)jarg2; 
  (arg1)->SetPixelHeight(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Image *arg1 = (AdaptiveCards::Image *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Image > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Image > **)&jarg1;
  arg1 = (AdaptiveCards::Image *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Image_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::Image *)AdaptiveCards_Image_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::Image > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Image >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ImageParser *)new AdaptiveCards::ImageParser();
  
  *(std::shared_ptr<  AdaptiveCards::ImageParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ImageParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageParser *arg1 = 0 ;
  AdaptiveCards::ImageParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ImageParser *)((*(std::shared_ptr< const AdaptiveCards::ImageParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ImageParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ImageParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ImageParser *)new AdaptiveCards::ImageParser((AdaptiveCards::ImageParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ImageParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ImageParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ImageParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ImageParser *arg1 = (AdaptiveCards::ImageParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ImageParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageParser > **)&jarg1;
  arg1 = (AdaptiveCards::ImageParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageParser *arg1 = (AdaptiveCards::ImageParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ImageParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageParser > **)&jarg1;
  arg1 = (AdaptiveCards::ImageParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageParser_1DeserializeWithoutCheckingType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageParser *arg1 = (AdaptiveCards::ImageParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ImageParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageParser > **)&jarg1;
  arg1 = (AdaptiveCards::ImageParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->DeserializeWithoutCheckingType(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageParser *arg1 = (AdaptiveCards::ImageParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ImageParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageParser > **)&jarg1;
  arg1 = (AdaptiveCards::ImageParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ImageSet *)new AdaptiveCards::ImageSet();
  
  *(std::shared_ptr<  AdaptiveCards::ImageSet > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ImageSet >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSet *arg1 = 0 ;
  AdaptiveCards::ImageSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ImageSet *)((*(std::shared_ptr< const AdaptiveCards::ImageSet > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ImageSet > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ImageSet const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ImageSet *)new AdaptiveCards::ImageSet((AdaptiveCards::ImageSet const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ImageSet > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ImageSet >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ImageSet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ImageSet *arg1 = (AdaptiveCards::ImageSet *) 0 ;
  std::shared_ptr< AdaptiveCards::ImageSet > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageSet > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSet *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSet_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSet *arg1 = (AdaptiveCards::ImageSet *) 0 ;
  std::shared_ptr< AdaptiveCards::ImageSet const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ImageSet > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSet *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ImageSet const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSet_1GetImageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::ImageSet *arg1 = (AdaptiveCards::ImageSet *) 0 ;
  std::shared_ptr< AdaptiveCards::ImageSet const > *smartarg1 = 0 ;
  AdaptiveCards::ImageSize result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ImageSet > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSet *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ImageSize)((AdaptiveCards::ImageSet const *)arg1)->GetImageSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSet_1SetImageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::ImageSet *arg1 = (AdaptiveCards::ImageSet *) 0 ;
  AdaptiveCards::ImageSize arg2 ;
  std::shared_ptr< AdaptiveCards::ImageSet > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageSet > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSet *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::ImageSize)jarg2; 
  (arg1)->SetImageSize(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSet_1GetImages_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSet *arg1 = (AdaptiveCards::ImageSet *) 0 ;
  std::shared_ptr< AdaptiveCards::ImageSet > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Image > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageSet > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSet *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::shared_ptr< AdaptiveCards::Image > > *) &(arg1)->GetImages();
  *(std::vector< std::shared_ptr< AdaptiveCards::Image > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSet_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ImageSet *arg1 = (AdaptiveCards::ImageSet *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ImageSet > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageSet > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSet *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSet_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::ImageSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::ImageSet *)AdaptiveCards_ImageSet_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::ImageSet > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ImageSet >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageSetParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSetParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ImageSetParser *)new AdaptiveCards::ImageSetParser();
  
  *(std::shared_ptr<  AdaptiveCards::ImageSetParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ImageSetParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ImageSetParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSetParser *arg1 = 0 ;
  AdaptiveCards::ImageSetParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ImageSetParser *)((*(std::shared_ptr< const AdaptiveCards::ImageSetParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ImageSetParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ImageSetParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ImageSetParser *)new AdaptiveCards::ImageSetParser((AdaptiveCards::ImageSetParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ImageSetParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ImageSetParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ImageSetParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ImageSetParser *arg1 = (AdaptiveCards::ImageSetParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ImageSetParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageSetParser > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSetParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSetParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSetParser *arg1 = (AdaptiveCards::ImageSetParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ImageSetParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageSetParser > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSetParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ImageSetParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ImageSetParser *arg1 = (AdaptiveCards::ImageSetParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ImageSetParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ImageSetParser > **)&jarg1;
  arg1 = (AdaptiveCards::ImageSetParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Column(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::Column *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::Column *)new AdaptiveCards::Column();
  
  *(std::shared_ptr<  AdaptiveCards::Column > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Column >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::shared_ptr< AdaptiveCards::Column const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Column const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::shared_ptr< AdaptiveCards::Column const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Column const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1DeserializeChildren(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return ;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  (arg1)->DeserializeChildren(*arg2,(Json::Value const &)*arg3);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1GetWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::shared_ptr< AdaptiveCards::Column const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Column const *)arg1)->GetWidth();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1SetWidth_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetWidth((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1SetWidth_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *arg3 = (std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *) 0 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg3; 
  (arg1)->SetWidth((std::string const &)*arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1GetPixelWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::shared_ptr< AdaptiveCards::Column const > *smartarg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  result = (int)((AdaptiveCards::Column const *)arg1)->GetPixelWidth();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1SetPixelWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  int arg2 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (int)jarg2; 
  (arg1)->SetPixelWidth(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1GetItems_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *) &(arg1)->GetItems();
  *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1GetRtl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::shared_ptr< AdaptiveCards::Column const > *smartarg1 = 0 ;
  std::optional< bool > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Column const *)arg1)->GetRtl();
  *(std::optional< bool > **)&jresult = new std::optional< bool >((const std::optional< bool > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1SetRtl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::optional< bool > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::optional< bool > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::optional< bool > const & reference is null");
    return ;
  } 
  (arg1)->SetRtl((std::optional< bool > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Column_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::Column *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::Column *)AdaptiveCards_Column_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::Column > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Column >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1Column(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::Column *arg1 = (AdaptiveCards::Column *) 0 ;
  std::shared_ptr< AdaptiveCards::Column > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Column > **)&jarg1;
  arg1 = (AdaptiveCards::Column *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ColumnParser *)new AdaptiveCards::ColumnParser();
  
  *(std::shared_ptr<  AdaptiveCards::ColumnParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ColumnParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnParser *arg1 = 0 ;
  AdaptiveCards::ColumnParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ColumnParser *)((*(std::shared_ptr< const AdaptiveCards::ColumnParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ColumnParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ColumnParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ColumnParser *)new AdaptiveCards::ColumnParser((AdaptiveCards::ColumnParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ColumnParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ColumnParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ColumnParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ColumnParser *arg1 = (AdaptiveCards::ColumnParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ColumnParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnParser > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnParser *arg1 = (AdaptiveCards::ColumnParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ColumnParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnParser > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnParser *arg1 = (AdaptiveCards::ColumnParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ColumnParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnParser > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ColumnSet *)new AdaptiveCards::ColumnSet();
  
  *(std::shared_ptr<  AdaptiveCards::ColumnSet > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ColumnSet >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSet *arg1 = 0 ;
  AdaptiveCards::ColumnSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ColumnSet *)((*(std::shared_ptr< const AdaptiveCards::ColumnSet > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ColumnSet > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ColumnSet const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ColumnSet *)new AdaptiveCards::ColumnSet((AdaptiveCards::ColumnSet const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ColumnSet > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ColumnSet >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ColumnSet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ColumnSet *arg1 = (AdaptiveCards::ColumnSet *) 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSet > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnSet > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSet *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnSet_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSet *arg1 = (AdaptiveCards::ColumnSet *) 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSet const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ColumnSet > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSet *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ColumnSet const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnSet_1DeserializeChildren(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  AdaptiveCards::ColumnSet *arg1 = (AdaptiveCards::ColumnSet *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSet > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnSet > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSet *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return ;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  (arg1)->DeserializeChildren(*arg2,(Json::Value const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnSet_1GetColumns_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSet *arg1 = (AdaptiveCards::ColumnSet *) 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSet > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::Column > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnSet > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSet *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::shared_ptr< AdaptiveCards::Column > > *) &(arg1)->GetColumns();
  *(std::vector< std::shared_ptr< AdaptiveCards::Column > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnSet_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ColumnSet *arg1 = (AdaptiveCards::ColumnSet *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSet > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnSet > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSet *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnSet_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::ColumnSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::ColumnSet *)AdaptiveCards_ColumnSet_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::ColumnSet > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ColumnSet >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnSetParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSetParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ColumnSetParser *)new AdaptiveCards::ColumnSetParser();
  
  *(std::shared_ptr<  AdaptiveCards::ColumnSetParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ColumnSetParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ColumnSetParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSetParser *arg1 = 0 ;
  AdaptiveCards::ColumnSetParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ColumnSetParser *)((*(std::shared_ptr< const AdaptiveCards::ColumnSetParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ColumnSetParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ColumnSetParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ColumnSetParser *)new AdaptiveCards::ColumnSetParser((AdaptiveCards::ColumnSetParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ColumnSetParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ColumnSetParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ColumnSetParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ColumnSetParser *arg1 = (AdaptiveCards::ColumnSetParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSetParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnSetParser > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSetParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnSetParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSetParser *arg1 = (AdaptiveCards::ColumnSetParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSetParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnSetParser > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSetParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ColumnSetParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ColumnSetParser *arg1 = (AdaptiveCards::ColumnSetParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ColumnSetParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ColumnSetParser > **)&jarg1;
  arg1 = (AdaptiveCards::ColumnSetParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoicesData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoicesData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ChoicesData *)new AdaptiveCards::ChoicesData();
  
  *(std::shared_ptr<  AdaptiveCards::ChoicesData > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoicesData >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoicesData const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1ShouldSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::ChoicesData const *)arg1)->ShouldSerialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoicesData const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1GetChoicesDataType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoicesData const *)arg1)->GetChoicesDataType();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1SetChoicesDataType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetChoicesDataType((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1GetDataset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoicesData const *)arg1)->GetDataset();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1SetDataset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetDataset((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::ChoicesData::Deserialize(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::ChoicesData > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::ChoicesData >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoicesData_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::ChoicesData::DeserializeFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::ChoicesData > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::ChoicesData >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ChoicesData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ChoicesData *arg1 = (AdaptiveCards::ChoicesData *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoicesData > **)&jarg1;
  arg1 = (AdaptiveCards::ChoicesData *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceInput(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ChoiceInput *)new AdaptiveCards::ChoiceInput();
  
  *(std::shared_ptr<  AdaptiveCards::ChoiceInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoiceInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoiceInput *arg1 = (AdaptiveCards::ChoiceInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceInput *arg1 = (AdaptiveCards::ChoiceInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1GetTitle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoiceInput *arg1 = (AdaptiveCards::ChoiceInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoiceInput const *)arg1)->GetTitle();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1SetTitle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ChoiceInput *arg1 = (AdaptiveCards::ChoiceInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetTitle((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoiceInput *arg1 = (AdaptiveCards::ChoiceInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoiceInput const *)arg1)->GetValue();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ChoiceInput *arg1 = (AdaptiveCards::ChoiceInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValue((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::ChoiceInput::Deserialize(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::ChoiceInput > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::ChoiceInput >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::ChoiceInput::DeserializeFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::ChoiceInput > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::ChoiceInput >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceInput_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::ChoiceInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::ChoiceInput *)AdaptiveCards_ChoiceInput_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::ChoiceInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoiceInput >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ChoiceInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ChoiceInput *arg1 = (AdaptiveCards::ChoiceInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceInput *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceSetInput_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ChoiceSetInput *)new AdaptiveCards::ChoiceSetInput();
  
  *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoiceSetInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceSetInput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = 0 ;
  AdaptiveCards::ChoiceSetInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ChoiceSetInput *)((*(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ChoiceSetInput const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ChoiceSetInput *)new AdaptiveCards::ChoiceSetInput((AdaptiveCards::ChoiceSetInput const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoiceSetInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ChoiceSetInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoiceSetInput const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1GetIsMultiSelect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::ChoiceSetInput const *)arg1)->GetIsMultiSelect();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1SetIsMultiSelect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetIsMultiSelect(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1GetChoiceSetStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput const > *smartarg1 = 0 ;
  AdaptiveCards::ChoiceSetStyle result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::ChoiceSetStyle)((AdaptiveCards::ChoiceSetInput const *)arg1)->GetChoiceSetStyle();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1SetChoiceSetStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  AdaptiveCards::ChoiceSetStyle arg2 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::ChoiceSetStyle)jarg2; 
  (arg1)->SetChoiceSetStyle(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1GetChoices_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > *) &(arg1)->GetChoices();
  *(std::vector< std::shared_ptr< AdaptiveCards::ChoiceInput > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1GetChoicesData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::shared_ptr< AdaptiveCards::ChoicesData > *) &((AdaptiveCards::ChoiceSetInput const *)arg1)->GetChoicesData();
  *(std::shared_ptr< AdaptiveCards::ChoicesData > **)&jresult = *result ? new std::shared_ptr< AdaptiveCards::ChoicesData >(*result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1SetChoicesData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > arg2 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoicesData > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::ChoicesData > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetChoicesData(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoiceSetInput const *)arg1)->GetValue();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValue((std::string const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1GetWrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::ChoiceSetInput const *)arg1)->GetWrap();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1SetWrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetWrap(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1GetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ChoiceSetInput const *)arg1)->GetPlaceholder();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1SetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ChoiceSetInput *arg1 = (AdaptiveCards::ChoiceSetInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetPlaceholder((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInput_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::ChoiceSetInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::ChoiceSetInput *)AdaptiveCards_ChoiceSetInput_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::ChoiceSetInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoiceSetInput >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceSetInputParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ChoiceSetInputParser *)new AdaptiveCards::ChoiceSetInputParser();
  
  *(std::shared_ptr<  AdaptiveCards::ChoiceSetInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoiceSetInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ChoiceSetInputParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInputParser *arg1 = 0 ;
  AdaptiveCards::ChoiceSetInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ChoiceSetInputParser *)((*(std::shared_ptr< const AdaptiveCards::ChoiceSetInputParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ChoiceSetInputParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ChoiceSetInputParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ChoiceSetInputParser *)new AdaptiveCards::ChoiceSetInputParser((AdaptiveCards::ChoiceSetInputParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ChoiceSetInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ChoiceSetInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ChoiceSetInputParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ChoiceSetInputParser *arg1 = (AdaptiveCards::ChoiceSetInputParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInputParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInputParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInputParser *arg1 = (AdaptiveCards::ChoiceSetInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ChoiceSetInputParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ChoiceSetInputParser *arg1 = (AdaptiveCards::ChoiceSetInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ChoiceSetInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ChoiceSetInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::ChoiceSetInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1DateInput_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::DateInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::DateInput *)new AdaptiveCards::DateInput();
  
  *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::DateInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1DateInput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::DateInput *arg1 = 0 ;
  AdaptiveCards::DateInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::DateInput *)((*(std::shared_ptr< const AdaptiveCards::DateInput > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::DateInput > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::DateInput const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::DateInput *)new AdaptiveCards::DateInput((AdaptiveCards::DateInput const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::DateInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1DateInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::shared_ptr< AdaptiveCards::DateInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::shared_ptr< AdaptiveCards::DateInput const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::DateInput const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1GetMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::shared_ptr< AdaptiveCards::DateInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::DateInput const *)arg1)->GetMax();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1SetMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::DateInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetMax((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1GetMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::shared_ptr< AdaptiveCards::DateInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::DateInput const *)arg1)->GetMin();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1SetMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::DateInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetMin((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1GetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::shared_ptr< AdaptiveCards::DateInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::DateInput const *)arg1)->GetPlaceholder();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1SetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::DateInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetPlaceholder((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::shared_ptr< AdaptiveCards::DateInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::DateInput const *)arg1)->GetValue();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::DateInput *arg1 = (AdaptiveCards::DateInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::DateInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jarg1;
  arg1 = (AdaptiveCards::DateInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValue((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInput_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::DateInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::DateInput *)AdaptiveCards_DateInput_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::DateInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::DateInput >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1DateInputParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::DateInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::DateInputParser *)new AdaptiveCards::DateInputParser();
  
  *(std::shared_ptr<  AdaptiveCards::DateInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::DateInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1DateInputParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::DateInputParser *arg1 = 0 ;
  AdaptiveCards::DateInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::DateInputParser *)((*(std::shared_ptr< const AdaptiveCards::DateInputParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::DateInputParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::DateInputParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::DateInputParser *)new AdaptiveCards::DateInputParser((AdaptiveCards::DateInputParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::DateInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::DateInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1DateInputParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::DateInputParser *arg1 = (AdaptiveCards::DateInputParser *) 0 ;
  std::shared_ptr< AdaptiveCards::DateInputParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::DateInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInputParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::DateInputParser *arg1 = (AdaptiveCards::DateInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::DateInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::DateInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_DateInputParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::DateInputParser *arg1 = (AdaptiveCards::DateInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::DateInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::DateInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::DateInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1NumberInput_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::NumberInput *)new AdaptiveCards::NumberInput();
  
  *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::NumberInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1NumberInput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInput *arg1 = 0 ;
  AdaptiveCards::NumberInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::NumberInput *)((*(std::shared_ptr< const AdaptiveCards::NumberInput > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::NumberInput > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::NumberInput const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::NumberInput *)new AdaptiveCards::NumberInput((AdaptiveCards::NumberInput const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::NumberInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1NumberInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::NumberInput const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1GetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::NumberInput const *)arg1)->GetPlaceholder();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1SetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetPlaceholder((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput const > *smartarg1 = 0 ;
  std::optional< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::NumberInput const *)arg1)->GetValue();
  *(std::optional< double > **)&jresult = new std::optional< double >((const std::optional< double > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::optional< double > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::optional< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::optional< double > const & reference is null");
    return ;
  } 
  (arg1)->SetValue((std::optional< double > const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1GetMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput const > *smartarg1 = 0 ;
  std::optional< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::NumberInput const *)arg1)->GetMax();
  *(std::optional< double > **)&jresult = new std::optional< double >((const std::optional< double > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1SetMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::optional< double > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::optional< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::optional< double > const & reference is null");
    return ;
  } 
  (arg1)->SetMax((std::optional< double > const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1GetMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput const > *smartarg1 = 0 ;
  std::optional< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::NumberInput const *)arg1)->GetMin();
  *(std::optional< double > **)&jresult = new std::optional< double >((const std::optional< double > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1SetMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::NumberInput *arg1 = (AdaptiveCards::NumberInput *) 0 ;
  std::optional< double > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::NumberInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::optional< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::optional< double > const & reference is null");
    return ;
  } 
  (arg1)->SetMin((std::optional< double > const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInput_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::NumberInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::NumberInput *)AdaptiveCards_NumberInput_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::NumberInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::NumberInput >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1NumberInputParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::NumberInputParser *)new AdaptiveCards::NumberInputParser();
  
  *(std::shared_ptr<  AdaptiveCards::NumberInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::NumberInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1NumberInputParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInputParser *arg1 = 0 ;
  AdaptiveCards::NumberInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::NumberInputParser *)((*(std::shared_ptr< const AdaptiveCards::NumberInputParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::NumberInputParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::NumberInputParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::NumberInputParser *)new AdaptiveCards::NumberInputParser((AdaptiveCards::NumberInputParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::NumberInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::NumberInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1NumberInputParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::NumberInputParser *arg1 = (AdaptiveCards::NumberInputParser *) 0 ;
  std::shared_ptr< AdaptiveCards::NumberInputParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInputParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInputParser *arg1 = (AdaptiveCards::NumberInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::NumberInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_NumberInputParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::NumberInputParser *arg1 = (AdaptiveCards::NumberInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::NumberInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::NumberInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::NumberInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TextInput_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::TextInput *)new AdaptiveCards::TextInput();
  
  *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TextInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TextInput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = 0 ;
  AdaptiveCards::TextInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::TextInput *)((*(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::TextInput const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::TextInput *)new AdaptiveCards::TextInput((AdaptiveCards::TextInput const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TextInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TextInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TextInput const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1GetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TextInput const *)arg1)->GetPlaceholder();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetPlaceholder((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TextInput const *)arg1)->GetValue();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValue((std::string const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1GetIsMultiline(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::TextInput const *)arg1)->GetIsMultiline();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SetIsMultiline(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetIsMultiline(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1GetMaxLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (unsigned int)((AdaptiveCards::TextInput const *)arg1)->GetMaxLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SetMaxLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  unsigned int arg2 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (unsigned int)jarg2; 
  (arg1)->SetMaxLength(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1GetTextInputStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  AdaptiveCards::TextInputStyle result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::TextInputStyle)((AdaptiveCards::TextInput const *)arg1)->GetTextInputStyle();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SetTextInputStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  AdaptiveCards::TextInputStyle arg2 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::TextInputStyle)jarg2; 
  (arg1)->SetTextInputStyle(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1GetInlineAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TextInput const *)arg1)->GetInlineAction();
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SetInlineAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > arg2 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetInlineAction(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1GetRegex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TextInput const *)arg1)->GetRegex();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1SetRegex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TextInput *arg1 = (AdaptiveCards::TextInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TextInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jarg1;
  arg1 = (AdaptiveCards::TextInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetRegex((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInput_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::TextInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::TextInput *)AdaptiveCards_TextInput_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::TextInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TextInput >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TextInputParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::TextInputParser *)new AdaptiveCards::TextInputParser();
  
  *(std::shared_ptr<  AdaptiveCards::TextInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TextInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TextInputParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInputParser *arg1 = 0 ;
  AdaptiveCards::TextInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::TextInputParser *)((*(std::shared_ptr< const AdaptiveCards::TextInputParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::TextInputParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::TextInputParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::TextInputParser *)new AdaptiveCards::TextInputParser((AdaptiveCards::TextInputParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::TextInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TextInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TextInputParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::TextInputParser *arg1 = (AdaptiveCards::TextInputParser *) 0 ;
  std::shared_ptr< AdaptiveCards::TextInputParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::TextInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInputParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInputParser *arg1 = (AdaptiveCards::TextInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::TextInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::TextInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TextInputParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::TextInputParser *arg1 = (AdaptiveCards::TextInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::TextInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TextInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::TextInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TimeInput_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::TimeInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::TimeInput *)new AdaptiveCards::TimeInput();
  
  *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TimeInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TimeInput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TimeInput *arg1 = 0 ;
  AdaptiveCards::TimeInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::TimeInput *)((*(std::shared_ptr< const AdaptiveCards::TimeInput > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::TimeInput > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::TimeInput const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::TimeInput *)new AdaptiveCards::TimeInput((AdaptiveCards::TimeInput const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TimeInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TimeInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TimeInput const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1GetMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TimeInput const *)arg1)->GetMax();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1SetMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetMax((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1GetMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TimeInput const *)arg1)->GetMin();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1SetMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetMin((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1GetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TimeInput const *)arg1)->GetPlaceholder();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1SetPlaceholder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetPlaceholder((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TimeInput const *)arg1)->GetValue();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TimeInput *arg1 = (AdaptiveCards::TimeInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TimeInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValue((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInput_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::TimeInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::TimeInput *)AdaptiveCards_TimeInput_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::TimeInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TimeInput >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TimeInputParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::TimeInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::TimeInputParser *)new AdaptiveCards::TimeInputParser();
  
  *(std::shared_ptr<  AdaptiveCards::TimeInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TimeInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TimeInputParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TimeInputParser *arg1 = 0 ;
  AdaptiveCards::TimeInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::TimeInputParser *)((*(std::shared_ptr< const AdaptiveCards::TimeInputParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::TimeInputParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::TimeInputParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::TimeInputParser *)new AdaptiveCards::TimeInputParser((AdaptiveCards::TimeInputParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::TimeInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TimeInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TimeInputParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::TimeInputParser *arg1 = (AdaptiveCards::TimeInputParser *) 0 ;
  std::shared_ptr< AdaptiveCards::TimeInputParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInputParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::TimeInputParser *arg1 = (AdaptiveCards::TimeInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::TimeInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TimeInputParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::TimeInputParser *arg1 = (AdaptiveCards::TimeInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::TimeInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TimeInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::TimeInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ToggleInput_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ToggleInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ToggleInput *)new AdaptiveCards::ToggleInput();
  
  *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ToggleInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ToggleInput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ToggleInput *arg1 = 0 ;
  AdaptiveCards::ToggleInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ToggleInput *)((*(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ToggleInput const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ToggleInput *)new AdaptiveCards::ToggleInput((AdaptiveCards::ToggleInput const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ToggleInput >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ToggleInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ToggleInput const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1GetTitle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ToggleInput const *)arg1)->GetTitle();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1SetTitle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetTitle((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ToggleInput const *)arg1)->GetValue();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValue((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1GetValueOff(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ToggleInput const *)arg1)->GetValueOff();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1SetValueOff(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValueOff((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1GetValueOn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ToggleInput const *)arg1)->GetValueOn();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1SetValueOn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValueOn((std::string const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1GetWrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInput const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::ToggleInput const *)arg1)->GetWrap();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1SetWrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  AdaptiveCards::ToggleInput *arg1 = (AdaptiveCards::ToggleInput *) 0 ;
  bool arg2 ;
  std::shared_ptr< AdaptiveCards::ToggleInput > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInput *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetWrap(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInput_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseCardElement *arg1 = (AdaptiveCards::BaseCardElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > *smartarg1 = 0 ;
  AdaptiveCards::ToggleInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseCardElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseCardElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::ToggleInput *)AdaptiveCards_ToggleInput_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::ToggleInput > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ToggleInput >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ToggleInputParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ToggleInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ToggleInputParser *)new AdaptiveCards::ToggleInputParser();
  
  *(std::shared_ptr<  AdaptiveCards::ToggleInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ToggleInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ToggleInputParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ToggleInputParser *arg1 = 0 ;
  AdaptiveCards::ToggleInputParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ToggleInputParser *)((*(std::shared_ptr< const AdaptiveCards::ToggleInputParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ToggleInputParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ToggleInputParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ToggleInputParser *)new AdaptiveCards::ToggleInputParser((AdaptiveCards::ToggleInputParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ToggleInputParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ToggleInputParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ToggleInputParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ToggleInputParser *arg1 = (AdaptiveCards::ToggleInputParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInputParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInputParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ToggleInputParser *arg1 = (AdaptiveCards::ToggleInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ToggleInputParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ToggleInputParser *arg1 = (AdaptiveCards::ToggleInputParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ToggleInputParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseCardElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ToggleInputParser > **)&jarg1;
  arg1 = (AdaptiveCards::ToggleInputParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseCardElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseCardElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ExecuteAction_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ExecuteAction *)new AdaptiveCards::ExecuteAction();
  
  *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ExecuteAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ExecuteAction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteAction *arg1 = 0 ;
  AdaptiveCards::ExecuteAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ExecuteAction *)((*(std::shared_ptr< const AdaptiveCards::ExecuteAction > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ExecuteAction > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ExecuteAction const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ExecuteAction *)new AdaptiveCards::ExecuteAction((AdaptiveCards::ExecuteAction const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ExecuteAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ExecuteAction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1GetDataJson(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ExecuteAction const *)arg1)->GetDataJson();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1GetDataJsonAsValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ExecuteAction const *)arg1)->GetDataJsonAsValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1SetDataJson_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  (arg1)->SetDataJson((Json::Value const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1SetDataJson_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetDataJson(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1GetVerb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ExecuteAction const *)arg1)->GetVerb();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1SetVerb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetVerb(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1GetAssociatedInputs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction const > *smartarg1 = 0 ;
  AdaptiveCards::AssociatedInputs result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::AssociatedInputs)((AdaptiveCards::ExecuteAction const *)arg1)->GetAssociatedInputs();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1SetAssociatedInputs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  AdaptiveCards::AssociatedInputs arg2 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::AssociatedInputs)jarg2; 
  (arg1)->SetAssociatedInputs(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteAction *arg1 = (AdaptiveCards::ExecuteAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteAction const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ExecuteAction > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ExecuteAction const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteAction_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  AdaptiveCards::ExecuteAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::ExecuteAction *)AdaptiveCards_ExecuteAction_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::ExecuteAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ExecuteAction >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ExecuteActionParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ExecuteActionParser *)new AdaptiveCards::ExecuteActionParser();
  
  *(std::shared_ptr<  AdaptiveCards::ExecuteActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ExecuteActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ExecuteActionParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteActionParser *arg1 = 0 ;
  AdaptiveCards::ExecuteActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ExecuteActionParser *)((*(std::shared_ptr< const AdaptiveCards::ExecuteActionParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ExecuteActionParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ExecuteActionParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ExecuteActionParser *)new AdaptiveCards::ExecuteActionParser((AdaptiveCards::ExecuteActionParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ExecuteActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ExecuteActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ExecuteActionParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ExecuteActionParser *arg1 = (AdaptiveCards::ExecuteActionParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteActionParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteActionParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteActionParser *arg1 = (AdaptiveCards::ExecuteActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ExecuteActionParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ExecuteActionParser *arg1 = (AdaptiveCards::ExecuteActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ExecuteActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ExecuteActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::ExecuteActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TokenExchangeResource_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::TokenExchangeResource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::TokenExchangeResource *)new AdaptiveCards::TokenExchangeResource();
  
  *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TokenExchangeResource >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1TokenExchangeResource_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  std::string arg1 ;
  std::string arg2 ;
  std::string arg3 ;
  AdaptiveCards::TokenExchangeResource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  (&arg1)->assign(arg1_pstr);
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  (&arg3)->assign(arg3_pstr);
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (AdaptiveCards::TokenExchangeResource *)new AdaptiveCards::TokenExchangeResource(arg1,arg2,arg3);
  
  *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::TokenExchangeResource >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1GetId_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetId();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1SetId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetId(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1GetUri_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetUri();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1SetUri(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetUri(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1GetProviderId_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetProviderId();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1SetProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetProviderId(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1ShouldSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::TokenExchangeResource const *)arg1)->ShouldSerialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TokenExchangeResource const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::TokenExchangeResource const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::TokenExchangeResource::Deserialize(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::TokenExchangeResource > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::TokenExchangeResource >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_TokenExchangeResource_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::TokenExchangeResource::DeserializeFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::TokenExchangeResource > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::TokenExchangeResource >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1TokenExchangeResource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::TokenExchangeResource *arg1 = (AdaptiveCards::TokenExchangeResource *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::TokenExchangeResource > **)&jarg1;
  arg1 = (AdaptiveCards::TokenExchangeResource *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AuthCardButton_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::AuthCardButton *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::AuthCardButton *)new AdaptiveCards::AuthCardButton();
  
  *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AuthCardButton >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AuthCardButton_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  std::string arg1 ;
  std::string arg2 ;
  std::string arg3 ;
  std::string arg4 ;
  AdaptiveCards::AuthCardButton *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  (&arg1)->assign(arg1_pstr);
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  (&arg3)->assign(arg3_pstr);
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return 0;
  (&arg4)->assign(arg4_pstr);
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  result = (AdaptiveCards::AuthCardButton *)new AdaptiveCards::AuthCardButton(arg1,arg2,arg3,arg4);
  
  *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AuthCardButton >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1GetType_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetType();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1SetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetType(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1GetTitle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetTitle();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1SetTitle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetTitle(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1GetImage_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetImage();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1SetImage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetImage(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1GetValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetValue();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetValue(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1ShouldSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::AuthCardButton const *)arg1)->ShouldSerialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::AuthCardButton const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::AuthCardButton const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::AuthCardButton::Deserialize(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::AuthCardButton > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::AuthCardButton >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AuthCardButton_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::AuthCardButton::DeserializeFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::AuthCardButton > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::AuthCardButton >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1AuthCardButton(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::AuthCardButton *arg1 = (AdaptiveCards::AuthCardButton *) 0 ;
  std::shared_ptr< AdaptiveCards::AuthCardButton > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::AuthCardButton > **)&jarg1;
  arg1 = (AdaptiveCards::AuthCardButton *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Refresh_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::Refresh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::Refresh *)new AdaptiveCards::Refresh();
  
  *(std::shared_ptr<  AdaptiveCards::Refresh > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Refresh >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Refresh_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > arg1 ;
  std::vector< std::string > arg2 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *argp1 ;
  std::vector< std::string > const *argp2 ;
  AdaptiveCards::Refresh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jarg1;
  if (argp1) arg1 = *argp1; 
  argp2 = *(std::vector< std::string > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< std::string > const");
    return 0;
  }
  arg2 = *argp2; 
  result = (AdaptiveCards::Refresh *)new AdaptiveCards::Refresh(arg1,arg2);
  
  *(std::shared_ptr<  AdaptiveCards::Refresh > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Refresh >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1GetAction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::shared_ptr< AdaptiveCards::Refresh > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetAction();
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1SetAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > arg2 ;
  std::shared_ptr< AdaptiveCards::Refresh > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetAction(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1GetUserIds_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::shared_ptr< AdaptiveCards::Refresh > *smartarg1 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::string > *) &(arg1)->GetUserIds();
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1SetUserIds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::vector< std::string > arg2 ;
  std::shared_ptr< AdaptiveCards::Refresh > *smartarg1 = 0 ;
  std::vector< std::string > *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::vector< std::string > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< std::string >");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetUserIds(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1ShouldSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::shared_ptr< AdaptiveCards::Refresh const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::Refresh const *)arg1)->ShouldSerialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::shared_ptr< AdaptiveCards::Refresh const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Refresh const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::shared_ptr< AdaptiveCards::Refresh const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Refresh const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Refresh > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::Refresh::Deserialize(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::Refresh > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::Refresh >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Refresh_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Refresh > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::Refresh::DeserializeFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::Refresh > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::Refresh >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1Refresh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::Refresh *arg1 = (AdaptiveCards::Refresh *) 0 ;
  std::shared_ptr< AdaptiveCards::Refresh > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Refresh > **)&jarg1;
  arg1 = (AdaptiveCards::Refresh *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Authentication_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::Authentication *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::Authentication *)new AdaptiveCards::Authentication();
  
  *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Authentication >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1Authentication_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  std::string arg1 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *arg3 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *arg4 = 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > tempnull3 ;
  AdaptiveCards::Authentication *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  (&arg1)->assign(arg1_pstr);
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? *(std::shared_ptr< AdaptiveCards::TokenExchangeResource > **)&jarg3 : &tempnull3; 
  arg4 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::Authentication *)new AdaptiveCards::Authentication(arg1,arg2,(std::shared_ptr< AdaptiveCards::TokenExchangeResource > const &)*arg3,(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > const &)*arg4);
  
  *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::Authentication >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1GetText_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetText();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1SetText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetText(arg2);
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1GetConnectionName_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetConnectionName();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1SetConnectionName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetConnectionName(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1GetTokenExchangeResource_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  result = (arg1)->GetTokenExchangeResource();
  *(std::shared_ptr< AdaptiveCards::TokenExchangeResource > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::TokenExchangeResource >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1SetTokenExchangeResource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > arg2 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::TokenExchangeResource > *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::TokenExchangeResource > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetTokenExchangeResource(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1GetButtons_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  result = (std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *) &(arg1)->GetButtons();
  *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1SetButtons(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > arg2 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< std::shared_ptr< AdaptiveCards::AuthCardButton > >");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetButtons(arg2);
}


SWIGEXPORT jboolean JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1ShouldSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  result = (bool)((AdaptiveCards::Authentication const *)arg1)->ShouldSerialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Authentication const *)arg1)->Serialize();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::Authentication const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Authentication > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = AdaptiveCards::Authentication::Deserialize(*arg1,(Json::Value const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::Authentication > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::Authentication >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_Authentication_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseContext *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::Authentication > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = AdaptiveCards::Authentication::DeserializeFromString(*arg1,(std::string const &)*arg2);
  *(std::shared_ptr< AdaptiveCards::Authentication > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::Authentication >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1Authentication(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::Authentication *arg1 = (AdaptiveCards::Authentication *) 0 ;
  std::shared_ptr< AdaptiveCards::Authentication > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::Authentication > **)&jarg1;
  arg1 = (AdaptiveCards::Authentication *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1OpenUrlAction_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::OpenUrlAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::OpenUrlAction *)new AdaptiveCards::OpenUrlAction();
  
  *(std::shared_ptr<  AdaptiveCards::OpenUrlAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::OpenUrlAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1OpenUrlAction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::OpenUrlAction *arg1 = 0 ;
  AdaptiveCards::OpenUrlAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::OpenUrlAction *)((*(std::shared_ptr< const AdaptiveCards::OpenUrlAction > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::OpenUrlAction > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::OpenUrlAction const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::OpenUrlAction *)new AdaptiveCards::OpenUrlAction((AdaptiveCards::OpenUrlAction const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::OpenUrlAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::OpenUrlAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1OpenUrlAction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::OpenUrlAction *arg1 = (AdaptiveCards::OpenUrlAction *) 0 ;
  std::shared_ptr< AdaptiveCards::OpenUrlAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::OpenUrlAction > **)&jarg1;
  arg1 = (AdaptiveCards::OpenUrlAction *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_OpenUrlAction_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::OpenUrlAction *arg1 = (AdaptiveCards::OpenUrlAction *) 0 ;
  std::shared_ptr< AdaptiveCards::OpenUrlAction const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::OpenUrlAction > **)&jarg1;
  arg1 = (AdaptiveCards::OpenUrlAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::OpenUrlAction const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_OpenUrlAction_1GetUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::OpenUrlAction *arg1 = (AdaptiveCards::OpenUrlAction *) 0 ;
  std::shared_ptr< AdaptiveCards::OpenUrlAction const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::OpenUrlAction > **)&jarg1;
  arg1 = (AdaptiveCards::OpenUrlAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::OpenUrlAction const *)arg1)->GetUrl();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_OpenUrlAction_1SetUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::OpenUrlAction *arg1 = (AdaptiveCards::OpenUrlAction *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::OpenUrlAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::OpenUrlAction > **)&jarg1;
  arg1 = (AdaptiveCards::OpenUrlAction *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetUrl((std::string const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_OpenUrlAction_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  AdaptiveCards::OpenUrlAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::OpenUrlAction *)AdaptiveCards_OpenUrlAction_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::OpenUrlAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::OpenUrlAction >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1OpenUrlActionParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::OpenUrlActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::OpenUrlActionParser *)new AdaptiveCards::OpenUrlActionParser();
  
  *(std::shared_ptr<  AdaptiveCards::OpenUrlActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::OpenUrlActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1OpenUrlActionParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::OpenUrlActionParser *arg1 = 0 ;
  AdaptiveCards::OpenUrlActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::OpenUrlActionParser *)((*(std::shared_ptr< const AdaptiveCards::OpenUrlActionParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::OpenUrlActionParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::OpenUrlActionParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::OpenUrlActionParser *)new AdaptiveCards::OpenUrlActionParser((AdaptiveCards::OpenUrlActionParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::OpenUrlActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::OpenUrlActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1OpenUrlActionParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::OpenUrlActionParser *arg1 = (AdaptiveCards::OpenUrlActionParser *) 0 ;
  std::shared_ptr< AdaptiveCards::OpenUrlActionParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::OpenUrlActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::OpenUrlActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_OpenUrlActionParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::OpenUrlActionParser *arg1 = (AdaptiveCards::OpenUrlActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::OpenUrlActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::OpenUrlActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::OpenUrlActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_OpenUrlActionParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::OpenUrlActionParser *arg1 = (AdaptiveCards::OpenUrlActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::OpenUrlActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::OpenUrlActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::OpenUrlActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ShowCardAction_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ShowCardAction *)new AdaptiveCards::ShowCardAction();
  
  *(std::shared_ptr<  AdaptiveCards::ShowCardAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ShowCardAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ShowCardAction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardAction *arg1 = 0 ;
  AdaptiveCards::ShowCardAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ShowCardAction *)((*(std::shared_ptr< const AdaptiveCards::ShowCardAction > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ShowCardAction > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ShowCardAction const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ShowCardAction *)new AdaptiveCards::ShowCardAction((AdaptiveCards::ShowCardAction const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ShowCardAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ShowCardAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ShowCardAction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ShowCardAction *arg1 = (AdaptiveCards::ShowCardAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ShowCardAction > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardAction *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardAction_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardAction *arg1 = (AdaptiveCards::ShowCardAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardAction const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ShowCardAction > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ShowCardAction const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardAction_1GetCard(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardAction *arg1 = (AdaptiveCards::ShowCardAction *) 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardAction const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCard > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ShowCardAction > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ShowCardAction const *)arg1)->GetCard();
  *(std::shared_ptr< AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::AdaptiveCard >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardAction_1SetCard(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ShowCardAction *arg1 = (AdaptiveCards::ShowCardAction *) 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCard > arg2 ;
  std::shared_ptr< AdaptiveCards::ShowCardAction > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCard > const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ShowCardAction > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardAction *)(smartarg1 ? smartarg1->get() : 0); 
  argp2 = *(std::shared_ptr< AdaptiveCards::AdaptiveCard > **)&jarg2;
  if (argp2) arg2 = *argp2; 
  (arg1)->SetCard(arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardAction_1SetLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::ShowCardAction *arg1 = (AdaptiveCards::ShowCardAction *) 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ShowCardAction > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardAction *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetLanguage((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardAction_1GetResourceInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::ShowCardAction *arg1 = (AdaptiveCards::ShowCardAction *) 0 ;
  std::vector< AdaptiveCards::RemoteResourceInformation > *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ShowCardAction > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardAction *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(std::vector< AdaptiveCards::RemoteResourceInformation > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< AdaptiveCards::RemoteResourceInformation > & reference is null");
    return ;
  } 
  (arg1)->GetResourceInformation(*arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardAction_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  AdaptiveCards::ShowCardAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::ShowCardAction *)AdaptiveCards_ShowCardAction_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::ShowCardAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ShowCardAction >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ShowCardActionParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::ShowCardActionParser *)new AdaptiveCards::ShowCardActionParser();
  
  *(std::shared_ptr<  AdaptiveCards::ShowCardActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ShowCardActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ShowCardActionParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardActionParser *arg1 = 0 ;
  AdaptiveCards::ShowCardActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::ShowCardActionParser *)((*(std::shared_ptr< const AdaptiveCards::ShowCardActionParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::ShowCardActionParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ShowCardActionParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::ShowCardActionParser *)new AdaptiveCards::ShowCardActionParser((AdaptiveCards::ShowCardActionParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::ShowCardActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ShowCardActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ShowCardActionParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ShowCardActionParser *arg1 = (AdaptiveCards::ShowCardActionParser *) 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardActionParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ShowCardActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardActionParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardActionParser *arg1 = (AdaptiveCards::ShowCardActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ShowCardActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ShowCardActionParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::ShowCardActionParser *arg1 = (AdaptiveCards::ShowCardActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::ShowCardActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ShowCardActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::ShowCardActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1SubmitAction_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::SubmitAction *)new AdaptiveCards::SubmitAction();
  
  *(std::shared_ptr<  AdaptiveCards::SubmitAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::SubmitAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1SubmitAction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitAction *arg1 = 0 ;
  AdaptiveCards::SubmitAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::SubmitAction *)((*(std::shared_ptr< const AdaptiveCards::SubmitAction > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::SubmitAction > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::SubmitAction const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::SubmitAction *)new AdaptiveCards::SubmitAction((AdaptiveCards::SubmitAction const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::SubmitAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::SubmitAction >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1SubmitAction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  std::shared_ptr< AdaptiveCards::SubmitAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1GetDataJson(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  std::shared_ptr< AdaptiveCards::SubmitAction const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::SubmitAction const *)arg1)->GetDataJson();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1GetDataJsonAsValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  std::shared_ptr< AdaptiveCards::SubmitAction const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::SubmitAction const *)arg1)->GetDataJsonAsValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1SetDataJson_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  Json::Value *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::SubmitAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(Json::Value **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return ;
  } 
  (arg1)->SetDataJson((Json::Value const &)*arg2);
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1SetDataJson_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  std::string arg2 ;
  std::shared_ptr< AdaptiveCards::SubmitAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->SetDataJson(arg2);
}


SWIGEXPORT jint JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1GetAssociatedInputs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  std::shared_ptr< AdaptiveCards::SubmitAction const > *smartarg1 = 0 ;
  AdaptiveCards::AssociatedInputs result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = (AdaptiveCards::AssociatedInputs)((AdaptiveCards::SubmitAction const *)arg1)->GetAssociatedInputs();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1SetAssociatedInputs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  AdaptiveCards::AssociatedInputs arg2 ;
  std::shared_ptr< AdaptiveCards::SubmitAction > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (AdaptiveCards::AssociatedInputs)jarg2; 
  (arg1)->SetAssociatedInputs(arg2);
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1SerializeToJsonValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitAction *arg1 = (AdaptiveCards::SubmitAction *) 0 ;
  std::shared_ptr< AdaptiveCards::SubmitAction const > *smartarg1 = 0 ;
  Json::Value result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::SubmitAction > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitAction *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::SubmitAction const *)arg1)->SerializeToJsonValue();
  *(Json::Value **)&jresult = new Json::Value((const Json::Value &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitAction_1dynamic_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::BaseActionElement *arg1 = (AdaptiveCards::BaseActionElement *) 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > *smartarg1 = 0 ;
  AdaptiveCards::SubmitAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::BaseActionElement > **)&jarg1;
  arg1 = (AdaptiveCards::BaseActionElement *)(smartarg1 ? smartarg1->get() : 0); 
  {
    result = (AdaptiveCards::SubmitAction *)AdaptiveCards_SubmitAction_dynamic_cast(arg1);
    if (!result) {
      jclass excep = jenv->FindClass("java/lang/ClassCastException");
      if (excep) {
        jenv->ThrowNew(excep, "dynamic_cast exception");
      }
    }
  }
  
  *(std::shared_ptr<  AdaptiveCards::SubmitAction > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::SubmitAction >(result SWIG_NO_NULL_DELETER_0) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1SubmitActionParser_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::SubmitActionParser *)new AdaptiveCards::SubmitActionParser();
  
  *(std::shared_ptr<  AdaptiveCards::SubmitActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::SubmitActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1SubmitActionParser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitActionParser *arg1 = 0 ;
  AdaptiveCards::SubmitActionParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  arg1 = (AdaptiveCards::SubmitActionParser *)((*(std::shared_ptr< const AdaptiveCards::SubmitActionParser > **)&jarg1) ? (*(std::shared_ptr< const AdaptiveCards::SubmitActionParser > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::SubmitActionParser const & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::SubmitActionParser *)new AdaptiveCards::SubmitActionParser((AdaptiveCards::SubmitActionParser const &)*arg1);
  
  *(std::shared_ptr<  AdaptiveCards::SubmitActionParser > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::SubmitActionParser >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1SubmitActionParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::SubmitActionParser *arg1 = (AdaptiveCards::SubmitActionParser *) 0 ;
  std::shared_ptr< AdaptiveCards::SubmitActionParser > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::SubmitActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitActionParser_1Deserialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitActionParser *arg1 = (AdaptiveCards::SubmitActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  Json::Value *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::SubmitActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::SubmitActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  arg3 = *(Json::Value **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Json::Value const & reference is null");
    return 0;
  } 
  result = (arg1)->Deserialize(*arg2,(Json::Value const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_SubmitActionParser_1DeserializeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  AdaptiveCards::SubmitActionParser *arg1 = (AdaptiveCards::SubmitActionParser *) 0 ;
  AdaptiveCards::ParseContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::shared_ptr< AdaptiveCards::SubmitActionParser > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::BaseActionElement > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::SubmitActionParser > **)&jarg1;
  arg1 = (AdaptiveCards::SubmitActionParser *)(smartarg1 ? smartarg1->get() : 0); 
  
  arg2 = (AdaptiveCards::ParseContext *)((*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2) ? (*(std::shared_ptr<  AdaptiveCards::ParseContext > **)&jarg2)->get() : 0);
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "AdaptiveCards::ParseContext & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (arg1)->DeserializeFromString(*arg2,(std::string const &)*arg3);
  *(std::shared_ptr< AdaptiveCards::BaseActionElement > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::BaseActionElement >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1ParseResult(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCard > arg1 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > arg2 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCard > *argp1 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > *argp2 ;
  AdaptiveCards::ParseResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(std::shared_ptr< AdaptiveCards::AdaptiveCard > **)&jarg1;
  if (argp1) arg1 = *argp1; 
  argp2 = *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >");
    return 0;
  }
  arg2 = *argp2; 
  result = (AdaptiveCards::ParseResult *)new AdaptiveCards::ParseResult(arg1,arg2);
  
  *(std::shared_ptr<  AdaptiveCards::ParseResult > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::ParseResult >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseResult_1GetAdaptiveCard(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseResult *arg1 = (AdaptiveCards::ParseResult *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseResult const > *smartarg1 = 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCard > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ParseResult > **)&jarg1;
  arg1 = (AdaptiveCards::ParseResult *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ParseResult const *)arg1)->GetAdaptiveCard();
  *(std::shared_ptr< AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr< AdaptiveCards::AdaptiveCard >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_ParseResult_1GetWarnings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AdaptiveCards::ParseResult *arg1 = (AdaptiveCards::ParseResult *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseResult const > *smartarg1 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::ParseResult > **)&jarg1;
  arg1 = (AdaptiveCards::ParseResult *)(smartarg1 ? smartarg1->get() : 0); 
  result = ((AdaptiveCards::ParseResult const *)arg1)->GetWarnings();
  *(std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > **)&jresult = new std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > >((const std::vector< std::shared_ptr< AdaptiveCards::AdaptiveCardParseWarning > > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_delete_1ParseResult(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AdaptiveCards::ParseResult *arg1 = (AdaptiveCards::ParseResult *) 0 ;
  std::shared_ptr< AdaptiveCards::ParseResult > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(std::shared_ptr<  AdaptiveCards::ParseResult > **)&jarg1;
  arg1 = (AdaptiveCards::ParseResult *)(smartarg1 ? smartarg1->get() : 0); 
  (void)arg1; delete smartarg1;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCard_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  AdaptiveCards::AdaptiveCard *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (AdaptiveCards::AdaptiveCard *)new AdaptiveCards::AdaptiveCard();
  
  *(std::shared_ptr<  AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AdaptiveCard >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCard_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jint jarg4, jstring jarg5, jstring jarg6, jint jarg7, jint jarg8, jlong jarg9) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  AdaptiveCards::ContainerStyle arg4 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  AdaptiveCards::VerticalContentAlignment arg7 ;
  AdaptiveCards::HeightType arg8 ;
  unsigned int arg9 ;
  AdaptiveCards::AdaptiveCard *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = (AdaptiveCards::ContainerStyle)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  arg7 = (AdaptiveCards::VerticalContentAlignment)jarg7; 
  arg8 = (AdaptiveCards::HeightType)jarg8; 
  arg9 = (unsigned int)jarg9; 
  result = (AdaptiveCards::AdaptiveCard *)new AdaptiveCards::AdaptiveCard((std::string const &)*arg1,(std::string const &)*arg2,(std::string const &)*arg3,arg4,(std::string const &)*arg5,(std::string const &)*arg6,arg7,arg8,arg9);
  
  *(std::shared_ptr<  AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AdaptiveCard >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCard_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jint jarg4, jstring jarg5, jstring jarg6, jint jarg7, jint jarg8, jlong jarg9, jlong jarg10, jobject jarg10_, jlong jarg11, jobject jarg11_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  AdaptiveCards::ContainerStyle arg4 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  AdaptiveCards::VerticalContentAlignment arg7 ;
  AdaptiveCards::HeightType arg8 ;
  unsigned int arg9 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg10 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg11 = 0 ;
  AdaptiveCards::AdaptiveCard *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg10_;
  (void)jarg11_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = (AdaptiveCards::ContainerStyle)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  arg7 = (AdaptiveCards::VerticalContentAlignment)jarg7; 
  arg8 = (AdaptiveCards::HeightType)jarg8; 
  arg9 = (unsigned int)jarg9; 
  arg10 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > & reference is null");
    return 0;
  } 
  arg11 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg11;
  if (!arg11) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::AdaptiveCard *)new AdaptiveCards::AdaptiveCard((std::string const &)*arg1,(std::string const &)*arg2,(std::string const &)*arg3,arg4,(std::string const &)*arg5,(std::string const &)*arg6,arg7,arg8,arg9,*arg10,*arg11);
  
  *(std::shared_ptr<  AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AdaptiveCard >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCard_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jstring jarg5, jstring jarg6, jint jarg7, jint jarg8, jlong jarg9) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > arg3 ;
  AdaptiveCards::ContainerStyle arg4 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  AdaptiveCards::VerticalContentAlignment arg7 ;
  AdaptiveCards::HeightType arg8 ;
  unsigned int arg9 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *argp3 ;
  AdaptiveCards::AdaptiveCard *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  argp3 = *(std::shared_ptr< AdaptiveCards::BackgroundImage > **)&jarg3;
  if (argp3) arg3 = *argp3; 
  arg4 = (AdaptiveCards::ContainerStyle)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  arg7 = (AdaptiveCards::VerticalContentAlignment)jarg7; 
  arg8 = (AdaptiveCards::HeightType)jarg8; 
  arg9 = (unsigned int)jarg9; 
  result = (AdaptiveCards::AdaptiveCard *)new AdaptiveCards::AdaptiveCard((std::string const &)*arg1,(std::string const &)*arg2,arg3,arg4,(std::string const &)*arg5,(std::string const &)*arg6,arg7,arg8,arg9);
  
  *(std::shared_ptr<  AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AdaptiveCard >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCard_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jstring jarg5, jstring jarg6, jint jarg7, jint jarg8, jlong jarg9, jlong jarg10, jobject jarg10_, jlong jarg11, jobject jarg11_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > arg3 ;
  AdaptiveCards::ContainerStyle arg4 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  AdaptiveCards::VerticalContentAlignment arg7 ;
  AdaptiveCards::HeightType arg8 ;
  unsigned int arg9 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg10 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg11 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *argp3 ;
  AdaptiveCards::AdaptiveCard *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg10_;
  (void)jarg11_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  argp3 = *(std::shared_ptr< AdaptiveCards::BackgroundImage > **)&jarg3;
  if (argp3) arg3 = *argp3; 
  arg4 = (AdaptiveCards::ContainerStyle)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  arg7 = (AdaptiveCards::VerticalContentAlignment)jarg7; 
  arg8 = (AdaptiveCards::HeightType)jarg8; 
  arg9 = (unsigned int)jarg9; 
  arg10 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > & reference is null");
    return 0;
  } 
  arg11 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg11;
  if (!arg11) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::AdaptiveCard *)new AdaptiveCards::AdaptiveCard((std::string const &)*arg1,(std::string const &)*arg2,arg3,arg4,(std::string const &)*arg5,(std::string const &)*arg6,arg7,arg8,arg9,*arg10,*arg11);
  
  *(std::shared_ptr<  AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AdaptiveCard >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_new_1AdaptiveCard_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jint jarg6, jstring jarg7, jstring jarg8, jint jarg9, jint jarg10, jlong jarg11, jlong jarg12, jobject jarg12_, jlong jarg13, jobject jarg13_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > arg3 ;
  std::shared_ptr< AdaptiveCards::Refresh > arg4 ;
  std::shared_ptr< AdaptiveCards::Authentication > arg5 ;
  AdaptiveCards::ContainerStyle arg6 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  AdaptiveCards::VerticalContentAlignment arg9 ;
  AdaptiveCards::HeightType arg10 ;
  unsigned int arg11 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > *arg12 = 0 ;
  std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > *arg13 = 0 ;
  std::shared_ptr< AdaptiveCards::BackgroundImage > *argp3 ;
  std::shared_ptr< AdaptiveCards::Refresh > *argp4 ;
  std::shared_ptr< AdaptiveCards::Authentication > *argp5 ;
  AdaptiveCards::AdaptiveCard *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg12_;
  (void)jarg13_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  argp3 = *(std::shared_ptr< AdaptiveCards::BackgroundImage > **)&jarg3;
  if (argp3) arg3 = *argp3; 
  argp4 = *(std::shared_ptr< AdaptiveCards::Refresh > **)&jarg4;
  if (argp4) arg4 = *argp4; 
  argp5 = *(std::shared_ptr< AdaptiveCards::Authentication > **)&jarg5;
  if (argp5) arg5 = *argp5; 
  arg6 = (AdaptiveCards::ContainerStyle)jarg6; 
  if(!jarg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0); 
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  jenv->ReleaseStringUTFChars(jarg7, arg7_pstr); 
  if(!jarg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0); 
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  jenv->ReleaseStringUTFChars(jarg8, arg8_pstr); 
  arg9 = (AdaptiveCards::VerticalContentAlignment)jarg9; 
  arg10 = (AdaptiveCards::HeightType)jarg10; 
  arg11 = (unsigned int)jarg11; 
  arg12 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > **)&jarg12;
  if (!arg12) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseCardElement > > & reference is null");
    return 0;
  } 
  arg13 = *(std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > **)&jarg13;
  if (!arg13) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::shared_ptr< AdaptiveCards::BaseActionElement > > & reference is null");
    return 0;
  } 
  result = (AdaptiveCards::AdaptiveCard *)new AdaptiveCards::AdaptiveCard((std::string const &)*arg1,(std::string const &)*arg2,arg3,arg4,arg5,arg6,(std::string const &)*arg7,(std::string const &)*arg8,arg9,arg10,arg11,*arg12,*arg13);
  
  *(std::shared_ptr<  AdaptiveCards::AdaptiveCard > **)&jresult = result ? new std::shared_ptr<  AdaptiveCards::AdaptiveCard >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_io_adaptivecards_objectmodel_AdaptiveCardObjectModelJNI_AdaptiveCard_1GetVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  AdaptiveCards::AdaptiveCard *arg1 = (AdaptiveCards::AdaptiveCard *) 0 ;
  std::shared_ptr< AdaptiveCards::AdaptiveCard const > *smartarg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(std::shared_ptr< const AdaptiveCards::AdaptiveCard > **)&jarg1;
  arg1 = (AdaptiveCards::AdaptiveCard *)(smartarg1 ? smartarg1->get() : 0