﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class GetTrainsFrom : Form
    {
        public GetTrainsFrom()
        {
            InitializeComponent();
            Control.CheckForIllegalCrossThreadCalls = false;
        }

        private void GetTrainsFrom_Load(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            System.Threading.ThreadPool.QueueUserWorkItem((m) =>
            {
                checkedListBox1.Items.Clear();

                var startStation = Stations.List.FirstOrDefault(fun => fun.Name == textBox1.Text.Trim());
                if (startStation == null)
                {
                    MessageBox.Show(string.Format("找不到站点：{0}，请重新输入！", textBox1.Text.Trim()));
                    return;
                }
                
                var endStation = Stations.List.FirstOrDefault(fun => fun.Name == textBox2.Text.Trim());

                if (endStation == null)
                {
                    MessageBox.Show(string.Format("找不到站点：{0}，请重新输入！", textBox2.Text.Trim()));

                    return;
                }



                list = _12306Class.GetTrains(dateTimePicker1.Value.ToString("yyyy-MM-dd"), startStation.Code, endStation.Code);

                if (list == null)
                {
                    MessageBox.Show("网络异常，请稍后重试");
                    return;
                }

                if (list.Count <= 0)
                {
                    MessageBox.Show(string.Format("找不到车次从{0}开往{1}的车次", textBox1.Text, textBox2.Text));
                    return;
                }


                _12306Class.From = startStation;
                _12306Class.To = endStation;


                foreach (var train in list)
                {
                    checkedListBox1.Items.Add(train.ToString());
                }
            });
        }

        private List<Train> list;

        private void button2_Click(object sender, EventArgs e)
        {
            List<Train> addList = new List<Train>();

            foreach (var index in checkedListBox1.CheckedIndices)
            {
                addList.Add(list[(int)index]);
            }

            Trains.AddTrains(addList);
        }

    }
}
