﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Speech.Synthesis;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            Control.CheckForIllegalCrossThreadCalls = false;
            button1.Enabled = false;

            richTextBox1.BackColor = Color.Black;
            richTextBox1.ForeColor = Color.White;


            Trains.TrainsChanged += Trains_TrainsChanged;
            Seat.SelectSeatsChange += TrainSeat_SelectSeatsChange;
            Thread12306.ShowMessage += Thread12306_Message;
            TranTime.TimeChanged += TranTime_TimeChanged;
            Thread12306.ThreadClosed += Thread12306_ThreadClosed;

            ThreadPool.QueueUserWorkItem((m) =>
            {
                Thread.Sleep(500);
                ShowMessage("正在初始化...", false);
                _12306Class.GetMainPage(cookie: new CookieCollection());
                ShowMessage("完成");
                GetLoginImage();

                //  先获取车站信息
                var v = Stations.List;
            });

        }

        void Thread12306_Message(object sender, List<Message> e)
        {
            ShowMessage(e);
        }

        void Thread12306_ThreadClosed(object sender, EventArgs e)
        {
            button12.Enabled = false;
            button7.Enabled = true;
        }

        void TranTime_TimeChanged(object sender, List<string> e)
        {
            listBox2.Items.Clear();

            foreach (var VARIABLE in e)
            {
                listBox2.Items.Add(VARIABLE);
            }
        }



        void TrainSeat_SelectSeatsChange(object sender, List<SeatsType> e)
        {
            listBox1.Items.Clear();
            foreach (var seatsType in e)
            {
                listBox1.Items.Add(seatsType);
            }
        }

        void Trains_TrainsChanged(object sender, List<Train> e)
        {
            checkedListBox2.Items.Clear();
            foreach (var train in e)
            {
                checkedListBox2.Items.Add(train);
            }

        }

        /// <summary>
        /// 获取登录验证码
        /// </summary>
        private void GetLoginImage()
        {
            ShowMessage("正在获取验证码...", false);
            Thread12306.Stop();
            ChangeOtherButton(false);
            button1.Enabled = false;
            button2.Enabled = false;
            button12.Enabled = false;

            Bitmap v = null;
            do
            {
                v = _12306Class.GetLoginImage();
            } while (v == null);
            pictureBox1.Image = v;
            
            button1.Enabled = true;
            button2.Enabled = true;

            ShowMessage("完成");


            //ImageFrom.GetImageFrom.Show(v);


            //string str = ImageFrom.GetImageFrom.Code;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            System.Threading.ThreadPool.QueueUserWorkItem((m) =>
                {
                    ShowMessage("正在登录...", false);
                    button1.Enabled = false;

                    var v = _12306Class.Login(textBox1.Text, textBox2.Text, textBox3.Text);
                    if (v.IsLogined)
                    {
                        ShowMessage("成功  ");
                        ShowMessage(string.Format("{0}  您好！",v.LoginName));
                        GetFavoriteContacts();
                        ChangeOtherButton(true);

                    }
                    else
                    {
                        ShowMessage("失败");
                        MessageBox.Show(v.Message);
                        button1.Enabled = true;

                        if (v.type == ErrorType.VerificationError)
                        {
                            textBox3.Text = "";
                            GetLoginImage();
                        }
                    }
                });
        }

        void ChangeOtherButton(bool enabled)
        {
            button3.Enabled = enabled;
            button4.Enabled = enabled;
            button5.Enabled = enabled;
            button6.Enabled = enabled;
            button7.Enabled = enabled;
        }

        List<Contact> listContact = new List<Contact>();

        /// <summary>
        /// 获取联系人信息
        /// </summary>
        private void GetFavoriteContacts()
        {
            ShowMessage("正在获取常用联系人...",false);
            int count = 0;
            int pageSize = 7;
            int pageIndex = 0;
            ;
            do
            {
                listContact.AddRange(_12306Class.GetFavoriteContacts());

                checkedListBox1.DataSource = listContact;

            } while ((pageIndex + 1) * pageSize < count);

            ShowMessage("完成");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            button2.Enabled = false;
            ThreadPool.QueueUserWorkItem((m) =>
            {
                GetLoginImage();
            });
        }

        private void button4_Click(object sender, EventArgs e)
        {
            GetFavoriteContacts();
        }

        private void groupBox2_Enter(object sender, EventArgs e)
        {

        }

        private void button3_Click(object sender, EventArgs e)
        {
            new CreateFavoriteContactFrom().ShowDialog();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            new GetTrainsFrom().ShowDialog();
        }

        private void button6_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < checkedListBox2.Items.Count; i++)
            {
                checkedListBox2.SetItemCheckState(i, CheckState.Checked);
            }
        }


        private void ShowMessage(string message, bool isNewLine = true)
        {
            try
            {

                this.Invoke(new Action<string, bool>((m, n) => { _ShowMessage(m, n); }), message, isNewLine);
            }
            catch (Exception)
            {
                
            }

        }
        private void _ShowMessage(string message, bool isNewLine = true)
        {
            try
            {
                richTextBox1.ForeColor = Color.White;
                richTextBox1.AppendText(string.Format("{0},{1}", DateTime.Now.ToString("HH:mm:ss"), message));
                if (isNewLine)
                {
                    richTextBox1.AppendText("\r\n");
                }

                richTextBox1.SelectionStart = richTextBox1.TextLength;
                richTextBox1.ScrollToCaret();
            }
            catch (Exception)
            {

            }
        }

        private void ShowMessage(List<Message> messages)
        {
            this.Invoke(new Action<List<Message>>((m) => { _ShowMessage(m); }), messages);

        }
        private void _ShowMessage(List<Message> messages)
        {
            try
            {
                richTextBox1.ForeColor = Color.White;
                richTextBox1.AppendText(string.Format("{0},", DateTime.Now.ToString("HH:mm:ss")));
                foreach (var message in messages)
                {
                    int p1 = richTextBox1.TextLength;  //取出未添加时的字符串长度。   
                    richTextBox1.AppendText(string.Format("{0},", message.Msg));  //保留每行的所有颜色。 //  rtb.Text += strInput + "/n";  //添加时，仅当前行有颜色。   
                    int p2 = string.Format("{0},", message.Msg).Length;  //取出要添加的文本的长度   
                    richTextBox1.Select(p1, p2);        //选中要添加的文本   
                    richTextBox1.SelectionColor = message.ForeColor;  //设置要添加的文本的字体色  
                }

                richTextBox1.AppendText("\r\n");

                richTextBox1.SelectionStart = richTextBox1.TextLength;
                richTextBox1.ScrollToCaret();
            }
            catch (Exception)
            {

            }
        }


        public void button7_Click(object sender, EventArgs e)
        {
            Thread12306.Stop();

            if (checkedListBox2.CheckedItems.Count <= 0)
            {
                MessageBox.Show("请选择列车");
                return;
            }

            if (listBox2.Items.Count <= 0)
            {
                MessageBox.Show("请选择乘车时间");
                return;
            }

            if (listBox1.Items.Count <= 0)
            {
                MessageBox.Show("请选择坐席");
                return;
            }

            if (checkedListBox2.CheckedItems.Count > 1 && listBox2.Items.Count > 1)
            {
                MessageBox.Show("选择多辆列车时，仅能选择一天乘车日期。");
                return;
            }

            List<string> times = new List<string>();

            object[] objs = new object[5];
            objs[0] = TranTime.GetTimes();
            objs[1] = checkedListBox2.CheckedItems;
            objs[2] = Seat.GetSeats();
            objs[3] = this;
            objs[4] = checkedListBox1.CheckedItems;

            button7.Enabled = false;

            ThreadPool.QueueUserWorkItem((m) =>
                {
                    bool b;
                    do
                    {
                        b = Thread12306.Start(objs);
                        Thread.Sleep(500);
                    } while (!b);

                    button12.Enabled = true;
                });
        }

        private void button8_Click(object sender, EventArgs e)
        {
            new SelectTrainSeatForm().ShowDialog();
        }

        private void button9_Click(object sender, EventArgs e)
        {
            Seat.ClearSelectSeats();
        }

        private void button11_Click(object sender, EventArgs e)
        {
            TranTime.Clear();
        }

        private void button10_Click(object sender, EventArgs e)
        {
            new TranTimeForm().ShowDialog();
        }

        public void button12_Click(object sender, EventArgs e)
        {
            button12.Enabled = false;
            Thread12306.Stop();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            Thread12306.Stop();
        }

        private void groupBox1_Enter(object sender, EventArgs e)
        {

        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }
    }

    class Thread12306
    {
        static bool start = true;
        static bool end = true;

        static Thread thread = null;

        public static void Stop()
        {
            start = false;

            if (thread != null && ShowMessage != null)
            {
                ShowMessage(null, new List<Message>() { new Message(string.Format("线程{0}正在停止...", thread.ManagedThreadId, Color.Red)) });
            }
        }

        public static bool Start(object obj)
        {
            if (!end)
            {
                return end;
            }

            start = true;

            thread = new Thread(ThreadStart());
            ShowMessage(null, new List<Message>() { new Message(string.Format("线程{0}开始...", thread.ManagedThreadId)) });
            thread.Start(obj);


            end = false;

            return true;
        }

        public static event EventHandler<List<Message>> ShowMessage;
        public static event EventHandler ThreadClosed;

        private static ParameterizedThreadStart ThreadStart()
        {
            int m = 6 * 100;
            int n = 0;
            return (o) =>
            {

                object[] objs = o as object[];

                var times = objs[0] as List<string>;

                var checkedItemCollection = objs[1] as CheckedListBox.CheckedItemCollection;

                var Seats = objs[2] as List<SeatsType>;

                var from1 = objs[3] as Form1;

                var checkedPeople = objs[4] as CheckedListBox.CheckedItemCollection;

                List<Train> selectTrainList = new List<Train>();

                foreach (Train v in checkedItemCollection)
                {
                    selectTrainList.Add(v);
                }

                List<Contact> selectContactList = new List<Contact>();

                foreach (Contact v in checkedPeople)
                {
                    selectContactList.Add(v);
                }

                while (start)
                {
                    foreach (var time in times)
                    {
                        n = 0;
                        var tempTrainList = _12306Class.GetTrains(time
                                         , _12306Class.From.Code
                                         , _12306Class.To.Code);


                        if (tempTrainList == null || tempTrainList.Count == 0)
                        {
                            ShowMessage(null, new List<Message>() { new Message("系统异常", Color.Red) });
                            return;
                        }

                        bool hasTask = false;

                        foreach (Train train in selectTrainList)
                        {
                            if (hasTask)
                            {
                                break;
                            }

                            var tempTrain = tempTrainList.SingleOrDefault(fun => fun.TrainValue == train.TrainValue);


                            if (tempTrain == null)
                            {
                                ShowMessage(null,
                                    new List<Message>() {new Message("车次（" + train.TrainValue + "）不存在", Color.Yellow)});
                                continue;
                            }

                            List<Message> listMessage = new List<Message>();

                            listMessage.Add(new Message("正在检查"));
                            listMessage.Add(new Message(train.TrainValue, Color.Yellow));
                            listMessage.Add(new Message(".."));

                            ShowMessage(null, listMessage);

                            listMessage.Clear();

                            foreach (SeatsType trainSeat in Seats)
                            {
                                if (hasTask)
                                {
                                    break;
                                }
                                switch (trainSeat)
                                {
                                    case SeatsType.商务座:
                                        hasTask = HasTask(train.SWZ);
                                        break;
                                    case SeatsType.特等座:
                                        hasTask = HasTask(train.TZ);
                                        break;
                                    case SeatsType.一等座:
                                        hasTask = HasTask(train.ZY);
                                        break;
                                    case SeatsType.二等座:
                                        hasTask = HasTask(train.ZE);
                                        break;
                                    case SeatsType.高级软卧:
                                        hasTask = HasTask(train.GR);
                                        break;
                                    case SeatsType.软卧:
                                        hasTask = HasTask(train.RW);
                                        break;
                                    case SeatsType.硬卧:
                                        hasTask = HasTask(train.YW);
                                        break;
                                    case SeatsType.软座:
                                        hasTask = HasTask(train.RZ);
                                        break;
                                    case SeatsType.硬座:
                                        hasTask = HasTask(train.YZ);
                                        break;
                                    case SeatsType.无座:
                                        hasTask = HasTask(train.WZ);
                                        break;
                                }


                                if (hasTask)
                                {
                                    ShowMessage(null,
                                        new List<Message>() {new Message(trainSeat.ToString() + ":" + "有..")});

                                    if (checkedPeople.Count <= 0)
                                    {
                                        ShowMessage(null,
                                            new List<Message>() { new Message("未选择常用联系人，不进行预订。",Color.Yellow) });
                                        //如果未选择常用联系人，则不订票
                                        hasTask = false;
                                    }
                                }
                                else
                                {
                                    ShowMessage(null,
                                        new List<Message>() {new Message(trainSeat.ToString() + ":" + "无..")});
                                }

                                if (hasTask)
                                {
                                   // from1.button12_Click(null, null);

                                    hasTask = GetTask(train, time, trainSeat, selectContactList);

                                    if (hasTask)
                                    {
                                        from1.button12_Click(null, null);
                                    }
                                }
                            }


                            ShowMessage(null, listMessage);
                        }

                        //foreach (SeatsType trainSeat in selectTrainList)
                        //{
                        //    var seat = _trainSeat.List.SingleOrDefault(fun => fun.Name == trainSeat.ToString() && fun.Count != "无");
                        //    if (seat != null)
                        //    {
                        //        HasTask(_trainSeat, time, seat);

                        //        break;
                        //    }
                        //}
                        while (start && n < m)
                        {
                            n++;
                            Thread.Sleep(10);
                        }
                    }
                }


                end = true;
                ShowMessage(null, new List<Message>() { new Message(string.Format("线程{0}已经停止...", thread.ManagedThreadId)) });
                if (ThreadClosed != null)
                {
                    ThreadClosed(null, null);
                }
            };
        }

        private static bool HasTask(string num)
        {
            try
            {
                var i = Convert.ToInt32(num);
                return true;
            }
            catch (Exception)
            {
                if (num == "有")
                {
                    return true;
                }
            }

            return false;
        }

        private static bool GetTask(Train train, string date, SeatsType seat, List<Contact> selectContactList)
        {
            ShowMessage(null, new List<Message>() { new Message("开始抢票...",Color.Yellow) });
            var v = _12306Class.GetTask(train, date, seat,selectContactList);

            if (!v.IsCreate)
            {
               // MessageBox.Show(v.Message);


                ShowMessage(null,new List<Message>() { new Message("抢票失败..."+v.Message,Color.Red) });
            }
            else
            {
                ShowMessage(null, new List<Message>() { new Message("抢票  ...", Color.Yellow), new Message(v.Message, Color.Red) });
            }

            return v.IsCreate;
        }

        private static void HasTask(TrainSeat train, string data, Seat seat)
        {


            if (ShowMessage != null)
            {
                ShowMessage(null, new List<Message>() { new Message(string.Format("{0},{1},{2}有票", train.ToString(), data, seat.Name), Color.Yellow) });

                MessageBox.Show("有票啦。。。。" + seat.Name);


                ThreadPool.QueueUserWorkItem((m) =>
                {
                    SpeechSynthesizer synthesizer = new SpeechSynthesizer();

                    PromptBuilder promptBuilder = new PromptBuilder();

                    promptBuilder.AppendText("Train tickets! I can go home!");

                    synthesizer.SpeakAsync(promptBuilder);

                });
            }
        }
    }

    class Message
    {
        private Color _ForeColor;
        public Color ForeColor
        {
            get { return _ForeColor; }
        }

        private string _Msg;
        public string Msg
        {
            get { return _Msg; }
        }

        public Message(string message)
            : this(message, Color.White)
        {
        }

        public Message(string message, Color color)
        {
            _Msg = message;
            _ForeColor = color;
        }
    }
}
