CONTRIBUTING
============

If you intend to contribute to this project, please keep some simple rules in
mind:

    - one commit per feature/fix
    - the short commit message shouldn't be longer than 50 characters
    - the short commit message should start with an uppercase character
    - use the imperative for the short commit message
    - don't finish the short commit message with a '.'
    - don't use github-specific syntax to close an issue (I'll do that, when
      merging into master)
    - it's always a good idea to have a look at 'git log' to get an idea how to
      format one's own commits
    - if you have questions about a certain patch or feature requests, just open
      a Github issue

Examples
--------

```
Bad:  "fixed loop to start from 0 instead of 1"
Good: "Avoid off-by-one issue in skiplist loop"

Bad:  "fixed typo"
Good: "Docs: typo"
```
