## About

This repository contains JavaScript implementations of famous computer science algorithms.

API reference with usage examples available
<a href="https://mgechev.github.io/javascript-algorithms/" target="_blank">here</a>.

## Development

**To install all dev dependencies**

Call:

```bash
npm install
```

**To setup repository with documentation**

```bash
npm run doc
```

This will build the documentation and open it in your browser.

**To update .html files with documentation**

Just run `npm run doc` again.

**To run tests**

Call:

```bash
npm run test
```

This will execute all `*.spec.js` files.

**To deploy documentation site**

```bash
npm run deploy
```

This requires you to have commit access to your Git remote.

## Contributions

Fork the repo and make required changes. Afterwards, push your changes in branch. The name will be according to the changes you did. Initiate the pull request.

Make sure your editor makes validations according to the `.jshintrc` in the root directory of the repository.

Before pushing to the repository, run:

```bash
npm run build
```

If the build is not successful, fix your code in order for the tests and jshint validation to run successfully. Then create a pull request.

## Contributors

[<img alt="mgechev" src="https://avatars1.githubusercontent.com/u/455023?v=4&s=117" width="117">](https://github.com/mgechev) |[<img alt="AndriiHeonia" src="https://avatars1.githubusercontent.com/u/773648?v=4&s=117" width="117">](https://github.com/AndriiHeonia) |[<img alt="Jakehp" src="https://avatars1.githubusercontent.com/u/1854569?v=4&s=117" width="117">](https://github.com/Jakehp) |[<img alt="lygstate" src="https://avatars3.githubusercontent.com/u/121040?v=4&s=117" width="117">](https://github.com/lygstate) |[<img alt="mik-laj" src="https://avatars1.githubusercontent.com/u/12058428?v=4&s=117" width="117">](https://github.com/mik-laj) |[<img alt="krzysztof-grzybek" src="https://avatars0.githubusercontent.com/u/6236664?v=4&s=117" width="117">](https://github.com/krzysztof-grzybek) |
:---: |:---: |:---: |:---: |:---: |:---: |
[mgechev](https://github.com/mgechev) |[AndriiHeonia](https://github.com/AndriiHeonia) |[Jakehp](https://github.com/Jakehp) |[lygstate](https://github.com/lygstate) |[mik-laj](https://github.com/mik-laj) |[krzysztof-grzybek](https://github.com/krzysztof-grzybek) |

[<img alt="pvoznenko" src="https://avatars3.githubusercontent.com/u/1098414?v=4&s=117" width="117">](https://github.com/pvoznenko) |[<img alt="jettcalleja" src="https://avatars0.githubusercontent.com/u/6356258?v=4&s=117" width="117">](https://github.com/jettcalleja) |[<img alt="filipefalcaos" src="https://avatars2.githubusercontent.com/u/9125631?v=4&s=117" width="117">](https://github.com/filipefalcaos) |[<img alt="kdamball" src="https://avatars3.githubusercontent.com/u/3318312?v=4&s=117" width="117">](https://github.com/kdamball) |[<img alt="lekkas" src="https://avatars3.githubusercontent.com/u/5211478?v=4&s=117" width="117">](https://github.com/lekkas) |[<img alt="infusion" src="https://avatars3.githubusercontent.com/u/197742?v=4&s=117" width="117">](https://github.com/infusion) |
:---: |:---: |:---: |:---: |:---: |:---: |
[pvoznenko](https://github.com/pvoznenko) |[jettcalleja](https://github.com/jettcalleja) |[filipefalcaos](https://github.com/filipefalcaos) |[kdamball](https://github.com/kdamball) |[lekkas](https://github.com/lekkas) |[infusion](https://github.com/infusion) |

[<img alt="deniskyashif" src="https://avatars2.githubusercontent.com/u/5999271?v=4&s=117" width="117">](https://github.com/deniskyashif) |[<img alt="brunohadlich" src="https://avatars2.githubusercontent.com/u/7043013?v=4&s=117" width="117">](https://github.com/brunohadlich) |[<img alt="designeng" src="https://avatars0.githubusercontent.com/u/2807469?v=4&s=117" width="117">](https://github.com/designeng) |[<img alt="Microfed" src="https://avatars1.githubusercontent.com/u/613179?v=4&s=117" width="117">](https://github.com/Microfed) |[<img alt="Nirajkashyap" src="https://avatars3.githubusercontent.com/u/4338110?v=4&s=117" width="117">](https://github.com/Nirajkashyap) |[<img alt="pkerpedjiev" src="https://avatars3.githubusercontent.com/u/2143629?v=4&s=117" width="117">](https://github.com/pkerpedjiev) |
:---: |:---: |:---: |:---: |:---: |:---: |
[deniskyashif](https://github.com/deniskyashif) |[brunohadlich](https://github.com/brunohadlich) |[designeng](https://github.com/designeng) |[Microfed](https://github.com/Microfed) |[Nirajkashyap](https://github.com/Nirajkashyap) |[pkerpedjiev](https://github.com/pkerpedjiev) |

[<img alt="duffman85" src="https://avatars0.githubusercontent.com/u/15054422?v=4&s=117" width="117">](https://github.com/duffman85) |[<img alt="Xuefeng-Zhu" src="https://avatars0.githubusercontent.com/u/5875315?v=4&s=117" width="117">](https://github.com/Xuefeng-Zhu) |[<img alt="emyarod" src="https://avatars3.githubusercontent.com/u/8265238?v=4&s=117" width="117">](https://github.com/emyarod) |[<img alt="alexjoverm" src="https://avatars3.githubusercontent.com/u/5701162?v=4&s=117" width="117">](https://github.com/alexjoverm) |[<img alt="amilajack" src="https://avatars1.githubusercontent.com/u/6374832?v=4&s=117" width="117">](https://github.com/amilajack) |[<img alt="BorislavBorisov22" src="https://avatars2.githubusercontent.com/u/20156662?v=4&s=117" width="117">](https://github.com/BorislavBorisov22) |
:---: |:---: |:---: |:---: |:---: |:---: |
[duffman85](https://github.com/duffman85) |[Xuefeng-Zhu](https://github.com/Xuefeng-Zhu) |[emyarod](https://github.com/emyarod) |[alexjoverm](https://github.com/alexjoverm) |[amilajack](https://github.com/amilajack) |[BorislavBorisov22](https://github.com/BorislavBorisov22) |

[<img alt="brunob15" src="https://avatars2.githubusercontent.com/u/5839627?v=4&s=117" width="117">](https://github.com/brunob15) |[<img alt="BryanChan777" src="https://avatars0.githubusercontent.com/u/43082778?v=4&s=117" width="117">](https://github.com/BryanChan777) |[<img alt="ysharplanguage" src="https://avatars0.githubusercontent.com/u/1055314?v=4&s=117" width="117">](https://github.com/ysharplanguage) |[<img alt="jurassix" src="https://avatars3.githubusercontent.com/u/1869117?v=4&s=117" width="117">](https://github.com/jurassix) |[<img alt="fisenkodv" src="https://avatars0.githubusercontent.com/u/1039447?v=4&s=117" width="117">](https://github.com/fisenkodv) |[<img alt="contra" src="https://avatars0.githubusercontent.com/u/425716?v=4&s=117" width="117">](https://github.com/contra) |
:---: |:---: |:---: |:---: |:---: |:---: |
[brunob15](https://github.com/brunob15) |[BryanChan777](https://github.com/BryanChan777) |[ysharplanguage](https://github.com/ysharplanguage) |[jurassix](https://github.com/jurassix) |[fisenkodv](https://github.com/fisenkodv) |[contra](https://github.com/contra) |

[<img alt="liesislukas" src="https://avatars3.githubusercontent.com/u/2733862?v=4&s=117" width="117">](https://github.com/liesislukas) |[<img alt="marrcelo" src="https://avatars3.githubusercontent.com/u/18054556?v=4&s=117" width="117">](https://github.com/marrcelo) |[<img alt="wnvko" src="https://avatars3.githubusercontent.com/u/5990334?v=4&s=117" width="117">](https://github.com/wnvko) |[<img alt="millerrach" src="https://avatars2.githubusercontent.com/u/12432794?v=4&s=117" width="117">](https://github.com/millerrach) |[<img alt="xiedezhuo" src="https://avatars3.githubusercontent.com/u/39017209?v=4&s=117" width="117">](https://github.com/xiedezhuo) |[<img alt="DengYiping" src="https://avatars0.githubusercontent.com/u/12176046?v=4&s=117" width="117">](https://github.com/DengYiping) |
:---: |:---: |:---: |:---: |:---: |:---: |
[liesislukas](https://github.com/liesislukas) |[marrcelo](https://github.com/marrcelo) |[wnvko](https://github.com/wnvko) |[millerrach](https://github.com/millerrach) |[xiedezhuo](https://github.com/xiedezhuo) |[DengYiping](https://github.com/DengYiping) |

[<img alt="fanixk" src="https://avatars2.githubusercontent.com/u/921156?v=4&s=117" width="117">](https://github.com/fanixk) |[<img alt="wlx199x" src="https://avatars1.githubusercontent.com/u/6756730?v=4&s=117" width="117">](https://github.com/wlx199x) |[<img alt="shaunak1111" src="https://avatars3.githubusercontent.com/u/1323960?v=4&s=117" width="117">](https://github.com/shaunak1111) |
:---: |:---: |:---: |
[fanixk](https://github.com/fanixk) |[wlx199x](https://github.com/wlx199x) |[shaunak1111](https://github.com/shaunak1111) |

## License

The code in this repository is distributed under the terms of the MIT license.

