# Google Art Downloader

```
Project is archived and read-only fot now
```

Cross-platform utility allows you to save all images from [Google Art Project](https://artsandculture.google.com) in high quality (up to 4K).

![screenshot](https://user-images.githubusercontent.com/15357833/144015262-a51e5260-7d81-40eb-b106-9faa9fc5ae1b.png)

⭐ It works perfectly from 2018 year till today, thanks for stars!

---

## Usage

1. Just download a zip archive with binaries from [releases](https://github.com/mewforest/google-art-downloader/releases), unzip it to any
folder and run **google-art-downloader.exe**.
2. Use button **"Paste url"** or `CTRL+V` to paste your url and click **"Download"** to start the image processing.

See [Running with Python](#running-with-python) section, if are running on Linux or macOS.

## Requirements

Compiled release requires just connection to the Internet and Chrome installed (should be added in PATH).

## Running from the source

### <a name="running-with-python"></a> Running with Python

> This method is also suit for you if you don't use Windows.

If you want co compile your own version or use it without downloading compiled files:

1. Install Python 3.8+ and add interpreter to PATH
2. Install Google Chrome or Chromium and add executable to PATH
3. Install all project dependencies:
   ```shell
   python -m pip install -r requirements.txt
   ```
4. **Only for Linux and MacOS**: be sure you make webdrivers from `bin` executables.
   - Linux:
    ```shell
    chmod +x bin/chromedriver_linux64/chromedriver
    ```
    - MacOS:
    ```shell
    chmod +x bin/chromedriver_mac64/chromedriver
    ```
5. Done! You have to just run a script:
    ```shell
    python GoogleArtDownloader.py
    ```
   
### Compiling to executable 
If you need to compile it with PyInstaller for Windows, follow this instructions:
1. Change source code of installed Selenium to disable Selenium terminal showing 
  (it's a [common bug](https://stackoverflow.com/a/46543874/8363830) by the way):
  
   - Open file: `<your-path-to-python>\Lib\site-packages\selenium\webdriver\common\service.py`. 
   - In opened file override method placed in `selenium.webdriver.common.service.Service`:
      ```python
      self.process = subprocess.Popen(cmd, env=self.env,
                                             close_fds=platform.system() != 'Windows',
                                             stdout=self.log_file,
                                             stderr=self.log_file,
                                             stdin=PIPE,
                                             )
      ```
      To this:
       ```python
       self.process = subprocess.Popen(cmd, stdin=PIPE, stdout=PIPE, stderr=PIPE, creationflags=0x08000000)
       ```
2.  After changes above, execute commands below to compile it:
   ```shell
   python -m pip install pyinstaller --upgrade
   python -m PyInstaller --onefile --noconsole --icon=favicon.ico .\GoogleArtDownloader.py
   ```
3. Copy `bin` folder to `dist`.
4. Done! Congratulations, your compiled script is ready to use in `dist` folder.

## Status of project

Deprecated, please use alternatives.

This utility doesn't download a maximum possible resolution of the image you provide.
It's because of webdriver screenshot limitation. If you really need the **maximum possible quality**, see alternatives section 
or feel free to improve this script with pull request. 

## Alternatives
If you are interested in more highest image resolution or Selenium webdriver isn't starting well, you could use alternatives:
- [dezoomify](https://ophir.alwaysdata.net/dezoomify/dezoomify.html) (works online),
- [dezoomify-rs](https://github.com/lovasoa/dezoomify-rs) (a command-line application for windows, linux and macos),
- [gapdecoder](https://github.com/gap-decoder/gapdecoder) (a python script) instead.

