## Bitcoin Market 💰
Bitcoin Market app shows you the current Bitcoin market price and price chart of different time intervals

## Tech stack and whys 🏗
* [Kotlin](https://kotlinlang.org/) - Google officially supports Kotlin on Android as a “first-class” language and it has [a lot of benefits](https://developer.android.com/kotlin)
* [MVVM Architecture](https://developer.android.com/jetpack/guide) - Modern, maintainable, and Google suggested app architecture
* [Dagger Hilt](https://dagger.dev/hilt/) - Easy implementation and less boilerplate code than Dagger2
* [Coroutine](https://developer.android.com/kotlin/coroutines) & [Flow](https://developer.android.com/kotlin/flow)
* [Retrofit](https://square.github.io/retrofit/)
* [OkHttp](https://square.github.io/okhttp/)
* [Moshi](https://github.com/square/moshi)
* [Jetpack Components](https://developer.android.com/jetpack) - Compose, ViewModel and more
* [MPAndroidChart](https://github.com/PhilJay/MPAndroidChart)
* [Lottie](https://github.com/airbnb/lottie-android)
* [Truth](https://truth.dev/) & [Mockk](https://mockk.io/) - For more readable unit tests

## Screenshots 📷
<img src="/arts/splash-screen.png" width="260"> &emsp;<img src="/arts/market-screen.png" width="260"> &emsp;<img src="/arts/market-screen-dark.png" width="260">

## Contribution 🙌
All contributions are welcome! Feel free to jump to the issues and pick one for yourself! Please write a comment inside of the issue before you start working.

## Contributors 👏
* [abdalla19977](https://github.com/abdalla19977)
* [masreplay](https://github.com/masreplay)
* [okanaydin](https://github.com/okanaydin)
* [boranfrkn](https://github.com/boranfrkn)
* [yagmurerdogan](https://github.com/yagmurerdogan)
* [mustafayigitt](https://github.com/mustafayigitt)
* [ozgurg](https://github.com/ozgurg)
* [Kardelio](https://github.com/Kardelio)
* [barissaglam](https://github.com/barissaglam)
* [enofeb](https://github.com/enofeb)
* [halilozel1903](https://github.com/halilozel1903)

## Credits 🙏
* Thanks to [CoinMarketCap](https://play.google.com/store/apps/details?id=com.coinmarketcap.android&hl=en&gl=US) for the design
* Thanks to [Rohith R Krishnan](https://lottiefiles.com/24693-coin-falling-animation) for the loading animation
