#!/bin/bash

# <bitbar.title>Currency Price</bitbar.title>
# <bitbar.version>v1.0</bitbar.version>
# <bitbar.author>Mehdi Chaouch</bitbar.author>
# <bitbar.author.github>mehdichaouch</bitbar.author.github>
# <bitbar.desc>Display currency price and crypto price using Coinbase and Revolut.</bitbar.desc>
# <bitbar.image>💹</bitbar.image>
# <xbar.dependencies>bash sed curl jq<xbar.dependencies>

# Quick On/Off
IS_DISABLE=false
if [ "$IS_DISABLE" == "true" ]; then
  echo "_" && echo "---"
  echo "🟢 On | bash='sed -i -e \"1 s/IS_DISABLE=true/IS_DISABLE=false/; t\" -e \"1,// s//IS_DISABLE=false/\" $0' terminal=false"
  exit
fi

##############################################################################################################
# Crypto ₿

bitcoinIconBase64="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"
ethIconBase64="iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAACXBIWXMAABYlAAAWJQFJUiTwAAAC/UlEQVRYw+WYX6gMcRTH997158GD/7Z7mzm/8/vN7KZNN1ohL+vBG+GmyN8Hrrh0S3nQxQPPIg9S8i9SJEUePVGKuOF6Q0qkkD9JQv6M7xmzzO6dXcvO7JJbp+bOTr/zmXO+55zfb1Ke56X+Jkv980D1/GnS8zXRPFy21/N8okDGmEnG5luOUjsN8/qWAznERx2bHgqQo/jl5M7O8S0DcpWaBYivISDPKHWoVUDtABgQiDCQAGaZZzYdCJHYEABUAokN1BJ47ECiE9FLDSBPK9XbNCA4Oxh2HgUEe5XryE1IHMjYZjqcfakDCPf5SNJAbYbo2lDHVYAgcKnExIBcorURTmsBedrmm5UCjwWIiMZiPDyPdEp8Drpajut3kcBEm2IHMor3l785fQTEcehkAaLTD1ukLLUM9/phjyu09Np13YmxAWWVmoqFPwfpeSrpQbQWoxdd8AUeThnR3Sxxn8O8GjPu6s8o8bG4gNqw4BV/gGrdA0frAHD7lxpCVAC8G88vBMwpiShgZzcMlCPSkg7YLjh+9ruilsgC7IxjYQ3mpQ0DyRvi7T5UcVYPUNhOgifdsIZc5iLCPfinQBD5W6R8az6fH9F4hBzHDrSYRpPbWDbD6miMSNcJtIwOf+8UrNUQkCyGijoPmGmymGVZ4yDSAz+qriqQulHq0thVjsb/+1zSK2Mpe7xlt5S3DNXSwNRad2GMXBoCBOHjuTVSnWJyHRTD2bgb4+HSFEeE+iSFfhpsXgKwywDaZoj3SDT83oVNGu5d/76L5CcS2ViBujKZUXBwL5SSO7A58lsxVRwmFkQuI03Q39oGOsKpZG4iwxXOZiAFn8JakR6DqFChUBgOwC1oEW/Kfifem+x+iHhHRFnfB8z2iKE6iBk2MukdY1pGSR2j472xzJSmbGGVUlyWmgggpHJzU08dEO6q6kDqYlD2zT0oomGergTSil+UOnPTgZC6MYB6VHFy7W7t2R69CFF54H9sQPNs+ceG4JzWi0itkOaZONB/9wXtG+MF7xgwhWr8AAAAAElFTkSuQmCC"
bnbIconBase64="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"
dogeIconBase64="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"
xrpIconBase64="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"
adaIconBase64="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"
ltcIconBase64="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"
neoIconBase64="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"
xmrIconBase64="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"
dashIconBase64="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"

# BTC
btc_spot_price_eur=$(curl -s "https://api.coinbase.com/v2/prices/BTC-EUR/spot" -H "CB-VERSION: 2017-04-16" | egrep -o '[0-9]+(\.)[0-9]*')
btc_buy_price_eur=$(curl -s "https://api.coinbase.com/v2/prices/BTC-EUR/buy" -H "CB-VERSION: 2017-04-16" | egrep -o '[0-9]+(\.)[0-9]*')
btc_sell_price_eur=$(curl -s "https://api.coinbase.com/v2/prices/BTC-EUR/sell" -H "CB-VERSION: 2017-04-16" | egrep -o '[0-9]+(\.)[0-9]*')
btc_spot_price_usd=$(curl -s "https://api.coinbase.com/v2/prices/BTC-USD/spot" -H "CB-VERSION: 2017-04-16" | egrep -o '[0-9]+(\.)[0-9]*')
btc_buy_price_usd=$(curl -s "https://api.coinbase.com/v2/prices/BTC-USD/buy" -H "CB-VERSION: 2017-04-16" | egrep -o '[0-9]+(\.)[0-9]*')
btc_sell_price_usd=$(curl -s "https://api.coinbase.com/v2/prices/BTC-USD/sell" -H "CB-VERSION: 2017-04-16" | egrep -o '[0-9]+(\.)[0-9]*')

##############################################################################################################
# REVOLUT 💹

upIconBase64='iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QAyQACAALwzISXAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AQHACkSBTjB+AAAALNJREFUOMvVk70NAjEMhb87WYiGBZAQU7ABNSVSWpZgEEagsJDoKBELUCEKFuBuCKTw0xyQC0lICe5i+/k9/wT+3opUUJQhcAUqa8I5ZQT4tANwioGTCkQZA9vmOQE2oUJFhL0DXBz33RpKUfCLfLTQJMx9IlEWuQr6QB3prGtNS1lwiMvEYo7ekNsKRBkB+y+rH1hDFVOwy7ids+gbVzrsM6CXeYDTF85xroB1ZoHb73ymB5RhJkpZTihGAAAAAElFTkSuQmCC'
downIconBase64='iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QABACnAADQ9FZaAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AQHACQ1FZwK3gAAAMRJREFUOMvNkjEKAjEQRZ+jKNjYKh5AbzCdjVcQj+BFPIKlp7EMeAJrUbASQVCEr80uG9cNbqe/Cgn/5WUI/DqNfBHM+kCzbs+lPUAr2pwBq5qABbB+M8gszkDvS/kOdAG5VBgEM4ApsP0CGLukjxlEoA0wSZR3Lo0qhxhZDIBDAmDA0wsBLD51CZeOwLKivHbprZx6AkAHuEXbD5fawYwywMqAzOKeDTTPvKqcTGZBMLsGs0utn5gADYEHcKp9e9ni//MCDtNCE3qjsIwAAAAASUVORK5CYII='

echo $(curl -s 'https://www.revolut.com/api/quote/public/CHFEUR' | $(command -v jq) -r '.rate' | xargs printf "1 CHF = %.5f EUR | color=green\n")
echo $(curl -s 'https://www.revolut.com/api/quote/public/CHFUSD' | $(command -v jq) -r '.rate' | xargs printf "1 CHF = %.5f USD | color=green")

##############################################################################################################
# OTHERS

echo "---"

# BTC
printf "₿ %s \t%.${VAR_DECIMALS}f EUR / %.${VAR_DECIMALS}f USD | color=green\n" "Spot price:" "$btc_spot_price_eur" "$btc_spot_price_usd"
printf "₿ %s \t%.${VAR_DECIMALS}f EUR / %.${VAR_DECIMALS}f USD | color=green\n" "Buy price:" "$btc_buy_price_eur" "$btc_buy_price_usd"
printf "₿ %s \t%.${VAR_DECIMALS}f EUR / %.${VAR_DECIMALS}f USD | color=green\n" "Sell price:" "$btc_sell_price_eur" "$btc_sell_price_usd"

echo "---"
echo "↻ - Refresh | terminal=false refresh=true"
echo "💹 Open TradingView CHFEUR | href=https://fr.tradingview.com/symbols/CHFEUR/?sort=recent"
echo "💹 Open TradingView CHFUSD | href=https://fr.tradingview.com/symbols/CHFUSD/?sort=recent"
echo "💹 Open TradingView BTCEUR | href=https://fr.tradingview.com/symbols/BTCEUR/?sort=recent"

# Quick On/Off
echo "🔴 Off | bash='sed -i -e \"1 s/IS_DISABLE=false/IS_DISABLE=true/; t\" -e \"1,// s//IS_DISABLE=true/\" $0' terminal=false"
