import * as React from "react";
import { cn } from "@palettify/utils";

export interface InputProps extends React.InputHTMLAttributes<HTMLInputElement> {}

const inputBase =
  "border-input placeholder:text-muted-foreground focus-visible:ring-ring flex h-9 w-full rounded-md border bg-transparent px-3 py-1 text-sm shadow-sm transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium focus-visible:outline-none focus-visible:ring-1 disabled:cursor-not-allowed disabled:opacity-50";

const Input = React.forwardRef<HTMLInputElement, InputProps>(
  ({ className, type, ...props }, ref) => {
    return (
      <input type={type} className={cn(inputBase, className)} ref={ref} {...props} />
    );
  }
);
Input.displayName = "Input";

export { Input, inputBase };
