/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.resources.Resource;

public class ObserveRelation {
    private static final Logger LOGGER = Logger.getLogger(ObserveRelation.class.getCanonicalName());
    private final long CHECK_INTERVAL_TIME = NetworkConfig.getStandard().getLong("NOTIFICATION_CHECK_INTERVAL");
    private final int CHECK_INTERVAL_COUNT = NetworkConfig.getStandard().getInt("NOTIFICATION_CHECK_INTERVAL_COUNT");
    private final ObservingEndpoint endpoint;
    private final Resource resource;
    private final Exchange exchange;
    private Response recentControlNotification;
    private Response nextControlNotification;
    private String key = null;
    private boolean established;
    private long interestCheckTimer = System.currentTimeMillis();
    private int interestCheckCounter = 1;
    private ConcurrentLinkedQueue<Response> notifications = new ConcurrentLinkedQueue();

    public ObserveRelation(ObservingEndpoint endpoint, Resource resource, Exchange exchange) {
        if (endpoint == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        if (exchange == null) {
            throw new NullPointerException();
        }
        this.endpoint = endpoint;
        this.resource = resource;
        this.exchange = exchange;
        this.established = false;
        this.key = this.getSource().toString() + "#" + exchange.getRequest().getTokenString();
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void setEstablished(boolean established) {
        this.established = established;
    }

    public void cancel() {
        LOGGER.log(Level.FINE, "Canceling observe relation {0} with {1}", new Object[]{this.getKey(), this.resource.getURI()});
        if (this.exchange.getResponse() != null) {
            this.exchange.getResponse().cancel();
        }
        this.setEstablished(false);
        this.resource.removeObserveRelation(this);
        this.endpoint.removeObserveRelation(this);
        this.exchange.setComplete();
    }

    public void cancelAll() {
        this.endpoint.cancelAll();
    }

    public void notifyObservers() {
        this.resource.handleRequest(this.exchange);
    }

    public Resource getResource() {
        return this.resource;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public InetSocketAddress getSource() {
        return this.endpoint.getAddress();
    }

    public boolean check() {
        boolean check = false;
        check |= this.interestCheckTimer + this.CHECK_INTERVAL_TIME < System.currentTimeMillis();
        if (check |= ++this.interestCheckCounter >= this.CHECK_INTERVAL_COUNT) {
            this.interestCheckTimer = System.currentTimeMillis();
            this.interestCheckCounter = 0;
        }
        return check;
    }

    public Response getCurrentControlNotification() {
        return this.recentControlNotification;
    }

    public void setCurrentControlNotification(Response recentControlNotification) {
        this.recentControlNotification = recentControlNotification;
    }

    public Response getNextControlNotification() {
        return this.nextControlNotification;
    }

    public void setNextControlNotification(Response nextControlNotification) {
        this.nextControlNotification = nextControlNotification;
    }

    public void addNotification(Response notification) {
        this.notifications.add(notification);
    }

    public Iterator<Response> getNotificationIterator() {
        return this.notifications.iterator();
    }

    public String getKey() {
        return this.key;
    }
}

