/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.core.network.serialization.UdpDataParser;
import org.eclipse.californium.core.network.serialization.UdpDataSerializer;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.CorrelationContext;
import org.eclipse.californium.elements.RawData;

public class InMemoryObservationStore
implements ObservationStore {
    private static final DataSerializer serializer = new UdpDataSerializer();
    private Map<Exchange.KeyToken, Observation> map = new ConcurrentHashMap<Exchange.KeyToken, Observation>();

    @Override
    public void add(Observation obs) {
        if (obs != null) {
            this.map.put(new Exchange.KeyToken(obs.getRequest().getToken()), obs);
        }
    }

    @Override
    public Observation get(byte[] token) {
        Observation obs = this.map.get(new Exchange.KeyToken(token));
        if (obs != null) {
            RawData serialize = serializer.serializeRequest(obs.getRequest(), null);
            UdpDataParser parser = new UdpDataParser();
            Request newRequest = (Request)parser.parseMessage(serialize);
            newRequest.setUserContext(obs.getRequest().getUserContext());
            return new Observation(newRequest, obs.getContext());
        }
        return null;
    }

    @Override
    public void remove(byte[] token) {
        this.map.remove(new Exchange.KeyToken(token));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getSize() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public void setContext(byte[] token, CorrelationContext ctx) {
        Observation obs = this.map.get(new Exchange.KeyToken(token));
        if (obs != null) {
            this.map.put(new Exchange.KeyToken(token), new Observation(obs.getRequest(), ctx));
        }
    }
}

