/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.BlockwiseLayer;
import org.eclipse.californium.core.network.stack.CoapStack;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;
import org.eclipse.californium.core.network.stack.ExchangeCleanupLayer;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.network.stack.ObserveLayer;
import org.eclipse.californium.core.network.stack.ReliabilityLayer;
import org.eclipse.californium.core.server.MessageDeliverer;

public class CoapUdpStack
implements CoapStack {
    private static final Logger LOGGER = Logger.getLogger(CoapStack.class.getCanonicalName());
    private List<Layer> layers;
    private Outbox outbox;
    private StackTopAdapter top = new StackTopAdapter();
    private StackBottomAdapter bottom;
    private MessageDeliverer deliverer;

    public CoapUdpStack(NetworkConfig config, Outbox outbox) {
        ReliabilityLayer reliabilityLayer;
        this.outbox = outbox;
        if (config.getBoolean("USE_CONGESTION_CONTROL")) {
            reliabilityLayer = CongestionControlLayer.newImplementation(config);
            LOGGER.log(Level.CONFIG, "Enabling congestion control: {0}", reliabilityLayer.getClass().getSimpleName());
        } else {
            reliabilityLayer = new ReliabilityLayer(config);
        }
        this.bottom = new StackBottomAdapter();
        this.layers = new Layer.TopDownBuilder().add(this.top).add(new ExchangeCleanupLayer()).add(new ObserveLayer(config)).add(new BlockwiseLayer(config)).add(reliabilityLayer).add(this.bottom).create();
    }

    @Override
    public void sendRequest(Request request) {
        this.top.sendRequest(request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        this.top.sendResponse(exchange, response);
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.top.sendEmptyMessage(exchange, message);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        this.bottom.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        this.bottom.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.bottom.receiveEmptyMessage(exchange, message);
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        for (Layer layer : this.layers) {
            layer.setExecutor(executor);
        }
    }

    @Override
    public void setDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
    }

    @Override
    public void destroy() {
        for (Layer layer : this.layers) {
            layer.destroy();
        }
    }

    @Override
    public boolean hasDeliverer() {
        return this.deliverer != null;
    }

    private class StackBottomAdapter
    extends AbstractLayer {
        private StackBottomAdapter() {
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            CoapUdpStack.this.outbox.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            CoapUdpStack.this.outbox.sendResponse(exchange, response);
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
            CoapUdpStack.this.outbox.sendEmptyMessage(exchange, message);
        }
    }

    private class StackTopAdapter
    extends AbstractLayer {
        private StackTopAdapter() {
        }

        public void sendRequest(Request request) {
            Exchange exchange = new Exchange(request, Exchange.Origin.LOCAL);
            this.sendRequest(exchange, request);
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            exchange.setRequest(request);
            super.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            exchange.setResponse(response);
            super.sendResponse(exchange, response);
        }

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            if (exchange.getRequest() == null) {
                exchange.setRequest(request);
            }
            if (CoapUdpStack.this.deliverer != null) {
                CoapUdpStack.this.deliverer.deliverRequest(exchange);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver request");
            }
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            exchange.setComplete();
            if (CoapUdpStack.this.deliverer != null) {
                CoapUdpStack.this.deliverer.deliverResponse(exchange, response);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver response");
            }
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        }
    }
}

