/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.BlockwiseLayer;
import org.eclipse.californium.core.network.stack.CoapStack;
import org.eclipse.californium.core.network.stack.ExchangeCleanupLayer;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.network.stack.ObserveLayer;
import org.eclipse.californium.core.server.MessageDeliverer;

public class CoapTcpStack
implements CoapStack {
    private static final Logger LOGGER = Logger.getLogger(CoapTcpStack.class.getCanonicalName());
    private List<Layer> layers;
    private Outbox outbox;
    private StackTopAdapter top = new StackTopAdapter();
    private StackBottomAdapter bottom;
    private MessageDeliverer deliverer;

    public CoapTcpStack(NetworkConfig config, Outbox outbox) {
        this.outbox = outbox;
        this.bottom = new StackBottomAdapter();
        this.layers = new Layer.TopDownBuilder().add(this.top).add(new ExchangeCleanupLayer()).add(new ObserveLayer(config)).add(new BlockwiseLayer(config)).add(this.bottom).create();
    }

    @Override
    public void sendRequest(Request request) {
        this.top.sendRequest(request);
        request.setAcknowledged(true);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        this.top.sendResponse(exchange, response);
        response.setAcknowledged(true);
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        LOGGER.log(Level.WARNING, "Attempting to send empty message in TCP mode {0}", message);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        request.setAcknowledged(true);
        this.bottom.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        response.setAcknowledged(true);
        this.bottom.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        LOGGER.log(Level.WARNING, "Received empty message in TCP mode {0}", message);
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        for (Layer layer : this.layers) {
            layer.setExecutor(executor);
        }
    }

    @Override
    public void setDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
    }

    @Override
    public void destroy() {
        for (Layer layer : this.layers) {
            layer.destroy();
        }
    }

    @Override
    public boolean hasDeliverer() {
        return this.deliverer != null;
    }

    private class StackBottomAdapter
    extends AbstractLayer {
        private StackBottomAdapter() {
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            CoapTcpStack.this.outbox.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            CoapTcpStack.this.outbox.sendResponse(exchange, response);
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
            CoapTcpStack.this.outbox.sendEmptyMessage(exchange, message);
        }
    }

    private class StackTopAdapter
    extends AbstractLayer {
        private StackTopAdapter() {
        }

        public void sendRequest(Request request) {
            Exchange exchange = new Exchange(request, Exchange.Origin.LOCAL);
            this.sendRequest(exchange, request);
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            exchange.setRequest(request);
            super.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            exchange.setResponse(response);
            super.sendResponse(exchange, response);
        }

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            if (exchange.getRequest() == null) {
                exchange.setRequest(request);
            }
            if (CoapTcpStack.this.hasDeliverer()) {
                CoapTcpStack.this.deliverer.deliverRequest(exchange);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver request");
            }
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            if (!response.getOptions().hasObserve()) {
                exchange.setComplete();
            }
            if (CoapTcpStack.this.hasDeliverer()) {
                CoapTcpStack.this.deliverer.deliverResponse(exchange, response);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver response");
            }
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        }
    }
}

