/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.Layer;

public abstract class AbstractLayer
implements Layer {
    private static final Logger LOGGER = Logger.getLogger(AbstractLayer.class.getCanonicalName());
    private Layer upperLayer;
    private Layer lowerLayer;
    protected ScheduledExecutorService executor;

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (this.lowerLayer != null) {
            this.lowerLayer.sendRequest(exchange, request);
        } else {
            LOGGER.log(Level.SEVERE, "No lower layer set for sending request [{0}]", request);
        }
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        if (this.lowerLayer != null) {
            this.lowerLayer.sendResponse(exchange, response);
        } else {
            LOGGER.log(Level.SEVERE, "No lower layer set for sending response [{0}]", response);
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (this.lowerLayer != null) {
            this.lowerLayer.sendEmptyMessage(exchange, message);
        } else {
            LOGGER.log(Level.SEVERE, "No lower layer set for sending empty message [{0}] for exchange [{1}]", new Object[]{message, exchange});
        }
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        if (this.upperLayer != null) {
            this.upperLayer.receiveRequest(exchange, request);
        } else {
            LOGGER.log(Level.SEVERE, "No upper layer set for receiving request [{0}] for exchange [{1}]", new Object[]{request, exchange});
        }
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (this.upperLayer != null) {
            this.upperLayer.receiveResponse(exchange, response);
        } else {
            LOGGER.log(Level.SEVERE, "No upper layer set for receiving response [{0}] for exchange [{1}]", new Object[]{response, exchange});
        }
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (this.upperLayer != null) {
            this.upperLayer.receiveEmptyMessage(exchange, message);
        } else {
            LOGGER.log(Level.SEVERE, "No upper layer set for receiving empty message [{0}] for exchange [{1}]", new Object[]{message, exchange});
        }
    }

    @Override
    public void setLowerLayer(Layer layer) {
        if (this.lowerLayer != layer) {
            if (this.lowerLayer != null) {
                this.lowerLayer.setUpperLayer(null);
            }
            this.lowerLayer = layer;
            this.lowerLayer.setUpperLayer(this);
        }
    }

    @Override
    public void setUpperLayer(Layer layer) {
        if (this.upperLayer != layer) {
            if (this.upperLayer != null) {
                this.upperLayer.setLowerLayer(null);
            }
            this.upperLayer = layer;
            this.upperLayer.setLowerLayer(this);
        }
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void reject(Exchange exchange, Message message) {
        if (message.getType() == CoAP.Type.ACK || message.getType() == CoAP.Type.RST) {
            throw new IllegalArgumentException("Cannot reject a " + (Object)((Object)message.getType()));
        }
        this.sendEmptyMessage(exchange, EmptyMessage.newRST(message));
    }

    @Override
    public void destroy() {
    }
}

