/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.DatagramReader;
import org.eclipse.californium.core.network.serialization.MessageHeader;

public final class UdpDataParser
extends DataParser {
    @Override
    protected MessageHeader parseHeader(DatagramReader reader) {
        int version = reader.read(2);
        this.assertCorrectVersion(version);
        int type = reader.read(2);
        int tokenLength = reader.read(4);
        this.assertValidTokenLength(tokenLength);
        int code = reader.read(8);
        int mid = reader.read(16);
        byte[] token = reader.readBytes(tokenLength);
        return new MessageHeader(version, CoAP.Type.valueOf(type), token, code, mid, 0);
    }

    private void assertCorrectVersion(int version) {
        if (version != 1) {
            throw new MessageFormatException("Message has invalid version: " + version);
        }
    }
}

