/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.serialization.DatagramReader;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.RawData;

public abstract class DataParser {
    public final Message parseMessage(RawData raw) {
        DatagramReader reader = new DatagramReader(raw.getBytes());
        MessageHeader header = this.parseHeader(reader);
        if (CoAP.isRequest(header.getCode())) {
            return this.parseMessage(reader, header, new Request(CoAP.Code.valueOf(header.getCode())));
        }
        if (CoAP.isResponse(header.getCode())) {
            return this.parseMessage(reader, header, new Response(CoAP.ResponseCode.valueOf(header.getCode())));
        }
        if (CoAP.isEmptyMessage(header.getCode())) {
            return this.parseMessage(reader, header, new EmptyMessage(header.getType()));
        }
        throw new MessageFormatException("illegal message code", header.getMID(), header.getCode(), CoAP.Type.CON == header.getType());
    }

    private Message parseMessage(DatagramReader source, MessageHeader header, Message target) {
        target.setMID(header.getMID());
        target.setType(header.getType());
        target.setToken(header.getToken());
        this.parseOptionsAndPayload(source, target);
        return target;
    }

    public final MessageHeader parseHeader(RawData raw) {
        DatagramReader reader = new DatagramReader(raw.getBytes());
        return this.parseHeader(reader);
    }

    protected abstract MessageHeader parseHeader(DatagramReader var1);

    protected final void assertValidTokenLength(int tokenLength) {
        if (tokenLength > 8) {
            throw new MessageFormatException("Message has invalid token length (> 8)" + tokenLength);
        }
    }

    private void parseOptionsAndPayload(DatagramReader reader, Message message) {
        int currentOptionNumber = 0;
        byte nextByte = 0;
        while (reader.bytesAvailable() && (nextByte = reader.readNextByte()) != -1) {
            int optionDeltaNibble = (0xF0 & nextByte) >> 4;
            currentOptionNumber = this.calculateNextOptionNumber(reader, currentOptionNumber, optionDeltaNibble, message);
            int optionLengthNibble = 0xF & nextByte;
            int optionLength = this.determineValueFromNibble(reader, optionLengthNibble, message);
            if (reader.bytesAvailable(optionLength)) {
                Option option = new Option(currentOptionNumber);
                option.setValue(reader.readBytes(optionLength));
                message.getOptions().addOption(option);
                continue;
            }
            String msg = String.format("Message contains option of length %d with only fewer bytes left in the message", optionLength);
            throw new MessageFormatException(msg, message.getMID(), message.getRawCode(), message.isConfirmable());
        }
        if (nextByte == -1) {
            if (!reader.bytesAvailable()) {
                throw new MessageFormatException("Found payload marker (0xFF) but message contains no payload", message.getMID(), message.getRawCode(), message.isConfirmable());
            }
            message.setPayload(reader.readBytesLeft());
        } else {
            message.setPayload((String)null);
        }
    }

    private int calculateNextOptionNumber(DatagramReader reader, int currentOptionNumber, int delta, Message message) {
        return currentOptionNumber + this.determineValueFromNibble(reader, delta, message);
    }

    private int determineValueFromNibble(DatagramReader reader, int delta, Message message) {
        if (delta <= 12) {
            return delta;
        }
        if (delta == 13) {
            return reader.read(8) + 13;
        }
        if (delta == 14) {
            return reader.read(16) + 269;
        }
        throw new MessageFormatException("Message contains illegal option delta/length: " + delta, message.getMID(), message.getRawCode(), message.isConfirmable());
    }
}

