/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.ExchangeObserver;
import org.eclipse.californium.core.network.Matcher;
import org.eclipse.californium.core.network.UdpMatcher;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.CorrelationContext;

public class TcpMatcher
implements Matcher {
    private static final Logger LOGGER = Logger.getLogger(UdpMatcher.class.getCanonicalName());
    private final ConcurrentHashMap<Exchange.KeyToken, Exchange> exchangesByToken;
    private final ConcurrentHashMap<Exchange.KeyUri, Exchange> ongoingExchanges;
    private final ExchangeObserver exchangeObserver = new ExchangeObserverImpl();
    private final int tokenSizeLimit;
    private final Level healthStatusLevel;
    private final int healthStatusInterval;
    private boolean started;
    private ScheduledExecutorService executor;

    public TcpMatcher(NetworkConfig config) {
        this.exchangesByToken = new ConcurrentHashMap();
        this.ongoingExchanges = new ConcurrentHashMap();
        this.tokenSizeLimit = config.getInt("TOKEN_SIZE_LIMIT");
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, "Matcher uses {0}={1}", new Object[]{"TOKEN_SIZE_LIMIT", this.tokenSizeLimit});
        }
        this.healthStatusLevel = Level.parse(config.getString("HEALTH_STATUS_PRINT_LEVEL"));
        this.healthStatusInterval = config.getInt("HEALTH_STATUS_INTERVAL");
    }

    @Override
    public synchronized void start() {
        if (this.executor == null) {
            throw new IllegalStateException("Matcher has no executor to publish health status.");
        }
        if (!this.started) {
            this.started = true;
            if (LOGGER.isLoggable(this.healthStatusLevel)) {
                this.executor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.log(TcpMatcher.this.healthStatusLevel, "Matcher state: {0} exchangesByToken, {1} ongoingExchanges", new Object[]{TcpMatcher.this.exchangesByToken.size(), TcpMatcher.this.ongoingExchanges.size()});
                    }
                }, this.healthStatusInterval, this.healthStatusInterval, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            this.clear();
        }
    }

    @Override
    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        Exchange.KeyToken idByToken;
        if (request.getToken() == null) {
            idByToken = this.createUnusedToken();
            request.setToken(idByToken.token);
        } else {
            idByToken = new Exchange.KeyToken(request.getToken());
            if (!(exchange.getFailedTransmissionCount() > 0 || request.getOptions().hasBlock1() || request.getOptions().hasBlock2() || request.getOptions().hasObserve() || this.exchangesByToken.get(idByToken) == null)) {
                LOGGER.log(Level.WARNING, "Manual token overrides existing open request: {0}", idByToken);
            }
        }
        exchange.setObserver(this.exchangeObserver);
        LOGGER.log(Level.FINE, "Tracking open request using {0}", new Object[]{idByToken});
        this.exchangesByToken.put(idByToken, exchange);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        response.setToken(exchange.getCurrentRequest().getToken());
        if (response.getOptions().hasBlock2()) {
            Request request = exchange.getCurrentRequest();
            Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), response.getDestination().getAddress(), response.getDestinationPort());
            if (exchange.getResponseBlockStatus() != null && !response.getOptions().hasObserve()) {
                if (this.ongoingExchanges.put(idByUri, exchange) == null) {
                    LOGGER.log(Level.FINE, "Ongoing Block2 started late, storing {0} for {1}", new Object[]{idByUri, request});
                } else {
                    LOGGER.log(Level.FINE, "Ongoing Block2 continued, storing {0} for {1}", new Object[]{idByUri, request});
                }
            } else {
                LOGGER.log(Level.FINE, "Ongoing Block2 completed, cleaning up {0} for {1}", new Object[]{idByUri, request});
                this.ongoingExchanges.remove(idByUri);
            }
        }
        if (response.isLast()) {
            exchange.setComplete();
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        message.setToken(new byte[0]);
    }

    @Override
    public Exchange receiveRequest(Request request) {
        if (!request.getOptions().hasBlock1() && !request.getOptions().hasBlock2()) {
            Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
            exchange.setObserver(this.exchangeObserver);
            return exchange;
        }
        Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
        LOGGER.log(Level.FINE, "Looking up ongoing exchange for {0}", idByUri);
        Exchange ongoing = this.ongoingExchanges.get(idByUri);
        if (ongoing != null) {
            return ongoing;
        }
        Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
        LOGGER.log(Level.FINER, "New ongoing request, storing {0} for {1}", new Object[]{idByUri, request});
        exchange.setObserver(this.exchangeObserver);
        this.ongoingExchanges.put(idByUri, exchange);
        return exchange;
    }

    @Override
    public Exchange receiveResponse(Response response, CorrelationContext responseContext) {
        Exchange.KeyToken idByToken = new Exchange.KeyToken(response.getToken());
        Exchange exchange = this.exchangesByToken.get(idByToken);
        if (exchange == null) {
            return null;
        }
        if (this.isResponseRelatedToRequest(exchange, responseContext)) {
            return exchange;
        }
        LOGGER.log(Level.INFO, "Ignoring potentially forged response for token {0} with non-matching correlation context", idByToken);
        return null;
    }

    private boolean isResponseRelatedToRequest(Exchange exchange, CorrelationContext responseContext) {
        return exchange.getCorrelationContext() == null || exchange.getCorrelationContext().equals(responseContext);
    }

    @Override
    public Exchange receiveEmptyMessage(EmptyMessage message) {
        return null;
    }

    @Override
    public void clear() {
        this.exchangesByToken.clear();
        this.ongoingExchanges.clear();
    }

    private Exchange.KeyToken createUnusedToken() {
        byte[] token;
        Exchange.KeyToken result;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        do {
            token = new byte[this.tokenSizeLimit];
            random.nextBytes(token);
        } while (this.exchangesByToken.get(result = new Exchange.KeyToken(token)) != null);
        return result;
    }

    @Override
    public void cancelObserve(byte[] token) {
    }

    private class ExchangeObserverImpl
    implements ExchangeObserver {
        private ExchangeObserverImpl() {
        }

        @Override
        public void completed(Exchange exchange) {
            if (exchange.getOrigin() == Exchange.Origin.LOCAL) {
                Exchange.KeyToken idByToken = new Exchange.KeyToken(exchange.getCurrentRequest().getToken());
                TcpMatcher.this.exchangesByToken.remove(idByToken);
            } else {
                Response response = exchange.getCurrentResponse();
                Request request = exchange.getCurrentRequest();
                if (request != null && (request.getOptions().hasBlock1() || response.getOptions().hasBlock2())) {
                    Exchange.KeyUri uriKey = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
                    LOGGER.log(Level.FINE, "Remote ongoing completed, cleaning up ", uriKey);
                    TcpMatcher.this.ongoingExchanges.remove(uriKey);
                }
            }
        }

        @Override
        public void contextEstablished(Exchange exchange) {
        }
    }
}

