/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.EndpointObserver;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.server.MessageDeliverer;

public interface Endpoint {
    public void start() throws IOException;

    public void stop();

    public void destroy();

    public void clear();

    public boolean isStarted();

    public void setExecutor(ScheduledExecutorService var1);

    public void addObserver(EndpointObserver var1);

    public void removeObserver(EndpointObserver var1);

    public void addNotificationListener(NotificationListener var1);

    public void removeNotificationListener(NotificationListener var1);

    public void addInterceptor(MessageInterceptor var1);

    public void removeInterceptor(MessageInterceptor var1);

    public List<MessageInterceptor> getInterceptors();

    public void sendRequest(Request var1);

    public void sendResponse(Exchange var1, Response var2);

    public void sendEmptyMessage(Exchange var1, EmptyMessage var2);

    public void setMessageDeliverer(MessageDeliverer var1);

    public InetSocketAddress getAddress();

    public NetworkConfig getConfig();

    public void cancelObservation(byte[] var1);
}

