/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;

public class Response
extends Message {
    private final CoAP.ResponseCode code;
    private long rtt;
    private boolean last = true;

    public static Response createResponse(Request request, CoAP.ResponseCode code) {
        Response response = new Response(code);
        response.setDestination(request.getSource());
        response.setDestinationPort(request.getSourcePort());
        return response;
    }

    public Response(CoAP.ResponseCode code) {
        this.code = code;
    }

    public CoAP.ResponseCode getCode() {
        return this.code;
    }

    @Override
    public int getRawCode() {
        return this.code.value;
    }

    public String toString() {
        String payload = this.getPayloadTracingString();
        return String.format("%s-%-6s MID=%5d, Token=%s, OptionSet=%s, %s", new Object[]{this.getType(), this.getCode(), this.getMID(), this.getTokenString(), this.getOptions(), payload});
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public long getRTT() {
        return this.rtt;
    }

    public void setRTT(long rtt) {
        this.rtt = rtt;
    }

    public boolean isNotification() {
        return this.getOptions().hasObserve();
    }
}

