/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.nio.charset.Charset;
import org.eclipse.californium.core.coap.MessageFormatException;

public final class CoAP {
    public static final int VERSION = 1;
    public static final String COAP_URI_SCHEME = "coap";
    public static final String COAP_TCP_URI_SCHEME = "coap+tcp";
    public static final String COAP_SECURE_TCP_URI_SCHEME = "coaps+tcp";
    public static final String COAP_SECURE_URI_SCHEME = "coaps";
    public static final int DEFAULT_COAP_PORT = 5683;
    public static final int DEFAULT_COAP_SECURE_PORT = 5684;
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    private CoAP() {
    }

    public static int getCodeClass(int code) {
        return (code & 0xE0) >> 5;
    }

    public static int getCodeDetail(int code) {
        return code & 0x1F;
    }

    public static String formatCode(int code) {
        return CoAP.formatCode(CoAP.getCodeClass(code), CoAP.getCodeDetail(code));
    }

    private static String formatCode(int codeClass, int codeDetail) {
        return String.format("%d.%02d", codeClass, codeDetail);
    }

    public static boolean isRequest(int code) {
        return code >= 1 && code <= 31;
    }

    public static boolean isResponse(int code) {
        return code >= 64 && code <= 191;
    }

    public static boolean isEmptyMessage(int code) {
        return code == 0;
    }

    public final class MessageFormat {
        public static final int LENGTH_NIBBLE_BITS = 4;
        public static final int VERSION_BITS = 2;
        public static final int TYPE_BITS = 2;
        public static final int TOKEN_LENGTH_BITS = 4;
        public static final int CODE_BITS = 8;
        public static final int MESSAGE_ID_BITS = 16;
        public static final int OPTION_DELTA_BITS = 4;
        public static final int OPTION_LENGTH_BITS = 4;
        public static final byte PAYLOAD_MARKER = -1;
        public static final int VERSION = 1;
        public static final int EMPTY_CODE = 0;
        public static final int REQUEST_CODE_LOWER_BOUND = 1;
        public static final int REQUEST_CODE_UPPER_BOUND = 31;
        public static final int RESPONSE_CODE_LOWER_BOUND = 64;
        public static final int RESPONSE_CODE_UPPER_BOUND = 191;

        private MessageFormat() {
        }
    }

    public static enum ResponseCode {
        _UNKNOWN_SUCCESS_CODE(2, 0),
        CREATED(2, 1),
        DELETED(2, 2),
        VALID(2, 3),
        CHANGED(2, 4),
        CONTENT(2, 5),
        CONTINUE(2, 31),
        BAD_REQUEST(4, 0),
        UNAUTHORIZED(4, 1),
        BAD_OPTION(4, 2),
        FORBIDDEN(4, 3),
        NOT_FOUND(4, 4),
        METHOD_NOT_ALLOWED(4, 5),
        NOT_ACCEPTABLE(4, 6),
        REQUEST_ENTITY_INCOMPLETE(4, 8),
        PRECONDITION_FAILED(4, 12),
        REQUEST_ENTITY_TOO_LARGE(4, 13),
        UNSUPPORTED_CONTENT_FORMAT(4, 15),
        INTERNAL_SERVER_ERROR(5, 0),
        NOT_IMPLEMENTED(5, 1),
        BAD_GATEWAY(5, 2),
        SERVICE_UNAVAILABLE(5, 3),
        GATEWAY_TIMEOUT(5, 4),
        PROXY_NOT_SUPPORTED(5, 5);

        public final int value;
        public final int codeClass;
        public final int codeDetail;

        private ResponseCode(int codeClass, int codeDetail) {
            this.codeClass = codeClass;
            this.codeDetail = codeDetail;
            this.value = codeClass << 5 | codeDetail;
        }

        public static ResponseCode valueOf(int value) {
            int codeClass = CoAP.getCodeClass(value);
            int codeDetail = CoAP.getCodeDetail(value);
            switch (codeClass) {
                case 2: {
                    return ResponseCode.valueOfSuccessCode(codeDetail);
                }
                case 4: {
                    return ResponseCode.valueOfClientErrorCode(codeDetail);
                }
                case 5: {
                    return ResponseCode.valueOfServerErrorCode(codeDetail);
                }
            }
            throw new MessageFormatException(String.format("Not a CoAP response code: %s", CoAP.formatCode(codeClass, codeDetail)));
        }

        private static ResponseCode valueOfSuccessCode(int codeDetail) {
            switch (codeDetail) {
                case 1: {
                    return CREATED;
                }
                case 2: {
                    return DELETED;
                }
                case 3: {
                    return VALID;
                }
                case 4: {
                    return CHANGED;
                }
                case 5: {
                    return CONTENT;
                }
                case 31: {
                    return CONTINUE;
                }
            }
            return _UNKNOWN_SUCCESS_CODE;
        }

        private static ResponseCode valueOfClientErrorCode(int codeDetail) {
            switch (codeDetail) {
                case 0: {
                    return BAD_REQUEST;
                }
                case 1: {
                    return UNAUTHORIZED;
                }
                case 2: {
                    return BAD_OPTION;
                }
                case 3: {
                    return FORBIDDEN;
                }
                case 4: {
                    return NOT_FOUND;
                }
                case 5: {
                    return METHOD_NOT_ALLOWED;
                }
                case 6: {
                    return NOT_ACCEPTABLE;
                }
                case 8: {
                    return REQUEST_ENTITY_INCOMPLETE;
                }
                case 12: {
                    return PRECONDITION_FAILED;
                }
                case 13: {
                    return REQUEST_ENTITY_TOO_LARGE;
                }
                case 15: {
                    return UNSUPPORTED_CONTENT_FORMAT;
                }
            }
            return BAD_REQUEST;
        }

        private static ResponseCode valueOfServerErrorCode(int codeDetail) {
            switch (codeDetail) {
                case 0: {
                    return INTERNAL_SERVER_ERROR;
                }
                case 1: {
                    return NOT_IMPLEMENTED;
                }
                case 2: {
                    return BAD_GATEWAY;
                }
                case 3: {
                    return SERVICE_UNAVAILABLE;
                }
                case 4: {
                    return GATEWAY_TIMEOUT;
                }
                case 5: {
                    return PROXY_NOT_SUPPORTED;
                }
            }
            return INTERNAL_SERVER_ERROR;
        }

        public String toString() {
            return CoAP.formatCode(this.codeClass, this.codeDetail);
        }

        public static boolean isSuccess(ResponseCode code) {
            return code.codeClass == 2;
        }

        public static boolean isClientError(ResponseCode code) {
            return code.codeClass == 4;
        }

        public static boolean isServerError(ResponseCode code) {
            return code.codeClass == 5;
        }
    }

    public static enum Code {
        GET(1),
        POST(2),
        PUT(3),
        DELETE(4);

        public final int value;

        private Code(int value) {
            this.value = value;
        }

        public static Code valueOf(int value) {
            int classCode = CoAP.getCodeClass(value);
            int detailCode = CoAP.getCodeDetail(value);
            if (classCode > 0) {
                throw new MessageFormatException(String.format("Not a CoAP request code: %s", CoAP.formatCode(classCode, detailCode)));
            }
            switch (detailCode) {
                case 1: {
                    return GET;
                }
                case 2: {
                    return POST;
                }
                case 3: {
                    return PUT;
                }
                case 4: {
                    return DELETE;
                }
            }
            throw new MessageFormatException(String.format("Unknown CoAP request code: %s", CoAP.formatCode(classCode, detailCode)));
        }
    }

    public static enum Type {
        CON(0),
        NON(1),
        ACK(2),
        RST(3);

        public final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type valueOf(int value) {
            switch (value) {
                case 0: {
                    return CON;
                }
                case 1: {
                    return NON;
                }
                case 2: {
                    return ACK;
                }
                case 3: {
                    return RST;
                }
            }
            throw new IllegalArgumentException("Unknown CoAP type " + value);
        }
    }
}

