/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObserveNotificationOrderer;

public class CoapObserveRelation {
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new Utils.DaemonThreadFactory("CoapObserveRelation#"));
    private Request request;
    private boolean canceled = false;
    private CoapResponse current = null;
    private Endpoint endpoint;
    private ObserveNotificationOrderer orderer;
    private ScheduledFuture<?> reregistrationHandle = null;
    private NotificationListener notificationListener;

    protected CoapObserveRelation(Request request, Endpoint endpoint) {
        this.request = request;
        this.endpoint = endpoint;
        this.orderer = new ObserveNotificationOrderer();
    }

    public void reregister() {
        if (!this.request.isCanceled()) {
            Request refresh = Request.newGet();
            refresh.setDestination(this.request.getDestination());
            refresh.setDestinationPort(this.request.getDestinationPort());
            refresh.setToken(this.request.getToken());
            refresh.setOptions(this.request.getOptions());
            refresh.setObserve();
            for (MessageObserver mo : this.request.getMessageObservers()) {
                refresh.addMessageObserver(mo);
            }
            this.endpoint.sendRequest(refresh);
            this.request = refresh;
            this.orderer = new ObserveNotificationOrderer();
        }
    }

    public void proactiveCancel() {
        Request cancel = Request.newGet();
        cancel.setDestination(this.request.getDestination());
        cancel.setDestinationPort(this.request.getDestinationPort());
        cancel.setToken(this.request.getToken());
        cancel.setOptions(this.request.getOptions());
        cancel.setObserveCancel();
        for (MessageObserver mo : this.request.getMessageObservers()) {
            cancel.addMessageObserver(mo);
        }
        this.endpoint.sendRequest(cancel);
        this.request.cancel();
        this.endpoint.cancelObservation(this.request.getToken());
        this.setCanceled(true);
    }

    public void reactiveCancel() {
        this.request.cancel();
        this.endpoint.cancelObservation(this.request.getToken());
        this.setCanceled(true);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public CoapResponse getCurrent() {
        return this.current;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (this.canceled) {
            this.setReregistrationHandle(null);
            if (this.notificationListener != null) {
                this.endpoint.removeNotificationListener(this.notificationListener);
            }
        }
    }

    public void setNotificationListener(NotificationListener listener) {
        this.notificationListener = listener;
    }

    protected void setCurrent(CoapResponse current) {
        this.current = current;
    }

    public ObserveNotificationOrderer getOrderer() {
        return this.orderer;
    }

    public synchronized void setReregistrationHandle(ScheduledFuture<?> reregistrationHandle) {
        if (this.reregistrationHandle != null) {
            this.reregistrationHandle.cancel(false);
        }
        this.reregistrationHandle = reregistrationHandle;
    }

    public void prepareReregistration(CoapResponse response, long backoff) {
        long timeout = response.getOptions().getMaxAge() * 1000L + backoff;
        ScheduledFuture<?> f = scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                CoapObserveRelation.this.reregister();
            }
        }, timeout, TimeUnit.MILLISECONDS);
        this.setReregistrationHandle(f);
    }
}

