/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.lang.Assert;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

public class SigningKeyResolverAdapter
implements SigningKeyResolver {
    @Override
    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        SignatureAlgorithm alg = SignatureAlgorithm.forName(header.getAlgorithm());
        byte[] keyBytes = this.resolveSigningKeyBytes(header, claims);
        Assert.isTrue(!alg.isRsa(), "resolveSigningKeyBytes(JwsHeader, Claims) cannot be used for RSA signatures.  Override the resolveSigningKey(JwsHeader, Claims) method instead and return a PublicKey or PrivateKey instance.");
        return new SecretKeySpec(keyBytes, alg.getJcaName());
    }

    @Override
    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        SignatureAlgorithm alg = SignatureAlgorithm.forName(header.getAlgorithm());
        byte[] keyBytes = this.resolveSigningKeyBytes(header, plaintext);
        Assert.isTrue(!alg.isRsa(), "resolveSigningKeyBytes(JwsHeader, String) cannot be used for RSA signatures.  Override the resolveSigningKey(JwsHeader, String) method instead and return a PublicKey or PrivateKey instance.");
        return new SecretKeySpec(keyBytes, alg.getJcaName());
    }

    public byte[] resolveSigningKeyBytes(JwsHeader header, Claims claims) {
        throw new UnsupportedJwtException("The specified SigningKeyResolver implementation does not support Claims JWS signing key resolution.  Consider overriding either the resolveSigningKey(JwsHeader, Claims) or resolveSigningKeyBytes(JwsHeader, Claims) method.");
    }

    public byte[] resolveSigningKeyBytes(JwsHeader header, String payload) {
        throw new UnsupportedJwtException("The specified SigningKeyResolver implementation does not support plaintext JWS signing key resolution.  Consider overriding either the resolveSigningKey(JwsHeader, String) or resolveSigningKeyBytes(JwsHeader, String) method.");
    }
}

