/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.twilio.twiml.TwiMLException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;

@XmlTransient
public abstract class TwiML {
    public String toXml() throws TwiMLException {
        try {
            JAXBContext context = JAXBContext.newInstance(this.getClass());
            StringWriter writer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            marshaller.marshal((Object)this, writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new TwiMLException(e.getMessage());
        }
    }

    public String toUrl() throws TwiMLException {
        try {
            return URLEncoder.encode(this.toXml(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TwiMLException(e.getMessage());
        }
    }

    public static class ToStringAdapter
    extends XmlAdapter<String, Object> {
        @Override
        public String marshal(Object v) throws Exception {
            return v == null ? null : v.toString();
        }

        @Override
        public Object unmarshal(String v) throws Exception {
            throw new UnsupportedOperationException("Not supported. Converts objects using toString().");
        }
    }
}

