/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.google.common.collect.Lists;
import com.twilio.twiml.Client;
import com.twilio.twiml.Conference;
import com.twilio.twiml.Method;
import com.twilio.twiml.Number;
import com.twilio.twiml.Queue;
import com.twilio.twiml.Sip;
import com.twilio.twiml.TwiML;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Dial")
public class Dial
extends TwiML {
    @XmlAttribute
    private final Boolean hangupOnStar;
    @XmlAttribute
    private final Integer timeout;
    @XmlAttribute
    private final Integer timeLimit;
    @XmlAttribute
    private final String action;
    @XmlAttribute
    private final Method method;
    @XmlAttribute
    private final String callerId;
    @XmlAttribute
    private final String recordingStatusCallback;
    @XmlAttribute
    private final Method recordingStatusCallbackMethod;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TwiML.ToStringAdapter.class)
    private final Record record;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TwiML.ToStringAdapter.class)
    private final Trim trim;
    @XmlElements(value={@XmlElement(name="Number", type=Number.class)})
    private final List<Number> numbers;
    @XmlElements(value={@XmlElement(name="Client", type=Client.class)})
    private final List<Client> clients;
    @XmlElement(name="Conference")
    private final Conference conference;
    @XmlElement(name="Queue")
    private final Queue queue;
    @XmlElement(name="Sip")
    private final Sip sip;

    private Dial() {
        this(new Builder());
    }

    private Dial(Builder b) {
        this.hangupOnStar = b.hangupOnStar;
        this.timeout = b.timeout;
        this.timeLimit = b.timeLimit;
        this.action = b.action;
        this.method = b.method;
        this.callerId = b.callerId;
        this.recordingStatusCallback = b.recordingStatusCallback;
        this.recordingStatusCallbackMethod = b.recordingStatusCallbackMethod;
        this.record = b.record;
        this.trim = b.trim;
        this.numbers = Lists.newArrayList(b.numbers);
        this.clients = Lists.newArrayList(b.clients);
        this.conference = b.conference;
        this.queue = b.queue;
        this.sip = b.sip;
    }

    public Boolean isHangupOnStar() {
        return this.hangupOnStar;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getTimeLimit() {
        return this.timeLimit;
    }

    public String getAction() {
        return this.action;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public String getRecordingStatusCallback() {
        return this.recordingStatusCallback;
    }

    public Method getRecordingStatusCallbackMethod() {
        return this.recordingStatusCallbackMethod;
    }

    public Record getRecord() {
        return this.record;
    }

    public Trim getTrim() {
        return this.trim;
    }

    public List<Number> getNumbers() {
        return this.numbers;
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public Conference getConference() {
        return this.conference;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public Sip getSip() {
        return this.sip;
    }

    public static class Builder {
        private Boolean hangupOnStar;
        private Integer timeout;
        private Integer timeLimit;
        private String action;
        private Method method;
        private String callerId;
        private String recordingStatusCallback;
        private Method recordingStatusCallbackMethod;
        private Record record;
        private Trim trim;
        private List<Number> numbers = Lists.newArrayList();
        private List<Client> clients = Lists.newArrayList();
        private Conference conference;
        private Queue queue;
        private Sip sip;

        public Builder hangupOnStar(boolean hangupOnStar) {
            this.hangupOnStar = hangupOnStar;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder timeLimit(int timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder callerId(String callerId) {
            this.callerId = callerId;
            return this;
        }

        public Builder recordingStatusCallback(String recordingStatusCallback) {
            this.recordingStatusCallback = recordingStatusCallback;
            return this;
        }

        public Builder recordingStatusCallbackMethod(Method recordingStatusCallbackMethod) {
            this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
            return this;
        }

        public Builder trim(Trim trim) {
            this.trim = trim;
            return this;
        }

        public Builder record(Record record) {
            this.record = record;
            return this;
        }

        public Builder number(Number number) {
            this.numbers.add(number);
            return this;
        }

        public Builder client(Client client) {
            this.clients.add(client);
            return this;
        }

        public Builder conference(Conference conference) {
            this.conference = conference;
            return this;
        }

        public Builder queue(Queue queue) {
            this.queue = queue;
            return this;
        }

        public Builder sip(Sip sip) {
            this.sip = sip;
            return this;
        }

        public Dial build() {
            return new Dial(this);
        }
    }

    public static enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Record {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_RINGING("record-from-ringing"),
        RECORD_FROM_ANSWER("record-from-answer"),
        RECORD_FROM_ANSWER_DUAL("record-from-answer-dual"),
        RECORD_FROM_RINGING_DUAL("record-from-ringing-dual");

        private final String value;

        private Record(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

