/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.twilio.taskrouter.TaskRouterResource;
import java.io.IOException;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class WorkflowRuleTarget
extends TaskRouterResource {
    @JsonProperty(value="queue")
    private final String queue;
    @JsonProperty(value="expression")
    private final String expression;
    @JsonProperty(value="priority")
    private final Integer priority;
    @JsonProperty(value="timeout")
    private final Integer timeout;

    private WorkflowRuleTarget(Builder b) throws IllegalArgumentException {
        this.queue = b.queue;
        this.expression = b.expression;
        this.priority = b.priority;
        this.timeout = b.timeout;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getExpression() {
        return this.expression;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("queue", this.queue).add("expression", this.expression).add("priority", this.priority).add("timeout", this.timeout).toString();
    }

    public static WorkflowRuleTarget fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(json, Builder.class).build();
    }

    public static class Builder {
        private String queue;
        private String expression;
        private Integer priority;
        private Integer timeout;

        @JsonCreator
        private Builder(@JsonProperty(value="queue") String queue, @JsonProperty(value="expression") String expression, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="timeout") Integer timeout) {
            this.queue = queue;
            this.expression = expression;
            this.priority = priority;
            this.timeout = timeout;
        }

        public Builder(String queue) {
            this.queue = queue;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public WorkflowRuleTarget build() {
            return new WorkflowRuleTarget(this);
        }
    }
}

