/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.twilio.taskrouter.TaskRouterResource;
import com.twilio.taskrouter.TaskRouting;
import com.twilio.taskrouter.WorkflowRule;
import com.twilio.taskrouter.WorkflowRuleTarget;
import java.io.IOException;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Workflow
extends TaskRouterResource {
    @JsonProperty(value="task_routing")
    private final TaskRouting taskRouting;

    public Workflow(List<WorkflowRule> workflowRules, WorkflowRuleTarget defaultTarget) throws Exception {
        this.taskRouting = new TaskRouting(workflowRules, defaultTarget);
    }

    @JsonCreator
    private Workflow(@JsonProperty(value="task_routing") TaskRouting taskRouting) {
        this.taskRouting = taskRouting;
    }

    @JsonIgnore
    public List<WorkflowRule> getWorkflowRules() {
        return this.taskRouting.getWorkflowRules();
    }

    @JsonIgnore
    public WorkflowRuleTarget getDefaultTarget() {
        return this.taskRouting.getDefaultTarget();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("taskRouting", this.taskRouting).toString();
    }

    public static Workflow fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(json, Workflow.class);
    }
}

