/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.twilio.taskrouter.TaskRouterResource;
import com.twilio.taskrouter.WorkflowRule;
import com.twilio.taskrouter.WorkflowRuleTarget;
import java.io.IOException;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class TaskRouting
extends TaskRouterResource {
    @JsonProperty(value="filters")
    private final List<WorkflowRule> workflowRules;
    @JsonProperty(value="default_filter")
    private final WorkflowRuleTarget defaultTarget;

    @JsonCreator
    public TaskRouting(@JsonProperty(value="filters") List<WorkflowRule> workflowRules, @JsonProperty(value="default_filter") WorkflowRuleTarget defaultTarget) {
        this.workflowRules = workflowRules;
        this.defaultTarget = defaultTarget;
    }

    public List<WorkflowRule> getWorkflowRules() {
        return this.workflowRules;
    }

    public WorkflowRuleTarget getDefaultTarget() {
        return this.defaultTarget;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("workflowRules", this.workflowRules).add("defaultTarget", this.defaultTarget).toString();
    }

    public static TaskRouting fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(json, TaskRouting.class);
    }
}

