/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.Trunk;

public class TrunkReader
extends Reader<Trunk> {
    @Override
    public ResourceSet<Trunk> read(TwilioRestClient client) {
        return new ResourceSet<Trunk>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Trunk> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TRUNKING.toString(), "/v1/Trunks", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Trunk> nextPage(Page<Trunk> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUNKING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Trunk> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trunk read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("trunks", response.getContent(), Trunk.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

