/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueuesStatistics;
import org.joda.time.DateTime;

public class TaskQueuesStatisticsReader
extends Reader<TaskQueuesStatistics> {
    private final String workspaceSid;
    private DateTime endDate;
    private String friendlyName;
    private Integer minutes;
    private DateTime startDate;

    public TaskQueuesStatisticsReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public TaskQueuesStatisticsReader setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public TaskQueuesStatisticsReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskQueuesStatisticsReader setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public TaskQueuesStatisticsReader setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Override
    public ResourceSet<TaskQueuesStatistics> read(TwilioRestClient client) {
        return new ResourceSet<TaskQueuesStatistics>(this, client, this.firstPage(client));
    }

    @Override
    public Page<TaskQueuesStatistics> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues/Statistics", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskQueuesStatistics> nextPage(Page<TaskQueuesStatistics> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<TaskQueuesStatistics> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueuesStatistics read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("task_queues_statistics", response.getContent(), TaskQueuesStatistics.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

