/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.WorkspaceStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkspaceStatistics
extends Resource {
    private static final long serialVersionUID = 176548291123699L;
    private final Map<String, Object> realtime;
    private final Map<String, Object> cumulative;
    private final String accountSid;
    private final String workspaceSid;

    public static WorkspaceStatisticsFetcher fetcher(String workspaceSid) {
        return new WorkspaceStatisticsFetcher(workspaceSid);
    }

    public static WorkspaceStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkspaceStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkspaceStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkspaceStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkspaceStatistics(@JsonProperty(value="realtime") Map<String, Object> realtime, @JsonProperty(value="cumulative") Map<String, Object> cumulative, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.realtime = realtime;
        this.cumulative = cumulative;
        this.accountSid = accountSid;
        this.workspaceSid = workspaceSid;
    }

    public final Map<String, Object> getRealtime() {
        return this.realtime;
    }

    public final Map<String, Object> getCumulative() {
        return this.cumulative;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceStatistics other = (WorkspaceStatistics)o;
        return Objects.equals(this.realtime, other.realtime) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.realtime, this.cumulative, this.accountSid, this.workspaceSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("realtime", this.realtime).add("cumulative", this.cumulative).add("accountSid", this.accountSid).add("workspaceSid", this.workspaceSid).toString();
    }
}

