/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Workflow;
import java.net.URI;

public class WorkflowCreator
extends Creator<Workflow> {
    private final String workspaceSid;
    private final String friendlyName;
    private final String configuration;
    private URI assignmentCallbackUrl;
    private URI fallbackAssignmentCallbackUrl;
    private Integer taskReservationTimeout;

    public WorkflowCreator(String workspaceSid, String friendlyName, String configuration) {
        this.workspaceSid = workspaceSid;
        this.friendlyName = friendlyName;
        this.configuration = configuration;
    }

    public WorkflowCreator setAssignmentCallbackUrl(URI assignmentCallbackUrl) {
        this.assignmentCallbackUrl = assignmentCallbackUrl;
        return this;
    }

    public WorkflowCreator setAssignmentCallbackUrl(String assignmentCallbackUrl) {
        return this.setAssignmentCallbackUrl(Promoter.uriFromString(assignmentCallbackUrl));
    }

    public WorkflowCreator setFallbackAssignmentCallbackUrl(URI fallbackAssignmentCallbackUrl) {
        this.fallbackAssignmentCallbackUrl = fallbackAssignmentCallbackUrl;
        return this;
    }

    public WorkflowCreator setFallbackAssignmentCallbackUrl(String fallbackAssignmentCallbackUrl) {
        return this.setFallbackAssignmentCallbackUrl(Promoter.uriFromString(fallbackAssignmentCallbackUrl));
    }

    public WorkflowCreator setTaskReservationTimeout(Integer taskReservationTimeout) {
        this.taskReservationTimeout = taskReservationTimeout;
        return this;
    }

    @Override
    public Workflow create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.workspaceSid + "/Workflows", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workflow creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Workflow.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.configuration != null) {
            request.addPostParam("Configuration", this.configuration);
        }
        if (this.assignmentCallbackUrl != null) {
            request.addPostParam("AssignmentCallbackUrl", this.assignmentCallbackUrl.toString());
        }
        if (this.fallbackAssignmentCallbackUrl != null) {
            request.addPostParam("FallbackAssignmentCallbackUrl", this.fallbackAssignmentCallbackUrl.toString());
        }
        if (this.taskReservationTimeout != null) {
            request.addPostParam("TaskReservationTimeout", this.taskReservationTimeout.toString());
        }
    }
}

