/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Worker;

public class WorkerReader
extends Reader<Worker> {
    private final String workspaceSid;
    private String activityName;
    private String activitySid;
    private String available;
    private String friendlyName;
    private String targetWorkersExpression;
    private String taskQueueName;
    private String taskQueueSid;

    public WorkerReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public WorkerReader setActivityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    public WorkerReader setActivitySid(String activitySid) {
        this.activitySid = activitySid;
        return this;
    }

    public WorkerReader setAvailable(String available) {
        this.available = available;
        return this;
    }

    public WorkerReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkerReader setTargetWorkersExpression(String targetWorkersExpression) {
        this.targetWorkersExpression = targetWorkersExpression;
        return this;
    }

    public WorkerReader setTaskQueueName(String taskQueueName) {
        this.taskQueueName = taskQueueName;
        return this;
    }

    public WorkerReader setTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    @Override
    public ResourceSet<Worker> read(TwilioRestClient client) {
        return new ResourceSet<Worker>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Worker> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.workspaceSid + "/Workers", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Worker> nextPage(Page<Worker> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Worker> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Worker read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("workers", response.getContent(), Worker.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.activityName != null) {
            request.addQueryParam("ActivityName", this.activityName);
        }
        if (this.activitySid != null) {
            request.addQueryParam("ActivitySid", this.activitySid);
        }
        if (this.available != null) {
            request.addQueryParam("Available", this.available);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.targetWorkersExpression != null) {
            request.addQueryParam("TargetWorkersExpression", this.targetWorkersExpression);
        }
        if (this.taskQueueName != null) {
            request.addQueryParam("TaskQueueName", this.taskQueueName);
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

