/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueue;

public class TaskQueueReader
extends Reader<TaskQueue> {
    private final String workspaceSid;
    private String friendlyName;
    private String evaluateWorkerAttributes;

    public TaskQueueReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public TaskQueueReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskQueueReader setEvaluateWorkerAttributes(String evaluateWorkerAttributes) {
        this.evaluateWorkerAttributes = evaluateWorkerAttributes;
        return this;
    }

    @Override
    public ResourceSet<TaskQueue> read(TwilioRestClient client) {
        return new ResourceSet<TaskQueue>(this, client, this.firstPage(client));
    }

    @Override
    public Page<TaskQueue> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskQueue> nextPage(Page<TaskQueue> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<TaskQueue> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueue read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("task_queues", response.getContent(), TaskQueue.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.evaluateWorkerAttributes != null) {
            request.addQueryParam("EvaluateWorkerAttributes", this.evaluateWorkerAttributes);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

