/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.ActivityCreator;
import com.twilio.rest.taskrouter.v1.workspace.ActivityDeleter;
import com.twilio.rest.taskrouter.v1.workspace.ActivityFetcher;
import com.twilio.rest.taskrouter.v1.workspace.ActivityReader;
import com.twilio.rest.taskrouter.v1.workspace.ActivityUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Activity
extends Resource {
    private static final long serialVersionUID = 66226006406843L;
    private final String accountSid;
    private final Boolean available;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String workspaceSid;
    private final URI url;

    public static ActivityFetcher fetcher(String workspaceSid, String sid) {
        return new ActivityFetcher(workspaceSid, sid);
    }

    public static ActivityUpdater updater(String workspaceSid, String sid, String friendlyName) {
        return new ActivityUpdater(workspaceSid, sid, friendlyName);
    }

    public static ActivityDeleter deleter(String workspaceSid, String sid) {
        return new ActivityDeleter(workspaceSid, sid);
    }

    public static ActivityReader reader(String workspaceSid) {
        return new ActivityReader(workspaceSid);
    }

    public static ActivityCreator creator(String workspaceSid, String friendlyName) {
        return new ActivityCreator(workspaceSid, friendlyName);
    }

    public static Activity fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Activity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Activity fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Activity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Activity(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="available") Boolean available, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.available = available;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getAvailable() {
        return this.available;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity other = (Activity)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.available, other.available) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.available, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("available", this.available).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("friendlyName", this.friendlyName).add("sid", this.sid).add("workspaceSid", this.workspaceSid).add("url", this.url).toString();
    }
}

