/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.Workspace;
import java.net.URI;

public class WorkspaceCreator
extends Creator<Workspace> {
    private final String friendlyName;
    private URI eventCallbackUrl;
    private String eventsFilter;
    private Boolean multiTaskEnabled;
    private String template;

    public WorkspaceCreator(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public WorkspaceCreator setEventCallbackUrl(URI eventCallbackUrl) {
        this.eventCallbackUrl = eventCallbackUrl;
        return this;
    }

    public WorkspaceCreator setEventCallbackUrl(String eventCallbackUrl) {
        return this.setEventCallbackUrl(Promoter.uriFromString(eventCallbackUrl));
    }

    public WorkspaceCreator setEventsFilter(String eventsFilter) {
        this.eventsFilter = eventsFilter;
        return this;
    }

    public WorkspaceCreator setMultiTaskEnabled(Boolean multiTaskEnabled) {
        this.multiTaskEnabled = multiTaskEnabled;
        return this;
    }

    public WorkspaceCreator setTemplate(String template) {
        this.template = template;
        return this;
    }

    @Override
    public Workspace create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workspace creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Workspace.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.eventCallbackUrl != null) {
            request.addPostParam("EventCallbackUrl", this.eventCallbackUrl.toString());
        }
        if (this.eventsFilter != null) {
            request.addPostParam("EventsFilter", this.eventsFilter);
        }
        if (this.multiTaskEnabled != null) {
            request.addPostParam("MultiTaskEnabled", this.multiTaskEnabled.toString());
        }
        if (this.template != null) {
            request.addPostParam("Template", this.template);
        }
    }
}

