/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.monitor.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.monitor.v1.AlertDeleter;
import com.twilio.rest.monitor.v1.AlertFetcher;
import com.twilio.rest.monitor.v1.AlertReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Alert
extends Resource {
    private static final long serialVersionUID = 84420812948753L;
    private final String accountSid;
    private final String alertText;
    private final String apiVersion;
    private final DateTime dateCreated;
    private final DateTime dateGenerated;
    private final DateTime dateUpdated;
    private final String errorCode;
    private final String logLevel;
    private final String moreInfo;
    private final HttpMethod requestMethod;
    private final String requestUrl;
    private final String requestVariables;
    private final String resourceSid;
    private final String responseBody;
    private final String responseHeaders;
    private final String sid;
    private final URI url;

    public static AlertFetcher fetcher(String sid) {
        return new AlertFetcher(sid);
    }

    public static AlertDeleter deleter(String sid) {
        return new AlertDeleter(sid);
    }

    public static AlertReader reader() {
        return new AlertReader();
    }

    public static Alert fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Alert.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Alert fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Alert.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Alert(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="alert_text") String alertText, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_generated") String dateGenerated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="error_code") String errorCode, @JsonProperty(value="log_level") String logLevel, @JsonProperty(value="more_info") String moreInfo, @JsonProperty(value="request_method") HttpMethod requestMethod, @JsonProperty(value="request_url") String requestUrl, @JsonProperty(value="request_variables") String requestVariables, @JsonProperty(value="resource_sid") String resourceSid, @JsonProperty(value="response_body") String responseBody, @JsonProperty(value="response_headers") String responseHeaders, @JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.alertText = alertText;
        this.apiVersion = apiVersion;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateGenerated = DateConverter.iso8601DateTimeFromString(dateGenerated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.errorCode = errorCode;
        this.logLevel = logLevel;
        this.moreInfo = moreInfo;
        this.requestMethod = requestMethod;
        this.requestUrl = requestUrl;
        this.requestVariables = requestVariables;
        this.resourceSid = resourceSid;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
        this.sid = sid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAlertText() {
        return this.alertText;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateGenerated() {
        return this.dateGenerated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getLogLevel() {
        return this.logLevel;
    }

    public final String getMoreInfo() {
        return this.moreInfo;
    }

    public final HttpMethod getRequestMethod() {
        return this.requestMethod;
    }

    public final String getRequestUrl() {
        return this.requestUrl;
    }

    public final String getRequestVariables() {
        return this.requestVariables;
    }

    public final String getResourceSid() {
        return this.resourceSid;
    }

    public final String getResponseBody() {
        return this.responseBody;
    }

    public final String getResponseHeaders() {
        return this.responseHeaders;
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alert other = (Alert)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.alertText, other.alertText) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateGenerated, other.dateGenerated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.logLevel, other.logLevel) && Objects.equals(this.moreInfo, other.moreInfo) && Objects.equals((Object)this.requestMethod, (Object)other.requestMethod) && Objects.equals(this.requestUrl, other.requestUrl) && Objects.equals(this.requestVariables, other.requestVariables) && Objects.equals(this.resourceSid, other.resourceSid) && Objects.equals(this.responseBody, other.responseBody) && Objects.equals(this.responseHeaders, other.responseHeaders) && Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.alertText, this.apiVersion, this.dateCreated, this.dateGenerated, this.dateUpdated, this.errorCode, this.logLevel, this.moreInfo, this.requestMethod, this.requestUrl, this.requestVariables, this.resourceSid, this.responseBody, this.responseHeaders, this.sid, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("alertText", this.alertText).add("apiVersion", this.apiVersion).add("dateCreated", this.dateCreated).add("dateGenerated", this.dateGenerated).add("dateUpdated", this.dateUpdated).add("errorCode", this.errorCode).add("logLevel", this.logLevel).add("moreInfo", this.moreInfo).add("requestMethod", (Object)this.requestMethod).add("requestUrl", this.requestUrl).add("requestVariables", this.requestVariables).add("resourceSid", this.resourceSid).add("responseBody", this.responseBody).add("responseHeaders", this.responseHeaders).add("sid", this.sid).add("url", this.url).toString();
    }
}

