/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1.service;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.service.User;

public class UserDeleter
extends Deleter<User> {
    private final String serviceSid;
    private final String sid;

    public UserDeleter(String serviceSid, String sid) {
        this.serviceSid = serviceSid;
        this.sid = sid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, Domains.IPMESSAGING.toString(), "/v1/Services/" + this.serviceSid + "/Users/" + this.sid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return response.getStatusCode() == 204;
    }
}

