/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.ipmessaging.v1.CredentialCreator;
import com.twilio.rest.ipmessaging.v1.CredentialDeleter;
import com.twilio.rest.ipmessaging.v1.CredentialFetcher;
import com.twilio.rest.ipmessaging.v1.CredentialReader;
import com.twilio.rest.ipmessaging.v1.CredentialUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Credential
extends Resource {
    private static final long serialVersionUID = 77946155752213L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final PushService type;
    private final String sandbox;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static CredentialReader reader() {
        return new CredentialReader();
    }

    public static CredentialCreator creator(PushService type) {
        return new CredentialCreator(type);
    }

    public static CredentialFetcher fetcher(String sid) {
        return new CredentialFetcher(sid);
    }

    public static CredentialUpdater updater(String sid) {
        return new CredentialUpdater(sid);
    }

    public static CredentialDeleter deleter(String sid) {
        return new CredentialDeleter(sid);
    }

    public static Credential fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Credential fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Credential(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="type") PushService type, @JsonProperty(value="sandbox") String sandbox, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.type = type;
        this.sandbox = sandbox;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final PushService getType() {
        return this.type;
    }

    public final String getSandbox() {
        return this.sandbox;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential other = (Credential)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.sandbox, other.sandbox) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.friendlyName, this.type, this.sandbox, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("friendlyName", this.friendlyName).add("type", (Object)this.type).add("sandbox", this.sandbox).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).toString();
    }

    public static enum PushService {
        GCM("gcm"),
        APN("apn");

        private final String value;

        private PushService(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static PushService forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return PushService.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

