/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v1.service.channel.MemberCreator;
import com.twilio.rest.chat.v1.service.channel.MemberDeleter;
import com.twilio.rest.chat.v1.service.channel.MemberFetcher;
import com.twilio.rest.chat.v1.service.channel.MemberReader;
import com.twilio.rest.chat.v1.service.channel.MemberUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Member
extends Resource {
    private static final long serialVersionUID = 868140426804L;
    private final String sid;
    private final String accountSid;
    private final String channelSid;
    private final String serviceSid;
    private final String identity;
    private final Integer lastConsumedMessageIndex;
    private final DateTime lastConsumptionTimestamp;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String roleSid;
    private final URI url;

    public static MemberFetcher fetcher(String serviceSid, String channelSid, String sid) {
        return new MemberFetcher(serviceSid, channelSid, sid);
    }

    public static MemberCreator creator(String serviceSid, String channelSid, String identity) {
        return new MemberCreator(serviceSid, channelSid, identity);
    }

    public static MemberReader reader(String serviceSid, String channelSid) {
        return new MemberReader(serviceSid, channelSid);
    }

    public static MemberDeleter deleter(String serviceSid, String channelSid, String sid) {
        return new MemberDeleter(serviceSid, channelSid, sid);
    }

    public static MemberUpdater updater(String serviceSid, String channelSid, String sid) {
        return new MemberUpdater(serviceSid, channelSid, sid);
    }

    public static Member fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Member fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Member(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="last_consumed_message_index") Integer lastConsumedMessageIndex, @JsonProperty(value="last_consumption_timestamp") String lastConsumptionTimestamp, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.channelSid = channelSid;
        this.serviceSid = serviceSid;
        this.identity = identity;
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        this.lastConsumptionTimestamp = DateConverter.iso8601DateTimeFromString(lastConsumptionTimestamp);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.roleSid = roleSid;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final Integer getLastConsumedMessageIndex() {
        return this.lastConsumedMessageIndex;
    }

    public final DateTime getLastConsumptionTimestamp() {
        return this.lastConsumptionTimestamp;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member other = (Member)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.lastConsumedMessageIndex, other.lastConsumedMessageIndex) && Objects.equals(this.lastConsumptionTimestamp, other.lastConsumptionTimestamp) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.channelSid, this.serviceSid, this.identity, this.lastConsumedMessageIndex, this.lastConsumptionTimestamp, this.dateCreated, this.dateUpdated, this.roleSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("channelSid", this.channelSid).add("serviceSid", this.serviceSid).add("identity", this.identity).add("lastConsumedMessageIndex", this.lastConsumedMessageIndex).add("lastConsumptionTimestamp", this.lastConsumptionTimestamp).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("roleSid", this.roleSid).add("url", this.url).toString();
    }
}

