/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.domain.IpAccessControlListMappingCreator;
import com.twilio.rest.api.v2010.account.sip.domain.IpAccessControlListMappingDeleter;
import com.twilio.rest.api.v2010.account.sip.domain.IpAccessControlListMappingFetcher;
import com.twilio.rest.api.v2010.account.sip.domain.IpAccessControlListMappingReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IpAccessControlListMapping
extends Resource {
    private static final long serialVersionUID = 214188792953524L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String uri;
    private final Map<String, String> subresourceUris;

    public static IpAccessControlListMappingFetcher fetcher(String accountSid, String domainSid, String sid) {
        return new IpAccessControlListMappingFetcher(accountSid, domainSid, sid);
    }

    public static IpAccessControlListMappingFetcher fetcher(String domainSid, String sid) {
        return new IpAccessControlListMappingFetcher(domainSid, sid);
    }

    public static IpAccessControlListMappingCreator creator(String accountSid, String domainSid, String ipAccessControlListSid) {
        return new IpAccessControlListMappingCreator(accountSid, domainSid, ipAccessControlListSid);
    }

    public static IpAccessControlListMappingCreator creator(String domainSid, String ipAccessControlListSid) {
        return new IpAccessControlListMappingCreator(domainSid, ipAccessControlListSid);
    }

    public static IpAccessControlListMappingReader reader(String accountSid, String domainSid) {
        return new IpAccessControlListMappingReader(accountSid, domainSid);
    }

    public static IpAccessControlListMappingReader reader(String domainSid) {
        return new IpAccessControlListMappingReader(domainSid);
    }

    public static IpAccessControlListMappingDeleter deleter(String accountSid, String domainSid, String sid) {
        return new IpAccessControlListMappingDeleter(accountSid, domainSid, sid);
    }

    public static IpAccessControlListMappingDeleter deleter(String domainSid, String sid) {
        return new IpAccessControlListMappingDeleter(domainSid, sid);
    }

    public static IpAccessControlListMapping fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, IpAccessControlListMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static IpAccessControlListMapping fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, IpAccessControlListMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private IpAccessControlListMapping(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.uri = uri;
        this.subresourceUris = subresourceUris;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAccessControlListMapping other = (IpAccessControlListMapping)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.uri, this.subresourceUris);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("friendlyName", this.friendlyName).add("sid", this.sid).add("uri", this.uri).add("subresourceUris", this.subresourceUris).toString();
    }
}

