/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.domain.CredentialListMapping;

public class CredentialListMappingCreator
extends Creator<CredentialListMapping> {
    private String accountSid;
    private final String domainSid;
    private final String credentialListSid;

    public CredentialListMappingCreator(String domainSid, String credentialListSid) {
        this.domainSid = domainSid;
        this.credentialListSid = credentialListSid;
    }

    public CredentialListMappingCreator(String accountSid, String domainSid, String credentialListSid) {
        this.accountSid = accountSid;
        this.domainSid = domainSid;
        this.credentialListSid = credentialListSid;
    }

    @Override
    public CredentialListMapping create(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/SIP/Domains/" + this.domainSid + "/CredentialListMappings.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialListMapping creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return CredentialListMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.credentialListSid != null) {
            request.addPostParam("CredentialListSid", this.credentialListSid);
        }
    }
}

