/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.CredentialList;

public class CredentialListUpdater
extends Updater<CredentialList> {
    private String accountSid;
    private final String sid;
    private final String friendlyName;

    public CredentialListUpdater(String sid, String friendlyName) {
        this.sid = sid;
        this.friendlyName = friendlyName;
    }

    public CredentialListUpdater(String accountSid, String sid, String friendlyName) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
    }

    @Override
    public CredentialList update(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/SIP/CredentialLists/" + this.sid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialList update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return CredentialList.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

