/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.queue;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.queue.Member;
import java.net.URI;

public class MemberUpdater
extends Updater<Member> {
    private String accountSid;
    private final String queueSid;
    private final String callSid;
    private final URI url;
    private final HttpMethod method;

    public MemberUpdater(String queueSid, String callSid, URI url, HttpMethod method) {
        this.queueSid = queueSid;
        this.callSid = callSid;
        this.url = url;
        this.method = method;
    }

    public MemberUpdater(String accountSid, String queueSid, String callSid, URI url, HttpMethod method) {
        this.accountSid = accountSid;
        this.queueSid = queueSid;
        this.callSid = callSid;
        this.url = url;
        this.method = method;
    }

    @Override
    public Member update(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Queues/" + this.queueSid + "/Members/" + this.callSid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.url != null) {
            request.addPostParam("Url", this.url.toString());
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
    }
}

