/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.queue;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.queue.Member;

public class MemberFetcher
extends Fetcher<Member> {
    private String accountSid;
    private final String queueSid;
    private final String callSid;

    public MemberFetcher(String queueSid, String callSid) {
        this.queueSid = queueSid;
        this.callSid = callSid;
    }

    public MemberFetcher(String accountSid, String queueSid, String callSid) {
        this.accountSid = accountSid;
        this.queueSid = queueSid;
        this.callSid = callSid;
    }

    @Override
    public Member fetch(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Queues/" + this.queueSid + "/Members/" + this.callSid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }
}

